package io.github.optimumcode.json.schema.`internal`.unicode.categories

import io.github.optimumcode.json.schema.`internal`.unicode.CharacterCategoryData
import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress

@Suppress("detekt:all")
internal object ConnectorPunctuation : CharacterCategoryData {
  override val minCodepoint: Int
    get() = 0x5f

  override val maxCodepoint: Int
    get() = 0xff3f

  override fun contains(codepoint: Int): Boolean {
    if (minCodepoint > codepoint || maxCodepoint < codepoint) {
      return false
    }
    return if (codepoint < 0xfe33) {
      if (codepoint < 0x203f) {
        codepoint == 0x5f
      } else {
        if (codepoint < 0x2054) {
          codepoint in 0x203f..0x2040
        } else {
          codepoint == 0x2054
        }
      }
    } else {
      if (codepoint < 0xfe4d) {
        codepoint in 0xfe33..0xfe34
      } else {
        if (codepoint < 0xff3f) {
          codepoint in 0xfe4d..0xfe4f
        } else {
          codepoint == 0xff3f
        }
      }
    }
  }
}
