package io.github.optimumcode.json.schema.`internal`.unicode.categories

import io.github.optimumcode.json.schema.`internal`.unicode.CharacterCategoryData
import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress

@Suppress("detekt:all")
internal object Control : CharacterCategoryData {
  override val minCodepoint: Int
    get() = 0x0

  override val maxCodepoint: Int
    get() = 0x9f

  override fun contains(codepoint: Int): Boolean {
    if (minCodepoint > codepoint || maxCodepoint < codepoint) {
      return false
    }
    return if (codepoint < 0x7f) {
      codepoint in 0x0..0x1f
    } else {
      codepoint in 0x7f..0x9f
    }
  }
}
