package io.github.optimumcode.json.schema.`internal`.unicode.categories

import io.github.optimumcode.json.schema.`internal`.unicode.CharacterCategoryData
import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress

@Suppress("detekt:all")
internal object CurrencySymbol : CharacterCategoryData {
  override val minCodepoint: Int
    get() = 0x24

  override val maxCodepoint: Int
    get() = 0x1ecb0

  override fun contains(codepoint: Int): Boolean {
    if (minCodepoint > codepoint || maxCodepoint < codepoint) {
      return false
    }
    return if (codepoint < 0x17db) {
      if (codepoint < 0x9f2) {
        if (codepoint < 0x58f) {
          if (codepoint < 0xa2) {
            codepoint == 0x24
          } else {
            codepoint in 0xa2..0xa5
          }
        } else {
          if (codepoint < 0x60b) {
            codepoint == 0x58f
          } else {
            if (codepoint < 0x7fe) {
              codepoint == 0x60b
            } else {
              codepoint in 0x7fe..0x7ff
            }
          }
        }
      } else {
        if (codepoint < 0xaf1) {
          if (codepoint < 0x9fb) {
            codepoint in 0x9f2..0x9f3
          } else {
            codepoint == 0x9fb
          }
        } else {
          if (codepoint < 0xbf9) {
            codepoint == 0xaf1
          } else {
            if (codepoint < 0xe3f) {
              codepoint == 0xbf9
            } else {
              codepoint == 0xe3f
            }
          }
        }
      }
    } else {
      if (codepoint < 0xff04) {
        if (codepoint < 0xa838) {
          if (codepoint < 0x20a0) {
            codepoint == 0x17db
          } else {
            codepoint in 0x20a0..0x20bf
          }
        } else {
          if (codepoint < 0xfdfc) {
            codepoint == 0xa838
          } else {
            if (codepoint < 0xfe69) {
              codepoint == 0xfdfc
            } else {
              codepoint == 0xfe69
            }
          }
        }
      } else {
        if (codepoint < 0x11fdd) {
          if (codepoint < 0xffe0) {
            codepoint == 0xff04
          } else {
            if (codepoint < 0xffe5) {
              codepoint in 0xffe0..0xffe1
            } else {
              codepoint in 0xffe5..0xffe6
            }
          }
        } else {
          if (codepoint < 0x1e2ff) {
            codepoint in 0x11fdd..0x11fe0
          } else {
            if (codepoint < 0x1ecb0) {
              codepoint == 0x1e2ff
            } else {
              codepoint == 0x1ecb0
            }
          }
        }
      }
    }
  }
}
