package io.github.optimumcode.json.schema.`internal`.unicode.categories

import io.github.optimumcode.json.schema.`internal`.unicode.CharacterCategoryData
import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress

@Suppress("detekt:all")
internal object DashPunctuation : CharacterCategoryData {
  override val minCodepoint: Int
    get() = 0x2d

  override val maxCodepoint: Int
    get() = 0x10ead

  override fun contains(codepoint: Int): Boolean {
    if (minCodepoint > codepoint || maxCodepoint < codepoint) {
      return false
    }
    return if (codepoint < 0x2e40) {
      if (codepoint < 0x1806) {
        if (codepoint < 0x5be) {
          if (codepoint < 0x58a) {
            codepoint == 0x2d
          } else {
            codepoint == 0x58a
          }
        } else {
          if (codepoint < 0x1400) {
            codepoint == 0x5be
          } else {
            codepoint == 0x1400
          }
        }
      } else {
        if (codepoint < 0x2e17) {
          if (codepoint < 0x2010) {
            codepoint == 0x1806
          } else {
            codepoint in 0x2010..0x2015
          }
        } else {
          if (codepoint < 0x2e1a) {
            codepoint == 0x2e17
          } else {
            if (codepoint < 0x2e3a) {
              codepoint == 0x2e1a
            } else {
              codepoint in 0x2e3a..0x2e3b
            }
          }
        }
      }
    } else {
      if (codepoint < 0xfe31) {
        if (codepoint < 0x3030) {
          if (codepoint < 0x301c) {
            codepoint == 0x2e40
          } else {
            codepoint == 0x301c
          }
        } else {
          if (codepoint < 0x30a0) {
            codepoint == 0x3030
          } else {
            codepoint == 0x30a0
          }
        }
      } else {
        if (codepoint < 0xfe63) {
          if (codepoint < 0xfe58) {
            codepoint in 0xfe31..0xfe32
          } else {
            codepoint == 0xfe58
          }
        } else {
          if (codepoint < 0xff0d) {
            codepoint == 0xfe63
          } else {
            if (codepoint < 0x10ead) {
              codepoint == 0xff0d
            } else {
              codepoint == 0x10ead
            }
          }
        }
      }
    }
  }
}
