package io.github.optimumcode.json.schema.`internal`.unicode.categories

import io.github.optimumcode.json.schema.`internal`.unicode.CharacterCategoryData
import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress

@Suppress("detekt:all")
internal object DecimalNumber : CharacterCategoryData {
  override val minCodepoint: Int
    get() = 0x30

  override val maxCodepoint: Int
    get() = 0x1fbf9

  override fun contains(codepoint: Int): Boolean {
    if (minCodepoint > codepoint || maxCodepoint < codepoint) {
      return false
    }
    return if (codepoint < 0xa8d0) {
      if (codepoint < 0xed0) {
        if (codepoint < 0xae6) {
          if (codepoint < 0x7c0) {
            if (codepoint < 0x660) {
              codepoint in 0x30..0x39
            } else {
              if (codepoint < 0x6f0) {
                codepoint in 0x660..0x669
              } else {
                codepoint in 0x6f0..0x6f9
              }
            }
          } else {
            if (codepoint < 0x9e6) {
              if (codepoint < 0x966) {
                codepoint in 0x7c0..0x7c9
              } else {
                codepoint in 0x966..0x96f
              }
            } else {
              if (codepoint < 0xa66) {
                codepoint in 0x9e6..0x9ef
              } else {
                codepoint in 0xa66..0xa6f
              }
            }
          }
        } else {
          if (codepoint < 0xce6) {
            if (codepoint < 0xbe6) {
              if (codepoint < 0xb66) {
                codepoint in 0xae6..0xaef
              } else {
                codepoint in 0xb66..0xb6f
              }
            } else {
              if (codepoint < 0xc66) {
                codepoint in 0xbe6..0xbef
              } else {
                codepoint in 0xc66..0xc6f
              }
            }
          } else {
            if (codepoint < 0xde6) {
              if (codepoint < 0xd66) {
                codepoint in 0xce6..0xcef
              } else {
                codepoint in 0xd66..0xd6f
              }
            } else {
              if (codepoint < 0xe50) {
                codepoint in 0xde6..0xdef
              } else {
                codepoint in 0xe50..0xe59
              }
            }
          }
        }
      } else {
        if (codepoint < 0x19d0) {
          if (codepoint < 0x1090) {
            if (codepoint < 0xf20) {
              codepoint in 0xed0..0xed9
            } else {
              if (codepoint < 0x1040) {
                codepoint in 0xf20..0xf29
              } else {
                codepoint in 0x1040..0x1049
              }
            }
          } else {
            if (codepoint < 0x1810) {
              if (codepoint < 0x17e0) {
                codepoint in 0x1090..0x1099
              } else {
                codepoint in 0x17e0..0x17e9
              }
            } else {
              if (codepoint < 0x1946) {
                codepoint in 0x1810..0x1819
              } else {
                codepoint in 0x1946..0x194f
              }
            }
          }
        } else {
          if (codepoint < 0x1bb0) {
            if (codepoint < 0x1a90) {
              if (codepoint < 0x1a80) {
                codepoint in 0x19d0..0x19d9
              } else {
                codepoint in 0x1a80..0x1a89
              }
            } else {
              if (codepoint < 0x1b50) {
                codepoint in 0x1a90..0x1a99
              } else {
                codepoint in 0x1b50..0x1b59
              }
            }
          } else {
            if (codepoint < 0x1c50) {
              if (codepoint < 0x1c40) {
                codepoint in 0x1bb0..0x1bb9
              } else {
                codepoint in 0x1c40..0x1c49
              }
            } else {
              if (codepoint < 0xa620) {
                codepoint in 0x1c50..0x1c59
              } else {
                codepoint in 0xa620..0xa629
              }
            }
          }
        }
      }
    } else {
      if (codepoint < 0x114d0) {
        if (codepoint < 0x104a0) {
          if (codepoint < 0xa9f0) {
            if (codepoint < 0xa900) {
              codepoint in 0xa8d0..0xa8d9
            } else {
              if (codepoint < 0xa9d0) {
                codepoint in 0xa900..0xa909
              } else {
                codepoint in 0xa9d0..0xa9d9
              }
            }
          } else {
            if (codepoint < 0xabf0) {
              if (codepoint < 0xaa50) {
                codepoint in 0xa9f0..0xa9f9
              } else {
                codepoint in 0xaa50..0xaa59
              }
            } else {
              if (codepoint < 0xff10) {
                codepoint in 0xabf0..0xabf9
              } else {
                codepoint in 0xff10..0xff19
              }
            }
          }
        } else {
          if (codepoint < 0x11136) {
            if (codepoint < 0x11066) {
              if (codepoint < 0x10d30) {
                codepoint in 0x104a0..0x104a9
              } else {
                codepoint in 0x10d30..0x10d39
              }
            } else {
              if (codepoint < 0x110f0) {
                codepoint in 0x11066..0x1106f
              } else {
                codepoint in 0x110f0..0x110f9
              }
            }
          } else {
            if (codepoint < 0x112f0) {
              if (codepoint < 0x111d0) {
                codepoint in 0x11136..0x1113f
              } else {
                codepoint in 0x111d0..0x111d9
              }
            } else {
              if (codepoint < 0x11450) {
                codepoint in 0x112f0..0x112f9
              } else {
                codepoint in 0x11450..0x11459
              }
            }
          }
        }
      } else {
        if (codepoint < 0x11da0) {
          if (codepoint < 0x118e0) {
            if (codepoint < 0x116c0) {
              if (codepoint < 0x11650) {
                codepoint in 0x114d0..0x114d9
              } else {
                codepoint in 0x11650..0x11659
              }
            } else {
              if (codepoint < 0x11730) {
                codepoint in 0x116c0..0x116c9
              } else {
                codepoint in 0x11730..0x11739
              }
            }
          } else {
            if (codepoint < 0x11c50) {
              if (codepoint < 0x11950) {
                codepoint in 0x118e0..0x118e9
              } else {
                codepoint in 0x11950..0x11959
              }
            } else {
              if (codepoint < 0x11d50) {
                codepoint in 0x11c50..0x11c59
              } else {
                codepoint in 0x11d50..0x11d59
              }
            }
          }
        } else {
          if (codepoint < 0x1e140) {
            if (codepoint < 0x16b50) {
              if (codepoint < 0x16a60) {
                codepoint in 0x11da0..0x11da9
              } else {
                codepoint in 0x16a60..0x16a69
              }
            } else {
              if (codepoint < 0x1d7ce) {
                codepoint in 0x16b50..0x16b59
              } else {
                codepoint in 0x1d7ce..0x1d7ff
              }
            }
          } else {
            if (codepoint < 0x1e950) {
              if (codepoint < 0x1e2f0) {
                codepoint in 0x1e140..0x1e149
              } else {
                codepoint in 0x1e2f0..0x1e2f9
              }
            } else {
              if (codepoint < 0x1fbf0) {
                codepoint in 0x1e950..0x1e959
              } else {
                codepoint in 0x1fbf0..0x1fbf9
              }
            }
          }
        }
      }
    }
  }
}
