package io.github.optimumcode.json.schema.`internal`.unicode.categories

import io.github.optimumcode.json.schema.`internal`.unicode.CharacterCategoryData
import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress

@Suppress("detekt:all")
internal object EnclosingMark : CharacterCategoryData {
  override val minCodepoint: Int
    get() = 0x488

  override val maxCodepoint: Int
    get() = 0xa672

  override fun contains(codepoint: Int): Boolean {
    if (minCodepoint > codepoint || maxCodepoint < codepoint) {
      return false
    }
    return if (codepoint < 0x20dd) {
      if (codepoint < 0x1abe) {
        codepoint in 0x488..0x489
      } else {
        codepoint == 0x1abe
      }
    } else {
      if (codepoint < 0x20e2) {
        codepoint in 0x20dd..0x20e0
      } else {
        if (codepoint < 0xa670) {
          codepoint in 0x20e2..0x20e4
        } else {
          codepoint in 0xa670..0xa672
        }
      }
    }
  }
}
