package io.github.optimumcode.json.schema.`internal`.unicode.categories

import io.github.optimumcode.json.schema.`internal`.unicode.CharacterCategoryData
import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress

@Suppress("detekt:all")
internal object Format : CharacterCategoryData {
  override val minCodepoint: Int
    get() = 0xad

  override val maxCodepoint: Int
    get() = 0xe007f

  override fun contains(codepoint: Int): Boolean {
    if (minCodepoint > codepoint || maxCodepoint < codepoint) {
      return false
    }
    return if (codepoint < 0x2066) {
      if (codepoint < 0x8e2) {
        if (codepoint < 0x61c) {
          if (codepoint < 0x600) {
            codepoint == 0xad
          } else {
            codepoint in 0x600..0x605
          }
        } else {
          if (codepoint < 0x6dd) {
            codepoint == 0x61c
          } else {
            if (codepoint < 0x70f) {
              codepoint == 0x6dd
            } else {
              codepoint == 0x70f
            }
          }
        }
      } else {
        if (codepoint < 0x200b) {
          if (codepoint < 0x180e) {
            codepoint == 0x8e2
          } else {
            codepoint == 0x180e
          }
        } else {
          if (codepoint < 0x202a) {
            codepoint in 0x200b..0x200f
          } else {
            if (codepoint < 0x2060) {
              codepoint in 0x202a..0x202e
            } else {
              codepoint in 0x2060..0x2064
            }
          }
        }
      }
    } else {
      if (codepoint < 0x13430) {
        if (codepoint < 0xfff9) {
          if (codepoint < 0xfeff) {
            codepoint in 0x2066..0x206f
          } else {
            codepoint == 0xfeff
          }
        } else {
          if (codepoint < 0x110bd) {
            codepoint in 0xfff9..0xfffb
          } else {
            if (codepoint < 0x110cd) {
              codepoint == 0x110bd
            } else {
              codepoint == 0x110cd
            }
          }
        }
      } else {
        if (codepoint < 0x1d173) {
          if (codepoint < 0x1bca0) {
            codepoint in 0x13430..0x13438
          } else {
            codepoint in 0x1bca0..0x1bca3
          }
        } else {
          if (codepoint < 0xe0001) {
            codepoint in 0x1d173..0x1d17a
          } else {
            if (codepoint < 0xe0020) {
              codepoint == 0xe0001
            } else {
              codepoint in 0xe0020..0xe007f
            }
          }
        }
      }
    }
  }
}
