package io.github.optimumcode.json.schema.`internal`.unicode.categories

import io.github.optimumcode.json.schema.`internal`.unicode.CharacterCategoryData
import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress

@Suppress("detekt:all")
internal object InitialPunctuation : CharacterCategoryData {
  override val minCodepoint: Int
    get() = 0xab

  override val maxCodepoint: Int
    get() = 0x2e20

  override fun contains(codepoint: Int): Boolean {
    if (minCodepoint > codepoint || maxCodepoint < codepoint) {
      return false
    }
    return if (codepoint < 0x2e02) {
      if (codepoint < 0x201b) {
        if (codepoint < 0x2018) {
          codepoint == 0xab
        } else {
          codepoint == 0x2018
        }
      } else {
        if (codepoint < 0x201f) {
          codepoint in 0x201b..0x201c
        } else {
          if (codepoint < 0x2039) {
            codepoint == 0x201f
          } else {
            codepoint == 0x2039
          }
        }
      }
    } else {
      if (codepoint < 0x2e0c) {
        if (codepoint < 0x2e04) {
          codepoint == 0x2e02
        } else {
          if (codepoint < 0x2e09) {
            codepoint == 0x2e04
          } else {
            codepoint == 0x2e09
          }
        }
      } else {
        if (codepoint < 0x2e1c) {
          codepoint == 0x2e0c
        } else {
          if (codepoint < 0x2e20) {
            codepoint == 0x2e1c
          } else {
            codepoint == 0x2e20
          }
        }
      }
    }
  }
}
