package io.github.optimumcode.json.schema.`internal`.unicode.categories

import io.github.optimumcode.json.schema.`internal`.unicode.CharacterCategoryData
import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress

@Suppress("detekt:all")
internal object LetterNumber : CharacterCategoryData {
  override val minCodepoint: Int
    get() = 0x16ee

  override val maxCodepoint: Int
    get() = 0x1246e

  override fun contains(codepoint: Int): Boolean {
    if (minCodepoint > codepoint || maxCodepoint < codepoint) {
      return false
    }
    return if (codepoint < 0xa6e6) {
      if (codepoint < 0x3007) {
        if (codepoint < 0x2160) {
          codepoint in 0x16ee..0x16f0
        } else {
          if (codepoint < 0x2185) {
            codepoint in 0x2160..0x2182
          } else {
            codepoint in 0x2185..0x2188
          }
        }
      } else {
        if (codepoint < 0x3021) {
          codepoint == 0x3007
        } else {
          if (codepoint < 0x3038) {
            codepoint in 0x3021..0x3029
          } else {
            codepoint in 0x3038..0x303a
          }
        }
      }
    } else {
      if (codepoint < 0x1034a) {
        if (codepoint < 0x10140) {
          codepoint in 0xa6e6..0xa6ef
        } else {
          if (codepoint < 0x10341) {
            codepoint in 0x10140..0x10174
          } else {
            codepoint == 0x10341
          }
        }
      } else {
        if (codepoint < 0x103d1) {
          codepoint == 0x1034a
        } else {
          if (codepoint < 0x12400) {
            codepoint in 0x103d1..0x103d5
          } else {
            codepoint in 0x12400..0x1246e
          }
        }
      }
    }
  }
}
