package io.github.optimumcode.json.schema.`internal`.unicode.categories

import io.github.optimumcode.json.schema.`internal`.unicode.CharacterCategoryData
import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress

@Suppress("detekt:all")
internal object MathSymbol : CharacterCategoryData {
  override val minCodepoint: Int
    get() = 0x2b

  override val maxCodepoint: Int
    get() = 0x1eef1

  override fun contains(codepoint: Int): Boolean {
    if (minCodepoint > codepoint || maxCodepoint < codepoint) {
      return false
    }
    return if (codepoint < 0x25c1) {
      if (codepoint < 0x214b) {
        if (codepoint < 0x3f6) {
          if (codepoint < 0xac) {
            if (codepoint < 0x7c) {
              if (codepoint < 0x3c) {
                codepoint == 0x2b
              } else {
                codepoint in 0x3c..0x3e
              }
            } else {
              if (codepoint < 0x7e) {
                codepoint == 0x7c
              } else {
                codepoint == 0x7e
              }
            }
          } else {
            if (codepoint < 0xd7) {
              if (codepoint < 0xb1) {
                codepoint == 0xac
              } else {
                codepoint == 0xb1
              }
            } else {
              if (codepoint < 0xf7) {
                codepoint == 0xd7
              } else {
                codepoint == 0xf7
              }
            }
          }
        } else {
          if (codepoint < 0x207a) {
            if (codepoint < 0x2044) {
              if (codepoint < 0x606) {
                codepoint == 0x3f6
              } else {
                codepoint in 0x606..0x608
              }
            } else {
              if (codepoint < 0x2052) {
                codepoint == 0x2044
              } else {
                codepoint == 0x2052
              }
            }
          } else {
            if (codepoint < 0x2118) {
              if (codepoint < 0x208a) {
                codepoint in 0x207a..0x207c
              } else {
                codepoint in 0x208a..0x208c
              }
            } else {
              if (codepoint < 0x2140) {
                codepoint == 0x2118
              } else {
                codepoint in 0x2140..0x2144
              }
            }
          }
        }
      } else {
        if (codepoint < 0x21d2) {
          if (codepoint < 0x21a3) {
            if (codepoint < 0x219a) {
              if (codepoint < 0x2190) {
                codepoint == 0x214b
              } else {
                codepoint in 0x2190..0x2194
              }
            } else {
              if (codepoint < 0x21a0) {
                codepoint in 0x219a..0x219b
              } else {
                codepoint == 0x21a0
              }
            }
          } else {
            if (codepoint < 0x21ae) {
              if (codepoint < 0x21a6) {
                codepoint == 0x21a3
              } else {
                codepoint == 0x21a6
              }
            } else {
              if (codepoint < 0x21ce) {
                codepoint == 0x21ae
              } else {
                codepoint in 0x21ce..0x21cf
              }
            }
          }
        } else {
          if (codepoint < 0x237c) {
            if (codepoint < 0x21f4) {
              if (codepoint < 0x21d4) {
                codepoint == 0x21d2
              } else {
                codepoint == 0x21d4
              }
            } else {
              if (codepoint < 0x2320) {
                codepoint in 0x21f4..0x22ff
              } else {
                codepoint in 0x2320..0x2321
              }
            }
          } else {
            if (codepoint < 0x23dc) {
              if (codepoint < 0x239b) {
                codepoint == 0x237c
              } else {
                codepoint in 0x239b..0x23b3
              }
            } else {
              if (codepoint < 0x25b7) {
                codepoint in 0x23dc..0x23e1
              } else {
                codepoint == 0x25b7
              }
            }
          }
        }
      }
    } else {
      if (codepoint < 0xff1c) {
        if (codepoint < 0x29dc) {
          if (codepoint < 0x27c7) {
            if (codepoint < 0x266f) {
              if (codepoint < 0x25f8) {
                codepoint == 0x25c1
              } else {
                codepoint in 0x25f8..0x25ff
              }
            } else {
              if (codepoint < 0x27c0) {
                codepoint == 0x266f
              } else {
                codepoint in 0x27c0..0x27c4
              }
            }
          } else {
            if (codepoint < 0x2900) {
              if (codepoint < 0x27f0) {
                codepoint in 0x27c7..0x27e5
              } else {
                codepoint in 0x27f0..0x27ff
              }
            } else {
              if (codepoint < 0x2999) {
                codepoint in 0x2900..0x2982
              } else {
                codepoint in 0x2999..0x29d7
              }
            }
          }
        } else {
          if (codepoint < 0xfb29) {
            if (codepoint < 0x2b30) {
              if (codepoint < 0x29fe) {
                codepoint in 0x29dc..0x29fb
              } else {
                codepoint in 0x29fe..0x2aff
              }
            } else {
              if (codepoint < 0x2b47) {
                codepoint in 0x2b30..0x2b44
              } else {
                codepoint in 0x2b47..0x2b4c
              }
            }
          } else {
            if (codepoint < 0xfe64) {
              if (codepoint < 0xfe62) {
                codepoint == 0xfb29
              } else {
                codepoint == 0xfe62
              }
            } else {
              if (codepoint < 0xff0b) {
                codepoint in 0xfe64..0xfe66
              } else {
                codepoint == 0xff0b
              }
            }
          }
        }
      } else {
        if (codepoint < 0x1d715) {
          if (codepoint < 0xffe9) {
            if (codepoint < 0xff5e) {
              if (codepoint < 0xff5c) {
                codepoint in 0xff1c..0xff1e
              } else {
                codepoint == 0xff5c
              }
            } else {
              if (codepoint < 0xffe2) {
                codepoint == 0xff5e
              } else {
                codepoint == 0xffe2
              }
            }
          } else {
            if (codepoint < 0x1d6db) {
              if (codepoint < 0x1d6c1) {
                codepoint in 0xffe9..0xffec
              } else {
                codepoint == 0x1d6c1
              }
            } else {
              if (codepoint < 0x1d6fb) {
                codepoint == 0x1d6db
              } else {
                codepoint == 0x1d6fb
              }
            }
          }
        } else {
          if (codepoint < 0x1d789) {
            if (codepoint < 0x1d74f) {
              if (codepoint < 0x1d735) {
                codepoint == 0x1d715
              } else {
                codepoint == 0x1d735
              }
            } else {
              if (codepoint < 0x1d76f) {
                codepoint == 0x1d74f
              } else {
                codepoint == 0x1d76f
              }
            }
          } else {
            if (codepoint < 0x1d7c3) {
              if (codepoint < 0x1d7a9) {
                codepoint == 0x1d789
              } else {
                codepoint == 0x1d7a9
              }
            } else {
              if (codepoint < 0x1eef0) {
                codepoint == 0x1d7c3
              } else {
                codepoint in 0x1eef0..0x1eef1
              }
            }
          }
        }
      }
    }
  }
}
