package io.github.optimumcode.json.schema.`internal`.unicode.categories

import io.github.optimumcode.json.schema.`internal`.unicode.CharacterCategoryData
import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress

@Suppress("detekt:all")
internal object ModifierSymbol : CharacterCategoryData {
  override val minCodepoint: Int
    get() = 0x5e

  override val maxCodepoint: Int
    get() = 0x1f3ff

  override fun contains(codepoint: Int): Boolean {
    if (minCodepoint > codepoint || maxCodepoint < codepoint) {
      return false
    }
    return if (codepoint < 0x1fcd) {
      if (codepoint < 0x2d2) {
        if (codepoint < 0xaf) {
          if (codepoint < 0x60) {
            codepoint == 0x5e
          } else {
            if (codepoint < 0xa8) {
              codepoint == 0x60
            } else {
              codepoint == 0xa8
            }
          }
        } else {
          if (codepoint < 0xb8) {
            if (codepoint < 0xb4) {
              codepoint == 0xaf
            } else {
              codepoint == 0xb4
            }
          } else {
            if (codepoint < 0x2c2) {
              codepoint == 0xb8
            } else {
              codepoint in 0x2c2..0x2c5
            }
          }
        }
      } else {
        if (codepoint < 0x375) {
          if (codepoint < 0x2ed) {
            if (codepoint < 0x2e5) {
              codepoint in 0x2d2..0x2df
            } else {
              codepoint in 0x2e5..0x2eb
            }
          } else {
            if (codepoint < 0x2ef) {
              codepoint == 0x2ed
            } else {
              codepoint in 0x2ef..0x2ff
            }
          }
        } else {
          if (codepoint < 0x1fbd) {
            if (codepoint < 0x384) {
              codepoint == 0x375
            } else {
              codepoint in 0x384..0x385
            }
          } else {
            if (codepoint < 0x1fbf) {
              codepoint == 0x1fbd
            } else {
              codepoint in 0x1fbf..0x1fc1
            }
          }
        }
      }
    } else {
      if (codepoint < 0xa789) {
        if (codepoint < 0x1ffd) {
          if (codepoint < 0x1fdd) {
            codepoint in 0x1fcd..0x1fcf
          } else {
            if (codepoint < 0x1fed) {
              codepoint in 0x1fdd..0x1fdf
            } else {
              codepoint in 0x1fed..0x1fef
            }
          }
        } else {
          if (codepoint < 0xa700) {
            if (codepoint < 0x309b) {
              codepoint in 0x1ffd..0x1ffe
            } else {
              codepoint in 0x309b..0x309c
            }
          } else {
            if (codepoint < 0xa720) {
              codepoint in 0xa700..0xa716
            } else {
              codepoint in 0xa720..0xa721
            }
          }
        }
      } else {
        if (codepoint < 0xff3e) {
          if (codepoint < 0xab6a) {
            if (codepoint < 0xab5b) {
              codepoint in 0xa789..0xa78a
            } else {
              codepoint == 0xab5b
            }
          } else {
            if (codepoint < 0xfbb2) {
              codepoint in 0xab6a..0xab6b
            } else {
              codepoint in 0xfbb2..0xfbc1
            }
          }
        } else {
          if (codepoint < 0xffe3) {
            if (codepoint < 0xff40) {
              codepoint == 0xff3e
            } else {
              codepoint == 0xff40
            }
          } else {
            if (codepoint < 0x1f3fb) {
              codepoint == 0xffe3
            } else {
              codepoint in 0x1f3fb..0x1f3ff
            }
          }
        }
      }
    }
  }
}
