package io.github.optimumcode.json.schema.`internal`.unicode.categories

import io.github.optimumcode.json.schema.`internal`.unicode.CharacterCategoryData
import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress

@Suppress("detekt:all")
internal object OtherNumber : CharacterCategoryData {
  override val minCodepoint: Int
    get() = 0xb2

  override val maxCodepoint: Int
    get() = 0x1f10c

  override fun contains(codepoint: Int): Boolean {
    if (minCodepoint > codepoint || maxCodepoint < codepoint) {
      return false
    }
    return if (codepoint < 0x10879) {
      if (codepoint < 0x2189) {
        if (codepoint < 0xd70) {
          if (codepoint < 0xb72) {
            if (codepoint < 0xbc) {
              if (codepoint < 0xb9) {
                codepoint in 0xb2..0xb3
              } else {
                codepoint == 0xb9
              }
            } else {
              if (codepoint < 0x9f4) {
                codepoint in 0xbc..0xbe
              } else {
                codepoint in 0x9f4..0x9f9
              }
            }
          } else {
            if (codepoint < 0xc78) {
              if (codepoint < 0xbf0) {
                codepoint in 0xb72..0xb77
              } else {
                codepoint in 0xbf0..0xbf2
              }
            } else {
              if (codepoint < 0xd58) {
                codepoint in 0xc78..0xc7e
              } else {
                codepoint in 0xd58..0xd5e
              }
            }
          }
        } else {
          if (codepoint < 0x19da) {
            if (codepoint < 0x1369) {
              if (codepoint < 0xf2a) {
                codepoint in 0xd70..0xd78
              } else {
                codepoint in 0xf2a..0xf33
              }
            } else {
              if (codepoint < 0x17f0) {
                codepoint in 0x1369..0x137c
              } else {
                codepoint in 0x17f0..0x17f9
              }
            }
          } else {
            if (codepoint < 0x2074) {
              if (codepoint < 0x2070) {
                codepoint == 0x19da
              } else {
                codepoint == 0x2070
              }
            } else {
              if (codepoint < 0x2080) {
                codepoint in 0x2074..0x2079
              } else {
                if (codepoint < 0x2150) {
                  codepoint in 0x2080..0x2089
                } else {
                  codepoint in 0x2150..0x215f
                }
              }
            }
          }
        }
      } else {
        if (codepoint < 0x3280) {
          if (codepoint < 0x2cfd) {
            if (codepoint < 0x24ea) {
              if (codepoint < 0x2460) {
                codepoint == 0x2189
              } else {
                codepoint in 0x2460..0x249b
              }
            } else {
              if (codepoint < 0x2776) {
                codepoint in 0x24ea..0x24ff
              } else {
                codepoint in 0x2776..0x2793
              }
            }
          } else {
            if (codepoint < 0x3220) {
              if (codepoint < 0x3192) {
                codepoint == 0x2cfd
              } else {
                codepoint in 0x3192..0x3195
              }
            } else {
              if (codepoint < 0x3248) {
                codepoint in 0x3220..0x3229
              } else {
                if (codepoint < 0x3251) {
                  codepoint in 0x3248..0x324f
                } else {
                  codepoint in 0x3251..0x325f
                }
              }
            }
          }
        } else {
          if (codepoint < 0x10175) {
            if (codepoint < 0xa830) {
              if (codepoint < 0x32b1) {
                codepoint in 0x3280..0x3289
              } else {
                codepoint in 0x32b1..0x32bf
              }
            } else {
              if (codepoint < 0x10107) {
                codepoint in 0xa830..0xa835
              } else {
                codepoint in 0x10107..0x10133
              }
            }
          } else {
            if (codepoint < 0x102e1) {
              if (codepoint < 0x1018a) {
                codepoint in 0x10175..0x10178
              } else {
                codepoint in 0x1018a..0x1018b
              }
            } else {
              if (codepoint < 0x10320) {
                codepoint in 0x102e1..0x102fb
              } else {
                if (codepoint < 0x10858) {
                  codepoint in 0x10320..0x10323
                } else {
                  codepoint in 0x10858..0x1085f
                }
              }
            }
          }
        }
      }
    } else {
      if (codepoint < 0x10fc5) {
        if (codepoint < 0x10a9d) {
          if (codepoint < 0x109bc) {
            if (codepoint < 0x108fb) {
              if (codepoint < 0x108a7) {
                codepoint in 0x10879..0x1087f
              } else {
                codepoint in 0x108a7..0x108af
              }
            } else {
              if (codepoint < 0x10916) {
                codepoint in 0x108fb..0x108ff
              } else {
                codepoint in 0x10916..0x1091b
              }
            }
          } else {
            if (codepoint < 0x109d2) {
              if (codepoint < 0x109c0) {
                codepoint in 0x109bc..0x109bd
              } else {
                codepoint in 0x109c0..0x109cf
              }
            } else {
              if (codepoint < 0x10a40) {
                codepoint in 0x109d2..0x109ff
              } else {
                if (codepoint < 0x10a7d) {
                  codepoint in 0x10a40..0x10a48
                } else {
                  codepoint in 0x10a7d..0x10a7e
                }
              }
            }
          }
        } else {
          if (codepoint < 0x10ba9) {
            if (codepoint < 0x10b58) {
              if (codepoint < 0x10aeb) {
                codepoint in 0x10a9d..0x10a9f
              } else {
                codepoint in 0x10aeb..0x10aef
              }
            } else {
              if (codepoint < 0x10b78) {
                codepoint in 0x10b58..0x10b5f
              } else {
                codepoint in 0x10b78..0x10b7f
              }
            }
          } else {
            if (codepoint < 0x10e60) {
              if (codepoint < 0x10cfa) {
                codepoint in 0x10ba9..0x10baf
              } else {
                codepoint in 0x10cfa..0x10cff
              }
            } else {
              if (codepoint < 0x10f1d) {
                codepoint in 0x10e60..0x10e7e
              } else {
                if (codepoint < 0x10f51) {
                  codepoint in 0x10f1d..0x10f26
                } else {
                  codepoint in 0x10f51..0x10f54
                }
              }
            }
          }
        }
      } else {
        if (codepoint < 0x1d2e0) {
          if (codepoint < 0x118ea) {
            if (codepoint < 0x111e1) {
              if (codepoint < 0x11052) {
                codepoint in 0x10fc5..0x10fcb
              } else {
                codepoint in 0x11052..0x11065
              }
            } else {
              if (codepoint < 0x1173a) {
                codepoint in 0x111e1..0x111f4
              } else {
                codepoint in 0x1173a..0x1173b
              }
            }
          } else {
            if (codepoint < 0x11fc0) {
              if (codepoint < 0x11c5a) {
                codepoint in 0x118ea..0x118f2
              } else {
                codepoint in 0x11c5a..0x11c6c
              }
            } else {
              if (codepoint < 0x16b5b) {
                codepoint in 0x11fc0..0x11fd4
              } else {
                if (codepoint < 0x16e80) {
                  codepoint in 0x16b5b..0x16b61
                } else {
                  codepoint in 0x16e80..0x16e96
                }
              }
            }
          }
        } else {
          if (codepoint < 0x1ecad) {
            if (codepoint < 0x1e8c7) {
              if (codepoint < 0x1d360) {
                codepoint in 0x1d2e0..0x1d2f3
              } else {
                codepoint in 0x1d360..0x1d378
              }
            } else {
              if (codepoint < 0x1ec71) {
                codepoint in 0x1e8c7..0x1e8cf
              } else {
                codepoint in 0x1ec71..0x1ecab
              }
            }
          } else {
            if (codepoint < 0x1ed01) {
              if (codepoint < 0x1ecb1) {
                codepoint in 0x1ecad..0x1ecaf
              } else {
                codepoint in 0x1ecb1..0x1ecb4
              }
            } else {
              if (codepoint < 0x1ed2f) {
                codepoint in 0x1ed01..0x1ed2d
              } else {
                if (codepoint < 0x1f100) {
                  codepoint in 0x1ed2f..0x1ed3d
                } else {
                  codepoint in 0x1f100..0x1f10c
                }
              }
            }
          }
        }
      }
    }
  }
}
