package io.github.optimumcode.json.schema.`internal`.unicode.categories

import io.github.optimumcode.json.schema.`internal`.unicode.CharacterCategoryData
import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress

@Suppress("detekt:all")
internal object PrivateUse : CharacterCategoryData {
  override val minCodepoint: Int
    get() = 0xe000

  override val maxCodepoint: Int
    get() = 0x10fffd

  override fun contains(codepoint: Int): Boolean {
    if (minCodepoint > codepoint || maxCodepoint < codepoint) {
      return false
    }
    return if (codepoint < 0xf0000) {
      codepoint in 0xe000..0xf8ff
    } else {
      if (codepoint < 0x100000) {
        codepoint in 0xf0000..0xffffd
      } else {
        codepoint in 0x100000..0x10fffd
      }
    }
  }
}
