package io.github.optimumcode.json.schema.`internal`.unicode.categories

import io.github.optimumcode.json.schema.`internal`.unicode.CharacterCategoryData
import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress

@Suppress("detekt:all")
internal object SpaceSeparator : CharacterCategoryData {
  override val minCodepoint: Int
    get() = 0x20

  override val maxCodepoint: Int
    get() = 0x3000

  override fun contains(codepoint: Int): Boolean {
    if (minCodepoint > codepoint || maxCodepoint < codepoint) {
      return false
    }
    return if (codepoint < 0x2000) {
      if (codepoint < 0xa0) {
        codepoint == 0x20
      } else {
        if (codepoint < 0x1680) {
          codepoint == 0xa0
        } else {
          codepoint == 0x1680
        }
      }
    } else {
      if (codepoint < 0x205f) {
        if (codepoint < 0x202f) {
          codepoint in 0x2000..0x200a
        } else {
          codepoint == 0x202f
        }
      } else {
        if (codepoint < 0x3000) {
          codepoint == 0x205f
        } else {
          codepoint == 0x3000
        }
      }
    }
  }
}
