package io.github.optimumcode.json.schema.`internal`.unicode.categories

import io.github.optimumcode.json.schema.`internal`.unicode.CharacterCategoryData
import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress

@Suppress("detekt:all")
internal object TitlecaseLetter : CharacterCategoryData {
  override val minCodepoint: Int
    get() = 0x1c5

  override val maxCodepoint: Int
    get() = 0x1ffc

  override fun contains(codepoint: Int): Boolean {
    if (minCodepoint > codepoint || maxCodepoint < codepoint) {
      return false
    }
    return if (codepoint < 0x1f98) {
      if (codepoint < 0x1cb) {
        if (codepoint < 0x1c8) {
          codepoint == 0x1c5
        } else {
          codepoint == 0x1c8
        }
      } else {
        if (codepoint < 0x1f2) {
          codepoint == 0x1cb
        } else {
          if (codepoint < 0x1f88) {
            codepoint == 0x1f2
          } else {
            codepoint in 0x1f88..0x1f8f
          }
        }
      }
    } else {
      if (codepoint < 0x1fbc) {
        if (codepoint < 0x1fa8) {
          codepoint in 0x1f98..0x1f9f
        } else {
          codepoint in 0x1fa8..0x1faf
        }
      } else {
        if (codepoint < 0x1fcc) {
          codepoint == 0x1fbc
        } else {
          if (codepoint < 0x1ffc) {
            codepoint == 0x1fcc
          } else {
            codepoint == 0x1ffc
          }
        }
      }
    }
  }
}
