package io.github.optimumcode.json.schema.`internal`.unicode.classes

import io.github.optimumcode.json.schema.`internal`.unicode.CharacterDirectionData
import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress

@Suppress("detekt:all")
internal object ArabicNumber : CharacterDirectionData {
  override val minCodepoint: Int
    get() = 0x600

  override val maxCodepoint: Int
    get() = 0x10e7e

  override fun contains(codepoint: Int): Boolean {
    if (minCodepoint > codepoint || maxCodepoint < codepoint) {
      return false
    }
    return if (codepoint < 0x6dd) {
      if (codepoint < 0x660) {
        codepoint in 0x600..0x605
      } else {
        if (codepoint < 0x66b) {
          codepoint in 0x660..0x669
        } else {
          codepoint in 0x66b..0x66c
        }
      }
    } else {
      if (codepoint < 0x10d30) {
        if (codepoint < 0x8e2) {
          codepoint == 0x6dd
        } else {
          codepoint == 0x8e2
        }
      } else {
        if (codepoint < 0x10e60) {
          codepoint in 0x10d30..0x10d39
        } else {
          codepoint in 0x10e60..0x10e7e
        }
      }
    }
  }
}
