package io.github.optimumcode.json.schema.`internal`.unicode.classes

import io.github.optimumcode.json.schema.`internal`.unicode.CharacterDirectionData
import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress

@Suppress("detekt:all")
internal object BoundaryNeutral : CharacterDirectionData {
  override val minCodepoint: Int
    get() = 0x0

  override val maxCodepoint: Int
    get() = 0xe007f

  override fun contains(codepoint: Int): Boolean {
    if (minCodepoint > codepoint || maxCodepoint < codepoint) {
      return false
    }
    return if (codepoint < 0x2060) {
      if (codepoint < 0x86) {
        if (codepoint < 0xe) {
          codepoint in 0x0..0x8
        } else {
          if (codepoint < 0x7f) {
            codepoint in 0xe..0x1b
          } else {
            codepoint in 0x7f..0x84
          }
        }
      } else {
        if (codepoint < 0x180e) {
          if (codepoint < 0xad) {
            codepoint in 0x86..0x9f
          } else {
            codepoint == 0xad
          }
        } else {
          if (codepoint < 0x200b) {
            codepoint == 0x180e
          } else {
            codepoint in 0x200b..0x200d
          }
        }
      }
    } else {
      if (codepoint < 0x1bca0) {
        if (codepoint < 0x206a) {
          codepoint in 0x2060..0x2064
        } else {
          if (codepoint < 0xfeff) {
            codepoint in 0x206a..0x206f
          } else {
            codepoint == 0xfeff
          }
        }
      } else {
        if (codepoint < 0xe0001) {
          if (codepoint < 0x1d173) {
            codepoint in 0x1bca0..0x1bca3
          } else {
            codepoint in 0x1d173..0x1d17a
          }
        } else {
          if (codepoint < 0xe0020) {
            codepoint == 0xe0001
          } else {
            codepoint in 0xe0020..0xe007f
          }
        }
      }
    }
  }
}
