package io.github.optimumcode.json.schema.`internal`.unicode.classes

import io.github.optimumcode.json.schema.`internal`.unicode.CharacterDirectionData
import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress

@Suppress("detekt:all")
internal object CommonSeparator : CharacterDirectionData {
  override val minCodepoint: Int
    get() = 0x2c

  override val maxCodepoint: Int
    get() = 0xff1a

  override fun contains(codepoint: Int): Boolean {
    if (minCodepoint > codepoint || maxCodepoint < codepoint) {
      return false
    }
    return if (codepoint < 0x2044) {
      if (codepoint < 0xa0) {
        if (codepoint < 0x2e) {
          codepoint == 0x2c
        } else {
          if (codepoint < 0x3a) {
            codepoint in 0x2e..0x2f
          } else {
            codepoint == 0x3a
          }
        }
      } else {
        if (codepoint < 0x60c) {
          codepoint == 0xa0
        } else {
          if (codepoint < 0x202f) {
            codepoint == 0x60c
          } else {
            codepoint == 0x202f
          }
        }
      }
    } else {
      if (codepoint < 0xfe55) {
        if (codepoint < 0xfe50) {
          codepoint == 0x2044
        } else {
          if (codepoint < 0xfe52) {
            codepoint == 0xfe50
          } else {
            codepoint == 0xfe52
          }
        }
      } else {
        if (codepoint < 0xff0e) {
          if (codepoint < 0xff0c) {
            codepoint == 0xfe55
          } else {
            codepoint == 0xff0c
          }
        } else {
          if (codepoint < 0xff1a) {
            codepoint in 0xff0e..0xff0f
          } else {
            codepoint == 0xff1a
          }
        }
      }
    }
  }
}
