package io.github.optimumcode.json.schema.`internal`.unicode.classes

import io.github.optimumcode.json.schema.`internal`.unicode.CharacterDirectionData
import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress

@Suppress("detekt:all")
internal object EuropeanNumber : CharacterDirectionData {
  override val minCodepoint: Int
    get() = 0x30

  override val maxCodepoint: Int
    get() = 0x1fbf9

  override fun contains(codepoint: Int): Boolean {
    if (minCodepoint > codepoint || maxCodepoint < codepoint) {
      return false
    }
    return if (codepoint < 0x2080) {
      if (codepoint < 0x6f0) {
        if (codepoint < 0xb2) {
          codepoint in 0x30..0x39
        } else {
          if (codepoint < 0xb9) {
            codepoint in 0xb2..0xb3
          } else {
            codepoint == 0xb9
          }
        }
      } else {
        if (codepoint < 0x2070) {
          codepoint in 0x6f0..0x6f9
        } else {
          if (codepoint < 0x2074) {
            codepoint == 0x2070
          } else {
            codepoint in 0x2074..0x2079
          }
        }
      }
    } else {
      if (codepoint < 0x102e1) {
        if (codepoint < 0x2488) {
          codepoint in 0x2080..0x2089
        } else {
          if (codepoint < 0xff10) {
            codepoint in 0x2488..0x249b
          } else {
            codepoint in 0xff10..0xff19
          }
        }
      } else {
        if (codepoint < 0x1f100) {
          if (codepoint < 0x1d7ce) {
            codepoint in 0x102e1..0x102fb
          } else {
            codepoint in 0x1d7ce..0x1d7ff
          }
        } else {
          if (codepoint < 0x1fbf0) {
            codepoint in 0x1f100..0x1f10a
          } else {
            codepoint in 0x1fbf0..0x1fbf9
          }
        }
      }
    }
  }
}
