package io.github.optimumcode.json.schema.`internal`.unicode.classes

import io.github.optimumcode.json.schema.`internal`.unicode.CharacterDirectionData
import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress

@Suppress("detekt:all")
internal object EuropeanSeparator : CharacterDirectionData {
  override val minCodepoint: Int
    get() = 0x2b

  override val maxCodepoint: Int
    get() = 0xff0d

  override fun contains(codepoint: Int): Boolean {
    if (minCodepoint > codepoint || maxCodepoint < codepoint) {
      return false
    }
    return if (codepoint < 0x2212) {
      if (codepoint < 0x207a) {
        if (codepoint < 0x2d) {
          codepoint == 0x2b
        } else {
          codepoint == 0x2d
        }
      } else {
        if (codepoint < 0x208a) {
          codepoint in 0x207a..0x207b
        } else {
          codepoint in 0x208a..0x208b
        }
      }
    } else {
      if (codepoint < 0xfe62) {
        if (codepoint < 0xfb29) {
          codepoint == 0x2212
        } else {
          codepoint == 0xfb29
        }
      } else {
        if (codepoint < 0xff0b) {
          codepoint in 0xfe62..0xfe63
        } else {
          if (codepoint < 0xff0d) {
            codepoint == 0xff0b
          } else {
            codepoint == 0xff0d
          }
        }
      }
    }
  }
}
