package io.github.optimumcode.json.schema.`internal`.unicode.classes

import io.github.optimumcode.json.schema.`internal`.unicode.CharacterDirectionData
import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress

@Suppress("detekt:all")
internal object EuropeanTerminator : CharacterDirectionData {
  override val minCodepoint: Int
    get() = 0x23

  override val maxCodepoint: Int
    get() = 0x1e2ff

  override fun contains(codepoint: Int): Boolean {
    if (minCodepoint > codepoint || maxCodepoint < codepoint) {
      return false
    }
    return if (codepoint < 0x2030) {
      if (codepoint < 0x9f2) {
        if (codepoint < 0x58f) {
          if (codepoint < 0xa2) {
            codepoint in 0x23..0x25
          } else {
            if (codepoint < 0xb0) {
              codepoint in 0xa2..0xa5
            } else {
              codepoint in 0xb0..0xb1
            }
          }
        } else {
          if (codepoint < 0x609) {
            codepoint == 0x58f
          } else {
            if (codepoint < 0x66a) {
              codepoint in 0x609..0x60a
            } else {
              codepoint == 0x66a
            }
          }
        }
      } else {
        if (codepoint < 0xbf9) {
          if (codepoint < 0x9fb) {
            codepoint in 0x9f2..0x9f3
          } else {
            if (codepoint < 0xaf1) {
              codepoint == 0x9fb
            } else {
              codepoint == 0xaf1
            }
          }
        } else {
          if (codepoint < 0xe3f) {
            codepoint == 0xbf9
          } else {
            if (codepoint < 0x17db) {
              codepoint == 0xe3f
            } else {
              codepoint == 0x17db
            }
          }
        }
      }
    } else {
      if (codepoint < 0xfe69) {
        if (codepoint < 0x2213) {
          if (codepoint < 0x20a0) {
            codepoint in 0x2030..0x2034
          } else {
            if (codepoint < 0x212e) {
              codepoint in 0x20a0..0x20bf
            } else {
              codepoint == 0x212e
            }
          }
        } else {
          if (codepoint < 0xa838) {
            codepoint == 0x2213
          } else {
            if (codepoint < 0xfe5f) {
              codepoint in 0xa838..0xa839
            } else {
              codepoint == 0xfe5f
            }
          }
        }
      } else {
        if (codepoint < 0xffe5) {
          if (codepoint < 0xff03) {
            codepoint in 0xfe69..0xfe6a
          } else {
            if (codepoint < 0xffe0) {
              codepoint in 0xff03..0xff05
            } else {
              codepoint in 0xffe0..0xffe1
            }
          }
        } else {
          if (codepoint < 0x11fdd) {
            codepoint in 0xffe5..0xffe6
          } else {
            if (codepoint < 0x1e2ff) {
              codepoint in 0x11fdd..0x11fe0
            } else {
              codepoint == 0x1e2ff
            }
          }
        }
      }
    }
  }
}
