package io.github.optimumcode.json.schema.`internal`.unicode.classes

import io.github.optimumcode.json.schema.`internal`.unicode.CharacterDirectionData
import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress

@Suppress("detekt:all")
internal object ParagraphSeparator : CharacterDirectionData {
  override val minCodepoint: Int
    get() = 0xa

  override val maxCodepoint: Int
    get() = 0x2029

  override fun contains(codepoint: Int): Boolean {
    if (minCodepoint > codepoint || maxCodepoint < codepoint) {
      return false
    }
    return if (codepoint < 0x1c) {
      if (codepoint < 0xd) {
        codepoint == 0xa
      } else {
        codepoint == 0xd
      }
    } else {
      if (codepoint < 0x85) {
        codepoint in 0x1c..0x1e
      } else {
        if (codepoint < 0x2029) {
          codepoint == 0x85
        } else {
          codepoint == 0x2029
        }
      }
    }
  }
}
