package io.github.optimumcode.json.schema.`internal`.unicode.classes

import io.github.optimumcode.json.schema.`internal`.unicode.CharacterDirectionData
import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress

@Suppress("detekt:all")
internal object SegmentSeparator : CharacterDirectionData {
  override val minCodepoint: Int
    get() = 0x9

  override val maxCodepoint: Int
    get() = 0x1f

  override fun contains(codepoint: Int): Boolean {
    if (minCodepoint > codepoint || maxCodepoint < codepoint) {
      return false
    }
    return if (codepoint < 0xb) {
      codepoint == 0x9
    } else {
      if (codepoint < 0x1f) {
        codepoint == 0xb
      } else {
        codepoint == 0x1f
      }
    }
  }
}
