package io.github.optimumcode.json.schema.`internal`.unicode.classes

import io.github.optimumcode.json.schema.`internal`.unicode.CharacterDirectionData
import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress

@Suppress("detekt:all")
internal object WhiteSpace : CharacterDirectionData {
  override val minCodepoint: Int
    get() = 0xc

  override val maxCodepoint: Int
    get() = 0x3000

  override fun contains(codepoint: Int): Boolean {
    if (minCodepoint > codepoint || maxCodepoint < codepoint) {
      return false
    }
    return if (codepoint < 0x2000) {
      if (codepoint < 0x20) {
        codepoint == 0xc
      } else {
        if (codepoint < 0x1680) {
          codepoint == 0x20
        } else {
          codepoint == 0x1680
        }
      }
    } else {
      if (codepoint < 0x205f) {
        if (codepoint < 0x2028) {
          codepoint in 0x2000..0x200a
        } else {
          codepoint == 0x2028
        }
      } else {
        if (codepoint < 0x3000) {
          codepoint == 0x205f
        } else {
          codepoint == 0x3000
        }
      }
    }
  }
}
