/*
 * Decompiled with CFR 0.152.
 */
package com.martijncourteaux.multitouchgestures;

import com.martijncourteaux.multitouchgestures.MultiTouchGestureUtilities;
import com.martijncourteaux.multitouchgestures.event.GestureEvent;
import java.awt.Dimension;
import java.awt.Toolkit;
import javax.swing.SwingUtilities;

class EventDispatch {
    private static Thread gestureEventThread;

    EventDispatch() {
    }

    public static native void init();

    private static native void start();

    public static native void stop();

    public static void startInSeparateThread() {
        if (gestureEventThread != null && gestureEventThread.isAlive()) {
            return;
        }
        gestureEventThread = new Thread(() -> {
            EventDispatch.init();
            EventDispatch.start();
        }, "Gesture Event Thread");
        gestureEventThread.start();
    }

    public static void dispatchMagnifyGesture(double mouseX, double mouseY, double magnification, int phase) {
        SwingUtilities.invokeLater(() -> {
            Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
            MultiTouchGestureUtilities.dispatchMagnifyGesture(mouseX, (double)d.height - mouseY, magnification, GestureEvent.Phase.getByCode(phase));
        });
    }

    public static void dispatchRotateGesture(double mouseX, double mouseY, double rotation, int phase) {
        SwingUtilities.invokeLater(() -> {
            Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
            MultiTouchGestureUtilities.dispatchRotateGesture(mouseX, (double)d.height - mouseY, -Math.toRadians(rotation), GestureEvent.Phase.getByCode(phase));
        });
    }

    public static void dispatchScrollWheelEvent(double mouseX, double mouseY, double deltaX, double deltaY, int phase, int subtype) {
        SwingUtilities.invokeLater(() -> {
            Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
            MultiTouchGestureUtilities.dispatchScrollGesture(mouseX, (double)d.height - mouseY, deltaX, deltaY, GestureEvent.Phase.getByCode(phase), subtype == 0 ? GestureEvent.Subtype.MOUSE : GestureEvent.Subtype.TABLET);
        });
    }
}

