/*
 * Decompiled with CFR 0.152.
 */
package com.martijncourteaux.multitouchgestures;

import com.martijncourteaux.multitouchgestures.GestureListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;

class MultiTouchClient
implements MouseMotionListener,
MouseListener {
    private final JComponent component;
    private final List<GestureListener> listeners;
    private boolean inside;

    public MultiTouchClient(JComponent component) {
        this.component = component;
        this.listeners = new ArrayList<GestureListener>();
    }

    public void attachListeners() {
        this.inside = false;
        this.component.addMouseListener(this);
        this.component.addMouseMotionListener(this);
    }

    public void detachListeners() {
        this.inside = false;
        this.component.removeMouseListener(this);
        this.component.removeMouseMotionListener(this);
    }

    public JComponent getComponent() {
        return this.component;
    }

    public List<GestureListener> getListeners() {
        return this.listeners;
    }

    public boolean isInside() {
        return this.inside;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.inside = true;
        if (e.getX() < 0 || this.component.getWidth() >= e.getX()) {
            this.inside = false;
        }
        if (e.getY() < 0 || this.component.getHeight() >= e.getY()) {
            this.inside = false;
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.inside = true;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.inside = true;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.inside = true;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.inside = true;
        if (e.getX() < 0 || this.component.getWidth() >= e.getX()) {
            this.inside = false;
        }
        if (e.getY() < 0 || this.component.getHeight() >= e.getY()) {
            this.inside = false;
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.inside = true;
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.inside = false;
    }
}

