/*
 * Decompiled with CFR 0.152.
 */
package com.martijncourteaux.multitouchgestures;

import com.martijncourteaux.multitouchgestures.EventDispatch;
import com.martijncourteaux.multitouchgestures.GestureListener;
import com.martijncourteaux.multitouchgestures.MultiTouchClient;
import com.martijncourteaux.multitouchgestures.event.GestureEvent;
import com.martijncourteaux.multitouchgestures.event.MagnifyGestureEvent;
import com.martijncourteaux.multitouchgestures.event.RotateGestureEvent;
import com.martijncourteaux.multitouchgestures.event.ScrollGestureEvent;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class MultiTouchGestureUtilities {
    private static boolean loaded;
    private static final HashMap<JComponent, MultiTouchClient> clients;
    private static int listenerCount;

    public static boolean isSupported() {
        return MultiTouchGestureUtilities.isMacOS();
    }

    private static boolean isMacOS() {
        String os = System.getProperty("os.name").toLowerCase().replaceAll("\\s+", "");
        return os.contains("macos");
    }

    private static boolean isArchArm() {
        String arch = System.getProperty("os.arch").toLowerCase().replaceAll("\\s+", "");
        return arch.contains("aarch");
    }

    private static void loadNativeLibrary() {
        if (loaded) {
            return;
        }
        if (!MultiTouchGestureUtilities.isSupported()) {
            throw new IllegalStateException("Only macOS is supported.");
        }
        String libName = MultiTouchGestureUtilities.isArchArm() ? "libmtg_mac_arm64.dylib" : "libmtg_mac_x86_64.dylib";
        File path = MultiTouchGestureUtilities.extractNative(libName);
        System.load(path.getAbsolutePath());
        loaded = true;
        Runtime.getRuntime().addShutdownHook(new Thread(EventDispatch::stop));
    }

    private static File extractNative(String nativeLibraryName) {
        byte[] libraryContent = MultiTouchGestureUtilities.readResourceToBuffer("/native/" + nativeLibraryName);
        String tempDir = System.getProperty("java.io.tmpdir");
        File nativeLibraryFile = new File(tempDir, nativeLibraryName);
        if (!nativeLibraryFile.exists()) {
            MultiTouchGestureUtilities.writeToFile(nativeLibraryFile, libraryContent);
            nativeLibraryFile.deleteOnExit();
            return nativeLibraryFile;
        }
        try {
            File tempFile = File.createTempFile(nativeLibraryName, "", new File(tempDir));
            MultiTouchGestureUtilities.writeToFile(tempFile, libraryContent);
            tempFile.deleteOnExit();
            return tempFile;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void writeToFile(File outputFile, byte[] content) {
        try (FileOutputStream fos = new FileOutputStream(outputFile);){
            fos.write(content);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot write to file " + outputFile.getAbsolutePath(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] readResourceToBuffer(String fileName) {
        try (InputStream is = MultiTouchGestureUtilities.class.getResourceAsStream(fileName);){
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            MultiTouchGestureUtilities.copyStreams(is, baos);
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot load resource " + fileName, e);
        }
    }

    private static void copyStreams(InputStream inputStream, OutputStream outputStream) throws IOException {
        int bytesRead;
        byte[] buff = new byte[8192];
        while ((bytesRead = inputStream.read(buff)) != -1) {
            outputStream.write(buff, 0, bytesRead);
        }
    }

    public static int getListenerCount() {
        return listenerCount;
    }

    public static void addGestureListener(JComponent component, GestureListener listener) {
        MultiTouchClient client;
        if (!MultiTouchGestureUtilities.isSupported()) {
            throw new IllegalStateException("Only macOS is supported.");
        }
        if (!loaded) {
            MultiTouchGestureUtilities.loadNativeLibrary();
        }
        if (listenerCount == 0) {
            EventDispatch.startInSeparateThread();
        }
        if ((client = clients.get(component)) == null) {
            client = new MultiTouchClient(component);
            client.attachListeners();
            clients.put(component, client);
        }
        List<GestureListener> list = client.getListeners();
        list.add(listener);
        ++listenerCount;
    }

    public static boolean removeGestureListener(JComponent component, GestureListener listener) {
        MultiTouchClient client = clients.get(component);
        if (client == null) {
            return false;
        }
        List<GestureListener> list = client.getListeners();
        if (list == null) {
            return false;
        }
        if (list.remove(listener)) {
            if (list.isEmpty()) {
                client.detachListeners();
                clients.remove(component);
            }
            if (--listenerCount == 0) {
                EventDispatch.stop();
            }
            return true;
        }
        return false;
    }

    public static int removeAllGestureListeners(JComponent component) {
        MultiTouchClient client = clients.get(component);
        if (client == null) {
            return 0;
        }
        client.detachListeners();
        clients.remove(component);
        List<GestureListener> list = client.getListeners();
        if (list == null) {
            return 0;
        }
        int c = list.size();
        list.clear();
        return c;
    }

    protected static void dispatchMagnifyGesture(double mouseX, double mouseY, double magnification, GestureEvent.Phase phase) {
        if (listenerCount == 0) {
            return;
        }
        int mXi = (int)Math.round(mouseX);
        int mYi = (int)Math.round(mouseY);
        for (Map.Entry<JComponent, MultiTouchClient> e : clients.entrySet()) {
            MultiTouchClient client;
            Rectangle r;
            JComponent c = e.getKey();
            if (!c.isValid() || !c.isVisible() || !(r = new Rectangle(c.getLocationOnScreen(), c.getSize())).contains(mXi, mYi) || !(client = e.getValue()).isInside()) continue;
            List<GestureListener> list = client.getListeners();
            Point relP = new Point(mXi, mYi);
            SwingUtilities.convertPointFromScreen(relP, c);
            MagnifyGestureEvent me = new MagnifyGestureEvent(c, relP.getX(), relP.getY(), mouseX, mouseY, phase, magnification);
            for (GestureListener l : list) {
                l.magnify(me);
            }
            return;
        }
    }

    protected static void dispatchRotateGesture(double mouseX, double mouseY, double rotation, GestureEvent.Phase phase) {
        if (listenerCount == 0) {
            return;
        }
        int mXi = (int)Math.round(mouseX);
        int mYi = (int)Math.round(mouseY);
        for (Map.Entry<JComponent, MultiTouchClient> e : clients.entrySet()) {
            MultiTouchClient client;
            JComponent c = e.getKey();
            Rectangle r = new Rectangle(c.getLocationOnScreen(), c.getSize());
            if (!r.contains(mXi, mYi) || !(client = e.getValue()).isInside()) continue;
            List<GestureListener> list = client.getListeners();
            Point relP = new Point(mXi, mYi);
            SwingUtilities.convertPointFromScreen(relP, c);
            RotateGestureEvent re = new RotateGestureEvent(c, relP.getX(), relP.getY(), mouseX, mouseY, phase, rotation);
            for (GestureListener l : list) {
                l.rotate(re);
            }
            return;
        }
    }

    protected static void dispatchScrollGesture(double mouseX, double mouseY, double dX, double dY, GestureEvent.Phase phase, GestureEvent.Subtype subtype) {
        if (listenerCount == 0) {
            return;
        }
        int mXi = (int)Math.round(mouseX);
        int mYi = (int)Math.round(mouseY);
        for (Map.Entry<JComponent, MultiTouchClient> e : clients.entrySet()) {
            MultiTouchClient client;
            JComponent c = e.getKey();
            Rectangle r = new Rectangle(c.getLocationOnScreen(), c.getSize());
            if (!r.contains(mXi, mYi) || !(client = e.getValue()).isInside()) continue;
            List<GestureListener> list = client.getListeners();
            Point relP = new Point(mXi, mYi);
            SwingUtilities.convertPointFromScreen(relP, c);
            ScrollGestureEvent se = new ScrollGestureEvent(c, relP.getX(), relP.getY(), mouseX, mouseY, phase, dX, dY, subtype);
            for (GestureListener l : list) {
                l.scroll(se);
            }
            return;
        }
    }

    static {
        clients = new HashMap();
        listenerCount = 0;
    }
}

