/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.rectcut;

import io.github.palexdev.rectcut.LayoutFunction;
import io.github.palexdev.rectcut.RectSide;
import java.util.Objects;
import java.util.function.BiConsumer;

public final class Rect
implements Cloneable {
    private double minX;
    private double minY;
    private double maxX;
    private double maxY;
    private double hSpacing = 0.0;
    private double vSpacing = 0.0;

    public Rect(double minX, double minY, double maxX, double maxY) {
        this.minX = minX;
        this.minY = minY;
        this.maxX = maxX;
        this.maxY = maxY;
    }

    public static Rect of(double minX, double minY, double maxX, double maxY) {
        return new Rect(minX, minY, maxX, maxY);
    }

    public Rect cut(RectSide side, double amount) {
        return side.cut(this, amount);
    }

    public Rect cutTop(double amount) {
        double minY = this.minY;
        this.minY = Math.min(this.maxY, this.minY + amount);
        Rect area = Rect.of(this.minX, minY, this.maxX, this.minY);
        this.minY += this.vSpacing;
        return area;
    }

    public Rect cutRight(double amount) {
        double maxX = this.maxX();
        this.maxX = Math.max(this.minX, this.maxX - amount);
        Rect area = Rect.of(this.maxX, this.minY, maxX, this.maxY);
        this.maxX -= this.hSpacing;
        return area;
    }

    public Rect cutBottom(double amount) {
        double maxY = this.maxY;
        this.maxY = Math.max(this.minY, this.maxY - amount);
        Rect area = Rect.of(this.minX, this.maxY, this.maxX, maxY);
        this.maxY -= this.vSpacing;
        return area;
    }

    public Rect cutLeft(double amount) {
        double minX = this.minX;
        this.minX = Math.min(this.maxX, this.minX + amount);
        Rect area = Rect.of(minX, this.minY, this.minX, this.maxY);
        this.minX += this.hSpacing;
        return area;
    }

    public Rect get(RectSide side, double amount) {
        return side.get(this, amount);
    }

    public Rect getTop(double amount) {
        double maxY = Math.min(this.maxY, this.minY + amount);
        return Rect.of(this.minX, this.minY, this.maxX, maxY);
    }

    public Rect getRight(double amount) {
        double minX = Math.max(this.minX, this.maxX - amount);
        return Rect.of(minX, this.minY, this.maxX, this.maxY);
    }

    public Rect getBottom(double amount) {
        double minY = Math.max(this.minY, this.maxY - amount);
        return Rect.of(this.minX, minY, this.maxX, this.maxY);
    }

    public Rect getLeft(double amount) {
        double maxX = Math.min(this.maxX, this.minX + amount);
        return Rect.of(this.minX, this.minY, maxX, this.maxY);
    }

    public Rect[] middleHCut(double amount) {
        double mMinX = (this.width() - amount) / 2.0 + this.minX;
        double mMaxX = mMinX + amount;
        return new Rect[]{Rect.of(this.minX, this.minY, mMinX, this.maxY), Rect.of(mMinX, this.minY, mMaxX, this.maxY), Rect.of(mMaxX, this.minY, this.maxX, this.maxY)};
    }

    public Rect[] middleVCut(double amount) {
        double mMinY = (this.height() - amount) / 2.0 + this.minY;
        double mMaxY = mMinY + amount;
        return new Rect[]{Rect.of(this.minX, this.minY, this.maxX, mMinY), Rect.of(this.minX, mMinY, this.maxX, mMaxY), Rect.of(this.minX, mMaxY, this.maxX, this.maxY)};
    }

    public Rect add(RectSide side, double amount) {
        return side.add(this, amount);
    }

    public Rect addTop(double amount) {
        return Rect.of(this.minX, this.minY - amount, this.maxX, this.minY);
    }

    public Rect addRight(double amount) {
        return Rect.of(this.maxX, this.minY, this.maxX + amount, this.maxY);
    }

    public Rect addBottom(double amount) {
        return Rect.of(this.minX, this.maxY, this.maxX, this.maxY + amount);
    }

    public Rect addLeft(double amount) {
        return Rect.of(this.minX - amount, this.minY, this.minX, this.maxY);
    }

    public Rect extend(double amount) {
        return Rect.of(this.minX - amount, this.minY - amount, this.maxX + amount, this.maxY + amount);
    }

    public Rect contract(double amount) {
        return Rect.of(this.minX + amount, this.minY + amount, this.maxX - amount, this.maxY - amount);
    }

    public Rect position(BiConsumer<Double, Double> fn) {
        fn.accept(this.minX, this.minY);
        return this;
    }

    public Rect resize(BiConsumer<Double, Double> fn) {
        double w = this.width();
        double h = this.height();
        fn.accept(w, h);
        return this;
    }

    public Rect layout(LayoutFunction fn) {
        double w = this.width();
        double h = this.height();
        fn.apply(this.minX, this.minY, w, h);
        return this;
    }

    protected Rect clone() {
        return Rect.of(this.minX, this.minY, this.maxX, this.maxY);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Rect rect = (Rect)o;
        return Double.compare(this.minX, rect.minX) == 0 && Double.compare(this.minY, rect.minY) == 0 && Double.compare(this.maxX, rect.maxX) == 0 && Double.compare(this.maxY, rect.maxY) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.minX, this.minY, this.maxX, this.maxY);
    }

    public String toString() {
        return "Rect[minX=" + this.minX + ", minY=" + this.minY + ", maxX=" + this.maxX + ", maxY=" + this.maxY + "]";
    }

    public double minX() {
        return this.minX;
    }

    public double minY() {
        return this.minY;
    }

    public double maxX() {
        return this.maxX;
    }

    public double maxY() {
        return this.maxY;
    }

    public double width() {
        return Math.max(0.0, this.maxX - this.minX);
    }

    public double height() {
        return Math.max(0.0, this.maxY - this.minY);
    }

    public Rect withInsets(double[] insets) {
        if (insets.length != 4) {
            throw new IllegalArgumentException("Insets array must be exactly of length 4");
        }
        return this.withInsets(insets[0], insets[1], insets[2], insets[3]);
    }

    public Rect withInsets(double uniform) {
        return this.withInsets(uniform, uniform, uniform, uniform);
    }

    public Rect withInsets(double top, double right, double bottom, double left) {
        this.minX += left;
        this.minY += top;
        this.maxX -= right;
        this.maxY -= bottom;
        return this;
    }

    public double hSpacing() {
        return this.hSpacing;
    }

    public Rect withHSpacing(double hSpacing) {
        this.hSpacing = hSpacing;
        return this;
    }

    public double vSpacing() {
        return this.vSpacing;
    }

    public Rect withVSpacing(double vSpacing) {
        this.vSpacing = vSpacing;
        return this;
    }
}

