/*
 * Decompiled with CFR 0.152.
 */
package io.github.pellse.assembler.rxjava;

import io.github.pellse.assembler.AssemblerAdapter;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class ObservableAdapter<T, ID, R>
implements AssemblerAdapter<T, ID, R, Observable<R>> {
    private final Scheduler scheduler;

    private ObservableAdapter(Scheduler scheduler) {
        this.scheduler = Objects.requireNonNull(scheduler);
    }

    public Observable<R> convertMapperSources(Supplier<Iterable<T>> topLevelEntitiesProvider, Function<Iterable<T>, Stream<Supplier<Map<ID, ?>>>> mapperSourcesBuilder, BiFunction<Iterable<T>, List<Map<ID, ?>>, Stream<R>> aggregateStreamBuilder) {
        return this.toObservable(topLevelEntitiesProvider).flatMap(entities -> Observable.zip((Iterable)((Stream)mapperSourcesBuilder.apply((Iterable<T>)entities)).map(this::toObservable).collect(Collectors.toList()), mapperResults -> (Stream)aggregateStreamBuilder.apply((Iterable)entities, Stream.of(mapperResults).map(mapResult -> (Map)mapResult).collect(Collectors.toList()))).flatMap(stream -> Observable.fromIterable(stream::iterator)));
    }

    private <U> Observable<U> toObservable(Supplier<U> mapperSource) {
        return Observable.fromCallable(mapperSource::get).subscribeOn(this.scheduler);
    }

    public static <T, ID, R> ObservableAdapter<T, ID, R> observableAdapter() {
        return ObservableAdapter.observableAdapter(Schedulers.computation());
    }

    public static <T, ID, R> ObservableAdapter<T, ID, R> observableAdapter(Executor executor) {
        return ObservableAdapter.observableAdapter(Schedulers.from((Executor)executor));
    }

    public static <T, ID, R> ObservableAdapter<T, ID, R> observableAdapter(Scheduler scheduler) {
        return new ObservableAdapter<T, ID, R>(scheduler);
    }
}

