package pluginloader.api

import kotlinx.serialization.Serializable
import org.bukkit.Location

@Serializable
open class Loc: V5{
    val world: String

    /**
     * @param world bukkit world name
     */
    constructor(x: Double, y: Double, z: Double, yaw: Float = 0F, pitch: Float = 0F, world: String = "world"): super(x, y, z, yaw, pitch){
        this.world = world
    }

    /**
     * @param world bukkit world name
     */
    constructor(x: Int, y: Int, z: Int, yaw: Float = 0F, pitch: Float = 0F, world: String = "world"): this(x.toDouble(), y.toDouble(), z.toDouble(), yaw, pitch, world)

    /**
     * @return null if world not loaded
     */
    fun location(): Location? = location(world)

    override fun equals(other: Any?): Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false
        if (!super.equals(other)) return false

        other as Loc

        if (world != other.world) return false

        return true
    }

    override fun hashCode(): Int {
        var result = super.hashCode()
        result = 31 * result + world.hashCode()
        return result
    }

    override fun toString(): String {
        return "Loc(x=$x, y=$y, z=$z, yaw=$yaw, pitch=$pitch, world=$world)"
    }

    companion object{
        val empty = Loc(0, 0, 0)
    }
}