package pluginloader.api

import org.bukkit.Bukkit
import org.bukkit.command.CommandSender
import org.bukkit.entity.Entity
import org.bukkit.entity.Player
import org.bukkit.event.Cancellable
import org.bukkit.event.entity.EntityDeathEvent
import org.bukkit.event.player.PlayerEvent
import org.bukkit.inventory.ItemStack
import org.bukkit.plugin.Plugin
import java.util.*

lateinit var plugin: Plugin

@Suppress("NOTHING_TO_INLINE")
inline fun ItemStack.item(): Item = Item.item(this)

typealias Sender = CommandSender

val Sender.isNotOp get() = !this.isOp

val Entity.uuid get(): UUID = this.uniqueId

val UUID.player get(): Player? = Bukkit.getPlayer(this)

val PlayerEvent.uuid get() = this.player.uuid

fun Cancellable.cancel() { this.isCancelled = true }

val EntityDeathEvent.killer: Player? get() = this.entity.killer

inline val onlinePlayers: Collection<Player> get() = Bukkit.getOnlinePlayers()

@Deprecated("Use more universal method", ReplaceWith("this.uuid"), level = DeprecationLevel.HIDDEN)
val Player.uuid get() = this.uniqueId