package pluginloader.api

import kotlinx.serialization.Serializable
import org.bukkit.Bukkit
import org.bukkit.Location
import org.bukkit.World

@Serializable
open class V5: V3{
    val yaw: Float
    val pitch: Float

    constructor(x: Double, y: Double, z: Double, yaw: Float = 0F, pitch: Float = 0F): super(x, y, z){
        this.yaw = yaw
        this.pitch = pitch
    }

    constructor(x: Int, y: Int, z: Int, yaw: Float = 0F, pitch: Float = 0F): this(x.toDouble(), y.toDouble(), z.toDouble(), yaw, pitch)

    constructor(l: Location): this(l.x, l.y, l.z, l.yaw, l.pitch)

    override val center: V5 get() = V5(blockX + 0.5, blockY.toDouble(), blockZ + 0.5, yaw, pitch)
    override val block: V5 get() = V5(blockX.toDouble(), blockY.toDouble(), blockZ.toDouble(), 0F, 0F)

    override fun location(world: World): Location = Location(world, x, y, z, yaw, pitch)

    //I really don't know why I need override like this, but don't touch
    override fun location(world: String): Location? {
        return location(Bukkit.getWorld(world) ?: return null)
    }

    override fun equals(other: Any?): Boolean {
        if (this === other) return true
        if(other == null)return false
        if (!javaClass.isInstance(other)) return false

        other as V5

        if (yaw != other.yaw) return false
        if (pitch != other.pitch) return false

        return super.equals(other)
    }

    override fun hashCode(): Int {
        var result = super.hashCode()
        result = 31 * result + yaw.hashCode()
        result = 31 * result + pitch.hashCode()
        return result
    }

    override fun toString() = "V5(x=$x, y=$y, z=$z, yaw=$yaw, pitch=$pitch)"
}