package pluginloader.api

import org.bukkit.command.CommandSender
import org.bukkit.event.EventPriority

/**
 * Register bukkit listener
 * See also [Plugin.registerListener]
 * Extremely recommend use internal, for compatibility with java 11+
 * ```
 * @Listener
 * internal fun listen(event: PlayerJoinEvent){event.player.sendMessage("hi")}
 * ```
 * @param priority call sequence: LOW (first), NORMAL (second), HIGH (third)
 * @param ignoreCancelled if true and event cancelled, method don't call
 */
@Target(AnnotationTarget.FUNCTION)
@Retention(AnnotationRetention.RUNTIME)
annotation class Listener(
    val priority: EventPriority = EventPriority.NORMAL,
    val ignoreCancelled: Boolean = false)

/**
 * Register bukkit command. Command can be used anyone
 * See also [Plugin.registerCommand]
 * Extremely recommend use internal, for compatibility with java 11+
 * ```
 * @Command("command", aliases = ["alias"])
 * internal fun cmd(sender: Sender, args: Args){}
 * ```
 * @param name command name, /hi
 * @param op if true, only player.isOp can call this command
 * @param sender [Sender] or [CommandSender]
 * @param args [Args] /example a b -> arrayOf("a", "b")
 */
@Target(AnnotationTarget.FUNCTION)
@Retention(AnnotationRetention.RUNTIME)
annotation class Command(
    val name: String,
    val aliases: Array<String> = [],
    val op: Boolean = false)