package pluginloader.api

import org.bukkit.Bukkit
import org.bukkit.entity.Player

val prefix = "§8[§aPlu§8]§f"

@PublishedApi
internal val constNonNull = Any()

fun Sender.msg(msg: String){
    sendMessage("$prefix $msg")
}

fun Args.use(sender: Sender, required: Int, text: String): Any?{
    if(size < required){
        sender.msg("Usage: §6/$text")
        return null
    }
    return constNonNull
}

fun Args.player(sender: Sender, index: Int): Player?{
    val str = this[index]
    val player = Bukkit.getPlayer(str)
    if(player == null) sender.msg("Player §6$str§f offline")
    return player
}

fun Args.int(sender: Sender, index: Int): Int?{
    val str = this[index]
    val i = str.toIntOrNull()
    if(i == null) sender.msg("§6$str§f not a number")
    return i
}

fun Args.float(sender: Sender, index: Int): Float?{
    return double(sender, index)?.toFloat()
}

fun Args.double(sender: Sender, index: Int): Double?{
    return double(this[index], sender)
}

private fun double(str: String, sender: Sender): Double? {
    return nonNull(str.toDoubleOrNull(), sender){"§6$str§f not a number"}
}

inline fun <T> Args.nonNull(sender: Sender, obj: T?, error: () -> String): T?{
    if(obj == null) sender.msg(error())
    return obj
}

inline fun Args.ifFalse(sender: Sender, boolean: Boolean, error: () -> String): Any?{
    if(boolean)return constNonNull
    sender.msg(error())
    return null
}

fun <T> Args.cantFind(sender: Sender, obj: T?, name: String, arg: String? = null): T?{
    if(obj == null) sender.msg("Can't find $name §6${arg ?: ""}")
    return obj
}

private inline fun <T> nonNull(obj: T?, sender: Sender, error: () -> String): T? {
    if(obj == null) sender.msg(error())
    return obj
}

fun Args.v3(sender: Sender, index: Int): V3?{
    val str = this[index]
    if(str == "~" && sender is Player) return V3(sender.location)
    val split = str.split(",")
    if(split.size == 3){
        run{
            return V3(
                double(split[0], sender) ?: return@run,
                double(split[1], sender) ?: return@run,
                double(split[2], sender) ?: return@run,
            )
        }
    }
    sender.msg("§6$str§f not a location, example: §60,60,0")
    return null
}

fun Args.v5(sender: Sender, index: Int): V5?{
    val str = this[index]
    if(str == "~" && sender is Player) return V5(sender.location)
    val split = str.split(",")
    if(split.size == 3){
        run{
            return V5(
                double(split[0], sender) ?: return@run,
                double(split[1], sender) ?: return@run,
                double(split[2], sender) ?: return@run,
            )
        }
    }else if(split.size == 5){
        run{
            return V5(
                double(split[0], sender) ?: return@run,
                double(split[1], sender) ?: return@run,
                double(split[2], sender) ?: return@run,
                double(split[3], sender)?.toFloat() ?: return@run,
                double(split[4], sender)?.toFloat() ?: return@run,
            )
        }
    }
    sender.msg("§6$str§f not a location, example: §60,60,0,0,0")
    return null
}