package pluginloader.api

import org.bukkit.Bukkit
import org.bukkit.scheduler.BukkitTask

/**
 * Call [task] in main thread in next tick
 */
fun runTask(task: () -> Unit): BukkitTask = scheduler().runTask(plugin, Task(task))

/**
 * Call [task] in main thread after [time] ticks (1/20 second)
 */
fun runTaskLater(time: Int, task: () -> Unit): BukkitTask = scheduler().runTaskLater(plugin, Task(task), time.toLong())

/**
 * Call [task] in main thread with period [time] ticks (1/20 second)
 * Carefully, this method don't cancel task after unload, use [Plugin.runTaskTimer]
 */
fun runTaskTimer(time: Int, task: () -> Unit): BukkitTask = scheduler().runTaskTimer(plugin, Task(task), time.toLong(), time.toLong())

/**
 * Call [task] in async threads
 */
fun runAsync(task: () -> Unit): BukkitTask = scheduler().runTaskAsynchronously(plugin, Task(task))

/**
 * Call [task] async after [time] ticks (1/20 second)
 */
fun runAsyncLater(time: Int, task: () -> Unit): BukkitTask = scheduler().runTaskLaterAsynchronously(plugin, Task(task), time.toLong())

/**
 * Call [task] async with period [time] ticks (1/20 second)
 * Carefully, this method don't cancel task after unload, use [Plugin.runAsyncTimer]
 */
fun runAsyncTimer(time: Int, task: () -> Unit): BukkitTask = scheduler().runTaskTimerAsynchronously(plugin, Task(task), time.toLong(), time.toLong())

private fun scheduler() = Bukkit.getScheduler()

private class Task(private val task: () -> Unit): Runnable{
    override fun run() {
        task()
    }
}