package pluginloader.api

import kotlinx.serialization.Serializable
import org.bukkit.Bukkit
import org.bukkit.Location
import org.bukkit.World
import org.bukkit.block.Block

@Serializable
open class V3(open val x: Double, open val y: Double, open val z: Double){
    constructor(x: Int, y: Int, z: Int): this(x.toDouble(), y.toDouble(), z.toDouble())

    constructor(l: Location): this(l.x, l.y, l.z)

    val blockX: Int get() = x.toInt()
    val blockY: Int get() = y.toInt()
    val blockZ: Int get() = z.toInt()

    open val center: V3 get() = V3(blockX + 0.5, blockY.toDouble(), blockZ + 0.5)
    open val block: V3 get() = V3(blockX.toDouble(), blockY.toDouble(), blockZ.toDouble())

    open fun location(world: World): Location = Location(world, x, y, z)

    open fun location(world: String): Location? {
        return location(Bukkit.getWorld(world) ?: return null)
    }

    fun block(world: World): Block = world.getBlockAt(blockX, blockY, blockZ)

    override fun equals(other: Any?): Boolean {
        if (this === other) return true
        if (other == null)return false
        if (!javaClass.isInstance(other)) return false

        other as V3

        if (x != other.x) return false
        if (y != other.y) return false
        if (z != other.z) return false

        return true
    }

    override fun hashCode(): Int {
        var result = x.hashCode()
        result = 31 * result + y.hashCode()
        result = 31 * result + z.hashCode()
        return result
    }

    override fun toString() = "V3(x=$x, y=$y, z=$z)"

    companion object{
        val empty = V3(0, 0, 0)

        fun Location.v3(): V3{
            return V3(x, y, z)
        }
    }
}