package pluginloader.gradle

import org.gradle.api.Project
import org.gradle.api.artifacts.Configuration
import org.gradle.api.artifacts.Dependency
import java.io.File

internal fun getenv(project: Project, env: String): String?{
    if(project.hasProperty(env))return project.property(env).toString()
    return System.getenv(env)
}

internal fun Project.applyPlugin(name: String){
    if(pluginManager.hasPlugin(name))return
    pluginManager.apply(name)
}

internal fun Project.compileDependency(name: String){
    dependency("compileOnly", name)
}

internal fun Project.dependency(configurationName: String, name: String){
    dependencies.add(configurationName, name)
}

internal fun Project.createConfiguration(name: String): Configuration{
    return project.configurations.create(name).apply {
        isTransitive = false
        project.configurations.getByName("compileClasspath").extendsFrom(this)
    }
}

internal fun Project.addDependencies(configuration: String, array: Array<out String>, replacer: (String) -> String = {it}){
    array.forEach{project.dependencies.add(configuration, replacer(it))}
}

//This is wrong a bit, but work
internal val hackyPath = "build/classes/kotlin/main/pluginloader"

internal fun Project.addToJarPerDependency(configuration: Configuration, writeToFile: (Dependency.() -> String)? = null, callback: Dependency.() -> String){
    configuration.allDependencies.forEach{
        val file = addFileToJar(callback(it))
        if(writeToFile != null) file.writeBytes(writeToFile(it).toByteArray())
    }
}

internal fun Project.addFileToJar(name: String): File{
    val file = file("$hackyPath/$name")
    file.parentFile.mkdirs()
    file.parentFile.mkdir()
    file.createNewFile()
    return file
}