/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.libpodj.api;

import com.google.gson.reflect.TypeToken;
import io.github.pod4dev.libpodj.ApiCallback;
import io.github.pod4dev.libpodj.ApiClient;
import io.github.pod4dev.libpodj.ApiException;
import io.github.pod4dev.libpodj.ApiResponse;
import io.github.pod4dev.libpodj.Configuration;
import io.github.pod4dev.libpodj.Pair;
import io.github.pod4dev.libpodj.model.HistoryResponse;
import io.github.pod4dev.libpodj.model.ImageBuildLibpod200Response;
import io.github.pod4dev.libpodj.model.ImageData;
import io.github.pod4dev.libpodj.model.ImageImportReport;
import io.github.pod4dev.libpodj.model.ImageLoadReport;
import io.github.pod4dev.libpodj.model.ImageSearch200Response;
import io.github.pod4dev.libpodj.model.ImageTreeReport;
import io.github.pod4dev.libpodj.model.LibpodImageSummary;
import io.github.pod4dev.libpodj.model.LibpodImagesPullReport;
import io.github.pod4dev.libpodj.model.LibpodImagesRemoveReport;
import io.github.pod4dev.libpodj.model.PruneReport;
import io.github.pod4dev.libpodj.model.ScpReport;
import jakarta.validation.constraints.NotNull;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;

public class ImagesApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ImagesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ImagesApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call imageBuildLibpodCall(String dockerfile, String t, Boolean allplatforms, String extrahosts, String remote, Boolean q, Boolean compatvolumes, Boolean nocache, String cachefrom, Boolean pull, Boolean rm, Boolean forcerm, Integer memory, Integer memswap, Integer cpushares, String cpusetcpus, Integer cpuperiod, Integer cpuquota, String buildargs, Integer shmsize, Boolean squash, String labels, List<String> layerLabel, Boolean layers, String networkmode, String platform, String target, String outputs, Boolean httpproxy, List<String> unsetenv, List<String> unsetlabel, List<String> volume, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/libpod/build";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (dockerfile != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dockerfile", dockerfile));
        }
        if (t != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("t", t));
        }
        if (allplatforms != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("allplatforms", allplatforms));
        }
        if (extrahosts != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("extrahosts", extrahosts));
        }
        if (remote != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("remote", remote));
        }
        if (q != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("q", q));
        }
        if (compatvolumes != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("compatvolumes", compatvolumes));
        }
        if (nocache != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("nocache", nocache));
        }
        if (cachefrom != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("cachefrom", cachefrom));
        }
        if (pull != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pull", pull));
        }
        if (rm != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("rm", rm));
        }
        if (forcerm != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("forcerm", forcerm));
        }
        if (memory != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("memory", memory));
        }
        if (memswap != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("memswap", memswap));
        }
        if (cpushares != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("cpushares", cpushares));
        }
        if (cpusetcpus != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("cpusetcpus", cpusetcpus));
        }
        if (cpuperiod != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("cpuperiod", cpuperiod));
        }
        if (cpuquota != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("cpuquota", cpuquota));
        }
        if (buildargs != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("buildargs", buildargs));
        }
        if (shmsize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("shmsize", shmsize));
        }
        if (squash != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("squash", squash));
        }
        if (labels != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labels", labels));
        }
        if (layerLabel != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "layerLabel", layerLabel));
        }
        if (layers != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("layers", layers));
        }
        if (networkmode != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("networkmode", networkmode));
        }
        if (platform != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("platform", platform));
        }
        if (target != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("target", target));
        }
        if (outputs != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("outputs", outputs));
        }
        if (httpproxy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("httpproxy", httpproxy));
        }
        if (unsetenv != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "unsetenv", unsetenv));
        }
        if (unsetlabel != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "unsetlabel", unsetlabel));
        }
        if (volume != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "volume", volume));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call imageBuildLibpodValidateBeforeCall(String dockerfile, String t, Boolean allplatforms, String extrahosts, String remote, Boolean q, Boolean compatvolumes, Boolean nocache, String cachefrom, Boolean pull, Boolean rm, Boolean forcerm, Integer memory, Integer memswap, Integer cpushares, String cpusetcpus, Integer cpuperiod, Integer cpuquota, String buildargs, Integer shmsize, Boolean squash, String labels, List<String> layerLabel, Boolean layers, String networkmode, String platform, String target, String outputs, Boolean httpproxy, List<String> unsetenv, List<String> unsetlabel, List<String> volume, ApiCallback _callback) throws ApiException {
        return this.imageBuildLibpodCall(dockerfile, t, allplatforms, extrahosts, remote, q, compatvolumes, nocache, cachefrom, pull, rm, forcerm, memory, memswap, cpushares, cpusetcpus, cpuperiod, cpuquota, buildargs, shmsize, squash, labels, layerLabel, layers, networkmode, platform, target, outputs, httpproxy, unsetenv, unsetlabel, volume, _callback);
    }

    private ApiResponse<ImageBuildLibpod200Response> imageBuildLibpodWithHttpInfo(String dockerfile, String t, Boolean allplatforms, String extrahosts, String remote, Boolean q, Boolean compatvolumes, Boolean nocache, String cachefrom, Boolean pull, Boolean rm, Boolean forcerm, Integer memory, Integer memswap, Integer cpushares, String cpusetcpus, Integer cpuperiod, Integer cpuquota, String buildargs, Integer shmsize, Boolean squash, String labels, List<String> layerLabel, Boolean layers, String networkmode, String platform, String target, String outputs, Boolean httpproxy, List<String> unsetenv, List<String> unsetlabel, List<String> volume) throws ApiException {
        Call localVarCall = this.imageBuildLibpodValidateBeforeCall(dockerfile, t, allplatforms, extrahosts, remote, q, compatvolumes, nocache, cachefrom, pull, rm, forcerm, memory, memswap, cpushares, cpusetcpus, cpuperiod, cpuquota, buildargs, shmsize, squash, labels, layerLabel, layers, networkmode, platform, target, outputs, httpproxy, unsetenv, unsetlabel, volume, null);
        Type localVarReturnType = new TypeToken<ImageBuildLibpod200Response>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call imageBuildLibpodAsync(String dockerfile, String t, Boolean allplatforms, String extrahosts, String remote, Boolean q, Boolean compatvolumes, Boolean nocache, String cachefrom, Boolean pull, Boolean rm, Boolean forcerm, Integer memory, Integer memswap, Integer cpushares, String cpusetcpus, Integer cpuperiod, Integer cpuquota, String buildargs, Integer shmsize, Boolean squash, String labels, List<String> layerLabel, Boolean layers, String networkmode, String platform, String target, String outputs, Boolean httpproxy, List<String> unsetenv, List<String> unsetlabel, List<String> volume, ApiCallback<ImageBuildLibpod200Response> _callback) throws ApiException {
        Call localVarCall = this.imageBuildLibpodValidateBeforeCall(dockerfile, t, allplatforms, extrahosts, remote, q, compatvolumes, nocache, cachefrom, pull, rm, forcerm, memory, memswap, cpushares, cpusetcpus, cpuperiod, cpuquota, buildargs, shmsize, squash, labels, layerLabel, layers, networkmode, platform, target, outputs, httpproxy, unsetenv, unsetlabel, volume, _callback);
        Type localVarReturnType = new TypeToken<ImageBuildLibpod200Response>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIimageBuildLibpodRequest imageBuildLibpod() {
        return new APIimageBuildLibpodRequest();
    }

    private Call imageChangesLibpodCall(String name, String parent, String diffType, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/libpod/images/{name}/changes".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (parent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("parent", parent));
        }
        if (diffType != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("diffType", diffType));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/octet-stream", "text/plain"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call imageChangesLibpodValidateBeforeCall(String name, String parent, String diffType, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling imageChangesLibpod(Async)");
        }
        return this.imageChangesLibpodCall(name, parent, diffType, _callback);
    }

    private ApiResponse<Void> imageChangesLibpodWithHttpInfo(@NotNull String name, String parent, String diffType) throws ApiException {
        Call localVarCall = this.imageChangesLibpodValidateBeforeCall(name, parent, diffType, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call imageChangesLibpodAsync(String name, String parent, String diffType, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.imageChangesLibpodValidateBeforeCall(name, parent, diffType, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public APIimageChangesLibpodRequest imageChangesLibpod(String name) {
        return new APIimageChangesLibpodRequest(name);
    }

    private Call imageDeleteAllLibpodCall(List<String> images, Boolean all, Boolean force, Boolean ignore, Boolean lookupManifest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/libpod/images/remove";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (images != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "images", images));
        }
        if (all != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("all", all));
        }
        if (force != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("force", force));
        }
        if (ignore != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("ignore", ignore));
        }
        if (lookupManifest != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("lookupManifest", lookupManifest));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call imageDeleteAllLibpodValidateBeforeCall(List<String> images, Boolean all, Boolean force, Boolean ignore, Boolean lookupManifest, ApiCallback _callback) throws ApiException {
        return this.imageDeleteAllLibpodCall(images, all, force, ignore, lookupManifest, _callback);
    }

    private ApiResponse<LibpodImagesRemoveReport> imageDeleteAllLibpodWithHttpInfo(List<String> images, Boolean all, Boolean force, Boolean ignore, Boolean lookupManifest) throws ApiException {
        Call localVarCall = this.imageDeleteAllLibpodValidateBeforeCall(images, all, force, ignore, lookupManifest, null);
        Type localVarReturnType = new TypeToken<LibpodImagesRemoveReport>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call imageDeleteAllLibpodAsync(List<String> images, Boolean all, Boolean force, Boolean ignore, Boolean lookupManifest, ApiCallback<LibpodImagesRemoveReport> _callback) throws ApiException {
        Call localVarCall = this.imageDeleteAllLibpodValidateBeforeCall(images, all, force, ignore, lookupManifest, _callback);
        Type localVarReturnType = new TypeToken<LibpodImagesRemoveReport>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIimageDeleteAllLibpodRequest imageDeleteAllLibpod() {
        return new APIimageDeleteAllLibpodRequest();
    }

    private Call imageDeleteLibpodCall(String name, Boolean force, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/libpod/images/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (force != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("force", force));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call imageDeleteLibpodValidateBeforeCall(String name, Boolean force, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling imageDeleteLibpod(Async)");
        }
        return this.imageDeleteLibpodCall(name, force, _callback);
    }

    private ApiResponse<LibpodImagesRemoveReport> imageDeleteLibpodWithHttpInfo(@NotNull String name, Boolean force) throws ApiException {
        Call localVarCall = this.imageDeleteLibpodValidateBeforeCall(name, force, null);
        Type localVarReturnType = new TypeToken<LibpodImagesRemoveReport>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call imageDeleteLibpodAsync(String name, Boolean force, ApiCallback<LibpodImagesRemoveReport> _callback) throws ApiException {
        Call localVarCall = this.imageDeleteLibpodValidateBeforeCall(name, force, _callback);
        Type localVarReturnType = new TypeToken<LibpodImagesRemoveReport>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIimageDeleteLibpodRequest imageDeleteLibpod(String name) {
        return new APIimageDeleteLibpodRequest(name);
    }

    private Call imageExistsLibpodCall(String name, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/libpod/images/{name}/exists".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call imageExistsLibpodValidateBeforeCall(String name, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling imageExistsLibpod(Async)");
        }
        return this.imageExistsLibpodCall(name, _callback);
    }

    private ApiResponse<Void> imageExistsLibpodWithHttpInfo(@NotNull String name) throws ApiException {
        Call localVarCall = this.imageExistsLibpodValidateBeforeCall(name, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call imageExistsLibpodAsync(String name, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.imageExistsLibpodValidateBeforeCall(name, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public APIimageExistsLibpodRequest imageExistsLibpod(String name) {
        return new APIimageExistsLibpodRequest(name);
    }

    private Call imageExportLibpodCall(String format, List<String> references, Boolean compress, Boolean ociAcceptUncompressedLayers, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/libpod/images/export";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (format != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("format", format));
        }
        if (references != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "references", references));
        }
        if (compress != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("compress", compress));
        }
        if (ociAcceptUncompressedLayers != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("ociAcceptUncompressedLayers", ociAcceptUncompressedLayers));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call imageExportLibpodValidateBeforeCall(String format, List<String> references, Boolean compress, Boolean ociAcceptUncompressedLayers, ApiCallback _callback) throws ApiException {
        return this.imageExportLibpodCall(format, references, compress, ociAcceptUncompressedLayers, _callback);
    }

    private ApiResponse<File> imageExportLibpodWithHttpInfo(String format, List<String> references, Boolean compress, Boolean ociAcceptUncompressedLayers) throws ApiException {
        Call localVarCall = this.imageExportLibpodValidateBeforeCall(format, references, compress, ociAcceptUncompressedLayers, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call imageExportLibpodAsync(String format, List<String> references, Boolean compress, Boolean ociAcceptUncompressedLayers, ApiCallback<File> _callback) throws ApiException {
        Call localVarCall = this.imageExportLibpodValidateBeforeCall(format, references, compress, ociAcceptUncompressedLayers, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIimageExportLibpodRequest imageExportLibpod() {
        return new APIimageExportLibpodRequest();
    }

    private Call imageGetLibpodCall(String name, String format, Boolean compress, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/libpod/images/{name}/get".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (format != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("format", format));
        }
        if (compress != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("compress", compress));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/x-tar"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call imageGetLibpodValidateBeforeCall(String name, String format, Boolean compress, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling imageGetLibpod(Async)");
        }
        return this.imageGetLibpodCall(name, format, compress, _callback);
    }

    private ApiResponse<File> imageGetLibpodWithHttpInfo(@NotNull String name, String format, Boolean compress) throws ApiException {
        Call localVarCall = this.imageGetLibpodValidateBeforeCall(name, format, compress, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call imageGetLibpodAsync(String name, String format, Boolean compress, ApiCallback<File> _callback) throws ApiException {
        Call localVarCall = this.imageGetLibpodValidateBeforeCall(name, format, compress, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIimageGetLibpodRequest imageGetLibpod(String name) {
        return new APIimageGetLibpodRequest(name);
    }

    private Call imageHistoryLibpodCall(String name, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/libpod/images/{name}/history".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call imageHistoryLibpodValidateBeforeCall(String name, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling imageHistoryLibpod(Async)");
        }
        return this.imageHistoryLibpodCall(name, _callback);
    }

    private ApiResponse<HistoryResponse> imageHistoryLibpodWithHttpInfo(@NotNull String name) throws ApiException {
        Call localVarCall = this.imageHistoryLibpodValidateBeforeCall(name, null);
        Type localVarReturnType = new TypeToken<HistoryResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call imageHistoryLibpodAsync(String name, ApiCallback<HistoryResponse> _callback) throws ApiException {
        Call localVarCall = this.imageHistoryLibpodValidateBeforeCall(name, _callback);
        Type localVarReturnType = new TypeToken<HistoryResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIimageHistoryLibpodRequest imageHistoryLibpod(String name) {
        return new APIimageHistoryLibpodRequest(name);
    }

    private Call imageImportLibpodCall(File upload, String contentType, List<String> changes, String message, String reference, String url, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        File localVarPostBody = upload;
        String localVarPath = "/libpod/images/import";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (changes != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "changes", changes));
        }
        if (message != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("message", message));
        }
        if (reference != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("reference", reference));
        }
        if (url != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("url", url));
        }
        if (contentType != null) {
            localVarHeaderParams.put("Content-Type", this.localVarApiClient.parameterToString(contentType));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/x-tar"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call imageImportLibpodValidateBeforeCall(File upload, String contentType, List<String> changes, String message, String reference, String url, ApiCallback _callback) throws ApiException {
        if (upload == null) {
            throw new ApiException("Missing the required parameter 'upload' when calling imageImportLibpod(Async)");
        }
        return this.imageImportLibpodCall(upload, contentType, changes, message, reference, url, _callback);
    }

    private ApiResponse<ImageImportReport> imageImportLibpodWithHttpInfo(@NotNull File upload, String contentType, List<String> changes, String message, String reference, String url) throws ApiException {
        Call localVarCall = this.imageImportLibpodValidateBeforeCall(upload, contentType, changes, message, reference, url, null);
        Type localVarReturnType = new TypeToken<ImageImportReport>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call imageImportLibpodAsync(File upload, String contentType, List<String> changes, String message, String reference, String url, ApiCallback<ImageImportReport> _callback) throws ApiException {
        Call localVarCall = this.imageImportLibpodValidateBeforeCall(upload, contentType, changes, message, reference, url, _callback);
        Type localVarReturnType = new TypeToken<ImageImportReport>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIimageImportLibpodRequest imageImportLibpod(File upload) {
        return new APIimageImportLibpodRequest(upload);
    }

    private Call imageInspectLibpodCall(String name, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/libpod/images/{name}/json".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call imageInspectLibpodValidateBeforeCall(String name, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling imageInspectLibpod(Async)");
        }
        return this.imageInspectLibpodCall(name, _callback);
    }

    private ApiResponse<ImageData> imageInspectLibpodWithHttpInfo(@NotNull String name) throws ApiException {
        Call localVarCall = this.imageInspectLibpodValidateBeforeCall(name, null);
        Type localVarReturnType = new TypeToken<ImageData>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call imageInspectLibpodAsync(String name, ApiCallback<ImageData> _callback) throws ApiException {
        Call localVarCall = this.imageInspectLibpodValidateBeforeCall(name, _callback);
        Type localVarReturnType = new TypeToken<ImageData>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIimageInspectLibpodRequest imageInspectLibpod(String name) {
        return new APIimageInspectLibpodRequest(name);
    }

    private Call imageListLibpodCall(Boolean all, String filters, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/libpod/images/json";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (all != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("all", all));
        }
        if (filters != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("filters", filters));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call imageListLibpodValidateBeforeCall(Boolean all, String filters, ApiCallback _callback) throws ApiException {
        return this.imageListLibpodCall(all, filters, _callback);
    }

    private ApiResponse<List<LibpodImageSummary>> imageListLibpodWithHttpInfo(Boolean all, String filters) throws ApiException {
        Call localVarCall = this.imageListLibpodValidateBeforeCall(all, filters, null);
        Type localVarReturnType = new TypeToken<List<LibpodImageSummary>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call imageListLibpodAsync(Boolean all, String filters, ApiCallback<List<LibpodImageSummary>> _callback) throws ApiException {
        Call localVarCall = this.imageListLibpodValidateBeforeCall(all, filters, _callback);
        Type localVarReturnType = new TypeToken<List<LibpodImageSummary>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIimageListLibpodRequest imageListLibpod() {
        return new APIimageListLibpodRequest();
    }

    private Call imageLoadLibpodCall(String upload, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        String localVarPostBody = upload;
        String localVarPath = "/libpod/images/load";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/x-tar"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call imageLoadLibpodValidateBeforeCall(String upload, ApiCallback _callback) throws ApiException {
        if (upload == null) {
            throw new ApiException("Missing the required parameter 'upload' when calling imageLoadLibpod(Async)");
        }
        return this.imageLoadLibpodCall(upload, _callback);
    }

    private ApiResponse<ImageLoadReport> imageLoadLibpodWithHttpInfo(@NotNull String upload) throws ApiException {
        Call localVarCall = this.imageLoadLibpodValidateBeforeCall(upload, null);
        Type localVarReturnType = new TypeToken<ImageLoadReport>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call imageLoadLibpodAsync(String upload, ApiCallback<ImageLoadReport> _callback) throws ApiException {
        Call localVarCall = this.imageLoadLibpodValidateBeforeCall(upload, _callback);
        Type localVarReturnType = new TypeToken<ImageLoadReport>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIimageLoadLibpodRequest imageLoadLibpod(String upload) {
        return new APIimageLoadLibpodRequest(upload);
    }

    private Call imagePruneLibpodCall(Boolean all, Boolean external, Boolean buildcache, String filters, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/libpod/images/prune";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (all != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("all", all));
        }
        if (external != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("external", external));
        }
        if (buildcache != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("buildcache", buildcache));
        }
        if (filters != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("filters", filters));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call imagePruneLibpodValidateBeforeCall(Boolean all, Boolean external, Boolean buildcache, String filters, ApiCallback _callback) throws ApiException {
        return this.imagePruneLibpodCall(all, external, buildcache, filters, _callback);
    }

    private ApiResponse<List<PruneReport>> imagePruneLibpodWithHttpInfo(Boolean all, Boolean external, Boolean buildcache, String filters) throws ApiException {
        Call localVarCall = this.imagePruneLibpodValidateBeforeCall(all, external, buildcache, filters, null);
        Type localVarReturnType = new TypeToken<List<PruneReport>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call imagePruneLibpodAsync(Boolean all, Boolean external, Boolean buildcache, String filters, ApiCallback<List<PruneReport>> _callback) throws ApiException {
        Call localVarCall = this.imagePruneLibpodValidateBeforeCall(all, external, buildcache, filters, _callback);
        Type localVarReturnType = new TypeToken<List<PruneReport>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIimagePruneLibpodRequest imagePruneLibpod() {
        return new APIimagePruneLibpodRequest();
    }

    private Call imagePullLibpodCall(String reference, Boolean quiet, Boolean compatMode, String arch, String OS, String variant, String policy, Boolean tlsVerify, Boolean allTags, String xRegistryAuth, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/libpod/images/pull";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (reference != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("reference", reference));
        }
        if (quiet != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("quiet", quiet));
        }
        if (compatMode != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("compatMode", compatMode));
        }
        if (arch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("Arch", arch));
        }
        if (OS != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("OS", OS));
        }
        if (variant != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("Variant", variant));
        }
        if (policy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("policy", policy));
        }
        if (tlsVerify != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("tlsVerify", tlsVerify));
        }
        if (allTags != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("allTags", allTags));
        }
        if (xRegistryAuth != null) {
            localVarHeaderParams.put("X-Registry-Auth", this.localVarApiClient.parameterToString(xRegistryAuth));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call imagePullLibpodValidateBeforeCall(String reference, Boolean quiet, Boolean compatMode, String arch, String OS, String variant, String policy, Boolean tlsVerify, Boolean allTags, String xRegistryAuth, ApiCallback _callback) throws ApiException {
        return this.imagePullLibpodCall(reference, quiet, compatMode, arch, OS, variant, policy, tlsVerify, allTags, xRegistryAuth, _callback);
    }

    private ApiResponse<LibpodImagesPullReport> imagePullLibpodWithHttpInfo(String reference, Boolean quiet, Boolean compatMode, String arch, String OS, String variant, String policy, Boolean tlsVerify, Boolean allTags, String xRegistryAuth) throws ApiException {
        Call localVarCall = this.imagePullLibpodValidateBeforeCall(reference, quiet, compatMode, arch, OS, variant, policy, tlsVerify, allTags, xRegistryAuth, null);
        Type localVarReturnType = new TypeToken<LibpodImagesPullReport>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call imagePullLibpodAsync(String reference, Boolean quiet, Boolean compatMode, String arch, String OS, String variant, String policy, Boolean tlsVerify, Boolean allTags, String xRegistryAuth, ApiCallback<LibpodImagesPullReport> _callback) throws ApiException {
        Call localVarCall = this.imagePullLibpodValidateBeforeCall(reference, quiet, compatMode, arch, OS, variant, policy, tlsVerify, allTags, xRegistryAuth, _callback);
        Type localVarReturnType = new TypeToken<LibpodImagesPullReport>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIimagePullLibpodRequest imagePullLibpod() {
        return new APIimagePullLibpodRequest();
    }

    private Call imagePushLibpodCall(String name, String destination, Boolean forceCompressionFormat, String compressionFormat, Integer compressionLevel, Boolean tlsVerify, Boolean quiet, String format, Boolean all, Boolean removeSignatures, Integer retry, String retryDelay, String xRegistryAuth, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/libpod/images/{name}/push".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (destination != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("destination", destination));
        }
        if (forceCompressionFormat != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("forceCompressionFormat", forceCompressionFormat));
        }
        if (compressionFormat != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("compressionFormat", compressionFormat));
        }
        if (compressionLevel != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("compressionLevel", compressionLevel));
        }
        if (tlsVerify != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("tlsVerify", tlsVerify));
        }
        if (quiet != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("quiet", quiet));
        }
        if (format != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("format", format));
        }
        if (all != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("all", all));
        }
        if (removeSignatures != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("removeSignatures", removeSignatures));
        }
        if (retry != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("retry", retry));
        }
        if (retryDelay != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("retryDelay", retryDelay));
        }
        if (xRegistryAuth != null) {
            localVarHeaderParams.put("X-Registry-Auth", this.localVarApiClient.parameterToString(xRegistryAuth));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call imagePushLibpodValidateBeforeCall(String name, String destination, Boolean forceCompressionFormat, String compressionFormat, Integer compressionLevel, Boolean tlsVerify, Boolean quiet, String format, Boolean all, Boolean removeSignatures, Integer retry, String retryDelay, String xRegistryAuth, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling imagePushLibpod(Async)");
        }
        return this.imagePushLibpodCall(name, destination, forceCompressionFormat, compressionFormat, compressionLevel, tlsVerify, quiet, format, all, removeSignatures, retry, retryDelay, xRegistryAuth, _callback);
    }

    private ApiResponse<File> imagePushLibpodWithHttpInfo(@NotNull String name, String destination, Boolean forceCompressionFormat, String compressionFormat, Integer compressionLevel, Boolean tlsVerify, Boolean quiet, String format, Boolean all, Boolean removeSignatures, Integer retry, String retryDelay, String xRegistryAuth) throws ApiException {
        Call localVarCall = this.imagePushLibpodValidateBeforeCall(name, destination, forceCompressionFormat, compressionFormat, compressionLevel, tlsVerify, quiet, format, all, removeSignatures, retry, retryDelay, xRegistryAuth, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call imagePushLibpodAsync(String name, String destination, Boolean forceCompressionFormat, String compressionFormat, Integer compressionLevel, Boolean tlsVerify, Boolean quiet, String format, Boolean all, Boolean removeSignatures, Integer retry, String retryDelay, String xRegistryAuth, ApiCallback<File> _callback) throws ApiException {
        Call localVarCall = this.imagePushLibpodValidateBeforeCall(name, destination, forceCompressionFormat, compressionFormat, compressionLevel, tlsVerify, quiet, format, all, removeSignatures, retry, retryDelay, xRegistryAuth, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIimagePushLibpodRequest imagePushLibpod(String name) {
        return new APIimagePushLibpodRequest(name);
    }

    private Call imageResolveLibpodCall(String name, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/libpod/images/{name}/resolve".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call imageResolveLibpodValidateBeforeCall(String name, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling imageResolveLibpod(Async)");
        }
        return this.imageResolveLibpodCall(name, _callback);
    }

    private ApiResponse<Void> imageResolveLibpodWithHttpInfo(@NotNull String name) throws ApiException {
        Call localVarCall = this.imageResolveLibpodValidateBeforeCall(name, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call imageResolveLibpodAsync(String name, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.imageResolveLibpodValidateBeforeCall(name, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public APIimageResolveLibpodRequest imageResolveLibpod(String name) {
        return new APIimageResolveLibpodRequest(name);
    }

    private Call imageScpLibpodCall(String name, String destination, Boolean quiet, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/libpod/images/scp/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (destination != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("destination", destination));
        }
        if (quiet != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("quiet", quiet));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call imageScpLibpodValidateBeforeCall(String name, String destination, Boolean quiet, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling imageScpLibpod(Async)");
        }
        return this.imageScpLibpodCall(name, destination, quiet, _callback);
    }

    private ApiResponse<ScpReport> imageScpLibpodWithHttpInfo(@NotNull String name, String destination, Boolean quiet) throws ApiException {
        Call localVarCall = this.imageScpLibpodValidateBeforeCall(name, destination, quiet, null);
        Type localVarReturnType = new TypeToken<ScpReport>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call imageScpLibpodAsync(String name, String destination, Boolean quiet, ApiCallback<ScpReport> _callback) throws ApiException {
        Call localVarCall = this.imageScpLibpodValidateBeforeCall(name, destination, quiet, _callback);
        Type localVarReturnType = new TypeToken<ScpReport>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIimageScpLibpodRequest imageScpLibpod(String name) {
        return new APIimageScpLibpodRequest(name);
    }

    private Call imageSearchLibpodCall(String term, Integer limit, String filters, Boolean tlsVerify, Boolean listTags, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/libpod/images/search";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (term != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("term", term));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (filters != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("filters", filters));
        }
        if (tlsVerify != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("tlsVerify", tlsVerify));
        }
        if (listTags != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("listTags", listTags));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call imageSearchLibpodValidateBeforeCall(String term, Integer limit, String filters, Boolean tlsVerify, Boolean listTags, ApiCallback _callback) throws ApiException {
        return this.imageSearchLibpodCall(term, limit, filters, tlsVerify, listTags, _callback);
    }

    private ApiResponse<ImageSearch200Response> imageSearchLibpodWithHttpInfo(String term, Integer limit, String filters, Boolean tlsVerify, Boolean listTags) throws ApiException {
        Call localVarCall = this.imageSearchLibpodValidateBeforeCall(term, limit, filters, tlsVerify, listTags, null);
        Type localVarReturnType = new TypeToken<ImageSearch200Response>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call imageSearchLibpodAsync(String term, Integer limit, String filters, Boolean tlsVerify, Boolean listTags, ApiCallback<ImageSearch200Response> _callback) throws ApiException {
        Call localVarCall = this.imageSearchLibpodValidateBeforeCall(term, limit, filters, tlsVerify, listTags, _callback);
        Type localVarReturnType = new TypeToken<ImageSearch200Response>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIimageSearchLibpodRequest imageSearchLibpod() {
        return new APIimageSearchLibpodRequest();
    }

    private Call imageTagLibpodCall(String name, String repo, String tag, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/libpod/images/{name}/tag".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (repo != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("repo", repo));
        }
        if (tag != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("tag", tag));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call imageTagLibpodValidateBeforeCall(String name, String repo, String tag, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling imageTagLibpod(Async)");
        }
        return this.imageTagLibpodCall(name, repo, tag, _callback);
    }

    private ApiResponse<Void> imageTagLibpodWithHttpInfo(@NotNull String name, String repo, String tag) throws ApiException {
        Call localVarCall = this.imageTagLibpodValidateBeforeCall(name, repo, tag, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call imageTagLibpodAsync(String name, String repo, String tag, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.imageTagLibpodValidateBeforeCall(name, repo, tag, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public APIimageTagLibpodRequest imageTagLibpod(String name) {
        return new APIimageTagLibpodRequest(name);
    }

    private Call imageTreeLibpodCall(String name, Boolean whatrequires, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/libpod/images/{name}/tree".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (whatrequires != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("whatrequires", whatrequires));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call imageTreeLibpodValidateBeforeCall(String name, Boolean whatrequires, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling imageTreeLibpod(Async)");
        }
        return this.imageTreeLibpodCall(name, whatrequires, _callback);
    }

    private ApiResponse<ImageTreeReport> imageTreeLibpodWithHttpInfo(@NotNull String name, Boolean whatrequires) throws ApiException {
        Call localVarCall = this.imageTreeLibpodValidateBeforeCall(name, whatrequires, null);
        Type localVarReturnType = new TypeToken<ImageTreeReport>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call imageTreeLibpodAsync(String name, Boolean whatrequires, ApiCallback<ImageTreeReport> _callback) throws ApiException {
        Call localVarCall = this.imageTreeLibpodValidateBeforeCall(name, whatrequires, _callback);
        Type localVarReturnType = new TypeToken<ImageTreeReport>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIimageTreeLibpodRequest imageTreeLibpod(String name) {
        return new APIimageTreeLibpodRequest(name);
    }

    private Call imageUntagLibpodCall(String name, String repo, String tag, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/libpod/images/{name}/untag".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (repo != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("repo", repo));
        }
        if (tag != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("tag", tag));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call imageUntagLibpodValidateBeforeCall(String name, String repo, String tag, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling imageUntagLibpod(Async)");
        }
        return this.imageUntagLibpodCall(name, repo, tag, _callback);
    }

    private ApiResponse<Void> imageUntagLibpodWithHttpInfo(@NotNull String name, String repo, String tag) throws ApiException {
        Call localVarCall = this.imageUntagLibpodValidateBeforeCall(name, repo, tag, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call imageUntagLibpodAsync(String name, String repo, String tag, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.imageUntagLibpodValidateBeforeCall(name, repo, tag, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public APIimageUntagLibpodRequest imageUntagLibpod(String name) {
        return new APIimageUntagLibpodRequest(name);
    }

    public class APIimageBuildLibpodRequest {
        private String dockerfile;
        private String t;
        private Boolean allplatforms;
        private String extrahosts;
        private String remote;
        private Boolean q;
        private Boolean compatvolumes;
        private Boolean nocache;
        private String cachefrom;
        private Boolean pull;
        private Boolean rm;
        private Boolean forcerm;
        private Integer memory;
        private Integer memswap;
        private Integer cpushares;
        private String cpusetcpus;
        private Integer cpuperiod;
        private Integer cpuquota;
        private String buildargs;
        private Integer shmsize;
        private Boolean squash;
        private String labels;
        private List<String> layerLabel;
        private Boolean layers;
        private String networkmode;
        private String platform;
        private String target;
        private String outputs;
        private Boolean httpproxy;
        private List<String> unsetenv;
        private List<String> unsetlabel;
        private List<String> volume;

        private APIimageBuildLibpodRequest() {
        }

        public APIimageBuildLibpodRequest dockerfile(String dockerfile) {
            this.dockerfile = dockerfile;
            return this;
        }

        public APIimageBuildLibpodRequest t(String t) {
            this.t = t;
            return this;
        }

        public APIimageBuildLibpodRequest allplatforms(Boolean allplatforms) {
            this.allplatforms = allplatforms;
            return this;
        }

        public APIimageBuildLibpodRequest extrahosts(String extrahosts) {
            this.extrahosts = extrahosts;
            return this;
        }

        public APIimageBuildLibpodRequest remote(String remote) {
            this.remote = remote;
            return this;
        }

        public APIimageBuildLibpodRequest q(Boolean q) {
            this.q = q;
            return this;
        }

        public APIimageBuildLibpodRequest compatvolumes(Boolean compatvolumes) {
            this.compatvolumes = compatvolumes;
            return this;
        }

        public APIimageBuildLibpodRequest nocache(Boolean nocache) {
            this.nocache = nocache;
            return this;
        }

        public APIimageBuildLibpodRequest cachefrom(String cachefrom) {
            this.cachefrom = cachefrom;
            return this;
        }

        public APIimageBuildLibpodRequest pull(Boolean pull) {
            this.pull = pull;
            return this;
        }

        public APIimageBuildLibpodRequest rm(Boolean rm) {
            this.rm = rm;
            return this;
        }

        public APIimageBuildLibpodRequest forcerm(Boolean forcerm) {
            this.forcerm = forcerm;
            return this;
        }

        public APIimageBuildLibpodRequest memory(Integer memory) {
            this.memory = memory;
            return this;
        }

        public APIimageBuildLibpodRequest memswap(Integer memswap) {
            this.memswap = memswap;
            return this;
        }

        public APIimageBuildLibpodRequest cpushares(Integer cpushares) {
            this.cpushares = cpushares;
            return this;
        }

        public APIimageBuildLibpodRequest cpusetcpus(String cpusetcpus) {
            this.cpusetcpus = cpusetcpus;
            return this;
        }

        public APIimageBuildLibpodRequest cpuperiod(Integer cpuperiod) {
            this.cpuperiod = cpuperiod;
            return this;
        }

        public APIimageBuildLibpodRequest cpuquota(Integer cpuquota) {
            this.cpuquota = cpuquota;
            return this;
        }

        public APIimageBuildLibpodRequest buildargs(String buildargs) {
            this.buildargs = buildargs;
            return this;
        }

        public APIimageBuildLibpodRequest shmsize(Integer shmsize) {
            this.shmsize = shmsize;
            return this;
        }

        public APIimageBuildLibpodRequest squash(Boolean squash) {
            this.squash = squash;
            return this;
        }

        public APIimageBuildLibpodRequest labels(String labels) {
            this.labels = labels;
            return this;
        }

        public APIimageBuildLibpodRequest layerLabel(List<String> layerLabel) {
            this.layerLabel = layerLabel;
            return this;
        }

        public APIimageBuildLibpodRequest layers(Boolean layers) {
            this.layers = layers;
            return this;
        }

        public APIimageBuildLibpodRequest networkmode(String networkmode) {
            this.networkmode = networkmode;
            return this;
        }

        public APIimageBuildLibpodRequest platform(String platform) {
            this.platform = platform;
            return this;
        }

        public APIimageBuildLibpodRequest target(String target) {
            this.target = target;
            return this;
        }

        public APIimageBuildLibpodRequest outputs(String outputs) {
            this.outputs = outputs;
            return this;
        }

        public APIimageBuildLibpodRequest httpproxy(Boolean httpproxy) {
            this.httpproxy = httpproxy;
            return this;
        }

        public APIimageBuildLibpodRequest unsetenv(List<String> unsetenv) {
            this.unsetenv = unsetenv;
            return this;
        }

        public APIimageBuildLibpodRequest unsetlabel(List<String> unsetlabel) {
            this.unsetlabel = unsetlabel;
            return this;
        }

        public APIimageBuildLibpodRequest volume(List<String> volume) {
            this.volume = volume;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ImagesApi.this.imageBuildLibpodCall(this.dockerfile, this.t, this.allplatforms, this.extrahosts, this.remote, this.q, this.compatvolumes, this.nocache, this.cachefrom, this.pull, this.rm, this.forcerm, this.memory, this.memswap, this.cpushares, this.cpusetcpus, this.cpuperiod, this.cpuquota, this.buildargs, this.shmsize, this.squash, this.labels, this.layerLabel, this.layers, this.networkmode, this.platform, this.target, this.outputs, this.httpproxy, this.unsetenv, this.unsetlabel, this.volume, _callback);
        }

        public ImageBuildLibpod200Response execute() throws ApiException {
            ApiResponse<ImageBuildLibpod200Response> localVarResp = ImagesApi.this.imageBuildLibpodWithHttpInfo(this.dockerfile, this.t, this.allplatforms, this.extrahosts, this.remote, this.q, this.compatvolumes, this.nocache, this.cachefrom, this.pull, this.rm, this.forcerm, this.memory, this.memswap, this.cpushares, this.cpusetcpus, this.cpuperiod, this.cpuquota, this.buildargs, this.shmsize, this.squash, this.labels, this.layerLabel, this.layers, this.networkmode, this.platform, this.target, this.outputs, this.httpproxy, this.unsetenv, this.unsetlabel, this.volume);
            return localVarResp.getData();
        }

        public ApiResponse<ImageBuildLibpod200Response> executeWithHttpInfo() throws ApiException {
            return ImagesApi.this.imageBuildLibpodWithHttpInfo(this.dockerfile, this.t, this.allplatforms, this.extrahosts, this.remote, this.q, this.compatvolumes, this.nocache, this.cachefrom, this.pull, this.rm, this.forcerm, this.memory, this.memswap, this.cpushares, this.cpusetcpus, this.cpuperiod, this.cpuquota, this.buildargs, this.shmsize, this.squash, this.labels, this.layerLabel, this.layers, this.networkmode, this.platform, this.target, this.outputs, this.httpproxy, this.unsetenv, this.unsetlabel, this.volume);
        }

        public Call executeAsync(ApiCallback<ImageBuildLibpod200Response> _callback) throws ApiException {
            return ImagesApi.this.imageBuildLibpodAsync(this.dockerfile, this.t, this.allplatforms, this.extrahosts, this.remote, this.q, this.compatvolumes, this.nocache, this.cachefrom, this.pull, this.rm, this.forcerm, this.memory, this.memswap, this.cpushares, this.cpusetcpus, this.cpuperiod, this.cpuquota, this.buildargs, this.shmsize, this.squash, this.labels, this.layerLabel, this.layers, this.networkmode, this.platform, this.target, this.outputs, this.httpproxy, this.unsetenv, this.unsetlabel, this.volume, _callback);
        }
    }

    public class APIimageChangesLibpodRequest {
        private final String name;
        private String parent;
        private String diffType;

        private APIimageChangesLibpodRequest(String name) {
            this.name = name;
        }

        public APIimageChangesLibpodRequest parent(String parent) {
            this.parent = parent;
            return this;
        }

        public APIimageChangesLibpodRequest diffType(String diffType) {
            this.diffType = diffType;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ImagesApi.this.imageChangesLibpodCall(this.name, this.parent, this.diffType, _callback);
        }

        public void execute() throws ApiException {
            ImagesApi.this.imageChangesLibpodWithHttpInfo(this.name, this.parent, this.diffType);
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return ImagesApi.this.imageChangesLibpodWithHttpInfo(this.name, this.parent, this.diffType);
        }

        public Call executeAsync(ApiCallback<Void> _callback) throws ApiException {
            return ImagesApi.this.imageChangesLibpodAsync(this.name, this.parent, this.diffType, _callback);
        }
    }

    public class APIimageDeleteAllLibpodRequest {
        private List<String> images;
        private Boolean all;
        private Boolean force;
        private Boolean ignore;
        private Boolean lookupManifest;

        private APIimageDeleteAllLibpodRequest() {
        }

        public APIimageDeleteAllLibpodRequest images(List<String> images) {
            this.images = images;
            return this;
        }

        public APIimageDeleteAllLibpodRequest all(Boolean all) {
            this.all = all;
            return this;
        }

        public APIimageDeleteAllLibpodRequest force(Boolean force) {
            this.force = force;
            return this;
        }

        public APIimageDeleteAllLibpodRequest ignore(Boolean ignore) {
            this.ignore = ignore;
            return this;
        }

        public APIimageDeleteAllLibpodRequest lookupManifest(Boolean lookupManifest) {
            this.lookupManifest = lookupManifest;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ImagesApi.this.imageDeleteAllLibpodCall(this.images, this.all, this.force, this.ignore, this.lookupManifest, _callback);
        }

        public LibpodImagesRemoveReport execute() throws ApiException {
            ApiResponse<LibpodImagesRemoveReport> localVarResp = ImagesApi.this.imageDeleteAllLibpodWithHttpInfo(this.images, this.all, this.force, this.ignore, this.lookupManifest);
            return localVarResp.getData();
        }

        public ApiResponse<LibpodImagesRemoveReport> executeWithHttpInfo() throws ApiException {
            return ImagesApi.this.imageDeleteAllLibpodWithHttpInfo(this.images, this.all, this.force, this.ignore, this.lookupManifest);
        }

        public Call executeAsync(ApiCallback<LibpodImagesRemoveReport> _callback) throws ApiException {
            return ImagesApi.this.imageDeleteAllLibpodAsync(this.images, this.all, this.force, this.ignore, this.lookupManifest, _callback);
        }
    }

    public class APIimageDeleteLibpodRequest {
        private final String name;
        private Boolean force;

        private APIimageDeleteLibpodRequest(String name) {
            this.name = name;
        }

        public APIimageDeleteLibpodRequest force(Boolean force) {
            this.force = force;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ImagesApi.this.imageDeleteLibpodCall(this.name, this.force, _callback);
        }

        public LibpodImagesRemoveReport execute() throws ApiException {
            ApiResponse<LibpodImagesRemoveReport> localVarResp = ImagesApi.this.imageDeleteLibpodWithHttpInfo(this.name, this.force);
            return localVarResp.getData();
        }

        public ApiResponse<LibpodImagesRemoveReport> executeWithHttpInfo() throws ApiException {
            return ImagesApi.this.imageDeleteLibpodWithHttpInfo(this.name, this.force);
        }

        public Call executeAsync(ApiCallback<LibpodImagesRemoveReport> _callback) throws ApiException {
            return ImagesApi.this.imageDeleteLibpodAsync(this.name, this.force, _callback);
        }
    }

    public class APIimageExistsLibpodRequest {
        private final String name;

        private APIimageExistsLibpodRequest(String name) {
            this.name = name;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ImagesApi.this.imageExistsLibpodCall(this.name, _callback);
        }

        public void execute() throws ApiException {
            ImagesApi.this.imageExistsLibpodWithHttpInfo(this.name);
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return ImagesApi.this.imageExistsLibpodWithHttpInfo(this.name);
        }

        public Call executeAsync(ApiCallback<Void> _callback) throws ApiException {
            return ImagesApi.this.imageExistsLibpodAsync(this.name, _callback);
        }
    }

    public class APIimageExportLibpodRequest {
        private String format;
        private List<String> references;
        private Boolean compress;
        private Boolean ociAcceptUncompressedLayers;

        private APIimageExportLibpodRequest() {
        }

        public APIimageExportLibpodRequest format(String format) {
            this.format = format;
            return this;
        }

        public APIimageExportLibpodRequest references(List<String> references) {
            this.references = references;
            return this;
        }

        public APIimageExportLibpodRequest compress(Boolean compress) {
            this.compress = compress;
            return this;
        }

        public APIimageExportLibpodRequest ociAcceptUncompressedLayers(Boolean ociAcceptUncompressedLayers) {
            this.ociAcceptUncompressedLayers = ociAcceptUncompressedLayers;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ImagesApi.this.imageExportLibpodCall(this.format, this.references, this.compress, this.ociAcceptUncompressedLayers, _callback);
        }

        public File execute() throws ApiException {
            ApiResponse<File> localVarResp = ImagesApi.this.imageExportLibpodWithHttpInfo(this.format, this.references, this.compress, this.ociAcceptUncompressedLayers);
            return localVarResp.getData();
        }

        public ApiResponse<File> executeWithHttpInfo() throws ApiException {
            return ImagesApi.this.imageExportLibpodWithHttpInfo(this.format, this.references, this.compress, this.ociAcceptUncompressedLayers);
        }

        public Call executeAsync(ApiCallback<File> _callback) throws ApiException {
            return ImagesApi.this.imageExportLibpodAsync(this.format, this.references, this.compress, this.ociAcceptUncompressedLayers, _callback);
        }
    }

    public class APIimageGetLibpodRequest {
        private final String name;
        private String format;
        private Boolean compress;

        private APIimageGetLibpodRequest(String name) {
            this.name = name;
        }

        public APIimageGetLibpodRequest format(String format) {
            this.format = format;
            return this;
        }

        public APIimageGetLibpodRequest compress(Boolean compress) {
            this.compress = compress;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ImagesApi.this.imageGetLibpodCall(this.name, this.format, this.compress, _callback);
        }

        public File execute() throws ApiException {
            ApiResponse<File> localVarResp = ImagesApi.this.imageGetLibpodWithHttpInfo(this.name, this.format, this.compress);
            return localVarResp.getData();
        }

        public ApiResponse<File> executeWithHttpInfo() throws ApiException {
            return ImagesApi.this.imageGetLibpodWithHttpInfo(this.name, this.format, this.compress);
        }

        public Call executeAsync(ApiCallback<File> _callback) throws ApiException {
            return ImagesApi.this.imageGetLibpodAsync(this.name, this.format, this.compress, _callback);
        }
    }

    public class APIimageHistoryLibpodRequest {
        private final String name;

        private APIimageHistoryLibpodRequest(String name) {
            this.name = name;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ImagesApi.this.imageHistoryLibpodCall(this.name, _callback);
        }

        public HistoryResponse execute() throws ApiException {
            ApiResponse<HistoryResponse> localVarResp = ImagesApi.this.imageHistoryLibpodWithHttpInfo(this.name);
            return localVarResp.getData();
        }

        public ApiResponse<HistoryResponse> executeWithHttpInfo() throws ApiException {
            return ImagesApi.this.imageHistoryLibpodWithHttpInfo(this.name);
        }

        public Call executeAsync(ApiCallback<HistoryResponse> _callback) throws ApiException {
            return ImagesApi.this.imageHistoryLibpodAsync(this.name, _callback);
        }
    }

    public class APIimageImportLibpodRequest {
        private final File upload;
        private String contentType;
        private List<String> changes;
        private String message;
        private String reference;
        private String url;

        private APIimageImportLibpodRequest(File upload) {
            this.upload = upload;
        }

        public APIimageImportLibpodRequest contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public APIimageImportLibpodRequest changes(List<String> changes) {
            this.changes = changes;
            return this;
        }

        public APIimageImportLibpodRequest message(String message) {
            this.message = message;
            return this;
        }

        public APIimageImportLibpodRequest reference(String reference) {
            this.reference = reference;
            return this;
        }

        public APIimageImportLibpodRequest url(String url) {
            this.url = url;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ImagesApi.this.imageImportLibpodCall(this.upload, this.contentType, this.changes, this.message, this.reference, this.url, _callback);
        }

        public ImageImportReport execute() throws ApiException {
            ApiResponse<ImageImportReport> localVarResp = ImagesApi.this.imageImportLibpodWithHttpInfo(this.upload, this.contentType, this.changes, this.message, this.reference, this.url);
            return localVarResp.getData();
        }

        public ApiResponse<ImageImportReport> executeWithHttpInfo() throws ApiException {
            return ImagesApi.this.imageImportLibpodWithHttpInfo(this.upload, this.contentType, this.changes, this.message, this.reference, this.url);
        }

        public Call executeAsync(ApiCallback<ImageImportReport> _callback) throws ApiException {
            return ImagesApi.this.imageImportLibpodAsync(this.upload, this.contentType, this.changes, this.message, this.reference, this.url, _callback);
        }
    }

    public class APIimageInspectLibpodRequest {
        private final String name;

        private APIimageInspectLibpodRequest(String name) {
            this.name = name;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ImagesApi.this.imageInspectLibpodCall(this.name, _callback);
        }

        public ImageData execute() throws ApiException {
            ApiResponse<ImageData> localVarResp = ImagesApi.this.imageInspectLibpodWithHttpInfo(this.name);
            return localVarResp.getData();
        }

        public ApiResponse<ImageData> executeWithHttpInfo() throws ApiException {
            return ImagesApi.this.imageInspectLibpodWithHttpInfo(this.name);
        }

        public Call executeAsync(ApiCallback<ImageData> _callback) throws ApiException {
            return ImagesApi.this.imageInspectLibpodAsync(this.name, _callback);
        }
    }

    public class APIimageListLibpodRequest {
        private Boolean all;
        private String filters;

        private APIimageListLibpodRequest() {
        }

        public APIimageListLibpodRequest all(Boolean all) {
            this.all = all;
            return this;
        }

        public APIimageListLibpodRequest filters(String filters) {
            this.filters = filters;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ImagesApi.this.imageListLibpodCall(this.all, this.filters, _callback);
        }

        public List<LibpodImageSummary> execute() throws ApiException {
            ApiResponse<List<LibpodImageSummary>> localVarResp = ImagesApi.this.imageListLibpodWithHttpInfo(this.all, this.filters);
            return localVarResp.getData();
        }

        public ApiResponse<List<LibpodImageSummary>> executeWithHttpInfo() throws ApiException {
            return ImagesApi.this.imageListLibpodWithHttpInfo(this.all, this.filters);
        }

        public Call executeAsync(ApiCallback<List<LibpodImageSummary>> _callback) throws ApiException {
            return ImagesApi.this.imageListLibpodAsync(this.all, this.filters, _callback);
        }
    }

    public class APIimageLoadLibpodRequest {
        private final String upload;

        private APIimageLoadLibpodRequest(String upload) {
            this.upload = upload;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ImagesApi.this.imageLoadLibpodCall(this.upload, _callback);
        }

        public ImageLoadReport execute() throws ApiException {
            ApiResponse<ImageLoadReport> localVarResp = ImagesApi.this.imageLoadLibpodWithHttpInfo(this.upload);
            return localVarResp.getData();
        }

        public ApiResponse<ImageLoadReport> executeWithHttpInfo() throws ApiException {
            return ImagesApi.this.imageLoadLibpodWithHttpInfo(this.upload);
        }

        public Call executeAsync(ApiCallback<ImageLoadReport> _callback) throws ApiException {
            return ImagesApi.this.imageLoadLibpodAsync(this.upload, _callback);
        }
    }

    public class APIimagePruneLibpodRequest {
        private Boolean all;
        private Boolean external;
        private Boolean buildcache;
        private String filters;

        private APIimagePruneLibpodRequest() {
        }

        public APIimagePruneLibpodRequest all(Boolean all) {
            this.all = all;
            return this;
        }

        public APIimagePruneLibpodRequest external(Boolean external) {
            this.external = external;
            return this;
        }

        public APIimagePruneLibpodRequest buildcache(Boolean buildcache) {
            this.buildcache = buildcache;
            return this;
        }

        public APIimagePruneLibpodRequest filters(String filters) {
            this.filters = filters;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ImagesApi.this.imagePruneLibpodCall(this.all, this.external, this.buildcache, this.filters, _callback);
        }

        public List<PruneReport> execute() throws ApiException {
            ApiResponse<List<PruneReport>> localVarResp = ImagesApi.this.imagePruneLibpodWithHttpInfo(this.all, this.external, this.buildcache, this.filters);
            return localVarResp.getData();
        }

        public ApiResponse<List<PruneReport>> executeWithHttpInfo() throws ApiException {
            return ImagesApi.this.imagePruneLibpodWithHttpInfo(this.all, this.external, this.buildcache, this.filters);
        }

        public Call executeAsync(ApiCallback<List<PruneReport>> _callback) throws ApiException {
            return ImagesApi.this.imagePruneLibpodAsync(this.all, this.external, this.buildcache, this.filters, _callback);
        }
    }

    public class APIimagePullLibpodRequest {
        private String reference;
        private Boolean quiet;
        private Boolean compatMode;
        private String arch;
        private String OS;
        private String variant;
        private String policy;
        private Boolean tlsVerify;
        private Boolean allTags;
        private String xRegistryAuth;

        private APIimagePullLibpodRequest() {
        }

        public APIimagePullLibpodRequest reference(String reference) {
            this.reference = reference;
            return this;
        }

        public APIimagePullLibpodRequest quiet(Boolean quiet) {
            this.quiet = quiet;
            return this;
        }

        public APIimagePullLibpodRequest compatMode(Boolean compatMode) {
            this.compatMode = compatMode;
            return this;
        }

        public APIimagePullLibpodRequest arch(String arch) {
            this.arch = arch;
            return this;
        }

        public APIimagePullLibpodRequest OS(String OS) {
            this.OS = OS;
            return this;
        }

        public APIimagePullLibpodRequest variant(String variant) {
            this.variant = variant;
            return this;
        }

        public APIimagePullLibpodRequest policy(String policy) {
            this.policy = policy;
            return this;
        }

        public APIimagePullLibpodRequest tlsVerify(Boolean tlsVerify) {
            this.tlsVerify = tlsVerify;
            return this;
        }

        public APIimagePullLibpodRequest allTags(Boolean allTags) {
            this.allTags = allTags;
            return this;
        }

        public APIimagePullLibpodRequest xRegistryAuth(String xRegistryAuth) {
            this.xRegistryAuth = xRegistryAuth;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ImagesApi.this.imagePullLibpodCall(this.reference, this.quiet, this.compatMode, this.arch, this.OS, this.variant, this.policy, this.tlsVerify, this.allTags, this.xRegistryAuth, _callback);
        }

        public LibpodImagesPullReport execute() throws ApiException {
            ApiResponse<LibpodImagesPullReport> localVarResp = ImagesApi.this.imagePullLibpodWithHttpInfo(this.reference, this.quiet, this.compatMode, this.arch, this.OS, this.variant, this.policy, this.tlsVerify, this.allTags, this.xRegistryAuth);
            return localVarResp.getData();
        }

        public ApiResponse<LibpodImagesPullReport> executeWithHttpInfo() throws ApiException {
            return ImagesApi.this.imagePullLibpodWithHttpInfo(this.reference, this.quiet, this.compatMode, this.arch, this.OS, this.variant, this.policy, this.tlsVerify, this.allTags, this.xRegistryAuth);
        }

        public Call executeAsync(ApiCallback<LibpodImagesPullReport> _callback) throws ApiException {
            return ImagesApi.this.imagePullLibpodAsync(this.reference, this.quiet, this.compatMode, this.arch, this.OS, this.variant, this.policy, this.tlsVerify, this.allTags, this.xRegistryAuth, _callback);
        }
    }

    public class APIimagePushLibpodRequest {
        private final String name;
        private String destination;
        private Boolean forceCompressionFormat;
        private String compressionFormat;
        private Integer compressionLevel;
        private Boolean tlsVerify;
        private Boolean quiet;
        private String format;
        private Boolean all;
        private Boolean removeSignatures;
        private Integer retry;
        private String retryDelay;
        private String xRegistryAuth;

        private APIimagePushLibpodRequest(String name) {
            this.name = name;
        }

        public APIimagePushLibpodRequest destination(String destination) {
            this.destination = destination;
            return this;
        }

        public APIimagePushLibpodRequest forceCompressionFormat(Boolean forceCompressionFormat) {
            this.forceCompressionFormat = forceCompressionFormat;
            return this;
        }

        public APIimagePushLibpodRequest compressionFormat(String compressionFormat) {
            this.compressionFormat = compressionFormat;
            return this;
        }

        public APIimagePushLibpodRequest compressionLevel(Integer compressionLevel) {
            this.compressionLevel = compressionLevel;
            return this;
        }

        public APIimagePushLibpodRequest tlsVerify(Boolean tlsVerify) {
            this.tlsVerify = tlsVerify;
            return this;
        }

        public APIimagePushLibpodRequest quiet(Boolean quiet) {
            this.quiet = quiet;
            return this;
        }

        public APIimagePushLibpodRequest format(String format) {
            this.format = format;
            return this;
        }

        public APIimagePushLibpodRequest all(Boolean all) {
            this.all = all;
            return this;
        }

        public APIimagePushLibpodRequest removeSignatures(Boolean removeSignatures) {
            this.removeSignatures = removeSignatures;
            return this;
        }

        public APIimagePushLibpodRequest retry(Integer retry) {
            this.retry = retry;
            return this;
        }

        public APIimagePushLibpodRequest retryDelay(String retryDelay) {
            this.retryDelay = retryDelay;
            return this;
        }

        public APIimagePushLibpodRequest xRegistryAuth(String xRegistryAuth) {
            this.xRegistryAuth = xRegistryAuth;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ImagesApi.this.imagePushLibpodCall(this.name, this.destination, this.forceCompressionFormat, this.compressionFormat, this.compressionLevel, this.tlsVerify, this.quiet, this.format, this.all, this.removeSignatures, this.retry, this.retryDelay, this.xRegistryAuth, _callback);
        }

        public File execute() throws ApiException {
            ApiResponse<File> localVarResp = ImagesApi.this.imagePushLibpodWithHttpInfo(this.name, this.destination, this.forceCompressionFormat, this.compressionFormat, this.compressionLevel, this.tlsVerify, this.quiet, this.format, this.all, this.removeSignatures, this.retry, this.retryDelay, this.xRegistryAuth);
            return localVarResp.getData();
        }

        public ApiResponse<File> executeWithHttpInfo() throws ApiException {
            return ImagesApi.this.imagePushLibpodWithHttpInfo(this.name, this.destination, this.forceCompressionFormat, this.compressionFormat, this.compressionLevel, this.tlsVerify, this.quiet, this.format, this.all, this.removeSignatures, this.retry, this.retryDelay, this.xRegistryAuth);
        }

        public Call executeAsync(ApiCallback<File> _callback) throws ApiException {
            return ImagesApi.this.imagePushLibpodAsync(this.name, this.destination, this.forceCompressionFormat, this.compressionFormat, this.compressionLevel, this.tlsVerify, this.quiet, this.format, this.all, this.removeSignatures, this.retry, this.retryDelay, this.xRegistryAuth, _callback);
        }
    }

    public class APIimageResolveLibpodRequest {
        private final String name;

        private APIimageResolveLibpodRequest(String name) {
            this.name = name;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ImagesApi.this.imageResolveLibpodCall(this.name, _callback);
        }

        public void execute() throws ApiException {
            ImagesApi.this.imageResolveLibpodWithHttpInfo(this.name);
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return ImagesApi.this.imageResolveLibpodWithHttpInfo(this.name);
        }

        public Call executeAsync(ApiCallback<Void> _callback) throws ApiException {
            return ImagesApi.this.imageResolveLibpodAsync(this.name, _callback);
        }
    }

    public class APIimageScpLibpodRequest {
        private final String name;
        private String destination;
        private Boolean quiet;

        private APIimageScpLibpodRequest(String name) {
            this.name = name;
        }

        public APIimageScpLibpodRequest destination(String destination) {
            this.destination = destination;
            return this;
        }

        public APIimageScpLibpodRequest quiet(Boolean quiet) {
            this.quiet = quiet;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ImagesApi.this.imageScpLibpodCall(this.name, this.destination, this.quiet, _callback);
        }

        public ScpReport execute() throws ApiException {
            ApiResponse<ScpReport> localVarResp = ImagesApi.this.imageScpLibpodWithHttpInfo(this.name, this.destination, this.quiet);
            return localVarResp.getData();
        }

        public ApiResponse<ScpReport> executeWithHttpInfo() throws ApiException {
            return ImagesApi.this.imageScpLibpodWithHttpInfo(this.name, this.destination, this.quiet);
        }

        public Call executeAsync(ApiCallback<ScpReport> _callback) throws ApiException {
            return ImagesApi.this.imageScpLibpodAsync(this.name, this.destination, this.quiet, _callback);
        }
    }

    public class APIimageSearchLibpodRequest {
        private String term;
        private Integer limit;
        private String filters;
        private Boolean tlsVerify;
        private Boolean listTags;

        private APIimageSearchLibpodRequest() {
        }

        public APIimageSearchLibpodRequest term(String term) {
            this.term = term;
            return this;
        }

        public APIimageSearchLibpodRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIimageSearchLibpodRequest filters(String filters) {
            this.filters = filters;
            return this;
        }

        public APIimageSearchLibpodRequest tlsVerify(Boolean tlsVerify) {
            this.tlsVerify = tlsVerify;
            return this;
        }

        public APIimageSearchLibpodRequest listTags(Boolean listTags) {
            this.listTags = listTags;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ImagesApi.this.imageSearchLibpodCall(this.term, this.limit, this.filters, this.tlsVerify, this.listTags, _callback);
        }

        public ImageSearch200Response execute() throws ApiException {
            ApiResponse<ImageSearch200Response> localVarResp = ImagesApi.this.imageSearchLibpodWithHttpInfo(this.term, this.limit, this.filters, this.tlsVerify, this.listTags);
            return localVarResp.getData();
        }

        public ApiResponse<ImageSearch200Response> executeWithHttpInfo() throws ApiException {
            return ImagesApi.this.imageSearchLibpodWithHttpInfo(this.term, this.limit, this.filters, this.tlsVerify, this.listTags);
        }

        public Call executeAsync(ApiCallback<ImageSearch200Response> _callback) throws ApiException {
            return ImagesApi.this.imageSearchLibpodAsync(this.term, this.limit, this.filters, this.tlsVerify, this.listTags, _callback);
        }
    }

    public class APIimageTagLibpodRequest {
        private final String name;
        private String repo;
        private String tag;

        private APIimageTagLibpodRequest(String name) {
            this.name = name;
        }

        public APIimageTagLibpodRequest repo(String repo) {
            this.repo = repo;
            return this;
        }

        public APIimageTagLibpodRequest tag(String tag) {
            this.tag = tag;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ImagesApi.this.imageTagLibpodCall(this.name, this.repo, this.tag, _callback);
        }

        public void execute() throws ApiException {
            ImagesApi.this.imageTagLibpodWithHttpInfo(this.name, this.repo, this.tag);
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return ImagesApi.this.imageTagLibpodWithHttpInfo(this.name, this.repo, this.tag);
        }

        public Call executeAsync(ApiCallback<Void> _callback) throws ApiException {
            return ImagesApi.this.imageTagLibpodAsync(this.name, this.repo, this.tag, _callback);
        }
    }

    public class APIimageTreeLibpodRequest {
        private final String name;
        private Boolean whatrequires;

        private APIimageTreeLibpodRequest(String name) {
            this.name = name;
        }

        public APIimageTreeLibpodRequest whatrequires(Boolean whatrequires) {
            this.whatrequires = whatrequires;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ImagesApi.this.imageTreeLibpodCall(this.name, this.whatrequires, _callback);
        }

        public ImageTreeReport execute() throws ApiException {
            ApiResponse<ImageTreeReport> localVarResp = ImagesApi.this.imageTreeLibpodWithHttpInfo(this.name, this.whatrequires);
            return localVarResp.getData();
        }

        public ApiResponse<ImageTreeReport> executeWithHttpInfo() throws ApiException {
            return ImagesApi.this.imageTreeLibpodWithHttpInfo(this.name, this.whatrequires);
        }

        public Call executeAsync(ApiCallback<ImageTreeReport> _callback) throws ApiException {
            return ImagesApi.this.imageTreeLibpodAsync(this.name, this.whatrequires, _callback);
        }
    }

    public class APIimageUntagLibpodRequest {
        private final String name;
        private String repo;
        private String tag;

        private APIimageUntagLibpodRequest(String name) {
            this.name = name;
        }

        public APIimageUntagLibpodRequest repo(String repo) {
            this.repo = repo;
            return this;
        }

        public APIimageUntagLibpodRequest tag(String tag) {
            this.tag = tag;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ImagesApi.this.imageUntagLibpodCall(this.name, this.repo, this.tag, _callback);
        }

        public void execute() throws ApiException {
            ImagesApi.this.imageUntagLibpodWithHttpInfo(this.name, this.repo, this.tag);
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return ImagesApi.this.imageUntagLibpodWithHttpInfo(this.name, this.repo, this.tag);
        }

        public Call executeAsync(ApiCallback<Void> _callback) throws ApiException {
            return ImagesApi.this.imageUntagLibpodAsync(this.name, this.repo, this.tag, _callback);
        }
    }
}

