/*
 * supports a RESTful API for the Libpod library
 * This documentation describes the Podman v2.x+ RESTful API. It consists of a Docker-compatible API and a Libpod API providing support for Podman’s unique features such as pods.  To start the service and keep it running for 5,000 seconds (-t 0 runs forever):  podman system service -t 5000 &  You can then use cURL on the socket using requests documented below.  NOTE: if you install the package podman-docker, it will create a symbolic link for /run/docker.sock to /run/podman/podman.sock  NOTE: Some fields in the API response JSON are encoded as omitempty, which means that if said field has a zero value, they will not be encoded in the API response. This is a feature to help reduce the size of the JSON responses returned via the API.  NOTE: Due to the limitations of [go-swagger](https://github.com/go-swagger/go-swagger), some field values that have a complex type show up as null in the docs as well as in the API responses. This is because the zero value for the field type is null. The field description in the docs will state what type the field is expected to be for such cases.  See podman-system-service(1) for more information.  Quick Examples:  'podman info'  curl --unix-socket /run/podman/podman.sock http://d/v5.0.0/libpod/info  'podman pull quay.io/containers/podman'  curl -XPOST --unix-socket /run/podman/podman.sock -v 'http://d/v5.0.0/images/create?fromImage=quay.io%2Fcontainers%2Fpodman'  'podman list images'  curl --unix-socket /run/podman/podman.sock -v 'http://d/v5.0.0/libpod/images/json' | jq
 *
 * The version of the OpenAPI document: 5.0.0
 * Contact: podman@lists.podman.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.github.pod4dev.libpodj.api;

import io.github.pod4dev.libpodj.ApiCallback;
import io.github.pod4dev.libpodj.ApiClient;
import io.github.pod4dev.libpodj.ApiException;
import io.github.pod4dev.libpodj.ApiResponse;
import io.github.pod4dev.libpodj.Configuration;
import io.github.pod4dev.libpodj.Pair;
import io.github.pod4dev.libpodj.ProgressRequestBody;
import io.github.pod4dev.libpodj.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;

import jakarta.validation.constraints.*;
import jakarta.validation.Valid;

import io.github.pod4dev.libpodj.model.Container;
import io.github.pod4dev.libpodj.model.ContainerCreateResponse;
import io.github.pod4dev.libpodj.model.ContainerJSON;
import io.github.pod4dev.libpodj.model.ContainerTopOKBody;
import io.github.pod4dev.libpodj.model.ContainerWait200Response;
import io.github.pod4dev.libpodj.model.ContainersPruneReport;
import io.github.pod4dev.libpodj.model.CreateContainerConfig;
import io.github.pod4dev.libpodj.model.ErrorModel;
import java.io.File;
import io.github.pod4dev.libpodj.model.UpdateConfig;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ContainersCompatApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ContainersCompatApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ContainersCompatApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private okhttp3.Call containerArchiveCall(String name, String path, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/containers/{name}/archive"
            .replace("{" + "name" + "}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (path != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("path", path));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call containerArchiveValidateBeforeCall(String name, String path, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling containerArchive(Async)");
        }

        // verify the required parameter 'path' is set
        if (path == null) {
            throw new ApiException("Missing the required parameter 'path' when calling containerArchive(Async)");
        }

        return containerArchiveCall(name, path, _callback);

    }


    private ApiResponse<File> containerArchiveWithHttpInfo( @NotNull String name,  @NotNull String path) throws ApiException {
        okhttp3.Call localVarCall = containerArchiveValidateBeforeCall(name, path, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call containerArchiveAsync(String name, String path, final ApiCallback<File> _callback) throws ApiException {

        okhttp3.Call localVarCall = containerArchiveValidateBeforeCall(name, path, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIcontainerArchiveRequest {
        private final String name;
        private final String path;

        private APIcontainerArchiveRequest(String name, String path) {
            this.name = name;
            this.path = path;
        }

        /**
         * Build call for containerArchive
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return containerArchiveCall(name, path, _callback);
        }

        /**
         * Execute containerArchive request
         * @return File
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public File execute() throws ApiException {
            ApiResponse<File> localVarResp = containerArchiveWithHttpInfo(name, path);
            return localVarResp.getData();
        }

        /**
         * Execute containerArchive request with HTTP info returned
         * @return ApiResponse&lt;File&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<File> executeWithHttpInfo() throws ApiException {
            return containerArchiveWithHttpInfo(name, path);
        }

        /**
         * Execute containerArchive request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<File> _callback) throws ApiException {
            return containerArchiveAsync(name, path, _callback);
        }
    }

    /**
     * Get files from a container
     * Get a tar archive of files from a container
     * @param name container name or id (required)
     * @param path Path to a directory in the container to extract (required)
     * @return APIcontainerArchiveRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> no error </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIcontainerArchiveRequest containerArchive(String name, String path) {
        return new APIcontainerArchiveRequest(name, path);
    }
    private okhttp3.Call containerArchiveLibpodCall(String name, String path, String rename, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/libpod/containers/{name}/archive"
            .replace("{" + "name" + "}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (path != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("path", path));
        }

        if (rename != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("rename", rename));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call containerArchiveLibpodValidateBeforeCall(String name, String path, String rename, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling containerArchiveLibpod(Async)");
        }

        // verify the required parameter 'path' is set
        if (path == null) {
            throw new ApiException("Missing the required parameter 'path' when calling containerArchiveLibpod(Async)");
        }

        return containerArchiveLibpodCall(name, path, rename, _callback);

    }


    private ApiResponse<File> containerArchiveLibpodWithHttpInfo( @NotNull String name,  @NotNull String path, String rename) throws ApiException {
        okhttp3.Call localVarCall = containerArchiveLibpodValidateBeforeCall(name, path, rename, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call containerArchiveLibpodAsync(String name, String path, String rename, final ApiCallback<File> _callback) throws ApiException {

        okhttp3.Call localVarCall = containerArchiveLibpodValidateBeforeCall(name, path, rename, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIcontainerArchiveLibpodRequest {
        private final String name;
        private final String path;
        private String rename;

        private APIcontainerArchiveLibpodRequest(String name, String path) {
            this.name = name;
            this.path = path;
        }

        /**
         * Set rename
         * @param rename JSON encoded map[string]string to translate paths (optional)
         * @return APIcontainerArchiveLibpodRequest
         */
        public APIcontainerArchiveLibpodRequest rename(String rename) {
            this.rename = rename;
            return this;
        }

        /**
         * Build call for containerArchiveLibpod
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return containerArchiveLibpodCall(name, path, rename, _callback);
        }

        /**
         * Execute containerArchiveLibpod request
         * @return File
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public File execute() throws ApiException {
            ApiResponse<File> localVarResp = containerArchiveLibpodWithHttpInfo(name, path, rename);
            return localVarResp.getData();
        }

        /**
         * Execute containerArchiveLibpod request with HTTP info returned
         * @return ApiResponse&lt;File&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<File> executeWithHttpInfo() throws ApiException {
            return containerArchiveLibpodWithHttpInfo(name, path, rename);
        }

        /**
         * Execute containerArchiveLibpod request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<File> _callback) throws ApiException {
            return containerArchiveLibpodAsync(name, path, rename, _callback);
        }
    }

    /**
     * Copy files from a container
     * Copy a tar archive of files from a container
     * @param name container name or id (required)
     * @param path Path to a directory in the container to extract (required)
     * @return APIcontainerArchiveLibpodRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> no error </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIcontainerArchiveLibpodRequest containerArchiveLibpod(String name, String path) {
        return new APIcontainerArchiveLibpodRequest(name, path);
    }
    private okhttp3.Call containerAttachCall(String name, String detachKeys, Boolean logs, Boolean stream, Boolean stdout, Boolean stderr, Boolean stdin, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/containers/{name}/attach"
            .replace("{" + "name" + "}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (detachKeys != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("detachKeys", detachKeys));
        }

        if (logs != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("logs", logs));
        }

        if (stream != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("stream", stream));
        }

        if (stdout != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("stdout", stdout));
        }

        if (stderr != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("stderr", stderr));
        }

        if (stdin != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("stdin", stdin));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call containerAttachValidateBeforeCall(String name, String detachKeys, Boolean logs, Boolean stream, Boolean stdout, Boolean stderr, Boolean stdin, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling containerAttach(Async)");
        }

        return containerAttachCall(name, detachKeys, logs, stream, stdout, stderr, stdin, _callback);

    }


    private ApiResponse<Void> containerAttachWithHttpInfo( @NotNull String name, String detachKeys, Boolean logs, Boolean stream, Boolean stdout, Boolean stderr, Boolean stdin) throws ApiException {
        okhttp3.Call localVarCall = containerAttachValidateBeforeCall(name, detachKeys, logs, stream, stdout, stderr, stdin, null);
        return localVarApiClient.execute(localVarCall);
    }

    private okhttp3.Call containerAttachAsync(String name, String detachKeys, Boolean logs, Boolean stream, Boolean stdout, Boolean stderr, Boolean stdin, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = containerAttachValidateBeforeCall(name, detachKeys, logs, stream, stdout, stderr, stdin, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public class APIcontainerAttachRequest {
        private final String name;
        private String detachKeys;
        private Boolean logs;
        private Boolean stream;
        private Boolean stdout;
        private Boolean stderr;
        private Boolean stdin;

        private APIcontainerAttachRequest(String name) {
            this.name = name;
        }

        /**
         * Set detachKeys
         * @param detachKeys keys to use for detaching from the container (optional)
         * @return APIcontainerAttachRequest
         */
        public APIcontainerAttachRequest detachKeys(String detachKeys) {
            this.detachKeys = detachKeys;
            return this;
        }

        /**
         * Set logs
         * @param logs Stream all logs from the container across the connection. Happens before streaming attach (if requested). At least one of logs or stream must be set (optional)
         * @return APIcontainerAttachRequest
         */
        public APIcontainerAttachRequest logs(Boolean logs) {
            this.logs = logs;
            return this;
        }

        /**
         * Set stream
         * @param stream Attach to the container. If unset, and logs is set, only the container&#39;s logs will be sent. At least one of stream or logs must be set (optional, default to true)
         * @return APIcontainerAttachRequest
         */
        public APIcontainerAttachRequest stream(Boolean stream) {
            this.stream = stream;
            return this;
        }

        /**
         * Set stdout
         * @param stdout Attach to container STDOUT (optional)
         * @return APIcontainerAttachRequest
         */
        public APIcontainerAttachRequest stdout(Boolean stdout) {
            this.stdout = stdout;
            return this;
        }

        /**
         * Set stderr
         * @param stderr Attach to container STDERR (optional)
         * @return APIcontainerAttachRequest
         */
        public APIcontainerAttachRequest stderr(Boolean stderr) {
            this.stderr = stderr;
            return this;
        }

        /**
         * Set stdin
         * @param stdin Attach to container STDIN (optional)
         * @return APIcontainerAttachRequest
         */
        public APIcontainerAttachRequest stdin(Boolean stdin) {
            this.stdin = stdin;
            return this;
        }

        /**
         * Build call for containerAttach
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 101 </td><td> No error, connection has been hijacked for transporting streams. </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return containerAttachCall(name, detachKeys, logs, stream, stdout, stderr, stdin, _callback);
        }

        /**
         * Execute containerAttach request
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 101 </td><td> No error, connection has been hijacked for transporting streams. </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public void execute() throws ApiException {
            containerAttachWithHttpInfo(name, detachKeys, logs, stream, stdout, stderr, stdin);
        }

        /**
         * Execute containerAttach request with HTTP info returned
         * @return ApiResponse&lt;Void&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 101 </td><td> No error, connection has been hijacked for transporting streams. </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return containerAttachWithHttpInfo(name, detachKeys, logs, stream, stdout, stderr, stdin);
        }

        /**
         * Execute containerAttach request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 101 </td><td> No error, connection has been hijacked for transporting streams. </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<Void> _callback) throws ApiException {
            return containerAttachAsync(name, detachKeys, logs, stream, stdout, stderr, stdin, _callback);
        }
    }

    /**
     * Attach to a container
     * Attach to a container to read its output or send it input. You can attach to the same container multiple times and you can reattach to containers that have been detached.  It uses the same stream format as docker, see the libpod attach endpoint for a description of the format. 
     * @param name the name or ID of the container (required)
     * @return APIcontainerAttachRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 101 </td><td> No error, connection has been hijacked for transporting streams. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIcontainerAttachRequest containerAttach(String name) {
        return new APIcontainerAttachRequest(name);
    }
    private okhttp3.Call containerChangesLibpod_0Call(String name, String parent, String diffType, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/libpod/containers/{name}/changes"
            .replace("{" + "name" + "}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (parent != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("parent", parent));
        }

        if (diffType != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("diffType", diffType));
        }

        final String[] localVarAccepts = {
            "application/json",
            "application/octet-stream",
            "text/plain"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call containerChangesLibpod_0ValidateBeforeCall(String name, String parent, String diffType, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling containerChangesLibpod_0(Async)");
        }

        return containerChangesLibpod_0Call(name, parent, diffType, _callback);

    }


    private ApiResponse<Void> containerChangesLibpod_0WithHttpInfo( @NotNull String name, String parent, String diffType) throws ApiException {
        okhttp3.Call localVarCall = containerChangesLibpod_0ValidateBeforeCall(name, parent, diffType, null);
        return localVarApiClient.execute(localVarCall);
    }

    private okhttp3.Call containerChangesLibpod_0Async(String name, String parent, String diffType, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = containerChangesLibpod_0ValidateBeforeCall(name, parent, diffType, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public class APIcontainerChangesLibpod_0Request {
        private final String name;
        private String parent;
        private String diffType;

        private APIcontainerChangesLibpod_0Request(String name) {
            this.name = name;
        }

        /**
         * Set parent
         * @param parent specify a second layer which is used to compare against it instead of the parent layer (optional)
         * @return APIcontainerChangesLibpod_0Request
         */
        public APIcontainerChangesLibpod_0Request parent(String parent) {
            this.parent = parent;
            return this;
        }

        /**
         * Set diffType
         * @param diffType select what you want to match, default is all (optional)
         * @return APIcontainerChangesLibpod_0Request
         */
        public APIcontainerChangesLibpod_0Request diffType(String diffType) {
            this.diffType = diffType;
            return this;
        }

        /**
         * Build call for containerChangesLibpod_0
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Array of Changes </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return containerChangesLibpod_0Call(name, parent, diffType, _callback);
        }

        /**
         * Execute containerChangesLibpod_0 request
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Array of Changes </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public void execute() throws ApiException {
            containerChangesLibpod_0WithHttpInfo(name, parent, diffType);
        }

        /**
         * Execute containerChangesLibpod_0 request with HTTP info returned
         * @return ApiResponse&lt;Void&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Array of Changes </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return containerChangesLibpod_0WithHttpInfo(name, parent, diffType);
        }

        /**
         * Execute containerChangesLibpod_0 request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Array of Changes </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<Void> _callback) throws ApiException {
            return containerChangesLibpod_0Async(name, parent, diffType, _callback);
        }
    }

    /**
     * Report on changes to container&#39;s filesystem; adds, deletes or modifications.
     * Returns which files in a container&#39;s filesystem have been added, deleted, or modified. The Kind of modification can be one of:  0: Modified 1: Added 2: Deleted 
     * @param name the name or id of the container (required)
     * @return APIcontainerChangesLibpod_0Request
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Array of Changes </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIcontainerChangesLibpod_0Request containerChangesLibpod_0(String name) {
        return new APIcontainerChangesLibpod_0Request(name);
    }
    private okhttp3.Call containerCreateCall(CreateContainerConfig body, String name, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "/containers/create";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (name != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("name", name));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json",
            "application/x-tar"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call containerCreateValidateBeforeCall(CreateContainerConfig body, String name, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling containerCreate(Async)");
        }

        return containerCreateCall(body, name, _callback);

    }


    private ApiResponse<ContainerCreateResponse> containerCreateWithHttpInfo( @NotNull CreateContainerConfig body, String name) throws ApiException {
        okhttp3.Call localVarCall = containerCreateValidateBeforeCall(body, name, null);
        Type localVarReturnType = new TypeToken<ContainerCreateResponse>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call containerCreateAsync(CreateContainerConfig body, String name, final ApiCallback<ContainerCreateResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = containerCreateValidateBeforeCall(body, name, _callback);
        Type localVarReturnType = new TypeToken<ContainerCreateResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIcontainerCreateRequest {
        private final CreateContainerConfig body;
        private String name;

        private APIcontainerCreateRequest(CreateContainerConfig body) {
            this.body = body;
        }

        /**
         * Set name
         * @param name container name (optional)
         * @return APIcontainerCreateRequest
         */
        public APIcontainerCreateRequest name(String name) {
            this.name = name;
            return this;
        }

        /**
         * Build call for containerCreate
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 201 </td><td> Create container </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> Conflict error in operation </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return containerCreateCall(body, name, _callback);
        }

        /**
         * Execute containerCreate request
         * @return ContainerCreateResponse
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 201 </td><td> Create container </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> Conflict error in operation </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ContainerCreateResponse execute() throws ApiException {
            ApiResponse<ContainerCreateResponse> localVarResp = containerCreateWithHttpInfo(body, name);
            return localVarResp.getData();
        }

        /**
         * Execute containerCreate request with HTTP info returned
         * @return ApiResponse&lt;ContainerCreateResponse&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 201 </td><td> Create container </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> Conflict error in operation </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<ContainerCreateResponse> executeWithHttpInfo() throws ApiException {
            return containerCreateWithHttpInfo(body, name);
        }

        /**
         * Execute containerCreate request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 201 </td><td> Create container </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> Conflict error in operation </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<ContainerCreateResponse> _callback) throws ApiException {
            return containerCreateAsync(body, name, _callback);
        }
    }

    /**
     * Create a container
     * 
     * @param body Container to create (required)
     * @return APIcontainerCreateRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Create container </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> Conflict error in operation </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIcontainerCreateRequest containerCreate(CreateContainerConfig body) {
        return new APIcontainerCreateRequest(body);
    }
    private okhttp3.Call containerDeleteCall(String name, Boolean force, Boolean v, Boolean link, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/containers/{name}"
            .replace("{" + "name" + "}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (force != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("force", force));
        }

        if (v != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("v", v));
        }

        if (link != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("link", link));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call containerDeleteValidateBeforeCall(String name, Boolean force, Boolean v, Boolean link, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling containerDelete(Async)");
        }

        return containerDeleteCall(name, force, v, link, _callback);

    }


    private ApiResponse<Void> containerDeleteWithHttpInfo( @NotNull String name, Boolean force, Boolean v, Boolean link) throws ApiException {
        okhttp3.Call localVarCall = containerDeleteValidateBeforeCall(name, force, v, link, null);
        return localVarApiClient.execute(localVarCall);
    }

    private okhttp3.Call containerDeleteAsync(String name, Boolean force, Boolean v, Boolean link, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = containerDeleteValidateBeforeCall(name, force, v, link, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public class APIcontainerDeleteRequest {
        private final String name;
        private Boolean force;
        private Boolean v;
        private Boolean link;

        private APIcontainerDeleteRequest(String name) {
            this.name = name;
        }

        /**
         * Set force
         * @param force If the container is running, kill it before removing it. (optional, default to false)
         * @return APIcontainerDeleteRequest
         */
        public APIcontainerDeleteRequest force(Boolean force) {
            this.force = force;
            return this;
        }

        /**
         * Set v
         * @param v Remove the volumes associated with the container. (optional, default to false)
         * @return APIcontainerDeleteRequest
         */
        public APIcontainerDeleteRequest v(Boolean v) {
            this.v = v;
            return this;
        }

        /**
         * Set link
         * @param link not supported (optional)
         * @return APIcontainerDeleteRequest
         */
        public APIcontainerDeleteRequest link(Boolean link) {
            this.link = link;
            return this;
        }

        /**
         * Build call for containerDelete
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> Conflict error in operation </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return containerDeleteCall(name, force, v, link, _callback);
        }

        /**
         * Execute containerDelete request
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> Conflict error in operation </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public void execute() throws ApiException {
            containerDeleteWithHttpInfo(name, force, v, link);
        }

        /**
         * Execute containerDelete request with HTTP info returned
         * @return ApiResponse&lt;Void&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> Conflict error in operation </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return containerDeleteWithHttpInfo(name, force, v, link);
        }

        /**
         * Execute containerDelete request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> Conflict error in operation </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<Void> _callback) throws ApiException {
            return containerDeleteAsync(name, force, v, link, _callback);
        }
    }

    /**
     * Remove a container
     * 
     * @param name the name or ID of the container (required)
     * @return APIcontainerDeleteRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> Conflict error in operation </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIcontainerDeleteRequest containerDelete(String name) {
        return new APIcontainerDeleteRequest(name);
    }
    private okhttp3.Call containerExportCall(String name, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/containers/{name}/export"
            .replace("{" + "name" + "}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call containerExportValidateBeforeCall(String name, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling containerExport(Async)");
        }

        return containerExportCall(name, _callback);

    }


    private ApiResponse<Void> containerExportWithHttpInfo( @NotNull String name) throws ApiException {
        okhttp3.Call localVarCall = containerExportValidateBeforeCall(name, null);
        return localVarApiClient.execute(localVarCall);
    }

    private okhttp3.Call containerExportAsync(String name, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = containerExportValidateBeforeCall(name, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public class APIcontainerExportRequest {
        private final String name;

        private APIcontainerExportRequest(String name) {
            this.name = name;
        }

        /**
         * Build call for containerExport
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> tarball is returned in body </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return containerExportCall(name, _callback);
        }

        /**
         * Execute containerExport request
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> tarball is returned in body </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public void execute() throws ApiException {
            containerExportWithHttpInfo(name);
        }

        /**
         * Execute containerExport request with HTTP info returned
         * @return ApiResponse&lt;Void&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> tarball is returned in body </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return containerExportWithHttpInfo(name);
        }

        /**
         * Execute containerExport request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> tarball is returned in body </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<Void> _callback) throws ApiException {
            return containerExportAsync(name, _callback);
        }
    }

    /**
     * Export a container
     * Export the contents of a container as a tarball.
     * @param name the name or ID of the container (required)
     * @return APIcontainerExportRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> tarball is returned in body </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIcontainerExportRequest containerExport(String name) {
        return new APIcontainerExportRequest(name);
    }
    private okhttp3.Call containerInspectCall(String name, Boolean size, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/containers/{name}/json"
            .replace("{" + "name" + "}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (size != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("size", size));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call containerInspectValidateBeforeCall(String name, Boolean size, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling containerInspect(Async)");
        }

        return containerInspectCall(name, size, _callback);

    }


    private ApiResponse<ContainerJSON> containerInspectWithHttpInfo( @NotNull String name, Boolean size) throws ApiException {
        okhttp3.Call localVarCall = containerInspectValidateBeforeCall(name, size, null);
        Type localVarReturnType = new TypeToken<ContainerJSON>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call containerInspectAsync(String name, Boolean size, final ApiCallback<ContainerJSON> _callback) throws ApiException {

        okhttp3.Call localVarCall = containerInspectValidateBeforeCall(name, size, _callback);
        Type localVarReturnType = new TypeToken<ContainerJSON>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIcontainerInspectRequest {
        private final String name;
        private Boolean size;

        private APIcontainerInspectRequest(String name) {
            this.name = name;
        }

        /**
         * Set size
         * @param size include the size of the container (optional, default to false)
         * @return APIcontainerInspectRequest
         */
        public APIcontainerInspectRequest size(Boolean size) {
            this.size = size;
            return this;
        }

        /**
         * Build call for containerInspect
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Inspect container </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return containerInspectCall(name, size, _callback);
        }

        /**
         * Execute containerInspect request
         * @return ContainerJSON
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Inspect container </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ContainerJSON execute() throws ApiException {
            ApiResponse<ContainerJSON> localVarResp = containerInspectWithHttpInfo(name, size);
            return localVarResp.getData();
        }

        /**
         * Execute containerInspect request with HTTP info returned
         * @return ApiResponse&lt;ContainerJSON&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Inspect container </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<ContainerJSON> executeWithHttpInfo() throws ApiException {
            return containerInspectWithHttpInfo(name, size);
        }

        /**
         * Execute containerInspect request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Inspect container </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<ContainerJSON> _callback) throws ApiException {
            return containerInspectAsync(name, size, _callback);
        }
    }

    /**
     * Inspect container
     * Return low-level information about a container.
     * @param name the name or id of the container (required)
     * @return APIcontainerInspectRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Inspect container </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIcontainerInspectRequest containerInspect(String name) {
        return new APIcontainerInspectRequest(name);
    }
    private okhttp3.Call containerKillCall(String name, Boolean all, String signal, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/containers/{name}/kill"
            .replace("{" + "name" + "}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (all != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("all", all));
        }

        if (signal != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("signal", signal));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call containerKillValidateBeforeCall(String name, Boolean all, String signal, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling containerKill(Async)");
        }

        return containerKillCall(name, all, signal, _callback);

    }


    private ApiResponse<Void> containerKillWithHttpInfo( @NotNull String name, Boolean all, String signal) throws ApiException {
        okhttp3.Call localVarCall = containerKillValidateBeforeCall(name, all, signal, null);
        return localVarApiClient.execute(localVarCall);
    }

    private okhttp3.Call containerKillAsync(String name, Boolean all, String signal, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = containerKillValidateBeforeCall(name, all, signal, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public class APIcontainerKillRequest {
        private final String name;
        private Boolean all;
        private String signal;

        private APIcontainerKillRequest(String name) {
            this.name = name;
        }

        /**
         * Set all
         * @param all Send kill signal to all containers (optional, default to false)
         * @return APIcontainerKillRequest
         */
        public APIcontainerKillRequest all(Boolean all) {
            this.all = all;
            return this;
        }

        /**
         * Set signal
         * @param signal signal to be sent to container (optional, default to SIGKILL)
         * @return APIcontainerKillRequest
         */
        public APIcontainerKillRequest signal(String signal) {
            this.signal = signal;
            return this;
        }

        /**
         * Build call for containerKill
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> Conflict error in operation </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return containerKillCall(name, all, signal, _callback);
        }

        /**
         * Execute containerKill request
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> Conflict error in operation </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public void execute() throws ApiException {
            containerKillWithHttpInfo(name, all, signal);
        }

        /**
         * Execute containerKill request with HTTP info returned
         * @return ApiResponse&lt;Void&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> Conflict error in operation </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return containerKillWithHttpInfo(name, all, signal);
        }

        /**
         * Execute containerKill request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> Conflict error in operation </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<Void> _callback) throws ApiException {
            return containerKillAsync(name, all, signal, _callback);
        }
    }

    /**
     * Kill container
     * Signal to send to the container as an integer or string (e.g. SIGINT)
     * @param name the name or ID of the container (required)
     * @return APIcontainerKillRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> Conflict error in operation </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIcontainerKillRequest containerKill(String name) {
        return new APIcontainerKillRequest(name);
    }
    private okhttp3.Call containerListCall(Boolean all, Boolean external, Integer limit, Boolean size, String filters, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/containers/json";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (all != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("all", all));
        }

        if (external != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("external", external));
        }

        if (limit != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("limit", limit));
        }

        if (size != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("size", size));
        }

        if (filters != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("filters", filters));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call containerListValidateBeforeCall(Boolean all, Boolean external, Integer limit, Boolean size, String filters, final ApiCallback _callback) throws ApiException {
        return containerListCall(all, external, limit, size, filters, _callback);

    }


    private ApiResponse<List<Container>> containerListWithHttpInfo(Boolean all, Boolean external, Integer limit, Boolean size, String filters) throws ApiException {
        okhttp3.Call localVarCall = containerListValidateBeforeCall(all, external, limit, size, filters, null);
        Type localVarReturnType = new TypeToken<List<Container>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call containerListAsync(Boolean all, Boolean external, Integer limit, Boolean size, String filters, final ApiCallback<List<Container>> _callback) throws ApiException {

        okhttp3.Call localVarCall = containerListValidateBeforeCall(all, external, limit, size, filters, _callback);
        Type localVarReturnType = new TypeToken<List<Container>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIcontainerListRequest {
        private Boolean all;
        private Boolean external;
        private Integer limit;
        private Boolean size;
        private String filters;

        private APIcontainerListRequest() {
        }

        /**
         * Set all
         * @param all Return all containers. By default, only running containers are shown (optional, default to false)
         * @return APIcontainerListRequest
         */
        public APIcontainerListRequest all(Boolean all) {
            this.all = all;
            return this;
        }

        /**
         * Set external
         * @param external Return containers in storage not controlled by Podman (optional, default to false)
         * @return APIcontainerListRequest
         */
        public APIcontainerListRequest external(Boolean external) {
            this.external = external;
            return this;
        }

        /**
         * Set limit
         * @param limit Return this number of most recently created containers, including non-running ones. (optional)
         * @return APIcontainerListRequest
         */
        public APIcontainerListRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        /**
         * Set size
         * @param size Return the size of container as fields SizeRw and SizeRootFs. (optional, default to false)
         * @return APIcontainerListRequest
         */
        public APIcontainerListRequest size(Boolean size) {
            this.size = size;
            return this;
        }

        /**
         * Set filters
         * @param filters A JSON encoded value of the filters (a &#x60;map[string][]string&#x60;) to process on the containers list. Available filters: - &#x60;ancestor&#x60;&#x3D;(&#x60;&lt;image-name&gt;[:&lt;tag&gt;]&#x60;, &#x60;&lt;image id&gt;&#x60;, or &#x60;&lt;image@digest&gt;&#x60;) - &#x60;before&#x60;&#x3D;(&#x60;&lt;container id&gt;&#x60; or &#x60;&lt;container name&gt;&#x60;) - &#x60;expose&#x60;&#x3D;(&#x60;&lt;port&gt;[/&lt;proto&gt;]&#x60; or &#x60;&lt;startport-endport&gt;/[&lt;proto&gt;]&#x60;) - &#x60;exited&#x3D;&lt;int&gt;&#x60; containers with exit code of &#x60;&lt;int&gt;&#x60; - &#x60;health&#x60;&#x3D;(&#x60;starting&#x60;, &#x60;healthy&#x60;, &#x60;unhealthy&#x60; or &#x60;none&#x60;) - &#x60;id&#x3D;&lt;ID&gt;&#x60; a container&#39;s ID - &#x60;is-task&#x60;&#x3D;(&#x60;true&#x60; or &#x60;false&#x60;) - &#x60;label&#x60;&#x3D;(&#x60;key&#x60; or &#x60;\&quot;key&#x3D;value\&quot;&#x60;) of a container label - &#x60;name&#x3D;&lt;name&gt;&#x60; a container&#39;s name - &#x60;network&#x60;&#x3D;(&#x60;&lt;network id&gt;&#x60; or &#x60;&lt;network name&gt;&#x60;) - &#x60;publish&#x60;&#x3D;(&#x60;&lt;port&gt;[/&lt;proto&gt;]&#x60; or &#x60;&lt;startport-endport&gt;/[&lt;proto&gt;]&#x60;) - &#x60;since&#x60;&#x3D;(&#x60;&lt;container id&gt;&#x60; or &#x60;&lt;container name&gt;&#x60;) - &#x60;status&#x60;&#x3D;(&#x60;created&#x60;, &#x60;restarting&#x60;, &#x60;running&#x60;, &#x60;removing&#x60;, &#x60;paused&#x60;, &#x60;exited&#x60; or &#x60;dead&#x60;) - &#x60;volume&#x60;&#x3D;(&#x60;&lt;volume name&gt;&#x60; or &#x60;&lt;mount point destination&gt;&#x60;)  (optional)
         * @return APIcontainerListRequest
         */
        public APIcontainerListRequest filters(String filters) {
            this.filters = filters;
            return this;
        }

        /**
         * Build call for containerList
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List Containers </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return containerListCall(all, external, limit, size, filters, _callback);
        }

        /**
         * Execute containerList request
         * @return List&lt;Container&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List Containers </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public List<Container> execute() throws ApiException {
            ApiResponse<List<Container>> localVarResp = containerListWithHttpInfo(all, external, limit, size, filters);
            return localVarResp.getData();
        }

        /**
         * Execute containerList request with HTTP info returned
         * @return ApiResponse&lt;List&lt;Container&gt;&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List Containers </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<List<Container>> executeWithHttpInfo() throws ApiException {
            return containerListWithHttpInfo(all, external, limit, size, filters);
        }

        /**
         * Execute containerList request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List Containers </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<List<Container>> _callback) throws ApiException {
            return containerListAsync(all, external, limit, size, filters, _callback);
        }
    }

    /**
     * List containers
     * Returns a list of containers
     * @return APIcontainerListRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List Containers </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIcontainerListRequest containerList() {
        return new APIcontainerListRequest();
    }
    private okhttp3.Call containerLogsCall(String name, Boolean follow, Boolean stdout, Boolean stderr, String since, String until, Boolean timestamps, String tail, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/containers/{name}/logs"
            .replace("{" + "name" + "}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (follow != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("follow", follow));
        }

        if (stdout != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("stdout", stdout));
        }

        if (stderr != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("stderr", stderr));
        }

        if (since != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("since", since));
        }

        if (until != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("until", until));
        }

        if (timestamps != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("timestamps", timestamps));
        }

        if (tail != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("tail", tail));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call containerLogsValidateBeforeCall(String name, Boolean follow, Boolean stdout, Boolean stderr, String since, String until, Boolean timestamps, String tail, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling containerLogs(Async)");
        }

        return containerLogsCall(name, follow, stdout, stderr, since, until, timestamps, tail, _callback);

    }


    private ApiResponse<Void> containerLogsWithHttpInfo( @NotNull String name, Boolean follow, Boolean stdout, Boolean stderr, String since, String until, Boolean timestamps, String tail) throws ApiException {
        okhttp3.Call localVarCall = containerLogsValidateBeforeCall(name, follow, stdout, stderr, since, until, timestamps, tail, null);
        return localVarApiClient.execute(localVarCall);
    }

    private okhttp3.Call containerLogsAsync(String name, Boolean follow, Boolean stdout, Boolean stderr, String since, String until, Boolean timestamps, String tail, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = containerLogsValidateBeforeCall(name, follow, stdout, stderr, since, until, timestamps, tail, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public class APIcontainerLogsRequest {
        private final String name;
        private Boolean follow;
        private Boolean stdout;
        private Boolean stderr;
        private String since;
        private String until;
        private Boolean timestamps;
        private String tail;

        private APIcontainerLogsRequest(String name) {
            this.name = name;
        }

        /**
         * Set follow
         * @param follow Keep connection after returning logs. (optional)
         * @return APIcontainerLogsRequest
         */
        public APIcontainerLogsRequest follow(Boolean follow) {
            this.follow = follow;
            return this;
        }

        /**
         * Set stdout
         * @param stdout Return logs from stdout (optional)
         * @return APIcontainerLogsRequest
         */
        public APIcontainerLogsRequest stdout(Boolean stdout) {
            this.stdout = stdout;
            return this;
        }

        /**
         * Set stderr
         * @param stderr Return logs from stderr (optional)
         * @return APIcontainerLogsRequest
         */
        public APIcontainerLogsRequest stderr(Boolean stderr) {
            this.stderr = stderr;
            return this;
        }

        /**
         * Set since
         * @param since Only return logs since this time, as a UNIX timestamp (optional)
         * @return APIcontainerLogsRequest
         */
        public APIcontainerLogsRequest since(String since) {
            this.since = since;
            return this;
        }

        /**
         * Set until
         * @param until Only return logs before this time, as a UNIX timestamp (optional)
         * @return APIcontainerLogsRequest
         */
        public APIcontainerLogsRequest until(String until) {
            this.until = until;
            return this;
        }

        /**
         * Set timestamps
         * @param timestamps Add timestamps to every log line (optional, default to false)
         * @return APIcontainerLogsRequest
         */
        public APIcontainerLogsRequest timestamps(Boolean timestamps) {
            this.timestamps = timestamps;
            return this;
        }

        /**
         * Set tail
         * @param tail Only return this number of log lines from the end of the logs (optional, default to all)
         * @return APIcontainerLogsRequest
         */
        public APIcontainerLogsRequest tail(String tail) {
            this.tail = tail;
            return this;
        }

        /**
         * Build call for containerLogs
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> logs returned as a stream in response body. </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return containerLogsCall(name, follow, stdout, stderr, since, until, timestamps, tail, _callback);
        }

        /**
         * Execute containerLogs request
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> logs returned as a stream in response body. </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public void execute() throws ApiException {
            containerLogsWithHttpInfo(name, follow, stdout, stderr, since, until, timestamps, tail);
        }

        /**
         * Execute containerLogs request with HTTP info returned
         * @return ApiResponse&lt;Void&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> logs returned as a stream in response body. </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return containerLogsWithHttpInfo(name, follow, stdout, stderr, since, until, timestamps, tail);
        }

        /**
         * Execute containerLogs request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> logs returned as a stream in response body. </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<Void> _callback) throws ApiException {
            return containerLogsAsync(name, follow, stdout, stderr, since, until, timestamps, tail, _callback);
        }
    }

    /**
     * Get container logs
     * Get stdout and stderr logs from a container.
     * @param name the name or ID of the container (required)
     * @return APIcontainerLogsRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> logs returned as a stream in response body. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIcontainerLogsRequest containerLogs(String name) {
        return new APIcontainerLogsRequest(name);
    }
    private okhttp3.Call containerPauseCall(String name, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/containers/{name}/pause"
            .replace("{" + "name" + "}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call containerPauseValidateBeforeCall(String name, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling containerPause(Async)");
        }

        return containerPauseCall(name, _callback);

    }


    private ApiResponse<Void> containerPauseWithHttpInfo( @NotNull String name) throws ApiException {
        okhttp3.Call localVarCall = containerPauseValidateBeforeCall(name, null);
        return localVarApiClient.execute(localVarCall);
    }

    private okhttp3.Call containerPauseAsync(String name, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = containerPauseValidateBeforeCall(name, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public class APIcontainerPauseRequest {
        private final String name;

        private APIcontainerPauseRequest(String name) {
            this.name = name;
        }

        /**
         * Build call for containerPause
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return containerPauseCall(name, _callback);
        }

        /**
         * Execute containerPause request
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public void execute() throws ApiException {
            containerPauseWithHttpInfo(name);
        }

        /**
         * Execute containerPause request with HTTP info returned
         * @return ApiResponse&lt;Void&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return containerPauseWithHttpInfo(name);
        }

        /**
         * Execute containerPause request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<Void> _callback) throws ApiException {
            return containerPauseAsync(name, _callback);
        }
    }

    /**
     * Pause container
     * Use the cgroups freezer to suspend all processes in a container.
     * @param name the name or ID of the container (required)
     * @return APIcontainerPauseRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIcontainerPauseRequest containerPause(String name) {
        return new APIcontainerPauseRequest(name);
    }
    private okhttp3.Call containerPruneCall(String filters, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/containers/prune";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (filters != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("filters", filters));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call containerPruneValidateBeforeCall(String filters, final ApiCallback _callback) throws ApiException {
        return containerPruneCall(filters, _callback);

    }


    private ApiResponse<List<ContainersPruneReport>> containerPruneWithHttpInfo(String filters) throws ApiException {
        okhttp3.Call localVarCall = containerPruneValidateBeforeCall(filters, null);
        Type localVarReturnType = new TypeToken<List<ContainersPruneReport>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call containerPruneAsync(String filters, final ApiCallback<List<ContainersPruneReport>> _callback) throws ApiException {

        okhttp3.Call localVarCall = containerPruneValidateBeforeCall(filters, _callback);
        Type localVarReturnType = new TypeToken<List<ContainersPruneReport>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIcontainerPruneRequest {
        private String filters;

        private APIcontainerPruneRequest() {
        }

        /**
         * Set filters
         * @param filters Filters to process on the prune list, encoded as JSON (a &#x60;map[string][]string&#x60;).  Available filters:  - &#x60;until&#x3D;&lt;timestamp&gt;&#x60; Prune containers created before this timestamp. The &#x60;&lt;timestamp&gt;&#x60; can be Unix timestamps, date formatted timestamps, or Go duration strings (e.g. &#x60;10m&#x60;, &#x60;1h30m&#x60;) computed relative to the daemon machine’s time.  - &#x60;label&#x60; (&#x60;label&#x3D;&lt;key&gt;&#x60;, &#x60;label&#x3D;&lt;key&gt;&#x3D;&lt;value&gt;&#x60;, &#x60;label!&#x3D;&lt;key&gt;&#x60;, or &#x60;label!&#x3D;&lt;key&gt;&#x3D;&lt;value&gt;&#x60;) Prune containers with (or without, in case &#x60;label!&#x3D;...&#x60; is used) the specified labels.  (optional)
         * @return APIcontainerPruneRequest
         */
        public APIcontainerPruneRequest filters(String filters) {
            this.filters = filters;
            return this;
        }

        /**
         * Build call for containerPrune
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Prune Containers </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return containerPruneCall(filters, _callback);
        }

        /**
         * Execute containerPrune request
         * @return List&lt;ContainersPruneReport&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Prune Containers </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public List<ContainersPruneReport> execute() throws ApiException {
            ApiResponse<List<ContainersPruneReport>> localVarResp = containerPruneWithHttpInfo(filters);
            return localVarResp.getData();
        }

        /**
         * Execute containerPrune request with HTTP info returned
         * @return ApiResponse&lt;List&lt;ContainersPruneReport&gt;&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Prune Containers </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<List<ContainersPruneReport>> executeWithHttpInfo() throws ApiException {
            return containerPruneWithHttpInfo(filters);
        }

        /**
         * Execute containerPrune request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Prune Containers </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<List<ContainersPruneReport>> _callback) throws ApiException {
            return containerPruneAsync(filters, _callback);
        }
    }

    /**
     * Delete stopped containers
     * Remove containers not in use
     * @return APIcontainerPruneRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Prune Containers </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIcontainerPruneRequest containerPrune() {
        return new APIcontainerPruneRequest();
    }
    private okhttp3.Call containerRenameCall(String name, String name2, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/containers/{name}/rename"
            .replace("{" + "name" + "}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (name2 != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("name", name2));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call containerRenameValidateBeforeCall(String name, String name2, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling containerRename(Async)");
        }

        // verify the required parameter 'name2' is set
        if (name2 == null) {
            throw new ApiException("Missing the required parameter 'name2' when calling containerRename(Async)");
        }

        return containerRenameCall(name, name2, _callback);

    }


    private ApiResponse<Void> containerRenameWithHttpInfo( @NotNull String name,  @NotNull String name2) throws ApiException {
        okhttp3.Call localVarCall = containerRenameValidateBeforeCall(name, name2, null);
        return localVarApiClient.execute(localVarCall);
    }

    private okhttp3.Call containerRenameAsync(String name, String name2, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = containerRenameValidateBeforeCall(name, name2, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public class APIcontainerRenameRequest {
        private final String name;
        private final String name2;

        private APIcontainerRenameRequest(String name, String name2) {
            this.name = name;
            this.name2 = name2;
        }

        /**
         * Build call for containerRename
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> Conflict error in operation </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return containerRenameCall(name, name2, _callback);
        }

        /**
         * Execute containerRename request
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> Conflict error in operation </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public void execute() throws ApiException {
            containerRenameWithHttpInfo(name, name2);
        }

        /**
         * Execute containerRename request with HTTP info returned
         * @return ApiResponse&lt;Void&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> Conflict error in operation </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return containerRenameWithHttpInfo(name, name2);
        }

        /**
         * Execute containerRename request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> Conflict error in operation </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<Void> _callback) throws ApiException {
            return containerRenameAsync(name, name2, _callback);
        }
    }

    /**
     * Rename an existing container
     * Change the name of an existing container.
     * @param name Full or partial ID or full name of the container to rename (required)
     * @param name2 New name for the container (required)
     * @return APIcontainerRenameRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> Conflict error in operation </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIcontainerRenameRequest containerRename(String name, String name2) {
        return new APIcontainerRenameRequest(name, name2);
    }
    private okhttp3.Call containerResizeCall(String name, Integer h, Integer w, Boolean running, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/containers/{name}/resize"
            .replace("{" + "name" + "}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (h != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("h", h));
        }

        if (w != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("w", w));
        }

        if (running != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("running", running));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call containerResizeValidateBeforeCall(String name, Integer h, Integer w, Boolean running, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling containerResize(Async)");
        }

        return containerResizeCall(name, h, w, running, _callback);

    }


    private ApiResponse<Object> containerResizeWithHttpInfo( @NotNull String name, Integer h, Integer w, Boolean running) throws ApiException {
        okhttp3.Call localVarCall = containerResizeValidateBeforeCall(name, h, w, running, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call containerResizeAsync(String name, Integer h, Integer w, Boolean running, final ApiCallback<Object> _callback) throws ApiException {

        okhttp3.Call localVarCall = containerResizeValidateBeforeCall(name, h, w, running, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIcontainerResizeRequest {
        private final String name;
        private Integer h;
        private Integer w;
        private Boolean running;

        private APIcontainerResizeRequest(String name) {
            this.name = name;
        }

        /**
         * Set h
         * @param h Height to set for the terminal, in characters (optional)
         * @return APIcontainerResizeRequest
         */
        public APIcontainerResizeRequest h(Integer h) {
            this.h = h;
            return this;
        }

        /**
         * Set w
         * @param w Width to set for the terminal, in characters (optional)
         * @return APIcontainerResizeRequest
         */
        public APIcontainerResizeRequest w(Integer w) {
            this.w = w;
            return this;
        }

        /**
         * Set running
         * @param running Ignore containers not running errors (optional)
         * @return APIcontainerResizeRequest
         */
        public APIcontainerResizeRequest running(Boolean running) {
            this.running = running;
            return this;
        }

        /**
         * Build call for containerResize
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Success </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return containerResizeCall(name, h, w, running, _callback);
        }

        /**
         * Execute containerResize request
         * @return Object
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Success </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public Object execute() throws ApiException {
            ApiResponse<Object> localVarResp = containerResizeWithHttpInfo(name, h, w, running);
            return localVarResp.getData();
        }

        /**
         * Execute containerResize request with HTTP info returned
         * @return ApiResponse&lt;Object&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Success </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<Object> executeWithHttpInfo() throws ApiException {
            return containerResizeWithHttpInfo(name, h, w, running);
        }

        /**
         * Execute containerResize request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Success </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<Object> _callback) throws ApiException {
            return containerResizeAsync(name, h, w, running, _callback);
        }
    }

    /**
     * Resize a container&#39;s TTY
     * Resize the terminal attached to a container (for use with Attach).
     * @param name the name or ID of the container (required)
     * @return APIcontainerResizeRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIcontainerResizeRequest containerResize(String name) {
        return new APIcontainerResizeRequest(name);
    }
    private okhttp3.Call containerRestartCall(String name, Integer t, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/containers/{name}/restart"
            .replace("{" + "name" + "}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (t != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("t", t));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call containerRestartValidateBeforeCall(String name, Integer t, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling containerRestart(Async)");
        }

        return containerRestartCall(name, t, _callback);

    }


    private ApiResponse<Void> containerRestartWithHttpInfo( @NotNull String name, Integer t) throws ApiException {
        okhttp3.Call localVarCall = containerRestartValidateBeforeCall(name, t, null);
        return localVarApiClient.execute(localVarCall);
    }

    private okhttp3.Call containerRestartAsync(String name, Integer t, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = containerRestartValidateBeforeCall(name, t, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public class APIcontainerRestartRequest {
        private final String name;
        private Integer t;

        private APIcontainerRestartRequest(String name) {
            this.name = name;
        }

        /**
         * Set t
         * @param t timeout before sending kill signal to container (optional)
         * @return APIcontainerRestartRequest
         */
        public APIcontainerRestartRequest t(Integer t) {
            this.t = t;
            return this;
        }

        /**
         * Build call for containerRestart
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return containerRestartCall(name, t, _callback);
        }

        /**
         * Execute containerRestart request
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public void execute() throws ApiException {
            containerRestartWithHttpInfo(name, t);
        }

        /**
         * Execute containerRestart request with HTTP info returned
         * @return ApiResponse&lt;Void&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return containerRestartWithHttpInfo(name, t);
        }

        /**
         * Execute containerRestart request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<Void> _callback) throws ApiException {
            return containerRestartAsync(name, t, _callback);
        }
    }

    /**
     * Restart container
     * 
     * @param name the name or ID of the container (required)
     * @return APIcontainerRestartRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIcontainerRestartRequest containerRestart(String name) {
        return new APIcontainerRestartRequest(name);
    }
    private okhttp3.Call containerStartCall(String name, String detachKeys, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/containers/{name}/start"
            .replace("{" + "name" + "}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (detachKeys != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("detachKeys", detachKeys));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call containerStartValidateBeforeCall(String name, String detachKeys, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling containerStart(Async)");
        }

        return containerStartCall(name, detachKeys, _callback);

    }


    private ApiResponse<Void> containerStartWithHttpInfo( @NotNull String name, String detachKeys) throws ApiException {
        okhttp3.Call localVarCall = containerStartValidateBeforeCall(name, detachKeys, null);
        return localVarApiClient.execute(localVarCall);
    }

    private okhttp3.Call containerStartAsync(String name, String detachKeys, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = containerStartValidateBeforeCall(name, detachKeys, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public class APIcontainerStartRequest {
        private final String name;
        private String detachKeys;

        private APIcontainerStartRequest(String name) {
            this.name = name;
        }

        /**
         * Set detachKeys
         * @param detachKeys Override the key sequence for detaching a container. Format is a single character [a-Z] or ctrl-&lt;value&gt; where &lt;value&gt; is one of: a-z, @, ^, [, , or _. (optional, default to ctrl-p,ctrl-q)
         * @return APIcontainerStartRequest
         */
        public APIcontainerStartRequest detachKeys(String detachKeys) {
            this.detachKeys = detachKeys;
            return this;
        }

        /**
         * Build call for containerStart
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 304 </td><td> Container already started </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return containerStartCall(name, detachKeys, _callback);
        }

        /**
         * Execute containerStart request
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 304 </td><td> Container already started </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public void execute() throws ApiException {
            containerStartWithHttpInfo(name, detachKeys);
        }

        /**
         * Execute containerStart request with HTTP info returned
         * @return ApiResponse&lt;Void&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 304 </td><td> Container already started </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return containerStartWithHttpInfo(name, detachKeys);
        }

        /**
         * Execute containerStart request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 304 </td><td> Container already started </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<Void> _callback) throws ApiException {
            return containerStartAsync(name, detachKeys, _callback);
        }
    }

    /**
     * Start a container
     * 
     * @param name the name or ID of the container (required)
     * @return APIcontainerStartRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
        <tr><td> 304 </td><td> Container already started </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIcontainerStartRequest containerStart(String name) {
        return new APIcontainerStartRequest(name);
    }
    private okhttp3.Call containerStatsCall(String name, Boolean stream, Boolean oneShot, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/containers/{name}/stats"
            .replace("{" + "name" + "}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (stream != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("stream", stream));
        }

        if (oneShot != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("one-shot", oneShot));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call containerStatsValidateBeforeCall(String name, Boolean stream, Boolean oneShot, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling containerStats(Async)");
        }

        return containerStatsCall(name, stream, oneShot, _callback);

    }


    private ApiResponse<Object> containerStatsWithHttpInfo( @NotNull String name, Boolean stream, Boolean oneShot) throws ApiException {
        okhttp3.Call localVarCall = containerStatsValidateBeforeCall(name, stream, oneShot, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call containerStatsAsync(String name, Boolean stream, Boolean oneShot, final ApiCallback<Object> _callback) throws ApiException {

        okhttp3.Call localVarCall = containerStatsValidateBeforeCall(name, stream, oneShot, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIcontainerStatsRequest {
        private final String name;
        private Boolean stream;
        private Boolean oneShot;

        private APIcontainerStatsRequest(String name) {
            this.name = name;
        }

        /**
         * Set stream
         * @param stream Stream the output (optional, default to true)
         * @return APIcontainerStatsRequest
         */
        public APIcontainerStatsRequest stream(Boolean stream) {
            this.stream = stream;
            return this;
        }

        /**
         * Set oneShot
         * @param oneShot Provide a one-shot response in which preCPU stats are blank, resulting in a single cycle return. (optional, default to false)
         * @return APIcontainerStatsRequest
         */
        public APIcontainerStatsRequest oneShot(Boolean oneShot) {
            this.oneShot = oneShot;
            return this;
        }

        /**
         * Build call for containerStats
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return containerStatsCall(name, stream, oneShot, _callback);
        }

        /**
         * Execute containerStats request
         * @return Object
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public Object execute() throws ApiException {
            ApiResponse<Object> localVarResp = containerStatsWithHttpInfo(name, stream, oneShot);
            return localVarResp.getData();
        }

        /**
         * Execute containerStats request with HTTP info returned
         * @return ApiResponse&lt;Object&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<Object> executeWithHttpInfo() throws ApiException {
            return containerStatsWithHttpInfo(name, stream, oneShot);
        }

        /**
         * Execute containerStats request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<Object> _callback) throws ApiException {
            return containerStatsAsync(name, stream, oneShot, _callback);
        }
    }

    /**
     * Get stats for a container
     * This returns a live stream of a container’s resource usage statistics.
     * @param name the name or ID of the container (required)
     * @return APIcontainerStatsRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> no error </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIcontainerStatsRequest containerStats(String name) {
        return new APIcontainerStatsRequest(name);
    }
    private okhttp3.Call containerStopCall(String name, Integer t, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/containers/{name}/stop"
            .replace("{" + "name" + "}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (t != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("t", t));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call containerStopValidateBeforeCall(String name, Integer t, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling containerStop(Async)");
        }

        return containerStopCall(name, t, _callback);

    }


    private ApiResponse<Void> containerStopWithHttpInfo( @NotNull String name, Integer t) throws ApiException {
        okhttp3.Call localVarCall = containerStopValidateBeforeCall(name, t, null);
        return localVarApiClient.execute(localVarCall);
    }

    private okhttp3.Call containerStopAsync(String name, Integer t, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = containerStopValidateBeforeCall(name, t, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public class APIcontainerStopRequest {
        private final String name;
        private Integer t;

        private APIcontainerStopRequest(String name) {
            this.name = name;
        }

        /**
         * Set t
         * @param t number of seconds to wait before killing container (optional)
         * @return APIcontainerStopRequest
         */
        public APIcontainerStopRequest t(Integer t) {
            this.t = t;
            return this;
        }

        /**
         * Build call for containerStop
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 304 </td><td> Container already stopped </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return containerStopCall(name, t, _callback);
        }

        /**
         * Execute containerStop request
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 304 </td><td> Container already stopped </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public void execute() throws ApiException {
            containerStopWithHttpInfo(name, t);
        }

        /**
         * Execute containerStop request with HTTP info returned
         * @return ApiResponse&lt;Void&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 304 </td><td> Container already stopped </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return containerStopWithHttpInfo(name, t);
        }

        /**
         * Execute containerStop request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 304 </td><td> Container already stopped </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<Void> _callback) throws ApiException {
            return containerStopAsync(name, t, _callback);
        }
    }

    /**
     * Stop a container
     * Stop a container
     * @param name the name or ID of the container (required)
     * @return APIcontainerStopRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
        <tr><td> 304 </td><td> Container already stopped </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIcontainerStopRequest containerStop(String name) {
        return new APIcontainerStopRequest(name);
    }
    private okhttp3.Call containerTopCall(String name, String psArgs, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/containers/{name}/top"
            .replace("{" + "name" + "}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (psArgs != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("ps_args", psArgs));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call containerTopValidateBeforeCall(String name, String psArgs, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling containerTop(Async)");
        }

        return containerTopCall(name, psArgs, _callback);

    }


    private ApiResponse<ContainerTopOKBody> containerTopWithHttpInfo( @NotNull String name, String psArgs) throws ApiException {
        okhttp3.Call localVarCall = containerTopValidateBeforeCall(name, psArgs, null);
        Type localVarReturnType = new TypeToken<ContainerTopOKBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call containerTopAsync(String name, String psArgs, final ApiCallback<ContainerTopOKBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = containerTopValidateBeforeCall(name, psArgs, _callback);
        Type localVarReturnType = new TypeToken<ContainerTopOKBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIcontainerTopRequest {
        private final String name;
        private String psArgs;

        private APIcontainerTopRequest(String name) {
            this.name = name;
        }

        /**
         * Set psArgs
         * @param psArgs arguments to pass to ps such as aux. (optional, default to -ef)
         * @return APIcontainerTopRequest
         */
        public APIcontainerTopRequest psArgs(String psArgs) {
            this.psArgs = psArgs;
            return this;
        }

        /**
         * Build call for containerTop
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List processes in container </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return containerTopCall(name, psArgs, _callback);
        }

        /**
         * Execute containerTop request
         * @return ContainerTopOKBody
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List processes in container </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ContainerTopOKBody execute() throws ApiException {
            ApiResponse<ContainerTopOKBody> localVarResp = containerTopWithHttpInfo(name, psArgs);
            return localVarResp.getData();
        }

        /**
         * Execute containerTop request with HTTP info returned
         * @return ApiResponse&lt;ContainerTopOKBody&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List processes in container </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<ContainerTopOKBody> executeWithHttpInfo() throws ApiException {
            return containerTopWithHttpInfo(name, psArgs);
        }

        /**
         * Execute containerTop request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List processes in container </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<ContainerTopOKBody> _callback) throws ApiException {
            return containerTopAsync(name, psArgs, _callback);
        }
    }

    /**
     * List processes running inside a container
     * 
     * @param name the name or ID of the container (required)
     * @return APIcontainerTopRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List processes in container </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIcontainerTopRequest containerTop(String name) {
        return new APIcontainerTopRequest(name);
    }
    private okhttp3.Call containerUnpauseCall(String name, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/containers/{name}/unpause"
            .replace("{" + "name" + "}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call containerUnpauseValidateBeforeCall(String name, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling containerUnpause(Async)");
        }

        return containerUnpauseCall(name, _callback);

    }


    private ApiResponse<Void> containerUnpauseWithHttpInfo( @NotNull String name) throws ApiException {
        okhttp3.Call localVarCall = containerUnpauseValidateBeforeCall(name, null);
        return localVarApiClient.execute(localVarCall);
    }

    private okhttp3.Call containerUnpauseAsync(String name, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = containerUnpauseValidateBeforeCall(name, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public class APIcontainerUnpauseRequest {
        private final String name;

        private APIcontainerUnpauseRequest(String name) {
            this.name = name;
        }

        /**
         * Build call for containerUnpause
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return containerUnpauseCall(name, _callback);
        }

        /**
         * Execute containerUnpause request
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public void execute() throws ApiException {
            containerUnpauseWithHttpInfo(name);
        }

        /**
         * Execute containerUnpause request with HTTP info returned
         * @return ApiResponse&lt;Void&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return containerUnpauseWithHttpInfo(name);
        }

        /**
         * Execute containerUnpause request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<Void> _callback) throws ApiException {
            return containerUnpauseAsync(name, _callback);
        }
    }

    /**
     * Unpause container
     * Resume a paused container
     * @param name the name or ID of the container (required)
     * @return APIcontainerUnpauseRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIcontainerUnpauseRequest containerUnpause(String name) {
        return new APIcontainerUnpauseRequest(name);
    }
    private okhttp3.Call containerUpdateCall(String name, UpdateConfig resources, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = resources;

        // create path and map variables
        String localVarPath = "/containers/{name}/update"
            .replace("{" + "name" + "}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json",
            "application/x-tar"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call containerUpdateValidateBeforeCall(String name, UpdateConfig resources, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling containerUpdate(Async)");
        }

        return containerUpdateCall(name, resources, _callback);

    }


    private ApiResponse<Void> containerUpdateWithHttpInfo( @NotNull String name, UpdateConfig resources) throws ApiException {
        okhttp3.Call localVarCall = containerUpdateValidateBeforeCall(name, resources, null);
        return localVarApiClient.execute(localVarCall);
    }

    private okhttp3.Call containerUpdateAsync(String name, UpdateConfig resources, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = containerUpdateValidateBeforeCall(name, resources, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public class APIcontainerUpdateRequest {
        private final String name;
        private UpdateConfig resources;

        private APIcontainerUpdateRequest(String name) {
            this.name = name;
        }

        /**
         * Set resources
         * @param resources attributes for updating the container (optional)
         * @return APIcontainerUpdateRequest
         */
        public APIcontainerUpdateRequest resources(UpdateConfig resources) {
            this.resources = resources;
            return this;
        }

        /**
         * Build call for containerUpdate
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return containerUpdateCall(name, resources, _callback);
        }

        /**
         * Execute containerUpdate request
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public void execute() throws ApiException {
            containerUpdateWithHttpInfo(name, resources);
        }

        /**
         * Execute containerUpdate request with HTTP info returned
         * @return ApiResponse&lt;Void&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return containerUpdateWithHttpInfo(name, resources);
        }

        /**
         * Execute containerUpdate request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<Void> _callback) throws ApiException {
            return containerUpdateAsync(name, resources, _callback);
        }
    }

    /**
     * Update configuration of an existing container
     * Change configuration settings for an existing container without requiring recreation.
     * @param name Full or partial ID or full name of the container to rename (required)
     * @return APIcontainerUpdateRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> no error </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIcontainerUpdateRequest containerUpdate(String name) {
        return new APIcontainerUpdateRequest(name);
    }
    private okhttp3.Call containerWaitCall(String name, String condition, String interval, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/containers/{name}/wait"
            .replace("{" + "name" + "}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (condition != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("condition", condition));
        }

        if (interval != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("interval", interval));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call containerWaitValidateBeforeCall(String name, String condition, String interval, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling containerWait(Async)");
        }

        return containerWaitCall(name, condition, interval, _callback);

    }


    private ApiResponse<ContainerWait200Response> containerWaitWithHttpInfo( @NotNull String name, String condition, String interval) throws ApiException {
        okhttp3.Call localVarCall = containerWaitValidateBeforeCall(name, condition, interval, null);
        Type localVarReturnType = new TypeToken<ContainerWait200Response>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call containerWaitAsync(String name, String condition, String interval, final ApiCallback<ContainerWait200Response> _callback) throws ApiException {

        okhttp3.Call localVarCall = containerWaitValidateBeforeCall(name, condition, interval, _callback);
        Type localVarReturnType = new TypeToken<ContainerWait200Response>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIcontainerWaitRequest {
        private final String name;
        private String condition;
        private String interval;

        private APIcontainerWaitRequest(String name) {
            this.name = name;
        }

        /**
         * Set condition
         * @param condition wait until container is to a given condition. default is stopped. valid conditions are:   - configured   - created   - exited   - paused   - running   - stopped  (optional)
         * @return APIcontainerWaitRequest
         */
        public APIcontainerWaitRequest condition(String condition) {
            this.condition = condition;
            return this;
        }

        /**
         * Set interval
         * @param interval Time Interval to wait before polling for completion. (optional, default to 250ms)
         * @return APIcontainerWaitRequest
         */
        public APIcontainerWaitRequest interval(String interval) {
            this.interval = interval;
            return this;
        }

        /**
         * Build call for containerWait
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Wait container </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return containerWaitCall(name, condition, interval, _callback);
        }

        /**
         * Execute containerWait request
         * @return ContainerWait200Response
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Wait container </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ContainerWait200Response execute() throws ApiException {
            ApiResponse<ContainerWait200Response> localVarResp = containerWaitWithHttpInfo(name, condition, interval);
            return localVarResp.getData();
        }

        /**
         * Execute containerWait request with HTTP info returned
         * @return ApiResponse&lt;ContainerWait200Response&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Wait container </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<ContainerWait200Response> executeWithHttpInfo() throws ApiException {
            return containerWaitWithHttpInfo(name, condition, interval);
        }

        /**
         * Execute containerWait request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Wait container </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<ContainerWait200Response> _callback) throws ApiException {
            return containerWaitAsync(name, condition, interval, _callback);
        }
    }

    /**
     * Wait on a container
     * Block until a container stops or given condition is met.
     * @param name the name or ID of the container (required)
     * @return APIcontainerWaitRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Wait container </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIcontainerWaitRequest containerWait(String name) {
        return new APIcontainerWaitRequest(name);
    }
    private okhttp3.Call imageCommitCall(String container, String repo, String tag, String comment, String author, Boolean pause, String changes, Boolean squash, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/commit";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (container != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("container", container));
        }

        if (repo != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("repo", repo));
        }

        if (tag != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("tag", tag));
        }

        if (comment != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("comment", comment));
        }

        if (author != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("author", author));
        }

        if (pause != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("pause", pause));
        }

        if (changes != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("changes", changes));
        }

        if (squash != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("squash", squash));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call imageCommitValidateBeforeCall(String container, String repo, String tag, String comment, String author, Boolean pause, String changes, Boolean squash, final ApiCallback _callback) throws ApiException {
        return imageCommitCall(container, repo, tag, comment, author, pause, changes, squash, _callback);

    }


    private ApiResponse<Void> imageCommitWithHttpInfo(String container, String repo, String tag, String comment, String author, Boolean pause, String changes, Boolean squash) throws ApiException {
        okhttp3.Call localVarCall = imageCommitValidateBeforeCall(container, repo, tag, comment, author, pause, changes, squash, null);
        return localVarApiClient.execute(localVarCall);
    }

    private okhttp3.Call imageCommitAsync(String container, String repo, String tag, String comment, String author, Boolean pause, String changes, Boolean squash, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = imageCommitValidateBeforeCall(container, repo, tag, comment, author, pause, changes, squash, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public class APIimageCommitRequest {
        private String container;
        private String repo;
        private String tag;
        private String comment;
        private String author;
        private Boolean pause;
        private String changes;
        private Boolean squash;

        private APIimageCommitRequest() {
        }

        /**
         * Set container
         * @param container the name or ID of a container (optional)
         * @return APIimageCommitRequest
         */
        public APIimageCommitRequest container(String container) {
            this.container = container;
            return this;
        }

        /**
         * Set repo
         * @param repo the repository name for the created image (optional)
         * @return APIimageCommitRequest
         */
        public APIimageCommitRequest repo(String repo) {
            this.repo = repo;
            return this;
        }

        /**
         * Set tag
         * @param tag tag name for the created image (optional)
         * @return APIimageCommitRequest
         */
        public APIimageCommitRequest tag(String tag) {
            this.tag = tag;
            return this;
        }

        /**
         * Set comment
         * @param comment commit message (optional)
         * @return APIimageCommitRequest
         */
        public APIimageCommitRequest comment(String comment) {
            this.comment = comment;
            return this;
        }

        /**
         * Set author
         * @param author author of the image (optional)
         * @return APIimageCommitRequest
         */
        public APIimageCommitRequest author(String author) {
            this.author = author;
            return this;
        }

        /**
         * Set pause
         * @param pause pause the container before committing it (optional)
         * @return APIimageCommitRequest
         */
        public APIimageCommitRequest pause(Boolean pause) {
            this.pause = pause;
            return this;
        }

        /**
         * Set changes
         * @param changes instructions to apply while committing in Dockerfile format (optional)
         * @return APIimageCommitRequest
         */
        public APIimageCommitRequest changes(String changes) {
            this.changes = changes;
            return this;
        }

        /**
         * Set squash
         * @param squash squash newly built layers into a single new layer (optional)
         * @return APIimageCommitRequest
         */
        public APIimageCommitRequest squash(Boolean squash) {
            this.squash = squash;
            return this;
        }

        /**
         * Build call for imageCommit
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 201 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such image </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return imageCommitCall(container, repo, tag, comment, author, pause, changes, squash, _callback);
        }

        /**
         * Execute imageCommit request
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 201 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such image </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public void execute() throws ApiException {
            imageCommitWithHttpInfo(container, repo, tag, comment, author, pause, changes, squash);
        }

        /**
         * Execute imageCommit request with HTTP info returned
         * @return ApiResponse&lt;Void&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 201 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such image </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return imageCommitWithHttpInfo(container, repo, tag, comment, author, pause, changes, squash);
        }

        /**
         * Execute imageCommit request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 201 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such image </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<Void> _callback) throws ApiException {
            return imageCommitAsync(container, repo, tag, comment, author, pause, changes, squash, _callback);
        }
    }

    /**
     * New Image
     * Create a new image from a container
     * @return APIimageCommitRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> no error </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No such image </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIimageCommitRequest imageCommit() {
        return new APIimageCommitRequest();
    }
    private okhttp3.Call putContainerArchiveCall(String name, String path, String noOverwriteDirNonDir, String copyUIDGID, String request, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = request;

        // create path and map variables
        String localVarPath = "/containers/{name}/archive"
            .replace("{" + "name" + "}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (path != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("path", path));
        }

        if (noOverwriteDirNonDir != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("noOverwriteDirNonDir", noOverwriteDirNonDir));
        }

        if (copyUIDGID != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("copyUIDGID", copyUIDGID));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json",
            "application/x-tar"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call putContainerArchiveValidateBeforeCall(String name, String path, String noOverwriteDirNonDir, String copyUIDGID, String request, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling putContainerArchive(Async)");
        }

        // verify the required parameter 'path' is set
        if (path == null) {
            throw new ApiException("Missing the required parameter 'path' when calling putContainerArchive(Async)");
        }

        return putContainerArchiveCall(name, path, noOverwriteDirNonDir, copyUIDGID, request, _callback);

    }


    private ApiResponse<Void> putContainerArchiveWithHttpInfo( @NotNull String name,  @NotNull String path, String noOverwriteDirNonDir, String copyUIDGID, String request) throws ApiException {
        okhttp3.Call localVarCall = putContainerArchiveValidateBeforeCall(name, path, noOverwriteDirNonDir, copyUIDGID, request, null);
        return localVarApiClient.execute(localVarCall);
    }

    private okhttp3.Call putContainerArchiveAsync(String name, String path, String noOverwriteDirNonDir, String copyUIDGID, String request, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = putContainerArchiveValidateBeforeCall(name, path, noOverwriteDirNonDir, copyUIDGID, request, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public class APIputContainerArchiveRequest {
        private final String name;
        private final String path;
        private String noOverwriteDirNonDir;
        private String copyUIDGID;
        private String request;

        private APIputContainerArchiveRequest(String name, String path) {
            this.name = name;
            this.path = path;
        }

        /**
         * Set noOverwriteDirNonDir
         * @param noOverwriteDirNonDir if unpacking the given content would cause an existing directory to be replaced with a non-directory and vice versa (1 or true) (optional)
         * @return APIputContainerArchiveRequest
         */
        public APIputContainerArchiveRequest noOverwriteDirNonDir(String noOverwriteDirNonDir) {
            this.noOverwriteDirNonDir = noOverwriteDirNonDir;
            return this;
        }

        /**
         * Set copyUIDGID
         * @param copyUIDGID copy UID/GID maps to the dest file or di (1 or true) (optional)
         * @return APIputContainerArchiveRequest
         */
        public APIputContainerArchiveRequest copyUIDGID(String copyUIDGID) {
            this.copyUIDGID = copyUIDGID;
            return this;
        }

        /**
         * Set request
         * @param request tarfile of files to copy into the container (optional)
         * @return APIputContainerArchiveRequest
         */
        public APIputContainerArchiveRequest request(String request) {
            this.request = request;
            return this;
        }

        /**
         * Build call for putContainerArchive
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 403 </td><td> the container rootfs is read-only </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return putContainerArchiveCall(name, path, noOverwriteDirNonDir, copyUIDGID, request, _callback);
        }

        /**
         * Execute putContainerArchive request
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 403 </td><td> the container rootfs is read-only </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public void execute() throws ApiException {
            putContainerArchiveWithHttpInfo(name, path, noOverwriteDirNonDir, copyUIDGID, request);
        }

        /**
         * Execute putContainerArchive request with HTTP info returned
         * @return ApiResponse&lt;Void&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 403 </td><td> the container rootfs is read-only </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return putContainerArchiveWithHttpInfo(name, path, noOverwriteDirNonDir, copyUIDGID, request);
        }

        /**
         * Execute putContainerArchive request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 403 </td><td> the container rootfs is read-only </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<Void> _callback) throws ApiException {
            return putContainerArchiveAsync(name, path, noOverwriteDirNonDir, copyUIDGID, request, _callback);
        }
    }

    /**
     * Put files into a container
     * Put a tar archive of files into a container
     * @param name container name or id (required)
     * @param path Path to a directory in the container to extract (required)
     * @return APIputContainerArchiveRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> no error </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> the container rootfs is read-only </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIputContainerArchiveRequest putContainerArchive(String name, String path) {
        return new APIputContainerArchiveRequest(name, path);
    }
}
