/*
 * supports a RESTful API for the Libpod library
 * This documentation describes the Podman v2.x+ RESTful API. It consists of a Docker-compatible API and a Libpod API providing support for Podman’s unique features such as pods.  To start the service and keep it running for 5,000 seconds (-t 0 runs forever):  podman system service -t 5000 &  You can then use cURL on the socket using requests documented below.  NOTE: if you install the package podman-docker, it will create a symbolic link for /run/docker.sock to /run/podman/podman.sock  NOTE: Some fields in the API response JSON are encoded as omitempty, which means that if said field has a zero value, they will not be encoded in the API response. This is a feature to help reduce the size of the JSON responses returned via the API.  NOTE: Due to the limitations of [go-swagger](https://github.com/go-swagger/go-swagger), some field values that have a complex type show up as null in the docs as well as in the API responses. This is because the zero value for the field type is null. The field description in the docs will state what type the field is expected to be for such cases.  See podman-system-service(1) for more information.  Quick Examples:  'podman info'  curl --unix-socket /run/podman/podman.sock http://d/v5.0.0/libpod/info  'podman pull quay.io/containers/podman'  curl -XPOST --unix-socket /run/podman/podman.sock -v 'http://d/v5.0.0/images/create?fromImage=quay.io%2Fcontainers%2Fpodman'  'podman list images'  curl --unix-socket /run/podman/podman.sock -v 'http://d/v5.0.0/libpod/images/json' | jq
 *
 * The version of the OpenAPI document: 5.0.0
 * Contact: podman@lists.podman.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.github.pod4dev.libpodj.api;

import io.github.pod4dev.libpodj.ApiCallback;
import io.github.pod4dev.libpodj.ApiClient;
import io.github.pod4dev.libpodj.ApiException;
import io.github.pod4dev.libpodj.ApiResponse;
import io.github.pod4dev.libpodj.Configuration;
import io.github.pod4dev.libpodj.Pair;
import io.github.pod4dev.libpodj.ProgressRequestBody;
import io.github.pod4dev.libpodj.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;

import javax.validation.constraints.*;

import io.github.pod4dev.libpodj.model.ContainerCreateResponse;
import io.github.pod4dev.libpodj.model.ContainerStats;
import io.github.pod4dev.libpodj.model.ContainerTopOKBody;
import io.github.pod4dev.libpodj.model.ContainersPruneReportLibpod;
import io.github.pod4dev.libpodj.model.ErrorModel;
import java.io.File;
import io.github.pod4dev.libpodj.model.HealthCheckResults;
import io.github.pod4dev.libpodj.model.InspectContainerData;
import io.github.pod4dev.libpodj.model.LibpodContainersRmReport;
import io.github.pod4dev.libpodj.model.ListContainer;
import io.github.pod4dev.libpodj.model.PlayKubeReport;
import io.github.pod4dev.libpodj.model.SpecGenerator;
import io.github.pod4dev.libpodj.model.UpdateEntities;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.GenericType;

public class ContainersApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ContainersApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ContainersApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private okhttp3.Call containerAttachLibpodCall(String name, String detachKeys, Boolean logs, Boolean stream, Boolean stdout, Boolean stderr, Boolean stdin, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/libpod/containers/{name}/attach"
            .replaceAll("\\{" + "name" + "\\}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (detachKeys != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("detachKeys", detachKeys));
        }

        if (logs != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("logs", logs));
        }

        if (stream != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("stream", stream));
        }

        if (stdout != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("stdout", stdout));
        }

        if (stderr != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("stderr", stderr));
        }

        if (stdin != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("stdin", stdin));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call containerAttachLibpodValidateBeforeCall(String name, String detachKeys, Boolean logs, Boolean stream, Boolean stdout, Boolean stderr, Boolean stdin, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling containerAttachLibpod(Async)");
        }
        

        okhttp3.Call localVarCall = containerAttachLibpodCall(name, detachKeys, logs, stream, stdout, stderr, stdin, _callback);
        return localVarCall;

    }


    private ApiResponse<Void> containerAttachLibpodWithHttpInfo( @NotNull String name, String detachKeys, Boolean logs, Boolean stream, Boolean stdout, Boolean stderr, Boolean stdin) throws ApiException {
        okhttp3.Call localVarCall = containerAttachLibpodValidateBeforeCall(name, detachKeys, logs, stream, stdout, stderr, stdin, null);
        return localVarApiClient.execute(localVarCall);
    }

    private okhttp3.Call containerAttachLibpodAsync(String name, String detachKeys, Boolean logs, Boolean stream, Boolean stdout, Boolean stderr, Boolean stdin, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = containerAttachLibpodValidateBeforeCall(name, detachKeys, logs, stream, stdout, stderr, stdin, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public class APIcontainerAttachLibpodRequest {
        private final String name;
        private String detachKeys;
        private Boolean logs;
        private Boolean stream;
        private Boolean stdout;
        private Boolean stderr;
        private Boolean stdin;

        private APIcontainerAttachLibpodRequest(String name) {
            this.name = name;
        }

        /**
         * Set detachKeys
         * @param detachKeys keys to use for detaching from the container (optional)
         * @return APIcontainerAttachLibpodRequest
         */
        public APIcontainerAttachLibpodRequest detachKeys(String detachKeys) {
            this.detachKeys = detachKeys;
            return this;
        }

        /**
         * Set logs
         * @param logs Stream all logs from the container across the connection. Happens before streaming attach (if requested). At least one of logs or stream must be set (optional)
         * @return APIcontainerAttachLibpodRequest
         */
        public APIcontainerAttachLibpodRequest logs(Boolean logs) {
            this.logs = logs;
            return this;
        }

        /**
         * Set stream
         * @param stream Attach to the container. If unset, and logs is set, only the container&#39;s logs will be sent. At least one of stream or logs must be set (optional, default to true)
         * @return APIcontainerAttachLibpodRequest
         */
        public APIcontainerAttachLibpodRequest stream(Boolean stream) {
            this.stream = stream;
            return this;
        }

        /**
         * Set stdout
         * @param stdout Attach to container STDOUT (optional)
         * @return APIcontainerAttachLibpodRequest
         */
        public APIcontainerAttachLibpodRequest stdout(Boolean stdout) {
            this.stdout = stdout;
            return this;
        }

        /**
         * Set stderr
         * @param stderr Attach to container STDERR (optional)
         * @return APIcontainerAttachLibpodRequest
         */
        public APIcontainerAttachLibpodRequest stderr(Boolean stderr) {
            this.stderr = stderr;
            return this;
        }

        /**
         * Set stdin
         * @param stdin Attach to container STDIN (optional)
         * @return APIcontainerAttachLibpodRequest
         */
        public APIcontainerAttachLibpodRequest stdin(Boolean stdin) {
            this.stdin = stdin;
            return this;
        }

        /**
         * Build call for containerAttachLibpod
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 101 </td><td> No error, connection has been hijacked for transporting streams. </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return containerAttachLibpodCall(name, detachKeys, logs, stream, stdout, stderr, stdin, _callback);
        }

        /**
         * Execute containerAttachLibpod request
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 101 </td><td> No error, connection has been hijacked for transporting streams. </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public void execute() throws ApiException {
            containerAttachLibpodWithHttpInfo(name, detachKeys, logs, stream, stdout, stderr, stdin);
        }

        /**
         * Execute containerAttachLibpod request with HTTP info returned
         * @return ApiResponse&lt;Void&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 101 </td><td> No error, connection has been hijacked for transporting streams. </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return containerAttachLibpodWithHttpInfo(name, detachKeys, logs, stream, stdout, stderr, stdin);
        }

        /**
         * Execute containerAttachLibpod request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 101 </td><td> No error, connection has been hijacked for transporting streams. </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<Void> _callback) throws ApiException {
            return containerAttachLibpodAsync(name, detachKeys, logs, stream, stdout, stderr, stdin, _callback);
        }
    }

    /**
     * Attach to a container
     * Attach to a container to read its output or send it input. You can attach to the same container multiple times and you can reattach to containers that have been detached.  ### Hijacking  This endpoint hijacks the HTTP connection to transport &#x60;stdin&#x60;, &#x60;stdout&#x60;, and &#x60;stderr&#x60; on the same socket.  This is the response from the service for an attach request:  &#x60;&#x60;&#x60; HTTP/1.1 200 OK Content-Type: application/vnd.docker.raw-stream  [STREAM] &#x60;&#x60;&#x60;  After the headers and two new lines, the TCP connection can now be used for raw, bidirectional communication between the client and server.  To inform potential proxies about connection hijacking, the client can also optionally send connection upgrade headers.  For example, the client sends this request to upgrade the connection:  &#x60;&#x60;&#x60; POST /v4.6.0/libpod/containers/16253994b7c4/attach?stream&#x3D;1&amp;stdout&#x3D;1 HTTP/1.1 Upgrade: tcp Connection: Upgrade &#x60;&#x60;&#x60;  The service will respond with a &#x60;101 UPGRADED&#x60; response, and will similarly follow with the raw stream:  &#x60;&#x60;&#x60; HTTP/1.1 101 UPGRADED Content-Type: application/vnd.docker.raw-stream Connection: Upgrade Upgrade: tcp  [STREAM] &#x60;&#x60;&#x60;  ### Stream format  When the TTY setting is disabled for the container, the HTTP Content-Type header is set to application/vnd.docker.multiplexed-stream (starting with v4.7.0, previously application/vnd.docker.raw-stream was always used) and the stream over the hijacked connected is multiplexed to separate out &#x60;stdout&#x60; and &#x60;stderr&#x60;. The stream consists of a series of frames, each containing a header and a payload.  The header contains the information about the output stream type and the size of the payload. It is encoded on the first eight bytes like this:  &#x60;&#x60;&#x60;go header :&#x3D; [8]byte{STREAM_TYPE, 0, 0, 0, SIZE1, SIZE2, SIZE3, SIZE4} &#x60;&#x60;&#x60;  &#x60;STREAM_TYPE&#x60; can be:  - 0: &#x60;stdin&#x60; (is written on &#x60;stdout&#x60;) - 1: &#x60;stdout&#x60; - 2: &#x60;stderr&#x60;  &#x60;SIZE1, SIZE2, SIZE3, SIZE4&#x60; are the four bytes of the &#x60;uint32&#x60; size encoded as big endian.  Following the header is the payload, which contains the specified number of bytes as written in the size.  The simplest way to implement this protocol is the following:  1. Read 8 bytes. 2. Choose &#x60;stdout&#x60; or &#x60;stderr&#x60; depending on the first byte. 3. Extract the frame size from the last four bytes. 4. Read the extracted size and output it on the correct output. 5. Goto 1.  ### Stream format when using a TTY  When the TTY setting is enabled for the container, the stream is not multiplexed. The data exchanged over the hijacked connection is simply the raw data from the process PTY and client&#39;s &#x60;stdin&#x60;. 
     * @param name the name or ID of the container (required)
     * @return APIcontainerAttachLibpodRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 101 </td><td> No error, connection has been hijacked for transporting streams. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIcontainerAttachLibpodRequest containerAttachLibpod(String name) {
        return new APIcontainerAttachLibpodRequest(name);
    }
    private okhttp3.Call containerChangesLibpodCall(String name, String parent, String diffType, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/libpod/containers/{name}/changes"
            .replaceAll("\\{" + "name" + "\\}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (parent != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("parent", parent));
        }

        if (diffType != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("diffType", diffType));
        }

        final String[] localVarAccepts = {
            "application/json", "application/octet-stream", "text/plain"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call containerChangesLibpodValidateBeforeCall(String name, String parent, String diffType, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling containerChangesLibpod(Async)");
        }
        

        okhttp3.Call localVarCall = containerChangesLibpodCall(name, parent, diffType, _callback);
        return localVarCall;

    }


    private ApiResponse<Void> containerChangesLibpodWithHttpInfo( @NotNull String name, String parent, String diffType) throws ApiException {
        okhttp3.Call localVarCall = containerChangesLibpodValidateBeforeCall(name, parent, diffType, null);
        return localVarApiClient.execute(localVarCall);
    }

    private okhttp3.Call containerChangesLibpodAsync(String name, String parent, String diffType, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = containerChangesLibpodValidateBeforeCall(name, parent, diffType, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public class APIcontainerChangesLibpodRequest {
        private final String name;
        private String parent;
        private String diffType;

        private APIcontainerChangesLibpodRequest(String name) {
            this.name = name;
        }

        /**
         * Set parent
         * @param parent specify a second layer which is used to compare against it instead of the parent layer (optional)
         * @return APIcontainerChangesLibpodRequest
         */
        public APIcontainerChangesLibpodRequest parent(String parent) {
            this.parent = parent;
            return this;
        }

        /**
         * Set diffType
         * @param diffType select what you want to match, default is all (optional)
         * @return APIcontainerChangesLibpodRequest
         */
        public APIcontainerChangesLibpodRequest diffType(String diffType) {
            this.diffType = diffType;
            return this;
        }

        /**
         * Build call for containerChangesLibpod
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Array of Changes </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return containerChangesLibpodCall(name, parent, diffType, _callback);
        }

        /**
         * Execute containerChangesLibpod request
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Array of Changes </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public void execute() throws ApiException {
            containerChangesLibpodWithHttpInfo(name, parent, diffType);
        }

        /**
         * Execute containerChangesLibpod request with HTTP info returned
         * @return ApiResponse&lt;Void&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Array of Changes </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return containerChangesLibpodWithHttpInfo(name, parent, diffType);
        }

        /**
         * Execute containerChangesLibpod request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Array of Changes </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<Void> _callback) throws ApiException {
            return containerChangesLibpodAsync(name, parent, diffType, _callback);
        }
    }

    /**
     * Report on changes to container&#39;s filesystem; adds, deletes or modifications.
     * Returns which files in a container&#39;s filesystem have been added, deleted, or modified. The Kind of modification can be one of:  0: Modified 1: Added 2: Deleted 
     * @param name the name or id of the container (required)
     * @return APIcontainerChangesLibpodRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Array of Changes </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIcontainerChangesLibpodRequest containerChangesLibpod(String name) {
        return new APIcontainerChangesLibpodRequest(name);
    }
    private okhttp3.Call containerCheckpointLibpodCall(String name, Boolean keep, Boolean leaveRunning, Boolean tcpEstablished, Boolean export, Boolean ignoreRootFS, Boolean ignoreVolumes, Boolean preCheckpoint, Boolean withPrevious, Boolean fileLocks, Boolean printStats, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/libpod/containers/{name}/checkpoint"
            .replaceAll("\\{" + "name" + "\\}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (keep != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("keep", keep));
        }

        if (leaveRunning != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("leaveRunning", leaveRunning));
        }

        if (tcpEstablished != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("tcpEstablished", tcpEstablished));
        }

        if (export != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("export", export));
        }

        if (ignoreRootFS != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("ignoreRootFS", ignoreRootFS));
        }

        if (ignoreVolumes != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("ignoreVolumes", ignoreVolumes));
        }

        if (preCheckpoint != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("preCheckpoint", preCheckpoint));
        }

        if (withPrevious != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("withPrevious", withPrevious));
        }

        if (fileLocks != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("fileLocks", fileLocks));
        }

        if (printStats != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("printStats", printStats));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call containerCheckpointLibpodValidateBeforeCall(String name, Boolean keep, Boolean leaveRunning, Boolean tcpEstablished, Boolean export, Boolean ignoreRootFS, Boolean ignoreVolumes, Boolean preCheckpoint, Boolean withPrevious, Boolean fileLocks, Boolean printStats, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling containerCheckpointLibpod(Async)");
        }
        

        okhttp3.Call localVarCall = containerCheckpointLibpodCall(name, keep, leaveRunning, tcpEstablished, export, ignoreRootFS, ignoreVolumes, preCheckpoint, withPrevious, fileLocks, printStats, _callback);
        return localVarCall;

    }


    private ApiResponse<Void> containerCheckpointLibpodWithHttpInfo( @NotNull String name, Boolean keep, Boolean leaveRunning, Boolean tcpEstablished, Boolean export, Boolean ignoreRootFS, Boolean ignoreVolumes, Boolean preCheckpoint, Boolean withPrevious, Boolean fileLocks, Boolean printStats) throws ApiException {
        okhttp3.Call localVarCall = containerCheckpointLibpodValidateBeforeCall(name, keep, leaveRunning, tcpEstablished, export, ignoreRootFS, ignoreVolumes, preCheckpoint, withPrevious, fileLocks, printStats, null);
        return localVarApiClient.execute(localVarCall);
    }

    private okhttp3.Call containerCheckpointLibpodAsync(String name, Boolean keep, Boolean leaveRunning, Boolean tcpEstablished, Boolean export, Boolean ignoreRootFS, Boolean ignoreVolumes, Boolean preCheckpoint, Boolean withPrevious, Boolean fileLocks, Boolean printStats, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = containerCheckpointLibpodValidateBeforeCall(name, keep, leaveRunning, tcpEstablished, export, ignoreRootFS, ignoreVolumes, preCheckpoint, withPrevious, fileLocks, printStats, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public class APIcontainerCheckpointLibpodRequest {
        private final String name;
        private Boolean keep;
        private Boolean leaveRunning;
        private Boolean tcpEstablished;
        private Boolean export;
        private Boolean ignoreRootFS;
        private Boolean ignoreVolumes;
        private Boolean preCheckpoint;
        private Boolean withPrevious;
        private Boolean fileLocks;
        private Boolean printStats;

        private APIcontainerCheckpointLibpodRequest(String name) {
            this.name = name;
        }

        /**
         * Set keep
         * @param keep keep all temporary checkpoint files (optional)
         * @return APIcontainerCheckpointLibpodRequest
         */
        public APIcontainerCheckpointLibpodRequest keep(Boolean keep) {
            this.keep = keep;
            return this;
        }

        /**
         * Set leaveRunning
         * @param leaveRunning leave the container running after writing checkpoint to disk (optional)
         * @return APIcontainerCheckpointLibpodRequest
         */
        public APIcontainerCheckpointLibpodRequest leaveRunning(Boolean leaveRunning) {
            this.leaveRunning = leaveRunning;
            return this;
        }

        /**
         * Set tcpEstablished
         * @param tcpEstablished checkpoint a container with established TCP connections (optional)
         * @return APIcontainerCheckpointLibpodRequest
         */
        public APIcontainerCheckpointLibpodRequest tcpEstablished(Boolean tcpEstablished) {
            this.tcpEstablished = tcpEstablished;
            return this;
        }

        /**
         * Set export
         * @param export export the checkpoint image to a tar.gz (optional)
         * @return APIcontainerCheckpointLibpodRequest
         */
        public APIcontainerCheckpointLibpodRequest export(Boolean export) {
            this.export = export;
            return this;
        }

        /**
         * Set ignoreRootFS
         * @param ignoreRootFS do not include root file-system changes when exporting. can only be used with export (optional)
         * @return APIcontainerCheckpointLibpodRequest
         */
        public APIcontainerCheckpointLibpodRequest ignoreRootFS(Boolean ignoreRootFS) {
            this.ignoreRootFS = ignoreRootFS;
            return this;
        }

        /**
         * Set ignoreVolumes
         * @param ignoreVolumes do not include associated volumes. can only be used with export (optional)
         * @return APIcontainerCheckpointLibpodRequest
         */
        public APIcontainerCheckpointLibpodRequest ignoreVolumes(Boolean ignoreVolumes) {
            this.ignoreVolumes = ignoreVolumes;
            return this;
        }

        /**
         * Set preCheckpoint
         * @param preCheckpoint dump the container&#39;s memory information only, leaving the container running. only works on runc 1.0-rc or higher (optional)
         * @return APIcontainerCheckpointLibpodRequest
         */
        public APIcontainerCheckpointLibpodRequest preCheckpoint(Boolean preCheckpoint) {
            this.preCheckpoint = preCheckpoint;
            return this;
        }

        /**
         * Set withPrevious
         * @param withPrevious check out the container with previous criu image files in pre-dump. only works on runc 1.0-rc or higher (optional)
         * @return APIcontainerCheckpointLibpodRequest
         */
        public APIcontainerCheckpointLibpodRequest withPrevious(Boolean withPrevious) {
            this.withPrevious = withPrevious;
            return this;
        }

        /**
         * Set fileLocks
         * @param fileLocks checkpoint a container with filelocks (optional)
         * @return APIcontainerCheckpointLibpodRequest
         */
        public APIcontainerCheckpointLibpodRequest fileLocks(Boolean fileLocks) {
            this.fileLocks = fileLocks;
            return this;
        }

        /**
         * Set printStats
         * @param printStats add checkpoint statistics to the returned CheckpointReport (optional)
         * @return APIcontainerCheckpointLibpodRequest
         */
        public APIcontainerCheckpointLibpodRequest printStats(Boolean printStats) {
            this.printStats = printStats;
            return this;
        }

        /**
         * Build call for containerCheckpointLibpod
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> tarball is returned in body if exported </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return containerCheckpointLibpodCall(name, keep, leaveRunning, tcpEstablished, export, ignoreRootFS, ignoreVolumes, preCheckpoint, withPrevious, fileLocks, printStats, _callback);
        }

        /**
         * Execute containerCheckpointLibpod request
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> tarball is returned in body if exported </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public void execute() throws ApiException {
            containerCheckpointLibpodWithHttpInfo(name, keep, leaveRunning, tcpEstablished, export, ignoreRootFS, ignoreVolumes, preCheckpoint, withPrevious, fileLocks, printStats);
        }

        /**
         * Execute containerCheckpointLibpod request with HTTP info returned
         * @return ApiResponse&lt;Void&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> tarball is returned in body if exported </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return containerCheckpointLibpodWithHttpInfo(name, keep, leaveRunning, tcpEstablished, export, ignoreRootFS, ignoreVolumes, preCheckpoint, withPrevious, fileLocks, printStats);
        }

        /**
         * Execute containerCheckpointLibpod request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> tarball is returned in body if exported </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<Void> _callback) throws ApiException {
            return containerCheckpointLibpodAsync(name, keep, leaveRunning, tcpEstablished, export, ignoreRootFS, ignoreVolumes, preCheckpoint, withPrevious, fileLocks, printStats, _callback);
        }
    }

    /**
     * Checkpoint a container
     * 
     * @param name the name or ID of the container (required)
     * @return APIcontainerCheckpointLibpodRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> tarball is returned in body if exported </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIcontainerCheckpointLibpodRequest containerCheckpointLibpod(String name) {
        return new APIcontainerCheckpointLibpodRequest(name);
    }
    private okhttp3.Call containerCreateLibpodCall(SpecGenerator create, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = create;

        // create path and map variables
        String localVarPath = "/libpod/containers/create";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json", "application/x-tar"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call containerCreateLibpodValidateBeforeCall(SpecGenerator create, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'create' is set
        if (create == null) {
            throw new ApiException("Missing the required parameter 'create' when calling containerCreateLibpod(Async)");
        }
        

        okhttp3.Call localVarCall = containerCreateLibpodCall(create, _callback);
        return localVarCall;

    }


    private ApiResponse<ContainerCreateResponse> containerCreateLibpodWithHttpInfo( @NotNull SpecGenerator create) throws ApiException {
        okhttp3.Call localVarCall = containerCreateLibpodValidateBeforeCall(create, null);
        Type localVarReturnType = new TypeToken<ContainerCreateResponse>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call containerCreateLibpodAsync(SpecGenerator create, final ApiCallback<ContainerCreateResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = containerCreateLibpodValidateBeforeCall(create, _callback);
        Type localVarReturnType = new TypeToken<ContainerCreateResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIcontainerCreateLibpodRequest {
        private final SpecGenerator create;

        private APIcontainerCreateLibpodRequest(SpecGenerator create) {
            this.create = create;
        }

        /**
         * Build call for containerCreateLibpod
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 201 </td><td> Create container </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> Conflict error in operation </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return containerCreateLibpodCall(create, _callback);
        }

        /**
         * Execute containerCreateLibpod request
         * @return ContainerCreateResponse
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 201 </td><td> Create container </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> Conflict error in operation </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ContainerCreateResponse execute() throws ApiException {
            ApiResponse<ContainerCreateResponse> localVarResp = containerCreateLibpodWithHttpInfo(create);
            return localVarResp.getData();
        }

        /**
         * Execute containerCreateLibpod request with HTTP info returned
         * @return ApiResponse&lt;ContainerCreateResponse&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 201 </td><td> Create container </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> Conflict error in operation </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<ContainerCreateResponse> executeWithHttpInfo() throws ApiException {
            return containerCreateLibpodWithHttpInfo(create);
        }

        /**
         * Execute containerCreateLibpod request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 201 </td><td> Create container </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> Conflict error in operation </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<ContainerCreateResponse> _callback) throws ApiException {
            return containerCreateLibpodAsync(create, _callback);
        }
    }

    /**
     * Create a container
     * 
     * @param create attributes for creating a container (required)
     * @return APIcontainerCreateLibpodRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Create container </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> Conflict error in operation </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIcontainerCreateLibpodRequest containerCreateLibpod(SpecGenerator create) {
        return new APIcontainerCreateLibpodRequest(create);
    }
    private okhttp3.Call containerDeleteLibpodCall(String name, Boolean depend, Boolean force, Boolean ignore, Integer timeout, Boolean v, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/libpod/containers/{name}"
            .replaceAll("\\{" + "name" + "\\}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (depend != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("depend", depend));
        }

        if (force != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("force", force));
        }

        if (ignore != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("ignore", ignore));
        }

        if (timeout != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("timeout", timeout));
        }

        if (v != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("v", v));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call containerDeleteLibpodValidateBeforeCall(String name, Boolean depend, Boolean force, Boolean ignore, Integer timeout, Boolean v, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling containerDeleteLibpod(Async)");
        }
        

        okhttp3.Call localVarCall = containerDeleteLibpodCall(name, depend, force, ignore, timeout, v, _callback);
        return localVarCall;

    }


    private ApiResponse<List<LibpodContainersRmReport>> containerDeleteLibpodWithHttpInfo( @NotNull String name, Boolean depend, Boolean force, Boolean ignore, Integer timeout, Boolean v) throws ApiException {
        okhttp3.Call localVarCall = containerDeleteLibpodValidateBeforeCall(name, depend, force, ignore, timeout, v, null);
        Type localVarReturnType = new TypeToken<List<LibpodContainersRmReport>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call containerDeleteLibpodAsync(String name, Boolean depend, Boolean force, Boolean ignore, Integer timeout, Boolean v, final ApiCallback<List<LibpodContainersRmReport>> _callback) throws ApiException {

        okhttp3.Call localVarCall = containerDeleteLibpodValidateBeforeCall(name, depend, force, ignore, timeout, v, _callback);
        Type localVarReturnType = new TypeToken<List<LibpodContainersRmReport>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIcontainerDeleteLibpodRequest {
        private final String name;
        private Boolean depend;
        private Boolean force;
        private Boolean ignore;
        private Integer timeout;
        private Boolean v;

        private APIcontainerDeleteLibpodRequest(String name) {
            this.name = name;
        }

        /**
         * Set depend
         * @param depend additionally remove containers that depend on the container to be removed (optional)
         * @return APIcontainerDeleteLibpodRequest
         */
        public APIcontainerDeleteLibpodRequest depend(Boolean depend) {
            this.depend = depend;
            return this;
        }

        /**
         * Set force
         * @param force force stop container if running (optional)
         * @return APIcontainerDeleteLibpodRequest
         */
        public APIcontainerDeleteLibpodRequest force(Boolean force) {
            this.force = force;
            return this;
        }

        /**
         * Set ignore
         * @param ignore ignore errors when the container to be removed does not existxo (optional)
         * @return APIcontainerDeleteLibpodRequest
         */
        public APIcontainerDeleteLibpodRequest ignore(Boolean ignore) {
            this.ignore = ignore;
            return this;
        }

        /**
         * Set timeout
         * @param timeout number of seconds to wait before killing container when force removing (optional, default to 10)
         * @return APIcontainerDeleteLibpodRequest
         */
        public APIcontainerDeleteLibpodRequest timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        /**
         * Set v
         * @param v delete volumes (optional)
         * @return APIcontainerDeleteLibpodRequest
         */
        public APIcontainerDeleteLibpodRequest v(Boolean v) {
            this.v = v;
            return this;
        }

        /**
         * Build call for containerDeleteLibpod
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Remove Containers </td><td>  -  </td></tr>
            <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> Conflict error in operation </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return containerDeleteLibpodCall(name, depend, force, ignore, timeout, v, _callback);
        }

        /**
         * Execute containerDeleteLibpod request
         * @return List&lt;LibpodContainersRmReport&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Remove Containers </td><td>  -  </td></tr>
            <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> Conflict error in operation </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public List<LibpodContainersRmReport> execute() throws ApiException {
            ApiResponse<List<LibpodContainersRmReport>> localVarResp = containerDeleteLibpodWithHttpInfo(name, depend, force, ignore, timeout, v);
            return localVarResp.getData();
        }

        /**
         * Execute containerDeleteLibpod request with HTTP info returned
         * @return ApiResponse&lt;List&lt;LibpodContainersRmReport&gt;&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Remove Containers </td><td>  -  </td></tr>
            <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> Conflict error in operation </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<List<LibpodContainersRmReport>> executeWithHttpInfo() throws ApiException {
            return containerDeleteLibpodWithHttpInfo(name, depend, force, ignore, timeout, v);
        }

        /**
         * Execute containerDeleteLibpod request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Remove Containers </td><td>  -  </td></tr>
            <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> Conflict error in operation </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<List<LibpodContainersRmReport>> _callback) throws ApiException {
            return containerDeleteLibpodAsync(name, depend, force, ignore, timeout, v, _callback);
        }
    }

    /**
     * Delete container
     * Delete container
     * @param name the name or ID of the container (required)
     * @return APIcontainerDeleteLibpodRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Remove Containers </td><td>  -  </td></tr>
        <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> Conflict error in operation </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIcontainerDeleteLibpodRequest containerDeleteLibpod(String name) {
        return new APIcontainerDeleteLibpodRequest(name);
    }
    private okhttp3.Call containerExistsLibpodCall(String name, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/libpod/containers/{name}/exists"
            .replaceAll("\\{" + "name" + "\\}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call containerExistsLibpodValidateBeforeCall(String name, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling containerExistsLibpod(Async)");
        }
        

        okhttp3.Call localVarCall = containerExistsLibpodCall(name, _callback);
        return localVarCall;

    }


    private ApiResponse<Void> containerExistsLibpodWithHttpInfo( @NotNull String name) throws ApiException {
        okhttp3.Call localVarCall = containerExistsLibpodValidateBeforeCall(name, null);
        return localVarApiClient.execute(localVarCall);
    }

    private okhttp3.Call containerExistsLibpodAsync(String name, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = containerExistsLibpodValidateBeforeCall(name, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public class APIcontainerExistsLibpodRequest {
        private final String name;

        private APIcontainerExistsLibpodRequest(String name) {
            this.name = name;
        }

        /**
         * Build call for containerExistsLibpod
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> container exists </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return containerExistsLibpodCall(name, _callback);
        }

        /**
         * Execute containerExistsLibpod request
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> container exists </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public void execute() throws ApiException {
            containerExistsLibpodWithHttpInfo(name);
        }

        /**
         * Execute containerExistsLibpod request with HTTP info returned
         * @return ApiResponse&lt;Void&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> container exists </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return containerExistsLibpodWithHttpInfo(name);
        }

        /**
         * Execute containerExistsLibpod request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> container exists </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<Void> _callback) throws ApiException {
            return containerExistsLibpodAsync(name, _callback);
        }
    }

    /**
     * Check if container exists
     * Quick way to determine if a container exists by name or ID
     * @param name the name or ID of the container (required)
     * @return APIcontainerExistsLibpodRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> container exists </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIcontainerExistsLibpodRequest containerExistsLibpod(String name) {
        return new APIcontainerExistsLibpodRequest(name);
    }
    private okhttp3.Call containerExportLibpodCall(String name, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/libpod/containers/{name}/export"
            .replaceAll("\\{" + "name" + "\\}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call containerExportLibpodValidateBeforeCall(String name, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling containerExportLibpod(Async)");
        }
        

        okhttp3.Call localVarCall = containerExportLibpodCall(name, _callback);
        return localVarCall;

    }


    private ApiResponse<Void> containerExportLibpodWithHttpInfo( @NotNull String name) throws ApiException {
        okhttp3.Call localVarCall = containerExportLibpodValidateBeforeCall(name, null);
        return localVarApiClient.execute(localVarCall);
    }

    private okhttp3.Call containerExportLibpodAsync(String name, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = containerExportLibpodValidateBeforeCall(name, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public class APIcontainerExportLibpodRequest {
        private final String name;

        private APIcontainerExportLibpodRequest(String name) {
            this.name = name;
        }

        /**
         * Build call for containerExportLibpod
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> tarball is returned in body </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return containerExportLibpodCall(name, _callback);
        }

        /**
         * Execute containerExportLibpod request
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> tarball is returned in body </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public void execute() throws ApiException {
            containerExportLibpodWithHttpInfo(name);
        }

        /**
         * Execute containerExportLibpod request with HTTP info returned
         * @return ApiResponse&lt;Void&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> tarball is returned in body </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return containerExportLibpodWithHttpInfo(name);
        }

        /**
         * Execute containerExportLibpod request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> tarball is returned in body </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<Void> _callback) throws ApiException {
            return containerExportLibpodAsync(name, _callback);
        }
    }

    /**
     * Export a container
     * Export the contents of a container as a tarball.
     * @param name the name or ID of the container (required)
     * @return APIcontainerExportLibpodRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> tarball is returned in body </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIcontainerExportLibpodRequest containerExportLibpod(String name) {
        return new APIcontainerExportLibpodRequest(name);
    }
    private okhttp3.Call containerHealthcheckLibpodCall(String name, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/libpod/containers/{name}/healthcheck"
            .replaceAll("\\{" + "name" + "\\}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call containerHealthcheckLibpodValidateBeforeCall(String name, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling containerHealthcheckLibpod(Async)");
        }
        

        okhttp3.Call localVarCall = containerHealthcheckLibpodCall(name, _callback);
        return localVarCall;

    }


    private ApiResponse<HealthCheckResults> containerHealthcheckLibpodWithHttpInfo( @NotNull String name) throws ApiException {
        okhttp3.Call localVarCall = containerHealthcheckLibpodValidateBeforeCall(name, null);
        Type localVarReturnType = new TypeToken<HealthCheckResults>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call containerHealthcheckLibpodAsync(String name, final ApiCallback<HealthCheckResults> _callback) throws ApiException {

        okhttp3.Call localVarCall = containerHealthcheckLibpodValidateBeforeCall(name, _callback);
        Type localVarReturnType = new TypeToken<HealthCheckResults>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIcontainerHealthcheckLibpodRequest {
        private final String name;

        private APIcontainerHealthcheckLibpodRequest(String name) {
            this.name = name;
        }

        /**
         * Build call for containerHealthcheckLibpod
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Healthcheck Results </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> container has no healthcheck or is not running </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return containerHealthcheckLibpodCall(name, _callback);
        }

        /**
         * Execute containerHealthcheckLibpod request
         * @return HealthCheckResults
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Healthcheck Results </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> container has no healthcheck or is not running </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public HealthCheckResults execute() throws ApiException {
            ApiResponse<HealthCheckResults> localVarResp = containerHealthcheckLibpodWithHttpInfo(name);
            return localVarResp.getData();
        }

        /**
         * Execute containerHealthcheckLibpod request with HTTP info returned
         * @return ApiResponse&lt;HealthCheckResults&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Healthcheck Results </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> container has no healthcheck or is not running </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<HealthCheckResults> executeWithHttpInfo() throws ApiException {
            return containerHealthcheckLibpodWithHttpInfo(name);
        }

        /**
         * Execute containerHealthcheckLibpod request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Healthcheck Results </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> container has no healthcheck or is not running </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<HealthCheckResults> _callback) throws ApiException {
            return containerHealthcheckLibpodAsync(name, _callback);
        }
    }

    /**
     * Run a container&#39;s healthcheck
     * Execute the defined healthcheck and return information about the results
     * @param name the name or ID of the container (required)
     * @return APIcontainerHealthcheckLibpodRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Healthcheck Results </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> container has no healthcheck or is not running </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIcontainerHealthcheckLibpodRequest containerHealthcheckLibpod(String name) {
        return new APIcontainerHealthcheckLibpodRequest(name);
    }
    private okhttp3.Call containerInitLibpodCall(String name, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/libpod/containers/{name}/init"
            .replaceAll("\\{" + "name" + "\\}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call containerInitLibpodValidateBeforeCall(String name, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling containerInitLibpod(Async)");
        }
        

        okhttp3.Call localVarCall = containerInitLibpodCall(name, _callback);
        return localVarCall;

    }


    private ApiResponse<Void> containerInitLibpodWithHttpInfo( @NotNull String name) throws ApiException {
        okhttp3.Call localVarCall = containerInitLibpodValidateBeforeCall(name, null);
        return localVarApiClient.execute(localVarCall);
    }

    private okhttp3.Call containerInitLibpodAsync(String name, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = containerInitLibpodValidateBeforeCall(name, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public class APIcontainerInitLibpodRequest {
        private final String name;

        private APIcontainerInitLibpodRequest(String name) {
            this.name = name;
        }

        /**
         * Build call for containerInitLibpod
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 304 </td><td> container already initialized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return containerInitLibpodCall(name, _callback);
        }

        /**
         * Execute containerInitLibpod request
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 304 </td><td> container already initialized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public void execute() throws ApiException {
            containerInitLibpodWithHttpInfo(name);
        }

        /**
         * Execute containerInitLibpod request with HTTP info returned
         * @return ApiResponse&lt;Void&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 304 </td><td> container already initialized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return containerInitLibpodWithHttpInfo(name);
        }

        /**
         * Execute containerInitLibpod request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 304 </td><td> container already initialized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<Void> _callback) throws ApiException {
            return containerInitLibpodAsync(name, _callback);
        }
    }

    /**
     * Initialize a container
     * Performs all tasks necessary for initializing the container but does not start the container.
     * @param name the name or ID of the container (required)
     * @return APIcontainerInitLibpodRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
        <tr><td> 304 </td><td> container already initialized </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIcontainerInitLibpodRequest containerInitLibpod(String name) {
        return new APIcontainerInitLibpodRequest(name);
    }
    private okhttp3.Call containerInspectLibpodCall(String name, Boolean size, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/libpod/containers/{name}/json"
            .replaceAll("\\{" + "name" + "\\}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (size != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("size", size));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call containerInspectLibpodValidateBeforeCall(String name, Boolean size, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling containerInspectLibpod(Async)");
        }
        

        okhttp3.Call localVarCall = containerInspectLibpodCall(name, size, _callback);
        return localVarCall;

    }


    private ApiResponse<InspectContainerData> containerInspectLibpodWithHttpInfo( @NotNull String name, Boolean size) throws ApiException {
        okhttp3.Call localVarCall = containerInspectLibpodValidateBeforeCall(name, size, null);
        Type localVarReturnType = new TypeToken<InspectContainerData>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call containerInspectLibpodAsync(String name, Boolean size, final ApiCallback<InspectContainerData> _callback) throws ApiException {

        okhttp3.Call localVarCall = containerInspectLibpodValidateBeforeCall(name, size, _callback);
        Type localVarReturnType = new TypeToken<InspectContainerData>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIcontainerInspectLibpodRequest {
        private final String name;
        private Boolean size;

        private APIcontainerInspectLibpodRequest(String name) {
            this.name = name;
        }

        /**
         * Set size
         * @param size display filesystem usage (optional)
         * @return APIcontainerInspectLibpodRequest
         */
        public APIcontainerInspectLibpodRequest size(Boolean size) {
            this.size = size;
            return this;
        }

        /**
         * Build call for containerInspectLibpod
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Inspect container </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return containerInspectLibpodCall(name, size, _callback);
        }

        /**
         * Execute containerInspectLibpod request
         * @return InspectContainerData
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Inspect container </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public InspectContainerData execute() throws ApiException {
            ApiResponse<InspectContainerData> localVarResp = containerInspectLibpodWithHttpInfo(name, size);
            return localVarResp.getData();
        }

        /**
         * Execute containerInspectLibpod request with HTTP info returned
         * @return ApiResponse&lt;InspectContainerData&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Inspect container </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<InspectContainerData> executeWithHttpInfo() throws ApiException {
            return containerInspectLibpodWithHttpInfo(name, size);
        }

        /**
         * Execute containerInspectLibpod request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Inspect container </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<InspectContainerData> _callback) throws ApiException {
            return containerInspectLibpodAsync(name, size, _callback);
        }
    }

    /**
     * Inspect container
     * Return low-level information about a container.
     * @param name the name or ID of the container (required)
     * @return APIcontainerInspectLibpodRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Inspect container </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIcontainerInspectLibpodRequest containerInspectLibpod(String name) {
        return new APIcontainerInspectLibpodRequest(name);
    }
    private okhttp3.Call containerKillLibpodCall(String name, String signal, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/libpod/containers/{name}/kill"
            .replaceAll("\\{" + "name" + "\\}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (signal != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("signal", signal));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call containerKillLibpodValidateBeforeCall(String name, String signal, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling containerKillLibpod(Async)");
        }
        

        okhttp3.Call localVarCall = containerKillLibpodCall(name, signal, _callback);
        return localVarCall;

    }


    private ApiResponse<Void> containerKillLibpodWithHttpInfo( @NotNull String name, String signal) throws ApiException {
        okhttp3.Call localVarCall = containerKillLibpodValidateBeforeCall(name, signal, null);
        return localVarApiClient.execute(localVarCall);
    }

    private okhttp3.Call containerKillLibpodAsync(String name, String signal, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = containerKillLibpodValidateBeforeCall(name, signal, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public class APIcontainerKillLibpodRequest {
        private final String name;
        private String signal;

        private APIcontainerKillLibpodRequest(String name) {
            this.name = name;
        }

        /**
         * Set signal
         * @param signal signal to be sent to container, either by integer or SIG_ name (optional, default to SIGKILL)
         * @return APIcontainerKillLibpodRequest
         */
        public APIcontainerKillLibpodRequest signal(String signal) {
            this.signal = signal;
            return this;
        }

        /**
         * Build call for containerKillLibpod
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> Conflict error in operation </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return containerKillLibpodCall(name, signal, _callback);
        }

        /**
         * Execute containerKillLibpod request
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> Conflict error in operation </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public void execute() throws ApiException {
            containerKillLibpodWithHttpInfo(name, signal);
        }

        /**
         * Execute containerKillLibpod request with HTTP info returned
         * @return ApiResponse&lt;Void&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> Conflict error in operation </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return containerKillLibpodWithHttpInfo(name, signal);
        }

        /**
         * Execute containerKillLibpod request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> Conflict error in operation </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<Void> _callback) throws ApiException {
            return containerKillLibpodAsync(name, signal, _callback);
        }
    }

    /**
     * Kill container
     * send a signal to a container, defaults to killing the container
     * @param name the name or ID of the container (required)
     * @return APIcontainerKillLibpodRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> Conflict error in operation </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIcontainerKillLibpodRequest containerKillLibpod(String name) {
        return new APIcontainerKillLibpodRequest(name);
    }
    private okhttp3.Call containerListLibpodCall(Boolean all, Integer limit, Boolean namespace, Boolean pod, Boolean size, Boolean sync, String filters, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/libpod/containers/json";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (all != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("all", all));
        }

        if (limit != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("limit", limit));
        }

        if (namespace != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("namespace", namespace));
        }

        if (pod != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("pod", pod));
        }

        if (size != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("size", size));
        }

        if (sync != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sync", sync));
        }

        if (filters != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("filters", filters));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call containerListLibpodValidateBeforeCall(Boolean all, Integer limit, Boolean namespace, Boolean pod, Boolean size, Boolean sync, String filters, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = containerListLibpodCall(all, limit, namespace, pod, size, sync, filters, _callback);
        return localVarCall;

    }


    private ApiResponse<List<ListContainer>> containerListLibpodWithHttpInfo(Boolean all, Integer limit, Boolean namespace, Boolean pod, Boolean size, Boolean sync, String filters) throws ApiException {
        okhttp3.Call localVarCall = containerListLibpodValidateBeforeCall(all, limit, namespace, pod, size, sync, filters, null);
        Type localVarReturnType = new TypeToken<List<ListContainer>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call containerListLibpodAsync(Boolean all, Integer limit, Boolean namespace, Boolean pod, Boolean size, Boolean sync, String filters, final ApiCallback<List<ListContainer>> _callback) throws ApiException {

        okhttp3.Call localVarCall = containerListLibpodValidateBeforeCall(all, limit, namespace, pod, size, sync, filters, _callback);
        Type localVarReturnType = new TypeToken<List<ListContainer>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIcontainerListLibpodRequest {
        private Boolean all;
        private Integer limit;
        private Boolean namespace;
        private Boolean pod;
        private Boolean size;
        private Boolean sync;
        private String filters;

        private APIcontainerListLibpodRequest() {
        }

        /**
         * Set all
         * @param all Return all containers. By default, only running containers are shown (optional, default to false)
         * @return APIcontainerListLibpodRequest
         */
        public APIcontainerListLibpodRequest all(Boolean all) {
            this.all = all;
            return this;
        }

        /**
         * Set limit
         * @param limit Return this number of most recently created containers, including non-running ones. (optional)
         * @return APIcontainerListLibpodRequest
         */
        public APIcontainerListLibpodRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        /**
         * Set namespace
         * @param namespace Include namespace information (optional, default to false)
         * @return APIcontainerListLibpodRequest
         */
        public APIcontainerListLibpodRequest namespace(Boolean namespace) {
            this.namespace = namespace;
            return this;
        }

        /**
         * Set pod
         * @param pod Ignored. Previously included details on pod name and ID that are currently included by default. (optional, default to false)
         * @return APIcontainerListLibpodRequest
         */
        public APIcontainerListLibpodRequest pod(Boolean pod) {
            this.pod = pod;
            return this;
        }

        /**
         * Set size
         * @param size Return the size of container as fields SizeRw and SizeRootFs. (optional, default to false)
         * @return APIcontainerListLibpodRequest
         */
        public APIcontainerListLibpodRequest size(Boolean size) {
            this.size = size;
            return this;
        }

        /**
         * Set sync
         * @param sync Sync container state with OCI runtime (optional, default to false)
         * @return APIcontainerListLibpodRequest
         */
        public APIcontainerListLibpodRequest sync(Boolean sync) {
            this.sync = sync;
            return this;
        }

        /**
         * Set filters
         * @param filters A JSON encoded value of the filters (a &#x60;map[string][]string&#x60;) to process on the containers list. Available filters: - &#x60;ancestor&#x60;&#x3D;(&#x60;&lt;image-name&gt;[:&lt;tag&gt;]&#x60;, &#x60;&lt;image id&gt;&#x60;, or &#x60;&lt;image@digest&gt;&#x60;) - &#x60;before&#x60;&#x3D;(&#x60;&lt;container id&gt;&#x60; or &#x60;&lt;container name&gt;&#x60;) - &#x60;expose&#x60;&#x3D;(&#x60;&lt;port&gt;[/&lt;proto&gt;]&#x60; or &#x60;&lt;startport-endport&gt;/[&lt;proto&gt;]&#x60;) - &#x60;exited&#x3D;&lt;int&gt;&#x60; containers with exit code of &#x60;&lt;int&gt;&#x60; - &#x60;health&#x60;&#x3D;(&#x60;starting&#x60;, &#x60;healthy&#x60;, &#x60;unhealthy&#x60; or &#x60;none&#x60;) - &#x60;id&#x3D;&lt;ID&gt;&#x60; a container&#39;s ID - &#x60;is-task&#x60;&#x3D;(&#x60;true&#x60; or &#x60;false&#x60;) - &#x60;label&#x60;&#x3D;(&#x60;key&#x60; or &#x60;\&quot;key&#x3D;value\&quot;&#x60;) of a container label - &#x60;name&#x3D;&lt;name&gt;&#x60; a container&#39;s name - &#x60;network&#x60;&#x3D;(&#x60;&lt;network id&gt;&#x60; or &#x60;&lt;network name&gt;&#x60;) - &#x60;pod&#x60;&#x3D;(&#x60;&lt;pod id&gt;&#x60; or &#x60;&lt;pod name&gt;&#x60;) - &#x60;publish&#x60;&#x3D;(&#x60;&lt;port&gt;[/&lt;proto&gt;]&#x60; or &#x60;&lt;startport-endport&gt;/[&lt;proto&gt;]&#x60;) - &#x60;since&#x60;&#x3D;(&#x60;&lt;container id&gt;&#x60; or &#x60;&lt;container name&gt;&#x60;) - &#x60;status&#x60;&#x3D;(&#x60;created&#x60;, &#x60;restarting&#x60;, &#x60;running&#x60;, &#x60;removing&#x60;, &#x60;paused&#x60;, &#x60;exited&#x60; or &#x60;dead&#x60;) - &#x60;volume&#x60;&#x3D;(&#x60;&lt;volume name&gt;&#x60; or &#x60;&lt;mount point destination&gt;&#x60;)  (optional)
         * @return APIcontainerListLibpodRequest
         */
        public APIcontainerListLibpodRequest filters(String filters) {
            this.filters = filters;
            return this;
        }

        /**
         * Build call for containerListLibpod
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List Containers </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return containerListLibpodCall(all, limit, namespace, pod, size, sync, filters, _callback);
        }

        /**
         * Execute containerListLibpod request
         * @return List&lt;ListContainer&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List Containers </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public List<ListContainer> execute() throws ApiException {
            ApiResponse<List<ListContainer>> localVarResp = containerListLibpodWithHttpInfo(all, limit, namespace, pod, size, sync, filters);
            return localVarResp.getData();
        }

        /**
         * Execute containerListLibpod request with HTTP info returned
         * @return ApiResponse&lt;List&lt;ListContainer&gt;&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List Containers </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<List<ListContainer>> executeWithHttpInfo() throws ApiException {
            return containerListLibpodWithHttpInfo(all, limit, namespace, pod, size, sync, filters);
        }

        /**
         * Execute containerListLibpod request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List Containers </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<List<ListContainer>> _callback) throws ApiException {
            return containerListLibpodAsync(all, limit, namespace, pod, size, sync, filters, _callback);
        }
    }

    /**
     * List containers
     * Returns a list of containers
     * @return APIcontainerListLibpodRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List Containers </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIcontainerListLibpodRequest containerListLibpod() {
        return new APIcontainerListLibpodRequest();
    }
    private okhttp3.Call containerLogsLibpodCall(String name, Boolean follow, Boolean stdout, Boolean stderr, String since, String until, Boolean timestamps, String tail, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/libpod/containers/{name}/logs"
            .replaceAll("\\{" + "name" + "\\}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (follow != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("follow", follow));
        }

        if (stdout != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("stdout", stdout));
        }

        if (stderr != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("stderr", stderr));
        }

        if (since != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("since", since));
        }

        if (until != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("until", until));
        }

        if (timestamps != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("timestamps", timestamps));
        }

        if (tail != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("tail", tail));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call containerLogsLibpodValidateBeforeCall(String name, Boolean follow, Boolean stdout, Boolean stderr, String since, String until, Boolean timestamps, String tail, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling containerLogsLibpod(Async)");
        }
        

        okhttp3.Call localVarCall = containerLogsLibpodCall(name, follow, stdout, stderr, since, until, timestamps, tail, _callback);
        return localVarCall;

    }


    private ApiResponse<Void> containerLogsLibpodWithHttpInfo( @NotNull String name, Boolean follow, Boolean stdout, Boolean stderr, String since, String until, Boolean timestamps, String tail) throws ApiException {
        okhttp3.Call localVarCall = containerLogsLibpodValidateBeforeCall(name, follow, stdout, stderr, since, until, timestamps, tail, null);
        return localVarApiClient.execute(localVarCall);
    }

    private okhttp3.Call containerLogsLibpodAsync(String name, Boolean follow, Boolean stdout, Boolean stderr, String since, String until, Boolean timestamps, String tail, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = containerLogsLibpodValidateBeforeCall(name, follow, stdout, stderr, since, until, timestamps, tail, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public class APIcontainerLogsLibpodRequest {
        private final String name;
        private Boolean follow;
        private Boolean stdout;
        private Boolean stderr;
        private String since;
        private String until;
        private Boolean timestamps;
        private String tail;

        private APIcontainerLogsLibpodRequest(String name) {
            this.name = name;
        }

        /**
         * Set follow
         * @param follow Keep connection after returning logs. (optional)
         * @return APIcontainerLogsLibpodRequest
         */
        public APIcontainerLogsLibpodRequest follow(Boolean follow) {
            this.follow = follow;
            return this;
        }

        /**
         * Set stdout
         * @param stdout Return logs from stdout (optional)
         * @return APIcontainerLogsLibpodRequest
         */
        public APIcontainerLogsLibpodRequest stdout(Boolean stdout) {
            this.stdout = stdout;
            return this;
        }

        /**
         * Set stderr
         * @param stderr Return logs from stderr (optional)
         * @return APIcontainerLogsLibpodRequest
         */
        public APIcontainerLogsLibpodRequest stderr(Boolean stderr) {
            this.stderr = stderr;
            return this;
        }

        /**
         * Set since
         * @param since Only return logs since this time, as a UNIX timestamp (optional)
         * @return APIcontainerLogsLibpodRequest
         */
        public APIcontainerLogsLibpodRequest since(String since) {
            this.since = since;
            return this;
        }

        /**
         * Set until
         * @param until Only return logs before this time, as a UNIX timestamp (optional)
         * @return APIcontainerLogsLibpodRequest
         */
        public APIcontainerLogsLibpodRequest until(String until) {
            this.until = until;
            return this;
        }

        /**
         * Set timestamps
         * @param timestamps Add timestamps to every log line (optional, default to false)
         * @return APIcontainerLogsLibpodRequest
         */
        public APIcontainerLogsLibpodRequest timestamps(Boolean timestamps) {
            this.timestamps = timestamps;
            return this;
        }

        /**
         * Set tail
         * @param tail Only return this number of log lines from the end of the logs (optional, default to all)
         * @return APIcontainerLogsLibpodRequest
         */
        public APIcontainerLogsLibpodRequest tail(String tail) {
            this.tail = tail;
            return this;
        }

        /**
         * Build call for containerLogsLibpod
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> logs returned as a stream in response body. </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return containerLogsLibpodCall(name, follow, stdout, stderr, since, until, timestamps, tail, _callback);
        }

        /**
         * Execute containerLogsLibpod request
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> logs returned as a stream in response body. </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public void execute() throws ApiException {
            containerLogsLibpodWithHttpInfo(name, follow, stdout, stderr, since, until, timestamps, tail);
        }

        /**
         * Execute containerLogsLibpod request with HTTP info returned
         * @return ApiResponse&lt;Void&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> logs returned as a stream in response body. </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return containerLogsLibpodWithHttpInfo(name, follow, stdout, stderr, since, until, timestamps, tail);
        }

        /**
         * Execute containerLogsLibpod request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> logs returned as a stream in response body. </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<Void> _callback) throws ApiException {
            return containerLogsLibpodAsync(name, follow, stdout, stderr, since, until, timestamps, tail, _callback);
        }
    }

    /**
     * Get container logs
     * Get stdout and stderr logs from a container.  The stream format is the same as described in the attach endpoint. 
     * @param name the name or ID of the container (required)
     * @return APIcontainerLogsLibpodRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> logs returned as a stream in response body. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIcontainerLogsLibpodRequest containerLogsLibpod(String name) {
        return new APIcontainerLogsLibpodRequest(name);
    }
    private okhttp3.Call containerMountLibpodCall(String name, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/libpod/containers/{name}/mount"
            .replaceAll("\\{" + "name" + "\\}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call containerMountLibpodValidateBeforeCall(String name, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling containerMountLibpod(Async)");
        }
        

        okhttp3.Call localVarCall = containerMountLibpodCall(name, _callback);
        return localVarCall;

    }


    private ApiResponse<String> containerMountLibpodWithHttpInfo( @NotNull String name) throws ApiException {
        okhttp3.Call localVarCall = containerMountLibpodValidateBeforeCall(name, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call containerMountLibpodAsync(String name, final ApiCallback<String> _callback) throws ApiException {

        okhttp3.Call localVarCall = containerMountLibpodValidateBeforeCall(name, _callback);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIcontainerMountLibpodRequest {
        private final String name;

        private APIcontainerMountLibpodRequest(String name) {
            this.name = name;
        }

        /**
         * Build call for containerMountLibpod
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> mounted container </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return containerMountLibpodCall(name, _callback);
        }

        /**
         * Execute containerMountLibpod request
         * @return String
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> mounted container </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public String execute() throws ApiException {
            ApiResponse<String> localVarResp = containerMountLibpodWithHttpInfo(name);
            return localVarResp.getData();
        }

        /**
         * Execute containerMountLibpod request with HTTP info returned
         * @return ApiResponse&lt;String&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> mounted container </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<String> executeWithHttpInfo() throws ApiException {
            return containerMountLibpodWithHttpInfo(name);
        }

        /**
         * Execute containerMountLibpod request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> mounted container </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<String> _callback) throws ApiException {
            return containerMountLibpodAsync(name, _callback);
        }
    }

    /**
     * Mount a container
     * Mount a container to the filesystem
     * @param name the name or ID of the container (required)
     * @return APIcontainerMountLibpodRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> mounted container </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIcontainerMountLibpodRequest containerMountLibpod(String name) {
        return new APIcontainerMountLibpodRequest(name);
    }
    private okhttp3.Call containerPauseLibpodCall(String name, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/libpod/containers/{name}/pause"
            .replaceAll("\\{" + "name" + "\\}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call containerPauseLibpodValidateBeforeCall(String name, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling containerPauseLibpod(Async)");
        }
        

        okhttp3.Call localVarCall = containerPauseLibpodCall(name, _callback);
        return localVarCall;

    }


    private ApiResponse<Void> containerPauseLibpodWithHttpInfo( @NotNull String name) throws ApiException {
        okhttp3.Call localVarCall = containerPauseLibpodValidateBeforeCall(name, null);
        return localVarApiClient.execute(localVarCall);
    }

    private okhttp3.Call containerPauseLibpodAsync(String name, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = containerPauseLibpodValidateBeforeCall(name, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public class APIcontainerPauseLibpodRequest {
        private final String name;

        private APIcontainerPauseLibpodRequest(String name) {
            this.name = name;
        }

        /**
         * Build call for containerPauseLibpod
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return containerPauseLibpodCall(name, _callback);
        }

        /**
         * Execute containerPauseLibpod request
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public void execute() throws ApiException {
            containerPauseLibpodWithHttpInfo(name);
        }

        /**
         * Execute containerPauseLibpod request with HTTP info returned
         * @return ApiResponse&lt;Void&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return containerPauseLibpodWithHttpInfo(name);
        }

        /**
         * Execute containerPauseLibpod request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<Void> _callback) throws ApiException {
            return containerPauseLibpodAsync(name, _callback);
        }
    }

    /**
     * Pause a container
     * Use the cgroups freezer to suspend all processes in a container.
     * @param name the name or ID of the container (required)
     * @return APIcontainerPauseLibpodRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIcontainerPauseLibpodRequest containerPauseLibpod(String name) {
        return new APIcontainerPauseLibpodRequest(name);
    }
    private okhttp3.Call containerPruneLibpodCall(String filters, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/libpod/containers/prune";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (filters != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("filters", filters));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call containerPruneLibpodValidateBeforeCall(String filters, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = containerPruneLibpodCall(filters, _callback);
        return localVarCall;

    }


    private ApiResponse<List<ContainersPruneReportLibpod>> containerPruneLibpodWithHttpInfo(String filters) throws ApiException {
        okhttp3.Call localVarCall = containerPruneLibpodValidateBeforeCall(filters, null);
        Type localVarReturnType = new TypeToken<List<ContainersPruneReportLibpod>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call containerPruneLibpodAsync(String filters, final ApiCallback<List<ContainersPruneReportLibpod>> _callback) throws ApiException {

        okhttp3.Call localVarCall = containerPruneLibpodValidateBeforeCall(filters, _callback);
        Type localVarReturnType = new TypeToken<List<ContainersPruneReportLibpod>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIcontainerPruneLibpodRequest {
        private String filters;

        private APIcontainerPruneLibpodRequest() {
        }

        /**
         * Set filters
         * @param filters Filters to process on the prune list, encoded as JSON (a &#x60;map[string][]string&#x60;).  Available filters:  - &#x60;until&#x3D;&lt;timestamp&gt;&#x60; Prune containers created before this timestamp. The &#x60;&lt;timestamp&gt;&#x60; can be Unix timestamps, date formatted timestamps, or Go duration strings (e.g. &#x60;10m&#x60;, &#x60;1h30m&#x60;) computed relative to the daemon machine’s time.  - &#x60;label&#x60; (&#x60;label&#x3D;&lt;key&gt;&#x60;, &#x60;label&#x3D;&lt;key&gt;&#x3D;&lt;value&gt;&#x60;, &#x60;label!&#x3D;&lt;key&gt;&#x60;, or &#x60;label!&#x3D;&lt;key&gt;&#x3D;&lt;value&gt;&#x60;) Prune containers with (or without, in case &#x60;label!&#x3D;...&#x60; is used) the specified labels.  (optional)
         * @return APIcontainerPruneLibpodRequest
         */
        public APIcontainerPruneLibpodRequest filters(String filters) {
            this.filters = filters;
            return this;
        }

        /**
         * Build call for containerPruneLibpod
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Prune Containers </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return containerPruneLibpodCall(filters, _callback);
        }

        /**
         * Execute containerPruneLibpod request
         * @return List&lt;ContainersPruneReportLibpod&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Prune Containers </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public List<ContainersPruneReportLibpod> execute() throws ApiException {
            ApiResponse<List<ContainersPruneReportLibpod>> localVarResp = containerPruneLibpodWithHttpInfo(filters);
            return localVarResp.getData();
        }

        /**
         * Execute containerPruneLibpod request with HTTP info returned
         * @return ApiResponse&lt;List&lt;ContainersPruneReportLibpod&gt;&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Prune Containers </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<List<ContainersPruneReportLibpod>> executeWithHttpInfo() throws ApiException {
            return containerPruneLibpodWithHttpInfo(filters);
        }

        /**
         * Execute containerPruneLibpod request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Prune Containers </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<List<ContainersPruneReportLibpod>> _callback) throws ApiException {
            return containerPruneLibpodAsync(filters, _callback);
        }
    }

    /**
     * Delete stopped containers
     * Remove containers not in use
     * @return APIcontainerPruneLibpodRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Prune Containers </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIcontainerPruneLibpodRequest containerPruneLibpod() {
        return new APIcontainerPruneLibpodRequest();
    }
    private okhttp3.Call containerRenameLibpodCall(String name, String name2, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/libpod/containers/{name}/rename"
            .replaceAll("\\{" + "name" + "\\}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (name2 != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("name", name2));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call containerRenameLibpodValidateBeforeCall(String name, String name2, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling containerRenameLibpod(Async)");
        }
        
        // verify the required parameter 'name2' is set
        if (name2 == null) {
            throw new ApiException("Missing the required parameter 'name2' when calling containerRenameLibpod(Async)");
        }
        

        okhttp3.Call localVarCall = containerRenameLibpodCall(name, name2, _callback);
        return localVarCall;

    }


    private ApiResponse<Void> containerRenameLibpodWithHttpInfo( @NotNull String name,  @NotNull String name2) throws ApiException {
        okhttp3.Call localVarCall = containerRenameLibpodValidateBeforeCall(name, name2, null);
        return localVarApiClient.execute(localVarCall);
    }

    private okhttp3.Call containerRenameLibpodAsync(String name, String name2, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = containerRenameLibpodValidateBeforeCall(name, name2, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public class APIcontainerRenameLibpodRequest {
        private final String name;
        private final String name2;

        private APIcontainerRenameLibpodRequest(String name, String name2) {
            this.name = name;
            this.name2 = name2;
        }

        /**
         * Build call for containerRenameLibpod
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> Conflict error in operation </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return containerRenameLibpodCall(name, name2, _callback);
        }

        /**
         * Execute containerRenameLibpod request
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> Conflict error in operation </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public void execute() throws ApiException {
            containerRenameLibpodWithHttpInfo(name, name2);
        }

        /**
         * Execute containerRenameLibpod request with HTTP info returned
         * @return ApiResponse&lt;Void&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> Conflict error in operation </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return containerRenameLibpodWithHttpInfo(name, name2);
        }

        /**
         * Execute containerRenameLibpod request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> Conflict error in operation </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<Void> _callback) throws ApiException {
            return containerRenameLibpodAsync(name, name2, _callback);
        }
    }

    /**
     * Rename an existing container
     * Change the name of an existing container.
     * @param name Full or partial ID or full name of the container to rename (required)
     * @param name2 New name for the container (required)
     * @return APIcontainerRenameLibpodRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> Conflict error in operation </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIcontainerRenameLibpodRequest containerRenameLibpod(String name, String name2) {
        return new APIcontainerRenameLibpodRequest(name, name2);
    }
    private okhttp3.Call containerResizeLibpodCall(String name, Integer h, Integer w, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/libpod/containers/{name}/resize"
            .replaceAll("\\{" + "name" + "\\}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (h != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("h", h));
        }

        if (w != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("w", w));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call containerResizeLibpodValidateBeforeCall(String name, Integer h, Integer w, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling containerResizeLibpod(Async)");
        }
        

        okhttp3.Call localVarCall = containerResizeLibpodCall(name, h, w, _callback);
        return localVarCall;

    }


    private ApiResponse<Object> containerResizeLibpodWithHttpInfo( @NotNull String name, Integer h, Integer w) throws ApiException {
        okhttp3.Call localVarCall = containerResizeLibpodValidateBeforeCall(name, h, w, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call containerResizeLibpodAsync(String name, Integer h, Integer w, final ApiCallback<Object> _callback) throws ApiException {

        okhttp3.Call localVarCall = containerResizeLibpodValidateBeforeCall(name, h, w, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIcontainerResizeLibpodRequest {
        private final String name;
        private Integer h;
        private Integer w;

        private APIcontainerResizeLibpodRequest(String name) {
            this.name = name;
        }

        /**
         * Set h
         * @param h Height to set for the terminal, in characters (optional)
         * @return APIcontainerResizeLibpodRequest
         */
        public APIcontainerResizeLibpodRequest h(Integer h) {
            this.h = h;
            return this;
        }

        /**
         * Set w
         * @param w Width to set for the terminal, in characters (optional)
         * @return APIcontainerResizeLibpodRequest
         */
        public APIcontainerResizeLibpodRequest w(Integer w) {
            this.w = w;
            return this;
        }

        /**
         * Build call for containerResizeLibpod
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Success </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> Conflict error in operation </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return containerResizeLibpodCall(name, h, w, _callback);
        }

        /**
         * Execute containerResizeLibpod request
         * @return Object
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Success </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> Conflict error in operation </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public Object execute() throws ApiException {
            ApiResponse<Object> localVarResp = containerResizeLibpodWithHttpInfo(name, h, w);
            return localVarResp.getData();
        }

        /**
         * Execute containerResizeLibpod request with HTTP info returned
         * @return ApiResponse&lt;Object&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Success </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> Conflict error in operation </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<Object> executeWithHttpInfo() throws ApiException {
            return containerResizeLibpodWithHttpInfo(name, h, w);
        }

        /**
         * Execute containerResizeLibpod request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Success </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> Conflict error in operation </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<Object> _callback) throws ApiException {
            return containerResizeLibpodAsync(name, h, w, _callback);
        }
    }

    /**
     * Resize a container&#39;s TTY
     * Resize the terminal attached to a container (for use with Attach).
     * @param name the name or ID of the container (required)
     * @return APIcontainerResizeLibpodRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> Conflict error in operation </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIcontainerResizeLibpodRequest containerResizeLibpod(String name) {
        return new APIcontainerResizeLibpodRequest(name);
    }
    private okhttp3.Call containerRestartLibpodCall(String name, Integer t, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/libpod/containers/{name}/restart"
            .replaceAll("\\{" + "name" + "\\}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (t != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("t", t));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call containerRestartLibpodValidateBeforeCall(String name, Integer t, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling containerRestartLibpod(Async)");
        }
        

        okhttp3.Call localVarCall = containerRestartLibpodCall(name, t, _callback);
        return localVarCall;

    }


    private ApiResponse<Void> containerRestartLibpodWithHttpInfo( @NotNull String name, Integer t) throws ApiException {
        okhttp3.Call localVarCall = containerRestartLibpodValidateBeforeCall(name, t, null);
        return localVarApiClient.execute(localVarCall);
    }

    private okhttp3.Call containerRestartLibpodAsync(String name, Integer t, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = containerRestartLibpodValidateBeforeCall(name, t, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public class APIcontainerRestartLibpodRequest {
        private final String name;
        private Integer t;

        private APIcontainerRestartLibpodRequest(String name) {
            this.name = name;
        }

        /**
         * Set t
         * @param t number of seconds to wait before killing container (optional, default to 10)
         * @return APIcontainerRestartLibpodRequest
         */
        public APIcontainerRestartLibpodRequest t(Integer t) {
            this.t = t;
            return this;
        }

        /**
         * Build call for containerRestartLibpod
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return containerRestartLibpodCall(name, t, _callback);
        }

        /**
         * Execute containerRestartLibpod request
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public void execute() throws ApiException {
            containerRestartLibpodWithHttpInfo(name, t);
        }

        /**
         * Execute containerRestartLibpod request with HTTP info returned
         * @return ApiResponse&lt;Void&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return containerRestartLibpodWithHttpInfo(name, t);
        }

        /**
         * Execute containerRestartLibpod request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<Void> _callback) throws ApiException {
            return containerRestartLibpodAsync(name, t, _callback);
        }
    }

    /**
     * Restart a container
     * 
     * @param name the name or ID of the container (required)
     * @return APIcontainerRestartLibpodRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIcontainerRestartLibpodRequest containerRestartLibpod(String name) {
        return new APIcontainerRestartLibpodRequest(name);
    }
    private okhttp3.Call containerRestoreLibpodCall(String name, String name2, Boolean keep, Boolean tcpEstablished, Boolean _import, Boolean ignoreRootFS, Boolean ignoreVolumes, Boolean ignoreStaticIP, Boolean ignoreStaticMAC, Boolean fileLocks, Boolean printStats, String pod, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/libpod/containers/{name}/restore"
            .replaceAll("\\{" + "name" + "\\}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (name2 != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("name", name2));
        }

        if (keep != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("keep", keep));
        }

        if (tcpEstablished != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("tcpEstablished", tcpEstablished));
        }

        if (_import != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("import", _import));
        }

        if (ignoreRootFS != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("ignoreRootFS", ignoreRootFS));
        }

        if (ignoreVolumes != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("ignoreVolumes", ignoreVolumes));
        }

        if (ignoreStaticIP != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("ignoreStaticIP", ignoreStaticIP));
        }

        if (ignoreStaticMAC != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("ignoreStaticMAC", ignoreStaticMAC));
        }

        if (fileLocks != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("fileLocks", fileLocks));
        }

        if (printStats != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("printStats", printStats));
        }

        if (pod != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("pod", pod));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call containerRestoreLibpodValidateBeforeCall(String name, String name2, Boolean keep, Boolean tcpEstablished, Boolean _import, Boolean ignoreRootFS, Boolean ignoreVolumes, Boolean ignoreStaticIP, Boolean ignoreStaticMAC, Boolean fileLocks, Boolean printStats, String pod, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling containerRestoreLibpod(Async)");
        }
        

        okhttp3.Call localVarCall = containerRestoreLibpodCall(name, name2, keep, tcpEstablished, _import, ignoreRootFS, ignoreVolumes, ignoreStaticIP, ignoreStaticMAC, fileLocks, printStats, pod, _callback);
        return localVarCall;

    }


    private ApiResponse<Void> containerRestoreLibpodWithHttpInfo( @NotNull String name, String name2, Boolean keep, Boolean tcpEstablished, Boolean _import, Boolean ignoreRootFS, Boolean ignoreVolumes, Boolean ignoreStaticIP, Boolean ignoreStaticMAC, Boolean fileLocks, Boolean printStats, String pod) throws ApiException {
        okhttp3.Call localVarCall = containerRestoreLibpodValidateBeforeCall(name, name2, keep, tcpEstablished, _import, ignoreRootFS, ignoreVolumes, ignoreStaticIP, ignoreStaticMAC, fileLocks, printStats, pod, null);
        return localVarApiClient.execute(localVarCall);
    }

    private okhttp3.Call containerRestoreLibpodAsync(String name, String name2, Boolean keep, Boolean tcpEstablished, Boolean _import, Boolean ignoreRootFS, Boolean ignoreVolumes, Boolean ignoreStaticIP, Boolean ignoreStaticMAC, Boolean fileLocks, Boolean printStats, String pod, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = containerRestoreLibpodValidateBeforeCall(name, name2, keep, tcpEstablished, _import, ignoreRootFS, ignoreVolumes, ignoreStaticIP, ignoreStaticMAC, fileLocks, printStats, pod, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public class APIcontainerRestoreLibpodRequest {
        private final String name;
        private String name2;
        private Boolean keep;
        private Boolean tcpEstablished;
        private Boolean _import;
        private Boolean ignoreRootFS;
        private Boolean ignoreVolumes;
        private Boolean ignoreStaticIP;
        private Boolean ignoreStaticMAC;
        private Boolean fileLocks;
        private Boolean printStats;
        private String pod;

        private APIcontainerRestoreLibpodRequest(String name) {
            this.name = name;
        }

        /**
         * Set name2
         * @param name2 the name of the container when restored from a tar. can only be used with import (optional)
         * @return APIcontainerRestoreLibpodRequest
         */
        public APIcontainerRestoreLibpodRequest name2(String name2) {
            this.name2 = name2;
            return this;
        }

        /**
         * Set keep
         * @param keep keep all temporary checkpoint files (optional)
         * @return APIcontainerRestoreLibpodRequest
         */
        public APIcontainerRestoreLibpodRequest keep(Boolean keep) {
            this.keep = keep;
            return this;
        }

        /**
         * Set tcpEstablished
         * @param tcpEstablished checkpoint a container with established TCP connections (optional)
         * @return APIcontainerRestoreLibpodRequest
         */
        public APIcontainerRestoreLibpodRequest tcpEstablished(Boolean tcpEstablished) {
            this.tcpEstablished = tcpEstablished;
            return this;
        }

        /**
         * Set _import
         * @param _import import the restore from a checkpoint tar.gz (optional)
         * @return APIcontainerRestoreLibpodRequest
         */
        public APIcontainerRestoreLibpodRequest _import(Boolean _import) {
            this._import = _import;
            return this;
        }

        /**
         * Set ignoreRootFS
         * @param ignoreRootFS do not include root file-system changes when exporting. can only be used with import (optional)
         * @return APIcontainerRestoreLibpodRequest
         */
        public APIcontainerRestoreLibpodRequest ignoreRootFS(Boolean ignoreRootFS) {
            this.ignoreRootFS = ignoreRootFS;
            return this;
        }

        /**
         * Set ignoreVolumes
         * @param ignoreVolumes do not restore associated volumes. can only be used with import (optional)
         * @return APIcontainerRestoreLibpodRequest
         */
        public APIcontainerRestoreLibpodRequest ignoreVolumes(Boolean ignoreVolumes) {
            this.ignoreVolumes = ignoreVolumes;
            return this;
        }

        /**
         * Set ignoreStaticIP
         * @param ignoreStaticIP ignore IP address if set statically (optional)
         * @return APIcontainerRestoreLibpodRequest
         */
        public APIcontainerRestoreLibpodRequest ignoreStaticIP(Boolean ignoreStaticIP) {
            this.ignoreStaticIP = ignoreStaticIP;
            return this;
        }

        /**
         * Set ignoreStaticMAC
         * @param ignoreStaticMAC ignore MAC address if set statically (optional)
         * @return APIcontainerRestoreLibpodRequest
         */
        public APIcontainerRestoreLibpodRequest ignoreStaticMAC(Boolean ignoreStaticMAC) {
            this.ignoreStaticMAC = ignoreStaticMAC;
            return this;
        }

        /**
         * Set fileLocks
         * @param fileLocks restore a container with file locks (optional)
         * @return APIcontainerRestoreLibpodRequest
         */
        public APIcontainerRestoreLibpodRequest fileLocks(Boolean fileLocks) {
            this.fileLocks = fileLocks;
            return this;
        }

        /**
         * Set printStats
         * @param printStats add restore statistics to the returned RestoreReport (optional)
         * @return APIcontainerRestoreLibpodRequest
         */
        public APIcontainerRestoreLibpodRequest printStats(Boolean printStats) {
            this.printStats = printStats;
            return this;
        }

        /**
         * Set pod
         * @param pod pod to restore into (optional)
         * @return APIcontainerRestoreLibpodRequest
         */
        public APIcontainerRestoreLibpodRequest pod(String pod) {
            this.pod = pod;
            return this;
        }

        /**
         * Build call for containerRestoreLibpod
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> tarball is returned in body if exported </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return containerRestoreLibpodCall(name, name2, keep, tcpEstablished, _import, ignoreRootFS, ignoreVolumes, ignoreStaticIP, ignoreStaticMAC, fileLocks, printStats, pod, _callback);
        }

        /**
         * Execute containerRestoreLibpod request
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> tarball is returned in body if exported </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public void execute() throws ApiException {
            containerRestoreLibpodWithHttpInfo(name, name2, keep, tcpEstablished, _import, ignoreRootFS, ignoreVolumes, ignoreStaticIP, ignoreStaticMAC, fileLocks, printStats, pod);
        }

        /**
         * Execute containerRestoreLibpod request with HTTP info returned
         * @return ApiResponse&lt;Void&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> tarball is returned in body if exported </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return containerRestoreLibpodWithHttpInfo(name, name2, keep, tcpEstablished, _import, ignoreRootFS, ignoreVolumes, ignoreStaticIP, ignoreStaticMAC, fileLocks, printStats, pod);
        }

        /**
         * Execute containerRestoreLibpod request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> tarball is returned in body if exported </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<Void> _callback) throws ApiException {
            return containerRestoreLibpodAsync(name, name2, keep, tcpEstablished, _import, ignoreRootFS, ignoreVolumes, ignoreStaticIP, ignoreStaticMAC, fileLocks, printStats, pod, _callback);
        }
    }

    /**
     * Restore a container
     * Restore a container from a checkpoint.
     * @param name the name or id of the container (required)
     * @return APIcontainerRestoreLibpodRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> tarball is returned in body if exported </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIcontainerRestoreLibpodRequest containerRestoreLibpod(String name) {
        return new APIcontainerRestoreLibpodRequest(name);
    }
    private okhttp3.Call containerShowMountedLibpodCall(final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/libpod/containers/showmounted";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call containerShowMountedLibpodValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = containerShowMountedLibpodCall(_callback);
        return localVarCall;

    }


    private ApiResponse<Map<String, String>> containerShowMountedLibpodWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = containerShowMountedLibpodValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<Map<String, String>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call containerShowMountedLibpodAsync(final ApiCallback<Map<String, String>> _callback) throws ApiException {

        okhttp3.Call localVarCall = containerShowMountedLibpodValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<Map<String, String>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIcontainerShowMountedLibpodRequest {

        private APIcontainerShowMountedLibpodRequest() {
        }

        /**
         * Build call for containerShowMountedLibpod
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> mounted containers </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return containerShowMountedLibpodCall(_callback);
        }

        /**
         * Execute containerShowMountedLibpod request
         * @return Map&lt;String, String&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> mounted containers </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public Map<String, String> execute() throws ApiException {
            ApiResponse<Map<String, String>> localVarResp = containerShowMountedLibpodWithHttpInfo();
            return localVarResp.getData();
        }

        /**
         * Execute containerShowMountedLibpod request with HTTP info returned
         * @return ApiResponse&lt;Map&lt;String, String&gt;&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> mounted containers </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<Map<String, String>> executeWithHttpInfo() throws ApiException {
            return containerShowMountedLibpodWithHttpInfo();
        }

        /**
         * Execute containerShowMountedLibpod request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> mounted containers </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<Map<String, String>> _callback) throws ApiException {
            return containerShowMountedLibpodAsync(_callback);
        }
    }

    /**
     * Show mounted containers
     * Lists all mounted containers mount points
     * @return APIcontainerShowMountedLibpodRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> mounted containers </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIcontainerShowMountedLibpodRequest containerShowMountedLibpod() {
        return new APIcontainerShowMountedLibpodRequest();
    }
    private okhttp3.Call containerStartLibpodCall(String name, String detachKeys, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/libpod/containers/{name}/start"
            .replaceAll("\\{" + "name" + "\\}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (detachKeys != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("detachKeys", detachKeys));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call containerStartLibpodValidateBeforeCall(String name, String detachKeys, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling containerStartLibpod(Async)");
        }
        

        okhttp3.Call localVarCall = containerStartLibpodCall(name, detachKeys, _callback);
        return localVarCall;

    }


    private ApiResponse<Void> containerStartLibpodWithHttpInfo( @NotNull String name, String detachKeys) throws ApiException {
        okhttp3.Call localVarCall = containerStartLibpodValidateBeforeCall(name, detachKeys, null);
        return localVarApiClient.execute(localVarCall);
    }

    private okhttp3.Call containerStartLibpodAsync(String name, String detachKeys, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = containerStartLibpodValidateBeforeCall(name, detachKeys, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public class APIcontainerStartLibpodRequest {
        private final String name;
        private String detachKeys;

        private APIcontainerStartLibpodRequest(String name) {
            this.name = name;
        }

        /**
         * Set detachKeys
         * @param detachKeys Override the key sequence for detaching a container. Format is a single character [a-Z] or ctrl-&lt;value&gt; where &lt;value&gt; is one of: a-z, @, ^, [, , or _. (optional, default to ctrl-p,ctrl-q)
         * @return APIcontainerStartLibpodRequest
         */
        public APIcontainerStartLibpodRequest detachKeys(String detachKeys) {
            this.detachKeys = detachKeys;
            return this;
        }

        /**
         * Build call for containerStartLibpod
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 304 </td><td> Container already started </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return containerStartLibpodCall(name, detachKeys, _callback);
        }

        /**
         * Execute containerStartLibpod request
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 304 </td><td> Container already started </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public void execute() throws ApiException {
            containerStartLibpodWithHttpInfo(name, detachKeys);
        }

        /**
         * Execute containerStartLibpod request with HTTP info returned
         * @return ApiResponse&lt;Void&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 304 </td><td> Container already started </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return containerStartLibpodWithHttpInfo(name, detachKeys);
        }

        /**
         * Execute containerStartLibpod request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 304 </td><td> Container already started </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<Void> _callback) throws ApiException {
            return containerStartLibpodAsync(name, detachKeys, _callback);
        }
    }

    /**
     * Start a container
     * 
     * @param name the name or ID of the container (required)
     * @return APIcontainerStartLibpodRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
        <tr><td> 304 </td><td> Container already started </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIcontainerStartLibpodRequest containerStartLibpod(String name) {
        return new APIcontainerStartLibpodRequest(name);
    }
    private okhttp3.Call containerStatsLibpodCall(String name, Boolean stream, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/libpod/containers/{name}/stats"
            .replaceAll("\\{" + "name" + "\\}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (stream != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("stream", stream));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call containerStatsLibpodValidateBeforeCall(String name, Boolean stream, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling containerStatsLibpod(Async)");
        }
        

        okhttp3.Call localVarCall = containerStatsLibpodCall(name, stream, _callback);
        return localVarCall;

    }


    private ApiResponse<Void> containerStatsLibpodWithHttpInfo( @NotNull String name, Boolean stream) throws ApiException {
        okhttp3.Call localVarCall = containerStatsLibpodValidateBeforeCall(name, stream, null);
        return localVarApiClient.execute(localVarCall);
    }

    private okhttp3.Call containerStatsLibpodAsync(String name, Boolean stream, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = containerStatsLibpodValidateBeforeCall(name, stream, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public class APIcontainerStatsLibpodRequest {
        private final String name;
        private Boolean stream;

        private APIcontainerStatsLibpodRequest(String name) {
            this.name = name;
        }

        /**
         * Set stream
         * @param stream Stream the output (optional, default to true)
         * @return APIcontainerStatsLibpodRequest
         */
        public APIcontainerStatsLibpodRequest stream(Boolean stream) {
            this.stream = stream;
            return this;
        }

        /**
         * Build call for containerStatsLibpod
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> Conflict error in operation </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return containerStatsLibpodCall(name, stream, _callback);
        }

        /**
         * Execute containerStatsLibpod request
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> Conflict error in operation </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public void execute() throws ApiException {
            containerStatsLibpodWithHttpInfo(name, stream);
        }

        /**
         * Execute containerStatsLibpod request with HTTP info returned
         * @return ApiResponse&lt;Void&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> Conflict error in operation </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return containerStatsLibpodWithHttpInfo(name, stream);
        }

        /**
         * Execute containerStatsLibpod request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> Conflict error in operation </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<Void> _callback) throws ApiException {
            return containerStatsLibpodAsync(name, stream, _callback);
        }
    }

    /**
     * Get stats for a container
     * DEPRECATED. This endpoint will be removed with the next major release. Please use /libpod/containers/stats instead.
     * @param name the name or ID of the container (required)
     * @return APIcontainerStatsLibpodRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> no error </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> Conflict error in operation </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIcontainerStatsLibpodRequest containerStatsLibpod(String name) {
        return new APIcontainerStatsLibpodRequest(name);
    }
    private okhttp3.Call containerStopLibpodCall(String name, Integer timeout, Boolean ignore, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/libpod/containers/{name}/stop"
            .replaceAll("\\{" + "name" + "\\}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (timeout != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("timeout", timeout));
        }

        if (ignore != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("Ignore", ignore));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call containerStopLibpodValidateBeforeCall(String name, Integer timeout, Boolean ignore, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling containerStopLibpod(Async)");
        }
        

        okhttp3.Call localVarCall = containerStopLibpodCall(name, timeout, ignore, _callback);
        return localVarCall;

    }


    private ApiResponse<Void> containerStopLibpodWithHttpInfo( @NotNull String name, Integer timeout, Boolean ignore) throws ApiException {
        okhttp3.Call localVarCall = containerStopLibpodValidateBeforeCall(name, timeout, ignore, null);
        return localVarApiClient.execute(localVarCall);
    }

    private okhttp3.Call containerStopLibpodAsync(String name, Integer timeout, Boolean ignore, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = containerStopLibpodValidateBeforeCall(name, timeout, ignore, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public class APIcontainerStopLibpodRequest {
        private final String name;
        private Integer timeout;
        private Boolean ignore;

        private APIcontainerStopLibpodRequest(String name) {
            this.name = name;
        }

        /**
         * Set timeout
         * @param timeout number of seconds to wait before killing container (optional, default to 10)
         * @return APIcontainerStopLibpodRequest
         */
        public APIcontainerStopLibpodRequest timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        /**
         * Set ignore
         * @param ignore do not return error if container is already stopped (optional, default to false)
         * @return APIcontainerStopLibpodRequest
         */
        public APIcontainerStopLibpodRequest ignore(Boolean ignore) {
            this.ignore = ignore;
            return this;
        }

        /**
         * Build call for containerStopLibpod
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 304 </td><td> Container already stopped </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return containerStopLibpodCall(name, timeout, ignore, _callback);
        }

        /**
         * Execute containerStopLibpod request
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 304 </td><td> Container already stopped </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public void execute() throws ApiException {
            containerStopLibpodWithHttpInfo(name, timeout, ignore);
        }

        /**
         * Execute containerStopLibpod request with HTTP info returned
         * @return ApiResponse&lt;Void&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 304 </td><td> Container already stopped </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return containerStopLibpodWithHttpInfo(name, timeout, ignore);
        }

        /**
         * Execute containerStopLibpod request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 304 </td><td> Container already stopped </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<Void> _callback) throws ApiException {
            return containerStopLibpodAsync(name, timeout, ignore, _callback);
        }
    }

    /**
     * Stop a container
     * 
     * @param name the name or ID of the container (required)
     * @return APIcontainerStopLibpodRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
        <tr><td> 304 </td><td> Container already stopped </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIcontainerStopLibpodRequest containerStopLibpod(String name) {
        return new APIcontainerStopLibpodRequest(name);
    }
    private okhttp3.Call containerTopLibpodCall(String name, Boolean stream, Integer delay, List<String> psArgs, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/libpod/containers/{name}/top"
            .replaceAll("\\{" + "name" + "\\}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (stream != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("stream", stream));
        }

        if (delay != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("delay", delay));
        }

        if (psArgs != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "ps_args", psArgs));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call containerTopLibpodValidateBeforeCall(String name, Boolean stream, Integer delay, List<String> psArgs, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling containerTopLibpod(Async)");
        }
        

        okhttp3.Call localVarCall = containerTopLibpodCall(name, stream, delay, psArgs, _callback);
        return localVarCall;

    }


    private ApiResponse<ContainerTopOKBody> containerTopLibpodWithHttpInfo( @NotNull String name, Boolean stream, Integer delay, List<String> psArgs) throws ApiException {
        okhttp3.Call localVarCall = containerTopLibpodValidateBeforeCall(name, stream, delay, psArgs, null);
        Type localVarReturnType = new TypeToken<ContainerTopOKBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call containerTopLibpodAsync(String name, Boolean stream, Integer delay, List<String> psArgs, final ApiCallback<ContainerTopOKBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = containerTopLibpodValidateBeforeCall(name, stream, delay, psArgs, _callback);
        Type localVarReturnType = new TypeToken<ContainerTopOKBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIcontainerTopLibpodRequest {
        private final String name;
        private Boolean stream;
        private Integer delay;
        private List<String> psArgs;

        private APIcontainerTopLibpodRequest(String name) {
            this.name = name;
        }

        /**
         * Set stream
         * @param stream when true, repeatedly stream the latest output (As of version 4.0) (optional)
         * @return APIcontainerTopLibpodRequest
         */
        public APIcontainerTopLibpodRequest stream(Boolean stream) {
            this.stream = stream;
            return this;
        }

        /**
         * Set delay
         * @param delay if streaming, delay in seconds between updates. Must be &gt;1. (As of version 4.0) (optional, default to 5)
         * @return APIcontainerTopLibpodRequest
         */
        public APIcontainerTopLibpodRequest delay(Integer delay) {
            this.delay = delay;
            return this;
        }

        /**
         * Set psArgs
         * @param psArgs arguments to pass to ps such as aux.  (optional)
         * @return APIcontainerTopLibpodRequest
         */
        public APIcontainerTopLibpodRequest psArgs(List<String> psArgs) {
            this.psArgs = psArgs;
            return this;
        }

        /**
         * Build call for containerTopLibpod
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List processes in container </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return containerTopLibpodCall(name, stream, delay, psArgs, _callback);
        }

        /**
         * Execute containerTopLibpod request
         * @return ContainerTopOKBody
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List processes in container </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ContainerTopOKBody execute() throws ApiException {
            ApiResponse<ContainerTopOKBody> localVarResp = containerTopLibpodWithHttpInfo(name, stream, delay, psArgs);
            return localVarResp.getData();
        }

        /**
         * Execute containerTopLibpod request with HTTP info returned
         * @return ApiResponse&lt;ContainerTopOKBody&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List processes in container </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<ContainerTopOKBody> executeWithHttpInfo() throws ApiException {
            return containerTopLibpodWithHttpInfo(name, stream, delay, psArgs);
        }

        /**
         * Execute containerTopLibpod request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List processes in container </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<ContainerTopOKBody> _callback) throws ApiException {
            return containerTopLibpodAsync(name, stream, delay, psArgs, _callback);
        }
    }

    /**
     * List processes
     * List processes running inside a container
     * @param name Name of container to query for processes (As of version 1.xx) (required)
     * @return APIcontainerTopLibpodRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List processes in container </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIcontainerTopLibpodRequest containerTopLibpod(String name) {
        return new APIcontainerTopLibpodRequest(name);
    }
    private okhttp3.Call containerUnmountLibpodCall(String name, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/libpod/containers/{name}/unmount"
            .replaceAll("\\{" + "name" + "\\}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call containerUnmountLibpodValidateBeforeCall(String name, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling containerUnmountLibpod(Async)");
        }
        

        okhttp3.Call localVarCall = containerUnmountLibpodCall(name, _callback);
        return localVarCall;

    }


    private ApiResponse<Void> containerUnmountLibpodWithHttpInfo( @NotNull String name) throws ApiException {
        okhttp3.Call localVarCall = containerUnmountLibpodValidateBeforeCall(name, null);
        return localVarApiClient.execute(localVarCall);
    }

    private okhttp3.Call containerUnmountLibpodAsync(String name, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = containerUnmountLibpodValidateBeforeCall(name, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public class APIcontainerUnmountLibpodRequest {
        private final String name;

        private APIcontainerUnmountLibpodRequest(String name) {
            this.name = name;
        }

        /**
         * Build call for containerUnmountLibpod
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> ok </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return containerUnmountLibpodCall(name, _callback);
        }

        /**
         * Execute containerUnmountLibpod request
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> ok </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public void execute() throws ApiException {
            containerUnmountLibpodWithHttpInfo(name);
        }

        /**
         * Execute containerUnmountLibpod request with HTTP info returned
         * @return ApiResponse&lt;Void&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> ok </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return containerUnmountLibpodWithHttpInfo(name);
        }

        /**
         * Execute containerUnmountLibpod request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> ok </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<Void> _callback) throws ApiException {
            return containerUnmountLibpodAsync(name, _callback);
        }
    }

    /**
     * Unmount a container
     * Unmount a container from the filesystem
     * @param name the name or ID of the container (required)
     * @return APIcontainerUnmountLibpodRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> ok </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIcontainerUnmountLibpodRequest containerUnmountLibpod(String name) {
        return new APIcontainerUnmountLibpodRequest(name);
    }
    private okhttp3.Call containerUnpauseLibpodCall(String name, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/libpod/containers/{name}/unpause"
            .replaceAll("\\{" + "name" + "\\}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call containerUnpauseLibpodValidateBeforeCall(String name, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling containerUnpauseLibpod(Async)");
        }
        

        okhttp3.Call localVarCall = containerUnpauseLibpodCall(name, _callback);
        return localVarCall;

    }


    private ApiResponse<Void> containerUnpauseLibpodWithHttpInfo( @NotNull String name) throws ApiException {
        okhttp3.Call localVarCall = containerUnpauseLibpodValidateBeforeCall(name, null);
        return localVarApiClient.execute(localVarCall);
    }

    private okhttp3.Call containerUnpauseLibpodAsync(String name, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = containerUnpauseLibpodValidateBeforeCall(name, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public class APIcontainerUnpauseLibpodRequest {
        private final String name;

        private APIcontainerUnpauseLibpodRequest(String name) {
            this.name = name;
        }

        /**
         * Build call for containerUnpauseLibpod
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return containerUnpauseLibpodCall(name, _callback);
        }

        /**
         * Execute containerUnpauseLibpod request
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public void execute() throws ApiException {
            containerUnpauseLibpodWithHttpInfo(name);
        }

        /**
         * Execute containerUnpauseLibpod request with HTTP info returned
         * @return ApiResponse&lt;Void&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return containerUnpauseLibpodWithHttpInfo(name);
        }

        /**
         * Execute containerUnpauseLibpod request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<Void> _callback) throws ApiException {
            return containerUnpauseLibpodAsync(name, _callback);
        }
    }

    /**
     * Unpause Container
     * 
     * @param name the name or ID of the container (required)
     * @return APIcontainerUnpauseLibpodRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIcontainerUnpauseLibpodRequest containerUnpauseLibpod(String name) {
        return new APIcontainerUnpauseLibpodRequest(name);
    }
    private okhttp3.Call containerUpdateLibpodCall(String name, String restartPolicy, Integer restartRetries, UpdateEntities config, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = config;

        // create path and map variables
        String localVarPath = "/libpod/containers/{name}/update"
            .replaceAll("\\{" + "name" + "\\}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (restartPolicy != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("restartPolicy", restartPolicy));
        }

        if (restartRetries != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("restartRetries", restartRetries));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json", "application/x-tar"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call containerUpdateLibpodValidateBeforeCall(String name, String restartPolicy, Integer restartRetries, UpdateEntities config, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling containerUpdateLibpod(Async)");
        }
        

        okhttp3.Call localVarCall = containerUpdateLibpodCall(name, restartPolicy, restartRetries, config, _callback);
        return localVarCall;

    }


    private ApiResponse<Void> containerUpdateLibpodWithHttpInfo( @NotNull String name, String restartPolicy, Integer restartRetries, UpdateEntities config) throws ApiException {
        okhttp3.Call localVarCall = containerUpdateLibpodValidateBeforeCall(name, restartPolicy, restartRetries, config, null);
        return localVarApiClient.execute(localVarCall);
    }

    private okhttp3.Call containerUpdateLibpodAsync(String name, String restartPolicy, Integer restartRetries, UpdateEntities config, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = containerUpdateLibpodValidateBeforeCall(name, restartPolicy, restartRetries, config, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public class APIcontainerUpdateLibpodRequest {
        private final String name;
        private String restartPolicy;
        private Integer restartRetries;
        private UpdateEntities config;

        private APIcontainerUpdateLibpodRequest(String name) {
            this.name = name;
        }

        /**
         * Set restartPolicy
         * @param restartPolicy New restart policy for the container. (optional)
         * @return APIcontainerUpdateLibpodRequest
         */
        public APIcontainerUpdateLibpodRequest restartPolicy(String restartPolicy) {
            this.restartPolicy = restartPolicy;
            return this;
        }

        /**
         * Set restartRetries
         * @param restartRetries New amount of retries for the container&#39;s restart policy. Only allowed if restartPolicy is set to on-failure (optional)
         * @return APIcontainerUpdateLibpodRequest
         */
        public APIcontainerUpdateLibpodRequest restartRetries(Integer restartRetries) {
            this.restartRetries = restartRetries;
            return this;
        }

        /**
         * Set config
         * @param config attributes for updating the container (optional)
         * @return APIcontainerUpdateLibpodRequest
         */
        public APIcontainerUpdateLibpodRequest config(UpdateEntities config) {
            this.config = config;
            return this;
        }

        /**
         * Build call for containerUpdateLibpod
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return containerUpdateLibpodCall(name, restartPolicy, restartRetries, config, _callback);
        }

        /**
         * Execute containerUpdateLibpod request
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public void execute() throws ApiException {
            containerUpdateLibpodWithHttpInfo(name, restartPolicy, restartRetries, config);
        }

        /**
         * Execute containerUpdateLibpod request with HTTP info returned
         * @return ApiResponse&lt;Void&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return containerUpdateLibpodWithHttpInfo(name, restartPolicy, restartRetries, config);
        }

        /**
         * Execute containerUpdateLibpod request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<Void> _callback) throws ApiException {
            return containerUpdateLibpodAsync(name, restartPolicy, restartRetries, config, _callback);
        }
    }

    /**
     * Update an existing containers cgroup configuration
     * Update an existing containers cgroup configuration.
     * @param name Full or partial ID or full name of the container to update (required)
     * @return APIcontainerUpdateLibpodRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIcontainerUpdateLibpodRequest containerUpdateLibpod(String name) {
        return new APIcontainerUpdateLibpodRequest(name);
    }
    private okhttp3.Call containerWaitLibpodCall(String name, List<String> condition, String interval, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/libpod/containers/{name}/wait"
            .replaceAll("\\{" + "name" + "\\}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (condition != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "condition", condition));
        }

        if (interval != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("interval", interval));
        }

        final String[] localVarAccepts = {
            "application/json", "text/plain"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call containerWaitLibpodValidateBeforeCall(String name, List<String> condition, String interval, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling containerWaitLibpod(Async)");
        }
        

        okhttp3.Call localVarCall = containerWaitLibpodCall(name, condition, interval, _callback);
        return localVarCall;

    }


    private ApiResponse<Integer> containerWaitLibpodWithHttpInfo( @NotNull String name, List<String> condition, String interval) throws ApiException {
        okhttp3.Call localVarCall = containerWaitLibpodValidateBeforeCall(name, condition, interval, null);
        Type localVarReturnType = new TypeToken<Integer>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call containerWaitLibpodAsync(String name, List<String> condition, String interval, final ApiCallback<Integer> _callback) throws ApiException {

        okhttp3.Call localVarCall = containerWaitLibpodValidateBeforeCall(name, condition, interval, _callback);
        Type localVarReturnType = new TypeToken<Integer>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIcontainerWaitLibpodRequest {
        private final String name;
        private List<String> condition;
        private String interval;

        private APIcontainerWaitLibpodRequest(String name) {
            this.name = name;
        }

        /**
         * Set condition
         * @param condition Conditions to wait for. If no condition provided the &#39;exited&#39; condition is assumed. (optional)
         * @return APIcontainerWaitLibpodRequest
         */
        public APIcontainerWaitLibpodRequest condition(List<String> condition) {
            this.condition = condition;
            return this;
        }

        /**
         * Set interval
         * @param interval Time Interval to wait before polling for completion. (optional, default to 250ms)
         * @return APIcontainerWaitLibpodRequest
         */
        public APIcontainerWaitLibpodRequest interval(String interval) {
            this.interval = interval;
            return this;
        }

        /**
         * Build call for containerWaitLibpod
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Status code </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return containerWaitLibpodCall(name, condition, interval, _callback);
        }

        /**
         * Execute containerWaitLibpod request
         * @return Integer
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Status code </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public Integer execute() throws ApiException {
            ApiResponse<Integer> localVarResp = containerWaitLibpodWithHttpInfo(name, condition, interval);
            return localVarResp.getData();
        }

        /**
         * Execute containerWaitLibpod request with HTTP info returned
         * @return ApiResponse&lt;Integer&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Status code </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<Integer> executeWithHttpInfo() throws ApiException {
            return containerWaitLibpodWithHttpInfo(name, condition, interval);
        }

        /**
         * Execute containerWaitLibpod request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Status code </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<Integer> _callback) throws ApiException {
            return containerWaitLibpodAsync(name, condition, interval, _callback);
        }
    }

    /**
     * Wait on a container
     * Wait on a container to meet a given condition
     * @param name the name or ID of the container (required)
     * @return APIcontainerWaitLibpodRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Status code </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIcontainerWaitLibpodRequest containerWaitLibpod(String name) {
        return new APIcontainerWaitLibpodRequest(name);
    }
    private okhttp3.Call containersStatsAllLibpodCall(List<String> containers, Boolean stream, Integer interval, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/libpod/containers/stats";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (containers != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "containers", containers));
        }

        if (stream != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("stream", stream));
        }

        if (interval != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("interval", interval));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call containersStatsAllLibpodValidateBeforeCall(List<String> containers, Boolean stream, Integer interval, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = containersStatsAllLibpodCall(containers, stream, interval, _callback);
        return localVarCall;

    }


    private ApiResponse<ContainerStats> containersStatsAllLibpodWithHttpInfo(List<String> containers, Boolean stream, Integer interval) throws ApiException {
        okhttp3.Call localVarCall = containersStatsAllLibpodValidateBeforeCall(containers, stream, interval, null);
        Type localVarReturnType = new TypeToken<ContainerStats>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call containersStatsAllLibpodAsync(List<String> containers, Boolean stream, Integer interval, final ApiCallback<ContainerStats> _callback) throws ApiException {

        okhttp3.Call localVarCall = containersStatsAllLibpodValidateBeforeCall(containers, stream, interval, _callback);
        Type localVarReturnType = new TypeToken<ContainerStats>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIcontainersStatsAllLibpodRequest {
        private List<String> containers;
        private Boolean stream;
        private Integer interval;

        private APIcontainersStatsAllLibpodRequest() {
        }

        /**
         * Set containers
         * @param containers names or IDs of containers (optional)
         * @return APIcontainersStatsAllLibpodRequest
         */
        public APIcontainersStatsAllLibpodRequest containers(List<String> containers) {
            this.containers = containers;
            return this;
        }

        /**
         * Set stream
         * @param stream Stream the output (optional, default to true)
         * @return APIcontainersStatsAllLibpodRequest
         */
        public APIcontainersStatsAllLibpodRequest stream(Boolean stream) {
            this.stream = stream;
            return this;
        }

        /**
         * Set interval
         * @param interval Time in seconds between stats reports (optional, default to 5)
         * @return APIcontainersStatsAllLibpodRequest
         */
        public APIcontainersStatsAllLibpodRequest interval(Integer interval) {
            this.interval = interval;
            return this;
        }

        /**
         * Build call for containersStatsAllLibpod
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Get stats for one or more containers </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return containersStatsAllLibpodCall(containers, stream, interval, _callback);
        }

        /**
         * Execute containersStatsAllLibpod request
         * @return ContainerStats
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Get stats for one or more containers </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ContainerStats execute() throws ApiException {
            ApiResponse<ContainerStats> localVarResp = containersStatsAllLibpodWithHttpInfo(containers, stream, interval);
            return localVarResp.getData();
        }

        /**
         * Execute containersStatsAllLibpod request with HTTP info returned
         * @return ApiResponse&lt;ContainerStats&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Get stats for one or more containers </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<ContainerStats> executeWithHttpInfo() throws ApiException {
            return containersStatsAllLibpodWithHttpInfo(containers, stream, interval);
        }

        /**
         * Execute containersStatsAllLibpod request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Get stats for one or more containers </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<ContainerStats> _callback) throws ApiException {
            return containersStatsAllLibpodAsync(containers, stream, interval, _callback);
        }
    }

    /**
     * Get stats for one or more containers
     * Return a live stream of resource usage statistics of one or more container. If no container is specified, the statistics of all containers are returned.
     * @return APIcontainersStatsAllLibpodRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Get stats for one or more containers </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIcontainersStatsAllLibpodRequest containersStatsAllLibpod() {
        return new APIcontainersStatsAllLibpodRequest();
    }
    private okhttp3.Call generateKubeLibpodCall(List<String> names, Boolean service, String type, Integer replicas, Boolean noTrunc, Boolean podmanOnly, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/libpod/generate/kube";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (names != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "names", names));
        }

        if (service != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("service", service));
        }

        if (type != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("type", type));
        }

        if (replicas != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("replicas", replicas));
        }

        if (noTrunc != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("noTrunc", noTrunc));
        }

        if (podmanOnly != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("podmanOnly", podmanOnly));
        }

        final String[] localVarAccepts = {
            "text/vnd.yaml", "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call generateKubeLibpodValidateBeforeCall(List<String> names, Boolean service, String type, Integer replicas, Boolean noTrunc, Boolean podmanOnly, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'names' is set
        if (names == null) {
            throw new ApiException("Missing the required parameter 'names' when calling generateKubeLibpod(Async)");
        }
        

        okhttp3.Call localVarCall = generateKubeLibpodCall(names, service, type, replicas, noTrunc, podmanOnly, _callback);
        return localVarCall;

    }


    private ApiResponse<File> generateKubeLibpodWithHttpInfo( @NotNull List<String> names, Boolean service, String type, Integer replicas, Boolean noTrunc, Boolean podmanOnly) throws ApiException {
        okhttp3.Call localVarCall = generateKubeLibpodValidateBeforeCall(names, service, type, replicas, noTrunc, podmanOnly, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call generateKubeLibpodAsync(List<String> names, Boolean service, String type, Integer replicas, Boolean noTrunc, Boolean podmanOnly, final ApiCallback<File> _callback) throws ApiException {

        okhttp3.Call localVarCall = generateKubeLibpodValidateBeforeCall(names, service, type, replicas, noTrunc, podmanOnly, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIgenerateKubeLibpodRequest {
        private final List<String> names;
        private Boolean service;
        private String type;
        private Integer replicas;
        private Boolean noTrunc;
        private Boolean podmanOnly;

        private APIgenerateKubeLibpodRequest(List<String> names) {
            this.names = names;
        }

        /**
         * Set service
         * @param service Generate YAML for a Kubernetes service object. (optional, default to false)
         * @return APIgenerateKubeLibpodRequest
         */
        public APIgenerateKubeLibpodRequest service(Boolean service) {
            this.service = service;
            return this;
        }

        /**
         * Set type
         * @param type Generate YAML for the given Kubernetes kind. (optional, default to pod)
         * @return APIgenerateKubeLibpodRequest
         */
        public APIgenerateKubeLibpodRequest type(String type) {
            this.type = type;
            return this;
        }

        /**
         * Set replicas
         * @param replicas Set the replica number for Deployment kind. (optional, default to 0)
         * @return APIgenerateKubeLibpodRequest
         */
        public APIgenerateKubeLibpodRequest replicas(Integer replicas) {
            this.replicas = replicas;
            return this;
        }

        /**
         * Set noTrunc
         * @param noTrunc don&#39;t truncate annotations to the Kubernetes maximum length of 63 characters (optional, default to false)
         * @return APIgenerateKubeLibpodRequest
         */
        public APIgenerateKubeLibpodRequest noTrunc(Boolean noTrunc) {
            this.noTrunc = noTrunc;
            return this;
        }

        /**
         * Set podmanOnly
         * @param podmanOnly add podman-only reserved annotations in generated YAML file (cannot be used by Kubernetes) (optional, default to false)
         * @return APIgenerateKubeLibpodRequest
         */
        public APIgenerateKubeLibpodRequest podmanOnly(Boolean podmanOnly) {
            this.podmanOnly = podmanOnly;
            return this;
        }

        /**
         * Build call for generateKubeLibpod
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Kubernetes YAML file describing pod </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return generateKubeLibpodCall(names, service, type, replicas, noTrunc, podmanOnly, _callback);
        }

        /**
         * Execute generateKubeLibpod request
         * @return File
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Kubernetes YAML file describing pod </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public File execute() throws ApiException {
            ApiResponse<File> localVarResp = generateKubeLibpodWithHttpInfo(names, service, type, replicas, noTrunc, podmanOnly);
            return localVarResp.getData();
        }

        /**
         * Execute generateKubeLibpod request with HTTP info returned
         * @return ApiResponse&lt;File&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Kubernetes YAML file describing pod </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<File> executeWithHttpInfo() throws ApiException {
            return generateKubeLibpodWithHttpInfo(names, service, type, replicas, noTrunc, podmanOnly);
        }

        /**
         * Execute generateKubeLibpod request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Kubernetes YAML file describing pod </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<File> _callback) throws ApiException {
            return generateKubeLibpodAsync(names, service, type, replicas, noTrunc, podmanOnly, _callback);
        }
    }

    /**
     * Generate a Kubernetes YAML file.
     * Generate Kubernetes YAML based on a pod or container.
     * @param names Name or ID of the container or pod. (required)
     * @return APIgenerateKubeLibpodRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Kubernetes YAML file describing pod </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIgenerateKubeLibpodRequest generateKubeLibpod(List<String> names) {
        return new APIgenerateKubeLibpodRequest(names);
    }
    private okhttp3.Call generateSystemdLibpodCall(String name, Boolean useName, Boolean _new, Boolean noHeader, Integer startTimeout, Integer stopTimeout, String restartPolicy, String containerPrefix, String podPrefix, String separator, Integer restartSec, List<String> wants, List<String> after, List<String> requires, List<String> additionalEnvVariables, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/libpod/generate/{name}/systemd"
            .replaceAll("\\{" + "name" + "\\}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (useName != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("useName", useName));
        }

        if (_new != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("new", _new));
        }

        if (noHeader != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("noHeader", noHeader));
        }

        if (startTimeout != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("startTimeout", startTimeout));
        }

        if (stopTimeout != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("stopTimeout", stopTimeout));
        }

        if (restartPolicy != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("restartPolicy", restartPolicy));
        }

        if (containerPrefix != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("containerPrefix", containerPrefix));
        }

        if (podPrefix != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("podPrefix", podPrefix));
        }

        if (separator != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("separator", separator));
        }

        if (restartSec != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("restartSec", restartSec));
        }

        if (wants != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "wants", wants));
        }

        if (after != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "after", after));
        }

        if (requires != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "requires", requires));
        }

        if (additionalEnvVariables != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "additionalEnvVariables", additionalEnvVariables));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call generateSystemdLibpodValidateBeforeCall(String name, Boolean useName, Boolean _new, Boolean noHeader, Integer startTimeout, Integer stopTimeout, String restartPolicy, String containerPrefix, String podPrefix, String separator, Integer restartSec, List<String> wants, List<String> after, List<String> requires, List<String> additionalEnvVariables, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling generateSystemdLibpod(Async)");
        }
        

        okhttp3.Call localVarCall = generateSystemdLibpodCall(name, useName, _new, noHeader, startTimeout, stopTimeout, restartPolicy, containerPrefix, podPrefix, separator, restartSec, wants, after, requires, additionalEnvVariables, _callback);
        return localVarCall;

    }


    private ApiResponse<Map<String, String>> generateSystemdLibpodWithHttpInfo( @NotNull String name, Boolean useName, Boolean _new, Boolean noHeader, Integer startTimeout, Integer stopTimeout, String restartPolicy, String containerPrefix, String podPrefix, String separator, Integer restartSec, List<String> wants, List<String> after, List<String> requires, List<String> additionalEnvVariables) throws ApiException {
        okhttp3.Call localVarCall = generateSystemdLibpodValidateBeforeCall(name, useName, _new, noHeader, startTimeout, stopTimeout, restartPolicy, containerPrefix, podPrefix, separator, restartSec, wants, after, requires, additionalEnvVariables, null);
        Type localVarReturnType = new TypeToken<Map<String, String>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call generateSystemdLibpodAsync(String name, Boolean useName, Boolean _new, Boolean noHeader, Integer startTimeout, Integer stopTimeout, String restartPolicy, String containerPrefix, String podPrefix, String separator, Integer restartSec, List<String> wants, List<String> after, List<String> requires, List<String> additionalEnvVariables, final ApiCallback<Map<String, String>> _callback) throws ApiException {

        okhttp3.Call localVarCall = generateSystemdLibpodValidateBeforeCall(name, useName, _new, noHeader, startTimeout, stopTimeout, restartPolicy, containerPrefix, podPrefix, separator, restartSec, wants, after, requires, additionalEnvVariables, _callback);
        Type localVarReturnType = new TypeToken<Map<String, String>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIgenerateSystemdLibpodRequest {
        private final String name;
        private Boolean useName;
        private Boolean _new;
        private Boolean noHeader;
        private Integer startTimeout;
        private Integer stopTimeout;
        private String restartPolicy;
        private String containerPrefix;
        private String podPrefix;
        private String separator;
        private Integer restartSec;
        private List<String> wants;
        private List<String> after;
        private List<String> requires;
        private List<String> additionalEnvVariables;

        private APIgenerateSystemdLibpodRequest(String name) {
            this.name = name;
        }

        /**
         * Set useName
         * @param useName Use container/pod names instead of IDs. (optional, default to false)
         * @return APIgenerateSystemdLibpodRequest
         */
        public APIgenerateSystemdLibpodRequest useName(Boolean useName) {
            this.useName = useName;
            return this;
        }

        /**
         * Set _new
         * @param _new Create a new container instead of starting an existing one. (optional, default to false)
         * @return APIgenerateSystemdLibpodRequest
         */
        public APIgenerateSystemdLibpodRequest _new(Boolean _new) {
            this._new = _new;
            return this;
        }

        /**
         * Set noHeader
         * @param noHeader Do not generate the header including the Podman version and the timestamp. (optional, default to false)
         * @return APIgenerateSystemdLibpodRequest
         */
        public APIgenerateSystemdLibpodRequest noHeader(Boolean noHeader) {
            this.noHeader = noHeader;
            return this;
        }

        /**
         * Set startTimeout
         * @param startTimeout Start timeout in seconds. (optional, default to 0)
         * @return APIgenerateSystemdLibpodRequest
         */
        public APIgenerateSystemdLibpodRequest startTimeout(Integer startTimeout) {
            this.startTimeout = startTimeout;
            return this;
        }

        /**
         * Set stopTimeout
         * @param stopTimeout Stop timeout in seconds. (optional, default to 10)
         * @return APIgenerateSystemdLibpodRequest
         */
        public APIgenerateSystemdLibpodRequest stopTimeout(Integer stopTimeout) {
            this.stopTimeout = stopTimeout;
            return this;
        }

        /**
         * Set restartPolicy
         * @param restartPolicy Systemd restart-policy. (optional, default to on-failure)
         * @return APIgenerateSystemdLibpodRequest
         */
        public APIgenerateSystemdLibpodRequest restartPolicy(String restartPolicy) {
            this.restartPolicy = restartPolicy;
            return this;
        }

        /**
         * Set containerPrefix
         * @param containerPrefix Systemd unit name prefix for containers. (optional, default to container)
         * @return APIgenerateSystemdLibpodRequest
         */
        public APIgenerateSystemdLibpodRequest containerPrefix(String containerPrefix) {
            this.containerPrefix = containerPrefix;
            return this;
        }

        /**
         * Set podPrefix
         * @param podPrefix Systemd unit name prefix for pods. (optional, default to pod)
         * @return APIgenerateSystemdLibpodRequest
         */
        public APIgenerateSystemdLibpodRequest podPrefix(String podPrefix) {
            this.podPrefix = podPrefix;
            return this;
        }

        /**
         * Set separator
         * @param separator Systemd unit name separator between name/id and prefix. (optional, default to -)
         * @return APIgenerateSystemdLibpodRequest
         */
        public APIgenerateSystemdLibpodRequest separator(String separator) {
            this.separator = separator;
            return this;
        }

        /**
         * Set restartSec
         * @param restartSec Configures the time to sleep before restarting a service. (optional, default to 0)
         * @return APIgenerateSystemdLibpodRequest
         */
        public APIgenerateSystemdLibpodRequest restartSec(Integer restartSec) {
            this.restartSec = restartSec;
            return this;
        }

        /**
         * Set wants
         * @param wants Systemd Wants list for the container or pods. (optional)
         * @return APIgenerateSystemdLibpodRequest
         */
        public APIgenerateSystemdLibpodRequest wants(List<String> wants) {
            this.wants = wants;
            return this;
        }

        /**
         * Set after
         * @param after Systemd After list for the container or pods. (optional)
         * @return APIgenerateSystemdLibpodRequest
         */
        public APIgenerateSystemdLibpodRequest after(List<String> after) {
            this.after = after;
            return this;
        }

        /**
         * Set requires
         * @param requires Systemd Requires list for the container or pods. (optional)
         * @return APIgenerateSystemdLibpodRequest
         */
        public APIgenerateSystemdLibpodRequest requires(List<String> requires) {
            this.requires = requires;
            return this;
        }

        /**
         * Set additionalEnvVariables
         * @param additionalEnvVariables Set environment variables to the systemd unit files. (optional)
         * @return APIgenerateSystemdLibpodRequest
         */
        public APIgenerateSystemdLibpodRequest additionalEnvVariables(List<String> additionalEnvVariables) {
            this.additionalEnvVariables = additionalEnvVariables;
            return this;
        }

        /**
         * Build call for generateSystemdLibpod
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return generateSystemdLibpodCall(name, useName, _new, noHeader, startTimeout, stopTimeout, restartPolicy, containerPrefix, podPrefix, separator, restartSec, wants, after, requires, additionalEnvVariables, _callback);
        }

        /**
         * Execute generateSystemdLibpod request
         * @return Map&lt;String, String&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public Map<String, String> execute() throws ApiException {
            ApiResponse<Map<String, String>> localVarResp = generateSystemdLibpodWithHttpInfo(name, useName, _new, noHeader, startTimeout, stopTimeout, restartPolicy, containerPrefix, podPrefix, separator, restartSec, wants, after, requires, additionalEnvVariables);
            return localVarResp.getData();
        }

        /**
         * Execute generateSystemdLibpod request with HTTP info returned
         * @return ApiResponse&lt;Map&lt;String, String&gt;&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<Map<String, String>> executeWithHttpInfo() throws ApiException {
            return generateSystemdLibpodWithHttpInfo(name, useName, _new, noHeader, startTimeout, stopTimeout, restartPolicy, containerPrefix, podPrefix, separator, restartSec, wants, after, requires, additionalEnvVariables);
        }

        /**
         * Execute generateSystemdLibpod request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<Map<String, String>> _callback) throws ApiException {
            return generateSystemdLibpodAsync(name, useName, _new, noHeader, startTimeout, stopTimeout, restartPolicy, containerPrefix, podPrefix, separator, restartSec, wants, after, requires, additionalEnvVariables, _callback);
        }
    }

    /**
     * Generate Systemd Units
     * Generate Systemd Units based on a pod or container.
     * @param name Name or ID of the container or pod. (required)
     * @return APIgenerateSystemdLibpodRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> no error </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIgenerateSystemdLibpodRequest generateSystemdLibpod(String name) {
        return new APIgenerateSystemdLibpodRequest(name);
    }
    private okhttp3.Call imageCommitLibpodCall(String container, String author, List<String> changes, String comment, String format, Boolean pause, Boolean squash, String repo, Boolean stream, String tag, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/libpod/commit";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (container != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("container", container));
        }

        if (author != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("author", author));
        }

        if (changes != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "changes", changes));
        }

        if (comment != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("comment", comment));
        }

        if (format != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("format", format));
        }

        if (pause != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("pause", pause));
        }

        if (squash != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("squash", squash));
        }

        if (repo != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("repo", repo));
        }

        if (stream != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("stream", stream));
        }

        if (tag != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("tag", tag));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call imageCommitLibpodValidateBeforeCall(String container, String author, List<String> changes, String comment, String format, Boolean pause, Boolean squash, String repo, Boolean stream, String tag, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'container' is set
        if (container == null) {
            throw new ApiException("Missing the required parameter 'container' when calling imageCommitLibpod(Async)");
        }
        

        okhttp3.Call localVarCall = imageCommitLibpodCall(container, author, changes, comment, format, pause, squash, repo, stream, tag, _callback);
        return localVarCall;

    }


    private ApiResponse<Void> imageCommitLibpodWithHttpInfo( @NotNull String container, String author, List<String> changes, String comment, String format, Boolean pause, Boolean squash, String repo, Boolean stream, String tag) throws ApiException {
        okhttp3.Call localVarCall = imageCommitLibpodValidateBeforeCall(container, author, changes, comment, format, pause, squash, repo, stream, tag, null);
        return localVarApiClient.execute(localVarCall);
    }

    private okhttp3.Call imageCommitLibpodAsync(String container, String author, List<String> changes, String comment, String format, Boolean pause, Boolean squash, String repo, Boolean stream, String tag, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = imageCommitLibpodValidateBeforeCall(container, author, changes, comment, format, pause, squash, repo, stream, tag, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public class APIimageCommitLibpodRequest {
        private final String container;
        private String author;
        private List<String> changes;
        private String comment;
        private String format;
        private Boolean pause;
        private Boolean squash;
        private String repo;
        private Boolean stream;
        private String tag;

        private APIimageCommitLibpodRequest(String container) {
            this.container = container;
        }

        /**
         * Set author
         * @param author author of the image (optional)
         * @return APIimageCommitLibpodRequest
         */
        public APIimageCommitLibpodRequest author(String author) {
            this.author = author;
            return this;
        }

        /**
         * Set changes
         * @param changes instructions to apply while committing in Dockerfile format (i.e. \&quot;CMD&#x3D;/bin/foo\&quot;) (optional)
         * @return APIimageCommitLibpodRequest
         */
        public APIimageCommitLibpodRequest changes(List<String> changes) {
            this.changes = changes;
            return this;
        }

        /**
         * Set comment
         * @param comment commit message (optional)
         * @return APIimageCommitLibpodRequest
         */
        public APIimageCommitLibpodRequest comment(String comment) {
            this.comment = comment;
            return this;
        }

        /**
         * Set format
         * @param format format of the image manifest and metadata (default \&quot;oci\&quot;) (optional)
         * @return APIimageCommitLibpodRequest
         */
        public APIimageCommitLibpodRequest format(String format) {
            this.format = format;
            return this;
        }

        /**
         * Set pause
         * @param pause pause the container before committing it (optional)
         * @return APIimageCommitLibpodRequest
         */
        public APIimageCommitLibpodRequest pause(Boolean pause) {
            this.pause = pause;
            return this;
        }

        /**
         * Set squash
         * @param squash squash the container before committing it (optional)
         * @return APIimageCommitLibpodRequest
         */
        public APIimageCommitLibpodRequest squash(Boolean squash) {
            this.squash = squash;
            return this;
        }

        /**
         * Set repo
         * @param repo the repository name for the created image (optional)
         * @return APIimageCommitLibpodRequest
         */
        public APIimageCommitLibpodRequest repo(String repo) {
            this.repo = repo;
            return this;
        }

        /**
         * Set stream
         * @param stream output from commit process (optional)
         * @return APIimageCommitLibpodRequest
         */
        public APIimageCommitLibpodRequest stream(Boolean stream) {
            this.stream = stream;
            return this;
        }

        /**
         * Set tag
         * @param tag tag name for the created image (optional)
         * @return APIimageCommitLibpodRequest
         */
        public APIimageCommitLibpodRequest tag(String tag) {
            this.tag = tag;
            return this;
        }

        /**
         * Build call for imageCommitLibpod
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 201 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such image </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return imageCommitLibpodCall(container, author, changes, comment, format, pause, squash, repo, stream, tag, _callback);
        }

        /**
         * Execute imageCommitLibpod request
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 201 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such image </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public void execute() throws ApiException {
            imageCommitLibpodWithHttpInfo(container, author, changes, comment, format, pause, squash, repo, stream, tag);
        }

        /**
         * Execute imageCommitLibpod request with HTTP info returned
         * @return ApiResponse&lt;Void&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 201 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such image </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return imageCommitLibpodWithHttpInfo(container, author, changes, comment, format, pause, squash, repo, stream, tag);
        }

        /**
         * Execute imageCommitLibpod request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 201 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such image </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<Void> _callback) throws ApiException {
            return imageCommitLibpodAsync(container, author, changes, comment, format, pause, squash, repo, stream, tag, _callback);
        }
    }

    /**
     * Commit
     * Create a new image from a container
     * @param container the name or ID of a container (required)
     * @return APIimageCommitLibpodRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> no error </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No such image </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIimageCommitLibpodRequest imageCommitLibpod(String container) {
        return new APIimageCommitLibpodRequest(container);
    }
    private okhttp3.Call kubeApplyLibpodCall(String caCertFile, String kubeConfig, String namespace, Boolean service, String _file, String request, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = request;

        // create path and map variables
        String localVarPath = "/libpod/kube/apply";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (caCertFile != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("caCertFile", caCertFile));
        }

        if (kubeConfig != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("kubeConfig", kubeConfig));
        }

        if (namespace != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("namespace", namespace));
        }

        if (service != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("service", service));
        }

        if (_file != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("file", _file));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json", "application/x-tar"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call kubeApplyLibpodValidateBeforeCall(String caCertFile, String kubeConfig, String namespace, Boolean service, String _file, String request, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = kubeApplyLibpodCall(caCertFile, kubeConfig, namespace, service, _file, request, _callback);
        return localVarCall;

    }


    private ApiResponse<File> kubeApplyLibpodWithHttpInfo(String caCertFile, String kubeConfig, String namespace, Boolean service, String _file, String request) throws ApiException {
        okhttp3.Call localVarCall = kubeApplyLibpodValidateBeforeCall(caCertFile, kubeConfig, namespace, service, _file, request, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call kubeApplyLibpodAsync(String caCertFile, String kubeConfig, String namespace, Boolean service, String _file, String request, final ApiCallback<File> _callback) throws ApiException {

        okhttp3.Call localVarCall = kubeApplyLibpodValidateBeforeCall(caCertFile, kubeConfig, namespace, service, _file, request, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIkubeApplyLibpodRequest {
        private String caCertFile;
        private String kubeConfig;
        private String namespace;
        private Boolean service;
        private String _file;
        private String request;

        private APIkubeApplyLibpodRequest() {
        }

        /**
         * Set caCertFile
         * @param caCertFile Path to the CA cert file for the Kubernetes cluster. (optional)
         * @return APIkubeApplyLibpodRequest
         */
        public APIkubeApplyLibpodRequest caCertFile(String caCertFile) {
            this.caCertFile = caCertFile;
            return this;
        }

        /**
         * Set kubeConfig
         * @param kubeConfig Path to the kubeconfig file for the Kubernetes cluster. (optional)
         * @return APIkubeApplyLibpodRequest
         */
        public APIkubeApplyLibpodRequest kubeConfig(String kubeConfig) {
            this.kubeConfig = kubeConfig;
            return this;
        }

        /**
         * Set namespace
         * @param namespace The namespace to deploy the workload to on the Kubernetes cluster. (optional)
         * @return APIkubeApplyLibpodRequest
         */
        public APIkubeApplyLibpodRequest namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        /**
         * Set service
         * @param service Create a service object for the container being deployed. (optional)
         * @return APIkubeApplyLibpodRequest
         */
        public APIkubeApplyLibpodRequest service(Boolean service) {
            this.service = service;
            return this;
        }

        /**
         * Set _file
         * @param _file Path to the Kubernetes yaml file to deploy. (optional)
         * @return APIkubeApplyLibpodRequest
         */
        public APIkubeApplyLibpodRequest _file(String _file) {
            this._file = _file;
            return this;
        }

        /**
         * Set request
         * @param request Kubernetes YAML file. (optional)
         * @return APIkubeApplyLibpodRequest
         */
        public APIkubeApplyLibpodRequest request(String request) {
            this.request = request;
            return this;
        }

        /**
         * Build call for kubeApplyLibpod
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Kubernetes YAML file successfully deployed to cluster </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return kubeApplyLibpodCall(caCertFile, kubeConfig, namespace, service, _file, request, _callback);
        }

        /**
         * Execute kubeApplyLibpod request
         * @return File
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Kubernetes YAML file successfully deployed to cluster </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public File execute() throws ApiException {
            ApiResponse<File> localVarResp = kubeApplyLibpodWithHttpInfo(caCertFile, kubeConfig, namespace, service, _file, request);
            return localVarResp.getData();
        }

        /**
         * Execute kubeApplyLibpod request with HTTP info returned
         * @return ApiResponse&lt;File&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Kubernetes YAML file successfully deployed to cluster </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<File> executeWithHttpInfo() throws ApiException {
            return kubeApplyLibpodWithHttpInfo(caCertFile, kubeConfig, namespace, service, _file, request);
        }

        /**
         * Execute kubeApplyLibpod request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Kubernetes YAML file successfully deployed to cluster </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<File> _callback) throws ApiException {
            return kubeApplyLibpodAsync(caCertFile, kubeConfig, namespace, service, _file, request, _callback);
        }
    }

    /**
     * Apply a podman workload or Kubernetes YAML file.
     * Deploy a podman container, pod, volume, or Kubernetes yaml to a Kubernetes cluster.
     * @return APIkubeApplyLibpodRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Kubernetes YAML file successfully deployed to cluster </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIkubeApplyLibpodRequest kubeApplyLibpod() {
        return new APIkubeApplyLibpodRequest();
    }
    private okhttp3.Call playKubeDownLibpodCall(String contentType, Boolean force, String request, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = request;

        // create path and map variables
        String localVarPath = "/libpod/play/kube";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (force != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("force", force));
        }

        if (contentType != null) {
            localVarHeaderParams.put("Content-Type", localVarApiClient.parameterToString(contentType));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json", "application/x-tar"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call playKubeDownLibpodValidateBeforeCall(String contentType, Boolean force, String request, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = playKubeDownLibpodCall(contentType, force, request, _callback);
        return localVarCall;

    }


    private ApiResponse<PlayKubeReport> playKubeDownLibpodWithHttpInfo(String contentType, Boolean force, String request) throws ApiException {
        okhttp3.Call localVarCall = playKubeDownLibpodValidateBeforeCall(contentType, force, request, null);
        Type localVarReturnType = new TypeToken<PlayKubeReport>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call playKubeDownLibpodAsync(String contentType, Boolean force, String request, final ApiCallback<PlayKubeReport> _callback) throws ApiException {

        okhttp3.Call localVarCall = playKubeDownLibpodValidateBeforeCall(contentType, force, request, _callback);
        Type localVarReturnType = new TypeToken<PlayKubeReport>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIplayKubeDownLibpodRequest {
        private String contentType;
        private Boolean force;
        private String request;

        private APIplayKubeDownLibpodRequest() {
        }

        /**
         * Set contentType
         * @param contentType  (optional, default to plain/text)
         * @return APIplayKubeDownLibpodRequest
         */
        public APIplayKubeDownLibpodRequest contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        /**
         * Set force
         * @param force Remove volumes. (optional, default to false)
         * @return APIplayKubeDownLibpodRequest
         */
        public APIplayKubeDownLibpodRequest force(Boolean force) {
            this.force = force;
            return this;
        }

        /**
         * Set request
         * @param request Kubernetes YAML file. (optional)
         * @return APIplayKubeDownLibpodRequest
         */
        public APIplayKubeDownLibpodRequest request(String request) {
            this.request = request;
            return this;
        }

        /**
         * Build call for playKubeDownLibpod
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> PlayKube response </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return playKubeDownLibpodCall(contentType, force, request, _callback);
        }

        /**
         * Execute playKubeDownLibpod request
         * @return PlayKubeReport
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> PlayKube response </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public PlayKubeReport execute() throws ApiException {
            ApiResponse<PlayKubeReport> localVarResp = playKubeDownLibpodWithHttpInfo(contentType, force, request);
            return localVarResp.getData();
        }

        /**
         * Execute playKubeDownLibpod request with HTTP info returned
         * @return ApiResponse&lt;PlayKubeReport&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> PlayKube response </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<PlayKubeReport> executeWithHttpInfo() throws ApiException {
            return playKubeDownLibpodWithHttpInfo(contentType, force, request);
        }

        /**
         * Execute playKubeDownLibpod request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> PlayKube response </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<PlayKubeReport> _callback) throws ApiException {
            return playKubeDownLibpodAsync(contentType, force, request, _callback);
        }
    }

    /**
     * Remove resources created from kube play
     * Tears down pods, secrets, and volumes defined in a YAML file
     * @return APIplayKubeDownLibpodRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> PlayKube response </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIplayKubeDownLibpodRequest playKubeDownLibpod() {
        return new APIplayKubeDownLibpodRequest();
    }
    private okhttp3.Call playKubeLibpodCall(String contentType, String annotations, String logDriver, List<String> logOptions, List<String> network, Boolean noHosts, Boolean noTrunc, List<String> publishPorts, Boolean publishAllPorts, Boolean replace, Boolean serviceContainer, Boolean start, List<String> staticIPs, List<String> staticMACs, Boolean tlsVerify, String userns, Boolean wait, Boolean build, String request, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = request;

        // create path and map variables
        String localVarPath = "/libpod/play/kube";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (annotations != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("annotations", annotations));
        }

        if (logDriver != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("logDriver", logDriver));
        }

        if (logOptions != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "logOptions", logOptions));
        }

        if (network != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "network", network));
        }

        if (noHosts != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("noHosts", noHosts));
        }

        if (noTrunc != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("noTrunc", noTrunc));
        }

        if (publishPorts != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "publishPorts", publishPorts));
        }

        if (publishAllPorts != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("publishAllPorts", publishAllPorts));
        }

        if (replace != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("replace", replace));
        }

        if (serviceContainer != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("serviceContainer", serviceContainer));
        }

        if (start != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("start", start));
        }

        if (staticIPs != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "staticIPs", staticIPs));
        }

        if (staticMACs != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "staticMACs", staticMACs));
        }

        if (tlsVerify != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("tlsVerify", tlsVerify));
        }

        if (userns != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("userns", userns));
        }

        if (wait != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("wait", wait));
        }

        if (build != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("build", build));
        }

        if (contentType != null) {
            localVarHeaderParams.put("Content-Type", localVarApiClient.parameterToString(contentType));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json", "application/x-tar"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call playKubeLibpodValidateBeforeCall(String contentType, String annotations, String logDriver, List<String> logOptions, List<String> network, Boolean noHosts, Boolean noTrunc, List<String> publishPorts, Boolean publishAllPorts, Boolean replace, Boolean serviceContainer, Boolean start, List<String> staticIPs, List<String> staticMACs, Boolean tlsVerify, String userns, Boolean wait, Boolean build, String request, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = playKubeLibpodCall(contentType, annotations, logDriver, logOptions, network, noHosts, noTrunc, publishPorts, publishAllPorts, replace, serviceContainer, start, staticIPs, staticMACs, tlsVerify, userns, wait, build, request, _callback);
        return localVarCall;

    }


    private ApiResponse<PlayKubeReport> playKubeLibpodWithHttpInfo(String contentType, String annotations, String logDriver, List<String> logOptions, List<String> network, Boolean noHosts, Boolean noTrunc, List<String> publishPorts, Boolean publishAllPorts, Boolean replace, Boolean serviceContainer, Boolean start, List<String> staticIPs, List<String> staticMACs, Boolean tlsVerify, String userns, Boolean wait, Boolean build, String request) throws ApiException {
        okhttp3.Call localVarCall = playKubeLibpodValidateBeforeCall(contentType, annotations, logDriver, logOptions, network, noHosts, noTrunc, publishPorts, publishAllPorts, replace, serviceContainer, start, staticIPs, staticMACs, tlsVerify, userns, wait, build, request, null);
        Type localVarReturnType = new TypeToken<PlayKubeReport>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call playKubeLibpodAsync(String contentType, String annotations, String logDriver, List<String> logOptions, List<String> network, Boolean noHosts, Boolean noTrunc, List<String> publishPorts, Boolean publishAllPorts, Boolean replace, Boolean serviceContainer, Boolean start, List<String> staticIPs, List<String> staticMACs, Boolean tlsVerify, String userns, Boolean wait, Boolean build, String request, final ApiCallback<PlayKubeReport> _callback) throws ApiException {

        okhttp3.Call localVarCall = playKubeLibpodValidateBeforeCall(contentType, annotations, logDriver, logOptions, network, noHosts, noTrunc, publishPorts, publishAllPorts, replace, serviceContainer, start, staticIPs, staticMACs, tlsVerify, userns, wait, build, request, _callback);
        Type localVarReturnType = new TypeToken<PlayKubeReport>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIplayKubeLibpodRequest {
        private String contentType;
        private String annotations;
        private String logDriver;
        private List<String> logOptions;
        private List<String> network;
        private Boolean noHosts;
        private Boolean noTrunc;
        private List<String> publishPorts;
        private Boolean publishAllPorts;
        private Boolean replace;
        private Boolean serviceContainer;
        private Boolean start;
        private List<String> staticIPs;
        private List<String> staticMACs;
        private Boolean tlsVerify;
        private String userns;
        private Boolean wait;
        private Boolean build;
        private String request;

        private APIplayKubeLibpodRequest() {
        }

        /**
         * Set contentType
         * @param contentType  (optional, default to plain/text)
         * @return APIplayKubeLibpodRequest
         */
        public APIplayKubeLibpodRequest contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        /**
         * Set annotations
         * @param annotations JSON encoded value of annotations (a map[string]string). (optional)
         * @return APIplayKubeLibpodRequest
         */
        public APIplayKubeLibpodRequest annotations(String annotations) {
            this.annotations = annotations;
            return this;
        }

        /**
         * Set logDriver
         * @param logDriver Logging driver for the containers in the pod. (optional)
         * @return APIplayKubeLibpodRequest
         */
        public APIplayKubeLibpodRequest logDriver(String logDriver) {
            this.logDriver = logDriver;
            return this;
        }

        /**
         * Set logOptions
         * @param logOptions logging driver options (optional)
         * @return APIplayKubeLibpodRequest
         */
        public APIplayKubeLibpodRequest logOptions(List<String> logOptions) {
            this.logOptions = logOptions;
            return this;
        }

        /**
         * Set network
         * @param network USe the network mode or specify an array of networks. (optional)
         * @return APIplayKubeLibpodRequest
         */
        public APIplayKubeLibpodRequest network(List<String> network) {
            this.network = network;
            return this;
        }

        /**
         * Set noHosts
         * @param noHosts do not setup /etc/hosts file in container (optional, default to false)
         * @return APIplayKubeLibpodRequest
         */
        public APIplayKubeLibpodRequest noHosts(Boolean noHosts) {
            this.noHosts = noHosts;
            return this;
        }

        /**
         * Set noTrunc
         * @param noTrunc use annotations that are not truncated to the Kubernetes maximum length of 63 characters (optional, default to false)
         * @return APIplayKubeLibpodRequest
         */
        public APIplayKubeLibpodRequest noTrunc(Boolean noTrunc) {
            this.noTrunc = noTrunc;
            return this;
        }

        /**
         * Set publishPorts
         * @param publishPorts publish a container&#39;s port, or a range of ports, to the host (optional)
         * @return APIplayKubeLibpodRequest
         */
        public APIplayKubeLibpodRequest publishPorts(List<String> publishPorts) {
            this.publishPorts = publishPorts;
            return this;
        }

        /**
         * Set publishAllPorts
         * @param publishAllPorts Whether to publish all ports defined in the K8S YAML file (containerPort, hostPort), if false only hostPort will be published (optional)
         * @return APIplayKubeLibpodRequest
         */
        public APIplayKubeLibpodRequest publishAllPorts(Boolean publishAllPorts) {
            this.publishAllPorts = publishAllPorts;
            return this;
        }

        /**
         * Set replace
         * @param replace replace existing pods and containers (optional, default to false)
         * @return APIplayKubeLibpodRequest
         */
        public APIplayKubeLibpodRequest replace(Boolean replace) {
            this.replace = replace;
            return this;
        }

        /**
         * Set serviceContainer
         * @param serviceContainer Starts a service container before all pods. (optional, default to false)
         * @return APIplayKubeLibpodRequest
         */
        public APIplayKubeLibpodRequest serviceContainer(Boolean serviceContainer) {
            this.serviceContainer = serviceContainer;
            return this;
        }

        /**
         * Set start
         * @param start Start the pod after creating it. (optional, default to true)
         * @return APIplayKubeLibpodRequest
         */
        public APIplayKubeLibpodRequest start(Boolean start) {
            this.start = start;
            return this;
        }

        /**
         * Set staticIPs
         * @param staticIPs Static IPs used for the pods. (optional)
         * @return APIplayKubeLibpodRequest
         */
        public APIplayKubeLibpodRequest staticIPs(List<String> staticIPs) {
            this.staticIPs = staticIPs;
            return this;
        }

        /**
         * Set staticMACs
         * @param staticMACs Static MACs used for the pods. (optional)
         * @return APIplayKubeLibpodRequest
         */
        public APIplayKubeLibpodRequest staticMACs(List<String> staticMACs) {
            this.staticMACs = staticMACs;
            return this;
        }

        /**
         * Set tlsVerify
         * @param tlsVerify Require HTTPS and verify signatures when contacting registries. (optional, default to true)
         * @return APIplayKubeLibpodRequest
         */
        public APIplayKubeLibpodRequest tlsVerify(Boolean tlsVerify) {
            this.tlsVerify = tlsVerify;
            return this;
        }

        /**
         * Set userns
         * @param userns Set the user namespace mode for the pods. (optional)
         * @return APIplayKubeLibpodRequest
         */
        public APIplayKubeLibpodRequest userns(String userns) {
            this.userns = userns;
            return this;
        }

        /**
         * Set wait
         * @param wait Clean up all objects created when a SIGTERM is received or pods exit. (optional, default to false)
         * @return APIplayKubeLibpodRequest
         */
        public APIplayKubeLibpodRequest wait(Boolean wait) {
            this.wait = wait;
            return this;
        }

        /**
         * Set build
         * @param build Build the images with corresponding context. (optional)
         * @return APIplayKubeLibpodRequest
         */
        public APIplayKubeLibpodRequest build(Boolean build) {
            this.build = build;
            return this;
        }

        /**
         * Set request
         * @param request Kubernetes YAML file. (optional)
         * @return APIplayKubeLibpodRequest
         */
        public APIplayKubeLibpodRequest request(String request) {
            this.request = request;
            return this;
        }

        /**
         * Build call for playKubeLibpod
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> PlayKube response </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return playKubeLibpodCall(contentType, annotations, logDriver, logOptions, network, noHosts, noTrunc, publishPorts, publishAllPorts, replace, serviceContainer, start, staticIPs, staticMACs, tlsVerify, userns, wait, build, request, _callback);
        }

        /**
         * Execute playKubeLibpod request
         * @return PlayKubeReport
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> PlayKube response </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public PlayKubeReport execute() throws ApiException {
            ApiResponse<PlayKubeReport> localVarResp = playKubeLibpodWithHttpInfo(contentType, annotations, logDriver, logOptions, network, noHosts, noTrunc, publishPorts, publishAllPorts, replace, serviceContainer, start, staticIPs, staticMACs, tlsVerify, userns, wait, build, request);
            return localVarResp.getData();
        }

        /**
         * Execute playKubeLibpod request with HTTP info returned
         * @return ApiResponse&lt;PlayKubeReport&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> PlayKube response </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<PlayKubeReport> executeWithHttpInfo() throws ApiException {
            return playKubeLibpodWithHttpInfo(contentType, annotations, logDriver, logOptions, network, noHosts, noTrunc, publishPorts, publishAllPorts, replace, serviceContainer, start, staticIPs, staticMACs, tlsVerify, userns, wait, build, request);
        }

        /**
         * Execute playKubeLibpod request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> PlayKube response </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<PlayKubeReport> _callback) throws ApiException {
            return playKubeLibpodAsync(contentType, annotations, logDriver, logOptions, network, noHosts, noTrunc, publishPorts, publishAllPorts, replace, serviceContainer, start, staticIPs, staticMACs, tlsVerify, userns, wait, build, request, _callback);
        }
    }

    /**
     * Play a Kubernetes YAML file.
     * Create and run pods based on a Kubernetes YAML file.  ### Content-Type  Then endpoint support two Content-Type  - &#x60;plain/text&#x60; for yaml format  - &#x60;application/x-tar&#x60; for sending context(s) required for building images  #### Tar format  The tar format must contain a &#x60;play.yaml&#x60; file at the root that will be used. If the file format requires context to build an image, it uses the image name and check for corresponding folder.  For example, the client sends a tar file with the following structure:  &#x60;&#x60;&#x60; └── content.tar  ├── play.yaml  └── foobar/      └── Containerfile &#x60;&#x60;&#x60;  The &#x60;play.yaml&#x60; is the following, the &#x60;foobar&#x60; image means we are looking for a context with this name. &#x60;&#x60;&#x60; apiVersion: v1 kind: Pod metadata: name: demo-build-remote spec: containers:  - name: container    image: foobar &#x60;&#x60;&#x60; 
     * @return APIplayKubeLibpodRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> PlayKube response </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIplayKubeLibpodRequest playKubeLibpod() {
        return new APIplayKubeLibpodRequest();
    }
    private okhttp3.Call putContainerArchiveLibpodCall(String name, String path, Boolean pause, String request, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = request;

        // create path and map variables
        String localVarPath = "/libpod/containers/{name}/archive"
            .replaceAll("\\{" + "name" + "\\}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (path != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("path", path));
        }

        if (pause != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("pause", pause));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json", "application/x-tar"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call putContainerArchiveLibpodValidateBeforeCall(String name, String path, Boolean pause, String request, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling putContainerArchiveLibpod(Async)");
        }
        
        // verify the required parameter 'path' is set
        if (path == null) {
            throw new ApiException("Missing the required parameter 'path' when calling putContainerArchiveLibpod(Async)");
        }
        

        okhttp3.Call localVarCall = putContainerArchiveLibpodCall(name, path, pause, request, _callback);
        return localVarCall;

    }


    private ApiResponse<Void> putContainerArchiveLibpodWithHttpInfo( @NotNull String name,  @NotNull String path, Boolean pause, String request) throws ApiException {
        okhttp3.Call localVarCall = putContainerArchiveLibpodValidateBeforeCall(name, path, pause, request, null);
        return localVarApiClient.execute(localVarCall);
    }

    private okhttp3.Call putContainerArchiveLibpodAsync(String name, String path, Boolean pause, String request, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = putContainerArchiveLibpodValidateBeforeCall(name, path, pause, request, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public class APIputContainerArchiveLibpodRequest {
        private final String name;
        private final String path;
        private Boolean pause;
        private String request;

        private APIputContainerArchiveLibpodRequest(String name, String path) {
            this.name = name;
            this.path = path;
        }

        /**
         * Set pause
         * @param pause pause the container while copying (defaults to true) (optional, default to true)
         * @return APIputContainerArchiveLibpodRequest
         */
        public APIputContainerArchiveLibpodRequest pause(Boolean pause) {
            this.pause = pause;
            return this;
        }

        /**
         * Set request
         * @param request tarfile of files to copy into the container (optional)
         * @return APIputContainerArchiveLibpodRequest
         */
        public APIputContainerArchiveLibpodRequest request(String request) {
            this.request = request;
            return this;
        }

        /**
         * Build call for putContainerArchiveLibpod
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 403 </td><td> the container rootfs is read-only </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return putContainerArchiveLibpodCall(name, path, pause, request, _callback);
        }

        /**
         * Execute putContainerArchiveLibpod request
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 403 </td><td> the container rootfs is read-only </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public void execute() throws ApiException {
            putContainerArchiveLibpodWithHttpInfo(name, path, pause, request);
        }

        /**
         * Execute putContainerArchiveLibpod request with HTTP info returned
         * @return ApiResponse&lt;Void&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 403 </td><td> the container rootfs is read-only </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return putContainerArchiveLibpodWithHttpInfo(name, path, pause, request);
        }

        /**
         * Execute putContainerArchiveLibpod request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 403 </td><td> the container rootfs is read-only </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<Void> _callback) throws ApiException {
            return putContainerArchiveLibpodAsync(name, path, pause, request, _callback);
        }
    }

    /**
     * Copy files into a container
     * Copy a tar archive of files into a container
     * @param name container name or id (required)
     * @param path Path to a directory in the container to extract (required)
     * @return APIputContainerArchiveLibpodRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> no error </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> the container rootfs is read-only </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIputContainerArchiveLibpodRequest putContainerArchiveLibpod(String name, String path) {
        return new APIputContainerArchiveLibpodRequest(name, path);
    }
}
