/*
 * supports a RESTful API for the Libpod library
 * This documentation describes the Podman v2.x+ RESTful API. It consists of a Docker-compatible API and a Libpod API providing support for Podman’s unique features such as pods.  To start the service and keep it running for 5,000 seconds (-t 0 runs forever):  podman system service -t 5000 &  You can then use cURL on the socket using requests documented below.  NOTE: if you install the package podman-docker, it will create a symbolic link for /run/docker.sock to /run/podman/podman.sock  NOTE: Some fields in the API response JSON are encoded as omitempty, which means that if said field has a zero value, they will not be encoded in the API response. This is a feature to help reduce the size of the JSON responses returned via the API.  NOTE: Due to the limitations of [go-swagger](https://github.com/go-swagger/go-swagger), some field values that have a complex type show up as null in the docs as well as in the API responses. This is because the zero value for the field type is null. The field description in the docs will state what type the field is expected to be for such cases.  See podman-system-service(1) for more information.  Quick Examples:  'podman info'  curl --unix-socket /run/podman/podman.sock http://d/v5.0.0/libpod/info  'podman pull quay.io/containers/podman'  curl -XPOST --unix-socket /run/podman/podman.sock -v 'http://d/v5.0.0/images/create?fromImage=quay.io%2Fcontainers%2Fpodman'  'podman list images'  curl --unix-socket /run/podman/podman.sock -v 'http://d/v5.0.0/libpod/images/json' | jq
 *
 * The version of the OpenAPI document: 5.0.0
 * Contact: podman@lists.podman.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.github.pod4dev.libpodj.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.io.Serializable;
import javax.validation.constraints.*;
import javax.validation.Valid;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import io.github.pod4dev.libpodj.JSON;

/**
 * Schema2HealthConfig is a HealthConfig, which holds configuration settings for the HEALTHCHECK feature, from docker/docker/api/types/container.
 */
@ApiModel(description = "Schema2HealthConfig is a HealthConfig, which holds configuration settings for the HEALTHCHECK feature, from docker/docker/api/types/container.")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class Schema2HealthConfig implements Serializable {
  private static final long serialVersionUID = 1L;

  public static final String SERIALIZED_NAME_INTERVAL = "Interval";
  @SerializedName(SERIALIZED_NAME_INTERVAL)
  private Long interval;

  public static final String SERIALIZED_NAME_RETRIES = "Retries";
  @SerializedName(SERIALIZED_NAME_RETRIES)
  private Long retries;

  public static final String SERIALIZED_NAME_START_INTERVAL = "StartInterval";
  @SerializedName(SERIALIZED_NAME_START_INTERVAL)
  private Long startInterval;

  public static final String SERIALIZED_NAME_START_PERIOD = "StartPeriod";
  @SerializedName(SERIALIZED_NAME_START_PERIOD)
  private Long startPeriod;

  public static final String SERIALIZED_NAME_TEST = "Test";
  @SerializedName(SERIALIZED_NAME_TEST)
  private List<String> test = null;

  public static final String SERIALIZED_NAME_TIMEOUT = "Timeout";
  @SerializedName(SERIALIZED_NAME_TIMEOUT)
  private Long timeout;

  public Schema2HealthConfig() {
  }

  public Schema2HealthConfig interval(Long interval) {
    
    this.interval = interval;
    return this;
  }

   /**
   * A Duration represents the elapsed time between two instants as an int64 nanosecond count. The representation limits the largest representable duration to approximately 290 years.
   * @return interval
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "A Duration represents the elapsed time between two instants as an int64 nanosecond count. The representation limits the largest representable duration to approximately 290 years.")

  public Long getInterval() {
    return interval;
  }


  public void setInterval(Long interval) {
    this.interval = interval;
  }


  public Schema2HealthConfig retries(Long retries) {
    
    this.retries = retries;
    return this;
  }

   /**
   * Retries is the number of consecutive failures needed to consider a container as unhealthy. Zero means inherit.
   * @return retries
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Retries is the number of consecutive failures needed to consider a container as unhealthy. Zero means inherit.")

  public Long getRetries() {
    return retries;
  }


  public void setRetries(Long retries) {
    this.retries = retries;
  }


  public Schema2HealthConfig startInterval(Long startInterval) {
    
    this.startInterval = startInterval;
    return this;
  }

   /**
   * A Duration represents the elapsed time between two instants as an int64 nanosecond count. The representation limits the largest representable duration to approximately 290 years.
   * @return startInterval
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "A Duration represents the elapsed time between two instants as an int64 nanosecond count. The representation limits the largest representable duration to approximately 290 years.")

  public Long getStartInterval() {
    return startInterval;
  }


  public void setStartInterval(Long startInterval) {
    this.startInterval = startInterval;
  }


  public Schema2HealthConfig startPeriod(Long startPeriod) {
    
    this.startPeriod = startPeriod;
    return this;
  }

   /**
   * A Duration represents the elapsed time between two instants as an int64 nanosecond count. The representation limits the largest representable duration to approximately 290 years.
   * @return startPeriod
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "A Duration represents the elapsed time between two instants as an int64 nanosecond count. The representation limits the largest representable duration to approximately 290 years.")

  public Long getStartPeriod() {
    return startPeriod;
  }


  public void setStartPeriod(Long startPeriod) {
    this.startPeriod = startPeriod;
  }


  public Schema2HealthConfig test(List<String> test) {
    
    this.test = test;
    return this;
  }

  public Schema2HealthConfig addTestItem(String testItem) {
    if (this.test == null) {
      this.test = new ArrayList<>();
    }
    this.test.add(testItem);
    return this;
  }

   /**
   * Test is the test to perform to check that the container is healthy. An empty slice means to inherit the default. The options are: {} : inherit healthcheck {\&quot;NONE\&quot;} : disable healthcheck {\&quot;CMD\&quot;, args...} : exec arguments directly {\&quot;CMD-SHELL\&quot;, command} : run command with system&#39;s default shell
   * @return test
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Test is the test to perform to check that the container is healthy. An empty slice means to inherit the default. The options are: {} : inherit healthcheck {\"NONE\"} : disable healthcheck {\"CMD\", args...} : exec arguments directly {\"CMD-SHELL\", command} : run command with system's default shell")

  public List<String> getTest() {
    return test;
  }


  public void setTest(List<String> test) {
    this.test = test;
  }


  public Schema2HealthConfig timeout(Long timeout) {
    
    this.timeout = timeout;
    return this;
  }

   /**
   * A Duration represents the elapsed time between two instants as an int64 nanosecond count. The representation limits the largest representable duration to approximately 290 years.
   * @return timeout
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "A Duration represents the elapsed time between two instants as an int64 nanosecond count. The representation limits the largest representable duration to approximately 290 years.")

  public Long getTimeout() {
    return timeout;
  }


  public void setTimeout(Long timeout) {
    this.timeout = timeout;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Schema2HealthConfig schema2HealthConfig = (Schema2HealthConfig) o;
    return Objects.equals(this.interval, schema2HealthConfig.interval) &&
        Objects.equals(this.retries, schema2HealthConfig.retries) &&
        Objects.equals(this.startInterval, schema2HealthConfig.startInterval) &&
        Objects.equals(this.startPeriod, schema2HealthConfig.startPeriod) &&
        Objects.equals(this.test, schema2HealthConfig.test) &&
        Objects.equals(this.timeout, schema2HealthConfig.timeout);
  }

  @Override
  public int hashCode() {
    return Objects.hash(interval, retries, startInterval, startPeriod, test, timeout);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Schema2HealthConfig {\n");
    sb.append("    interval: ").append(toIndentedString(interval)).append("\n");
    sb.append("    retries: ").append(toIndentedString(retries)).append("\n");
    sb.append("    startInterval: ").append(toIndentedString(startInterval)).append("\n");
    sb.append("    startPeriod: ").append(toIndentedString(startPeriod)).append("\n");
    sb.append("    test: ").append(toIndentedString(test)).append("\n");
    sb.append("    timeout: ").append(toIndentedString(timeout)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("Interval");
    openapiFields.add("Retries");
    openapiFields.add("StartInterval");
    openapiFields.add("StartPeriod");
    openapiFields.add("Test");
    openapiFields.add("Timeout");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to Schema2HealthConfig
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (Schema2HealthConfig.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in Schema2HealthConfig is not found in the empty JSON string", Schema2HealthConfig.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!Schema2HealthConfig.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `Schema2HealthConfig` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
      }
      // ensure the json data is an array
      if ((jsonObj.get("Test") != null && !jsonObj.get("Test").isJsonNull()) && !jsonObj.get("Test").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `Test` to be an array in the JSON string but got `%s`", jsonObj.get("Test").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!Schema2HealthConfig.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'Schema2HealthConfig' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<Schema2HealthConfig> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(Schema2HealthConfig.class));

       return (TypeAdapter<T>) new TypeAdapter<Schema2HealthConfig>() {
           @Override
           public void write(JsonWriter out, Schema2HealthConfig value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public Schema2HealthConfig read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of Schema2HealthConfig given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of Schema2HealthConfig
  * @throws IOException if the JSON string is invalid with respect to Schema2HealthConfig
  */
  public static Schema2HealthConfig fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, Schema2HealthConfig.class);
  }

 /**
  * Convert an instance of Schema2HealthConfig to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

