/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.libpodj.api;

import com.google.gson.reflect.TypeToken;
import io.github.pod4dev.libpodj.ApiCallback;
import io.github.pod4dev.libpodj.ApiClient;
import io.github.pod4dev.libpodj.ApiException;
import io.github.pod4dev.libpodj.ApiResponse;
import io.github.pod4dev.libpodj.Configuration;
import io.github.pod4dev.libpodj.Pair;
import io.github.pod4dev.libpodj.model.AuthConfig;
import io.github.pod4dev.libpodj.model.AuthReport;
import io.github.pod4dev.libpodj.model.SystemComponentVersion;
import io.github.pod4dev.libpodj.model.SystemDfReport;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class SystemCompatApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public SystemCompatApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SystemCompatApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call systemAuthCall(AuthConfig authConfig, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        AuthConfig localVarPostBody = authConfig;
        String localVarPath = "/auth";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/x-tar"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call systemAuthValidateBeforeCall(AuthConfig authConfig, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.systemAuthCall(authConfig, _callback);
        return localVarCall;
    }

    private ApiResponse<AuthReport> systemAuthWithHttpInfo(AuthConfig authConfig) throws ApiException {
        Call localVarCall = this.systemAuthValidateBeforeCall(authConfig, null);
        Type localVarReturnType = new TypeToken<AuthReport>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call systemAuthAsync(AuthConfig authConfig, ApiCallback<AuthReport> _callback) throws ApiException {
        Call localVarCall = this.systemAuthValidateBeforeCall(authConfig, _callback);
        Type localVarReturnType = new TypeToken<AuthReport>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIsystemAuthRequest systemAuth() {
        return new APIsystemAuthRequest();
    }

    private Call systemDataUsageCall(ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/system/df";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call systemDataUsageValidateBeforeCall(ApiCallback _callback) throws ApiException {
        Call localVarCall = this.systemDataUsageCall(_callback);
        return localVarCall;
    }

    private ApiResponse<SystemDfReport> systemDataUsageWithHttpInfo() throws ApiException {
        Call localVarCall = this.systemDataUsageValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<SystemDfReport>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call systemDataUsageAsync(ApiCallback<SystemDfReport> _callback) throws ApiException {
        Call localVarCall = this.systemDataUsageValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<SystemDfReport>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIsystemDataUsageRequest systemDataUsage() {
        return new APIsystemDataUsageRequest();
    }

    private Call systemEventsCall(String since, String until, String filters, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/events";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (since != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("since", since));
        }
        if (until != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("until", until));
        }
        if (filters != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("filters", filters));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call systemEventsValidateBeforeCall(String since, String until, String filters, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.systemEventsCall(since, until, filters, _callback);
        return localVarCall;
    }

    private ApiResponse<Void> systemEventsWithHttpInfo(String since, String until, String filters) throws ApiException {
        Call localVarCall = this.systemEventsValidateBeforeCall(since, until, filters, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call systemEventsAsync(String since, String until, String filters, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.systemEventsValidateBeforeCall(since, until, filters, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public APIsystemEventsRequest systemEvents() {
        return new APIsystemEventsRequest();
    }

    private Call systemInfoCall(ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/info";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call systemInfoValidateBeforeCall(ApiCallback _callback) throws ApiException {
        Call localVarCall = this.systemInfoCall(_callback);
        return localVarCall;
    }

    private ApiResponse<Void> systemInfoWithHttpInfo() throws ApiException {
        Call localVarCall = this.systemInfoValidateBeforeCall(null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call systemInfoAsync(ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.systemInfoValidateBeforeCall(_callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public APIsystemInfoRequest systemInfo() {
        return new APIsystemInfoRequest();
    }

    private Call systemPingCall(ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/libpod/_ping";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"text/plain"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call systemPingValidateBeforeCall(ApiCallback _callback) throws ApiException {
        Call localVarCall = this.systemPingCall(_callback);
        return localVarCall;
    }

    private ApiResponse<String> systemPingWithHttpInfo() throws ApiException {
        Call localVarCall = this.systemPingValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call systemPingAsync(ApiCallback<String> _callback) throws ApiException {
        Call localVarCall = this.systemPingValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIsystemPingRequest systemPing() {
        return new APIsystemPingRequest();
    }

    private Call systemVersionCall(ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/version";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call systemVersionValidateBeforeCall(ApiCallback _callback) throws ApiException {
        Call localVarCall = this.systemVersionCall(_callback);
        return localVarCall;
    }

    private ApiResponse<SystemComponentVersion> systemVersionWithHttpInfo() throws ApiException {
        Call localVarCall = this.systemVersionValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<SystemComponentVersion>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call systemVersionAsync(ApiCallback<SystemComponentVersion> _callback) throws ApiException {
        Call localVarCall = this.systemVersionValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<SystemComponentVersion>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIsystemVersionRequest systemVersion() {
        return new APIsystemVersionRequest();
    }

    public class APIsystemAuthRequest {
        private AuthConfig authConfig;

        private APIsystemAuthRequest() {
        }

        public APIsystemAuthRequest authConfig(AuthConfig authConfig) {
            this.authConfig = authConfig;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return SystemCompatApi.this.systemAuthCall(this.authConfig, _callback);
        }

        public AuthReport execute() throws ApiException {
            ApiResponse<AuthReport> localVarResp = SystemCompatApi.this.systemAuthWithHttpInfo(this.authConfig);
            return localVarResp.getData();
        }

        public ApiResponse<AuthReport> executeWithHttpInfo() throws ApiException {
            return SystemCompatApi.this.systemAuthWithHttpInfo(this.authConfig);
        }

        public Call executeAsync(ApiCallback<AuthReport> _callback) throws ApiException {
            return SystemCompatApi.this.systemAuthAsync(this.authConfig, _callback);
        }
    }

    public class APIsystemDataUsageRequest {
        private APIsystemDataUsageRequest() {
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return SystemCompatApi.this.systemDataUsageCall(_callback);
        }

        public SystemDfReport execute() throws ApiException {
            ApiResponse<SystemDfReport> localVarResp = SystemCompatApi.this.systemDataUsageWithHttpInfo();
            return localVarResp.getData();
        }

        public ApiResponse<SystemDfReport> executeWithHttpInfo() throws ApiException {
            return SystemCompatApi.this.systemDataUsageWithHttpInfo();
        }

        public Call executeAsync(ApiCallback<SystemDfReport> _callback) throws ApiException {
            return SystemCompatApi.this.systemDataUsageAsync(_callback);
        }
    }

    public class APIsystemEventsRequest {
        private String since;
        private String until;
        private String filters;

        private APIsystemEventsRequest() {
        }

        public APIsystemEventsRequest since(String since) {
            this.since = since;
            return this;
        }

        public APIsystemEventsRequest until(String until) {
            this.until = until;
            return this;
        }

        public APIsystemEventsRequest filters(String filters) {
            this.filters = filters;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return SystemCompatApi.this.systemEventsCall(this.since, this.until, this.filters, _callback);
        }

        public void execute() throws ApiException {
            SystemCompatApi.this.systemEventsWithHttpInfo(this.since, this.until, this.filters);
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return SystemCompatApi.this.systemEventsWithHttpInfo(this.since, this.until, this.filters);
        }

        public Call executeAsync(ApiCallback<Void> _callback) throws ApiException {
            return SystemCompatApi.this.systemEventsAsync(this.since, this.until, this.filters, _callback);
        }
    }

    public class APIsystemInfoRequest {
        private APIsystemInfoRequest() {
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return SystemCompatApi.this.systemInfoCall(_callback);
        }

        public void execute() throws ApiException {
            SystemCompatApi.this.systemInfoWithHttpInfo();
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return SystemCompatApi.this.systemInfoWithHttpInfo();
        }

        public Call executeAsync(ApiCallback<Void> _callback) throws ApiException {
            return SystemCompatApi.this.systemInfoAsync(_callback);
        }
    }

    public class APIsystemPingRequest {
        private APIsystemPingRequest() {
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return SystemCompatApi.this.systemPingCall(_callback);
        }

        public String execute() throws ApiException {
            ApiResponse<String> localVarResp = SystemCompatApi.this.systemPingWithHttpInfo();
            return localVarResp.getData();
        }

        public ApiResponse<String> executeWithHttpInfo() throws ApiException {
            return SystemCompatApi.this.systemPingWithHttpInfo();
        }

        public Call executeAsync(ApiCallback<String> _callback) throws ApiException {
            return SystemCompatApi.this.systemPingAsync(_callback);
        }
    }

    public class APIsystemVersionRequest {
        private APIsystemVersionRequest() {
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return SystemCompatApi.this.systemVersionCall(_callback);
        }

        public SystemComponentVersion execute() throws ApiException {
            ApiResponse<SystemComponentVersion> localVarResp = SystemCompatApi.this.systemVersionWithHttpInfo();
            return localVarResp.getData();
        }

        public ApiResponse<SystemComponentVersion> executeWithHttpInfo() throws ApiException {
            return SystemCompatApi.this.systemVersionWithHttpInfo();
        }

        public Call executeAsync(ApiCallback<SystemComponentVersion> _callback) throws ApiException {
            return SystemCompatApi.this.systemVersionAsync(_callback);
        }
    }
}

