/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.libpodj.api;

import com.google.gson.reflect.TypeToken;
import io.github.pod4dev.libpodj.ApiCallback;
import io.github.pod4dev.libpodj.ApiClient;
import io.github.pod4dev.libpodj.ApiException;
import io.github.pod4dev.libpodj.ApiResponse;
import io.github.pod4dev.libpodj.Configuration;
import io.github.pod4dev.libpodj.Pair;
import io.github.pod4dev.libpodj.model.PruneReport;
import io.github.pod4dev.libpodj.model.VolumeConfigResponse;
import io.github.pod4dev.libpodj.model.VolumeCreateOptions;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.validation.constraints.NotNull;
import okhttp3.Call;

public class VolumesApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public VolumesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public VolumesApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call volumeCreateLibpodCall(VolumeCreateOptions create, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        VolumeCreateOptions localVarPostBody = create;
        String localVarPath = "/libpod/volumes/create";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/x-tar"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call volumeCreateLibpodValidateBeforeCall(VolumeCreateOptions create, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.volumeCreateLibpodCall(create, _callback);
        return localVarCall;
    }

    private ApiResponse<VolumeConfigResponse> volumeCreateLibpodWithHttpInfo(VolumeCreateOptions create) throws ApiException {
        Call localVarCall = this.volumeCreateLibpodValidateBeforeCall(create, null);
        Type localVarReturnType = new TypeToken<VolumeConfigResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call volumeCreateLibpodAsync(VolumeCreateOptions create, ApiCallback<VolumeConfigResponse> _callback) throws ApiException {
        Call localVarCall = this.volumeCreateLibpodValidateBeforeCall(create, _callback);
        Type localVarReturnType = new TypeToken<VolumeConfigResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIvolumeCreateLibpodRequest volumeCreateLibpod() {
        return new APIvolumeCreateLibpodRequest();
    }

    private Call volumeDeleteLibpodCall(String name, Boolean force, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/libpod/volumes/{name}".replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (force != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("force", force));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call volumeDeleteLibpodValidateBeforeCall(String name, Boolean force, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling volumeDeleteLibpod(Async)");
        }
        Call localVarCall = this.volumeDeleteLibpodCall(name, force, _callback);
        return localVarCall;
    }

    private ApiResponse<Void> volumeDeleteLibpodWithHttpInfo(@NotNull String name, Boolean force) throws ApiException {
        Call localVarCall = this.volumeDeleteLibpodValidateBeforeCall(name, force, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call volumeDeleteLibpodAsync(String name, Boolean force, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.volumeDeleteLibpodValidateBeforeCall(name, force, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public APIvolumeDeleteLibpodRequest volumeDeleteLibpod(String name) {
        return new APIvolumeDeleteLibpodRequest(name);
    }

    private Call volumeExistsLibpodCall(String name, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/libpod/volumes/{name}/exists".replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call volumeExistsLibpodValidateBeforeCall(String name, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling volumeExistsLibpod(Async)");
        }
        Call localVarCall = this.volumeExistsLibpodCall(name, _callback);
        return localVarCall;
    }

    private ApiResponse<Void> volumeExistsLibpodWithHttpInfo(@NotNull String name) throws ApiException {
        Call localVarCall = this.volumeExistsLibpodValidateBeforeCall(name, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call volumeExistsLibpodAsync(String name, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.volumeExistsLibpodValidateBeforeCall(name, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public APIvolumeExistsLibpodRequest volumeExistsLibpod(String name) {
        return new APIvolumeExistsLibpodRequest(name);
    }

    private Call volumeInspectLibpodCall(String name, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/libpod/volumes/{name}/json".replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call volumeInspectLibpodValidateBeforeCall(String name, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling volumeInspectLibpod(Async)");
        }
        Call localVarCall = this.volumeInspectLibpodCall(name, _callback);
        return localVarCall;
    }

    private ApiResponse<VolumeConfigResponse> volumeInspectLibpodWithHttpInfo(@NotNull String name) throws ApiException {
        Call localVarCall = this.volumeInspectLibpodValidateBeforeCall(name, null);
        Type localVarReturnType = new TypeToken<VolumeConfigResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call volumeInspectLibpodAsync(String name, ApiCallback<VolumeConfigResponse> _callback) throws ApiException {
        Call localVarCall = this.volumeInspectLibpodValidateBeforeCall(name, _callback);
        Type localVarReturnType = new TypeToken<VolumeConfigResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIvolumeInspectLibpodRequest volumeInspectLibpod(String name) {
        return new APIvolumeInspectLibpodRequest(name);
    }

    private Call volumeListLibpodCall(String filters, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/libpod/volumes/json";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (filters != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("filters", filters));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call volumeListLibpodValidateBeforeCall(String filters, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.volumeListLibpodCall(filters, _callback);
        return localVarCall;
    }

    private ApiResponse<List<VolumeConfigResponse>> volumeListLibpodWithHttpInfo(String filters) throws ApiException {
        Call localVarCall = this.volumeListLibpodValidateBeforeCall(filters, null);
        Type localVarReturnType = new TypeToken<List<VolumeConfigResponse>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call volumeListLibpodAsync(String filters, ApiCallback<List<VolumeConfigResponse>> _callback) throws ApiException {
        Call localVarCall = this.volumeListLibpodValidateBeforeCall(filters, _callback);
        Type localVarReturnType = new TypeToken<List<VolumeConfigResponse>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIvolumeListLibpodRequest volumeListLibpod() {
        return new APIvolumeListLibpodRequest();
    }

    private Call volumePruneLibpodCall(String filters, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/libpod/volumes/prune";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (filters != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("filters", filters));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call volumePruneLibpodValidateBeforeCall(String filters, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.volumePruneLibpodCall(filters, _callback);
        return localVarCall;
    }

    private ApiResponse<List<PruneReport>> volumePruneLibpodWithHttpInfo(String filters) throws ApiException {
        Call localVarCall = this.volumePruneLibpodValidateBeforeCall(filters, null);
        Type localVarReturnType = new TypeToken<List<PruneReport>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call volumePruneLibpodAsync(String filters, ApiCallback<List<PruneReport>> _callback) throws ApiException {
        Call localVarCall = this.volumePruneLibpodValidateBeforeCall(filters, _callback);
        Type localVarReturnType = new TypeToken<List<PruneReport>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIvolumePruneLibpodRequest volumePruneLibpod() {
        return new APIvolumePruneLibpodRequest();
    }

    public class APIvolumeCreateLibpodRequest {
        private VolumeCreateOptions create;

        private APIvolumeCreateLibpodRequest() {
        }

        public APIvolumeCreateLibpodRequest create(VolumeCreateOptions create) {
            this.create = create;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return VolumesApi.this.volumeCreateLibpodCall(this.create, _callback);
        }

        public VolumeConfigResponse execute() throws ApiException {
            ApiResponse<VolumeConfigResponse> localVarResp = VolumesApi.this.volumeCreateLibpodWithHttpInfo(this.create);
            return localVarResp.getData();
        }

        public ApiResponse<VolumeConfigResponse> executeWithHttpInfo() throws ApiException {
            return VolumesApi.this.volumeCreateLibpodWithHttpInfo(this.create);
        }

        public Call executeAsync(ApiCallback<VolumeConfigResponse> _callback) throws ApiException {
            return VolumesApi.this.volumeCreateLibpodAsync(this.create, _callback);
        }
    }

    public class APIvolumeDeleteLibpodRequest {
        private final String name;
        private Boolean force;

        private APIvolumeDeleteLibpodRequest(String name) {
            this.name = name;
        }

        public APIvolumeDeleteLibpodRequest force(Boolean force) {
            this.force = force;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return VolumesApi.this.volumeDeleteLibpodCall(this.name, this.force, _callback);
        }

        public void execute() throws ApiException {
            VolumesApi.this.volumeDeleteLibpodWithHttpInfo(this.name, this.force);
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return VolumesApi.this.volumeDeleteLibpodWithHttpInfo(this.name, this.force);
        }

        public Call executeAsync(ApiCallback<Void> _callback) throws ApiException {
            return VolumesApi.this.volumeDeleteLibpodAsync(this.name, this.force, _callback);
        }
    }

    public class APIvolumeExistsLibpodRequest {
        private final String name;

        private APIvolumeExistsLibpodRequest(String name) {
            this.name = name;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return VolumesApi.this.volumeExistsLibpodCall(this.name, _callback);
        }

        public void execute() throws ApiException {
            VolumesApi.this.volumeExistsLibpodWithHttpInfo(this.name);
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return VolumesApi.this.volumeExistsLibpodWithHttpInfo(this.name);
        }

        public Call executeAsync(ApiCallback<Void> _callback) throws ApiException {
            return VolumesApi.this.volumeExistsLibpodAsync(this.name, _callback);
        }
    }

    public class APIvolumeInspectLibpodRequest {
        private final String name;

        private APIvolumeInspectLibpodRequest(String name) {
            this.name = name;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return VolumesApi.this.volumeInspectLibpodCall(this.name, _callback);
        }

        public VolumeConfigResponse execute() throws ApiException {
            ApiResponse<VolumeConfigResponse> localVarResp = VolumesApi.this.volumeInspectLibpodWithHttpInfo(this.name);
            return localVarResp.getData();
        }

        public ApiResponse<VolumeConfigResponse> executeWithHttpInfo() throws ApiException {
            return VolumesApi.this.volumeInspectLibpodWithHttpInfo(this.name);
        }

        public Call executeAsync(ApiCallback<VolumeConfigResponse> _callback) throws ApiException {
            return VolumesApi.this.volumeInspectLibpodAsync(this.name, _callback);
        }
    }

    public class APIvolumeListLibpodRequest {
        private String filters;

        private APIvolumeListLibpodRequest() {
        }

        public APIvolumeListLibpodRequest filters(String filters) {
            this.filters = filters;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return VolumesApi.this.volumeListLibpodCall(this.filters, _callback);
        }

        public List<VolumeConfigResponse> execute() throws ApiException {
            ApiResponse<List<VolumeConfigResponse>> localVarResp = VolumesApi.this.volumeListLibpodWithHttpInfo(this.filters);
            return localVarResp.getData();
        }

        public ApiResponse<List<VolumeConfigResponse>> executeWithHttpInfo() throws ApiException {
            return VolumesApi.this.volumeListLibpodWithHttpInfo(this.filters);
        }

        public Call executeAsync(ApiCallback<List<VolumeConfigResponse>> _callback) throws ApiException {
            return VolumesApi.this.volumeListLibpodAsync(this.filters, _callback);
        }
    }

    public class APIvolumePruneLibpodRequest {
        private String filters;

        private APIvolumePruneLibpodRequest() {
        }

        public APIvolumePruneLibpodRequest filters(String filters) {
            this.filters = filters;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return VolumesApi.this.volumePruneLibpodCall(this.filters, _callback);
        }

        public List<PruneReport> execute() throws ApiException {
            ApiResponse<List<PruneReport>> localVarResp = VolumesApi.this.volumePruneLibpodWithHttpInfo(this.filters);
            return localVarResp.getData();
        }

        public ApiResponse<List<PruneReport>> executeWithHttpInfo() throws ApiException {
            return VolumesApi.this.volumePruneLibpodWithHttpInfo(this.filters);
        }

        public Call executeAsync(ApiCallback<List<PruneReport>> _callback) throws ApiException {
            return VolumesApi.this.volumePruneLibpodAsync(this.filters, _callback);
        }
    }
}

