/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.libpodj.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.pod4dev.libpodj.JSON;
import io.github.pod4dev.libpodj.model.TypeMount;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.validation.Valid;

public class AccessMode
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_BLOCK_VOLUME = "BlockVolume";
    @SerializedName(value="BlockVolume")
    private Object blockVolume;
    public static final String SERIALIZED_NAME_MOUNT_VOLUME = "MountVolume";
    @SerializedName(value="MountVolume")
    private TypeMount mountVolume;
    public static final String SERIALIZED_NAME_SCOPE = "Scope";
    @SerializedName(value="Scope")
    private String scope;
    public static final String SERIALIZED_NAME_SHARING = "Sharing";
    @SerializedName(value="Sharing")
    private String sharing;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public AccessMode blockVolume(Object blockVolume) {
        this.blockVolume = blockVolume;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Intentionally empty.")
    public Object getBlockVolume() {
        return this.blockVolume;
    }

    public void setBlockVolume(Object blockVolume) {
        this.blockVolume = blockVolume;
    }

    public AccessMode mountVolume(TypeMount mountVolume) {
        this.mountVolume = mountVolume;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    public TypeMount getMountVolume() {
        return this.mountVolume;
    }

    public void setMountVolume(TypeMount mountVolume) {
        this.mountVolume = mountVolume;
    }

    public AccessMode scope(String scope) {
        this.scope = scope;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Scope defines the Scope of a Cluster Volume. This is how many nodes a Volume can be accessed simultaneously on.")
    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public AccessMode sharing(String sharing) {
        this.sharing = sharing;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="SharingMode defines the Sharing of a Cluster Volume. This is how Tasks using a Volume at the same time can use it.")
    public String getSharing() {
        return this.sharing;
    }

    public void setSharing(String sharing) {
        this.sharing = sharing;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccessMode accessMode = (AccessMode)o;
        return Objects.equals(this.blockVolume, accessMode.blockVolume) && Objects.equals(this.mountVolume, accessMode.mountVolume) && Objects.equals(this.scope, accessMode.scope) && Objects.equals(this.sharing, accessMode.sharing);
    }

    public int hashCode() {
        return Objects.hash(this.blockVolume, this.mountVolume, this.scope, this.sharing);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccessMode {\n");
        sb.append("    blockVolume: ").append(this.toIndentedString(this.blockVolume)).append("\n");
        sb.append("    mountVolume: ").append(this.toIndentedString(this.mountVolume)).append("\n");
        sb.append("    scope: ").append(this.toIndentedString(this.scope)).append("\n");
        sb.append("    sharing: ").append(this.toIndentedString(this.sharing)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in AccessMode is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `AccessMode` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MOUNT_VOLUME) != null && !jsonObj.get(SERIALIZED_NAME_MOUNT_VOLUME).isJsonNull()) {
            TypeMount.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_MOUNT_VOLUME));
        }
        if (jsonObj.get(SERIALIZED_NAME_SCOPE) != null && !jsonObj.get(SERIALIZED_NAME_SCOPE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SCOPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `Scope` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SCOPE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SHARING) != null && !jsonObj.get(SERIALIZED_NAME_SHARING).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SHARING).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `Sharing` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SHARING).toString()));
        }
    }

    public static AccessMode fromJson(String jsonString) throws IOException {
        return (AccessMode)JSON.getGson().fromJson(jsonString, AccessMode.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_BLOCK_VOLUME);
        openapiFields.add(SERIALIZED_NAME_MOUNT_VOLUME);
        openapiFields.add(SERIALIZED_NAME_SCOPE);
        openapiFields.add(SERIALIZED_NAME_SHARING);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!AccessMode.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(AccessMode.class));
            return new TypeAdapter<AccessMode>(){

                public void write(JsonWriter out, AccessMode value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public AccessMode read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    AccessMode.validateJsonObject(jsonObj);
                    return (AccessMode)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

