/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.libpodj.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.pod4dev.libpodj.JSON;
import io.github.pod4dev.libpodj.model.IDMap;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.validation.Valid;

public class AutoUserNsOptions
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_ADDITIONAL_G_I_D_MAPPINGS = "AdditionalGIDMappings";
    @SerializedName(value="AdditionalGIDMappings")
    private List<IDMap> additionalGIDMappings = null;
    public static final String SERIALIZED_NAME_ADDITIONAL_U_I_D_MAPPINGS = "AdditionalUIDMappings";
    @SerializedName(value="AdditionalUIDMappings")
    private List<IDMap> additionalUIDMappings = null;
    public static final String SERIALIZED_NAME_GROUP_FILE = "GroupFile";
    @SerializedName(value="GroupFile")
    private String groupFile;
    public static final String SERIALIZED_NAME_INITIAL_SIZE = "InitialSize";
    @SerializedName(value="InitialSize")
    private Integer initialSize;
    public static final String SERIALIZED_NAME_PASSWD_FILE = "PasswdFile";
    @SerializedName(value="PasswdFile")
    private String passwdFile;
    public static final String SERIALIZED_NAME_SIZE = "Size";
    @SerializedName(value="Size")
    private Integer size;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public AutoUserNsOptions additionalGIDMappings(List<IDMap> additionalGIDMappings) {
        this.additionalGIDMappings = additionalGIDMappings;
        return this;
    }

    public AutoUserNsOptions addAdditionalGIDMappingsItem(IDMap additionalGIDMappingsItem) {
        if (this.additionalGIDMappings == null) {
            this.additionalGIDMappings = new ArrayList<IDMap>();
        }
        this.additionalGIDMappings.add(additionalGIDMappingsItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="AdditionalGIDMappings specified additional GID mappings to include in the generated user namespace.")
    public List<IDMap> getAdditionalGIDMappings() {
        return this.additionalGIDMappings;
    }

    public void setAdditionalGIDMappings(List<IDMap> additionalGIDMappings) {
        this.additionalGIDMappings = additionalGIDMappings;
    }

    public AutoUserNsOptions additionalUIDMappings(List<IDMap> additionalUIDMappings) {
        this.additionalUIDMappings = additionalUIDMappings;
        return this;
    }

    public AutoUserNsOptions addAdditionalUIDMappingsItem(IDMap additionalUIDMappingsItem) {
        if (this.additionalUIDMappings == null) {
            this.additionalUIDMappings = new ArrayList<IDMap>();
        }
        this.additionalUIDMappings.add(additionalUIDMappingsItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="AdditionalUIDMappings specified additional UID mappings to include in the generated user namespace.")
    public List<IDMap> getAdditionalUIDMappings() {
        return this.additionalUIDMappings;
    }

    public void setAdditionalUIDMappings(List<IDMap> additionalUIDMappings) {
        this.additionalUIDMappings = additionalUIDMappings;
    }

    public AutoUserNsOptions groupFile(String groupFile) {
        this.groupFile = groupFile;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="GroupFile to use if the container uses a volume.")
    public String getGroupFile() {
        return this.groupFile;
    }

    public void setGroupFile(String groupFile) {
        this.groupFile = groupFile;
    }

    public AutoUserNsOptions initialSize(Integer initialSize) {
        this.initialSize = initialSize;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="InitialSize defines the minimum size for the user namespace. The created user namespace will have at least this size.")
    public Integer getInitialSize() {
        return this.initialSize;
    }

    public void setInitialSize(Integer initialSize) {
        this.initialSize = initialSize;
    }

    public AutoUserNsOptions passwdFile(String passwdFile) {
        this.passwdFile = passwdFile;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="PasswdFile to use if the container uses a volume.")
    public String getPasswdFile() {
        return this.passwdFile;
    }

    public void setPasswdFile(String passwdFile) {
        this.passwdFile = passwdFile;
    }

    public AutoUserNsOptions size(Integer size) {
        this.size = size;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Size defines the size for the user namespace.  If it is set to a value bigger than 0, the user namespace will have exactly this size. If it is not set, some heuristics will be used to find its size.")
    public Integer getSize() {
        return this.size;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AutoUserNsOptions autoUserNsOptions = (AutoUserNsOptions)o;
        return Objects.equals(this.additionalGIDMappings, autoUserNsOptions.additionalGIDMappings) && Objects.equals(this.additionalUIDMappings, autoUserNsOptions.additionalUIDMappings) && Objects.equals(this.groupFile, autoUserNsOptions.groupFile) && Objects.equals(this.initialSize, autoUserNsOptions.initialSize) && Objects.equals(this.passwdFile, autoUserNsOptions.passwdFile) && Objects.equals(this.size, autoUserNsOptions.size);
    }

    public int hashCode() {
        return Objects.hash(this.additionalGIDMappings, this.additionalUIDMappings, this.groupFile, this.initialSize, this.passwdFile, this.size);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AutoUserNsOptions {\n");
        sb.append("    additionalGIDMappings: ").append(this.toIndentedString(this.additionalGIDMappings)).append("\n");
        sb.append("    additionalUIDMappings: ").append(this.toIndentedString(this.additionalUIDMappings)).append("\n");
        sb.append("    groupFile: ").append(this.toIndentedString(this.groupFile)).append("\n");
        sb.append("    initialSize: ").append(this.toIndentedString(this.initialSize)).append("\n");
        sb.append("    passwdFile: ").append(this.toIndentedString(this.passwdFile)).append("\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArrayadditionalUIDMappings;
        JsonArray jsonArrayadditionalGIDMappings;
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in AutoUserNsOptions is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `AutoUserNsOptions` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ADDITIONAL_G_I_D_MAPPINGS) != null && !jsonObj.get(SERIALIZED_NAME_ADDITIONAL_G_I_D_MAPPINGS).isJsonNull() && (jsonArrayadditionalGIDMappings = jsonObj.getAsJsonArray(SERIALIZED_NAME_ADDITIONAL_G_I_D_MAPPINGS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_ADDITIONAL_G_I_D_MAPPINGS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `AdditionalGIDMappings` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ADDITIONAL_G_I_D_MAPPINGS).toString()));
            }
            for (int i = 0; i < jsonArrayadditionalGIDMappings.size(); ++i) {
                IDMap.validateJsonObject(jsonArrayadditionalGIDMappings.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_ADDITIONAL_U_I_D_MAPPINGS) != null && !jsonObj.get(SERIALIZED_NAME_ADDITIONAL_U_I_D_MAPPINGS).isJsonNull() && (jsonArrayadditionalUIDMappings = jsonObj.getAsJsonArray(SERIALIZED_NAME_ADDITIONAL_U_I_D_MAPPINGS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_ADDITIONAL_U_I_D_MAPPINGS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `AdditionalUIDMappings` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ADDITIONAL_U_I_D_MAPPINGS).toString()));
            }
            for (int i = 0; i < jsonArrayadditionalUIDMappings.size(); ++i) {
                IDMap.validateJsonObject(jsonArrayadditionalUIDMappings.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_GROUP_FILE) != null && !jsonObj.get(SERIALIZED_NAME_GROUP_FILE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_GROUP_FILE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `GroupFile` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_GROUP_FILE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PASSWD_FILE) != null && !jsonObj.get(SERIALIZED_NAME_PASSWD_FILE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_PASSWD_FILE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `PasswdFile` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PASSWD_FILE).toString()));
        }
    }

    public static AutoUserNsOptions fromJson(String jsonString) throws IOException {
        return (AutoUserNsOptions)JSON.getGson().fromJson(jsonString, AutoUserNsOptions.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ADDITIONAL_G_I_D_MAPPINGS);
        openapiFields.add(SERIALIZED_NAME_ADDITIONAL_U_I_D_MAPPINGS);
        openapiFields.add(SERIALIZED_NAME_GROUP_FILE);
        openapiFields.add(SERIALIZED_NAME_INITIAL_SIZE);
        openapiFields.add(SERIALIZED_NAME_PASSWD_FILE);
        openapiFields.add(SERIALIZED_NAME_SIZE);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!AutoUserNsOptions.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(AutoUserNsOptions.class));
            return new TypeAdapter<AutoUserNsOptions>(){

                public void write(JsonWriter out, AutoUserNsOptions value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public AutoUserNsOptions read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    AutoUserNsOptions.validateJsonObject(jsonObj);
                    return (AutoUserNsOptions)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

