/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.libpodj.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.pod4dev.libpodj.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

@ApiModel(description="ContainerSize holds the size of the container's root filesystem and top read-write layer.")
public class ContainerSize
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_ROOT_FS_SIZE = "rootFsSize";
    @SerializedName(value="rootFsSize")
    private Long rootFsSize;
    public static final String SERIALIZED_NAME_RW_SIZE = "rwSize";
    @SerializedName(value="rwSize")
    private Long rwSize;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public ContainerSize rootFsSize(Long rootFsSize) {
        this.rootFsSize = rootFsSize;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Long getRootFsSize() {
        return this.rootFsSize;
    }

    public void setRootFsSize(Long rootFsSize) {
        this.rootFsSize = rootFsSize;
    }

    public ContainerSize rwSize(Long rwSize) {
        this.rwSize = rwSize;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Long getRwSize() {
        return this.rwSize;
    }

    public void setRwSize(Long rwSize) {
        this.rwSize = rwSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContainerSize containerSize = (ContainerSize)o;
        return Objects.equals(this.rootFsSize, containerSize.rootFsSize) && Objects.equals(this.rwSize, containerSize.rwSize);
    }

    public int hashCode() {
        return Objects.hash(this.rootFsSize, this.rwSize);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ContainerSize {\n");
        sb.append("    rootFsSize: ").append(this.toIndentedString(this.rootFsSize)).append("\n");
        sb.append("    rwSize: ").append(this.toIndentedString(this.rwSize)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in ContainerSize is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `ContainerSize` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
    }

    public static ContainerSize fromJson(String jsonString) throws IOException {
        return (ContainerSize)JSON.getGson().fromJson(jsonString, ContainerSize.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ROOT_FS_SIZE);
        openapiFields.add(SERIALIZED_NAME_RW_SIZE);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!ContainerSize.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(ContainerSize.class));
            return new TypeAdapter<ContainerSize>(){

                public void write(JsonWriter out, ContainerSize value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public ContainerSize read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    ContainerSize.validateJsonObject(jsonObj);
                    return (ContainerSize)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

