/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.libpodj.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.pod4dev.libpodj.JSON;
import io.github.pod4dev.libpodj.model.HealthCheckLog;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.validation.Valid;

@ApiModel(description="HealthCheckResults describes the results/logs from a healthcheck")
public class HealthCheckResults
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_FAILING_STREAK = "FailingStreak";
    @SerializedName(value="FailingStreak")
    private Long failingStreak;
    public static final String SERIALIZED_NAME_LOG = "Log";
    @SerializedName(value="Log")
    private List<HealthCheckLog> log = null;
    public static final String SERIALIZED_NAME_STATUS = "Status";
    @SerializedName(value="Status")
    private String status;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public HealthCheckResults failingStreak(Long failingStreak) {
        this.failingStreak = failingStreak;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="FailingStreak is the number of consecutive failed healthchecks")
    public Long getFailingStreak() {
        return this.failingStreak;
    }

    public void setFailingStreak(Long failingStreak) {
        this.failingStreak = failingStreak;
    }

    public HealthCheckResults log(List<HealthCheckLog> log) {
        this.log = log;
        return this;
    }

    public HealthCheckResults addLogItem(HealthCheckLog logItem) {
        if (this.log == null) {
            this.log = new ArrayList<HealthCheckLog>();
        }
        this.log.add(logItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Log describes healthcheck attempts and results")
    public List<HealthCheckLog> getLog() {
        return this.log;
    }

    public void setLog(List<HealthCheckLog> log) {
        this.log = log;
    }

    public HealthCheckResults status(String status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Status starting, healthy or unhealthy")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HealthCheckResults healthCheckResults = (HealthCheckResults)o;
        return Objects.equals(this.failingStreak, healthCheckResults.failingStreak) && Objects.equals(this.log, healthCheckResults.log) && Objects.equals(this.status, healthCheckResults.status);
    }

    public int hashCode() {
        return Objects.hash(this.failingStreak, this.log, this.status);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HealthCheckResults {\n");
        sb.append("    failingStreak: ").append(this.toIndentedString(this.failingStreak)).append("\n");
        sb.append("    log: ").append(this.toIndentedString(this.log)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArraylog;
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in HealthCheckResults is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `HealthCheckResults` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_LOG) != null && !jsonObj.get(SERIALIZED_NAME_LOG).isJsonNull() && (jsonArraylog = jsonObj.getAsJsonArray(SERIALIZED_NAME_LOG)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_LOG).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `Log` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LOG).toString()));
            }
            for (int i = 0; i < jsonArraylog.size(); ++i) {
                HealthCheckLog.validateJsonObject(jsonArraylog.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_STATUS) != null && !jsonObj.get(SERIALIZED_NAME_STATUS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_STATUS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `Status` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STATUS).toString()));
        }
    }

    public static HealthCheckResults fromJson(String jsonString) throws IOException {
        return (HealthCheckResults)JSON.getGson().fromJson(jsonString, HealthCheckResults.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_FAILING_STREAK);
        openapiFields.add(SERIALIZED_NAME_LOG);
        openapiFields.add(SERIALIZED_NAME_STATUS);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!HealthCheckResults.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(HealthCheckResults.class));
            return new TypeAdapter<HealthCheckResults>(){

                public void write(JsonWriter out, HealthCheckResults value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public HealthCheckResults read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    HealthCheckResults.validateJsonObject(jsonObj);
                    return (HealthCheckResults)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

