/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.libpodj.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.pod4dev.libpodj.JSON;
import io.github.pod4dev.libpodj.model.AutoUserNsOptions;
import io.github.pod4dev.libpodj.model.IDMap;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.validation.Valid;

@ApiModel(description="IDMappingOptions are used for specifying how ID mapping should be set up for a layer or container.")
public class IDMappingOptions
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_AUTO_USER_NS = "AutoUserNs";
    @SerializedName(value="AutoUserNs")
    private Boolean autoUserNs;
    public static final String SERIALIZED_NAME_AUTO_USER_NS_OPTS = "AutoUserNsOpts";
    @SerializedName(value="AutoUserNsOpts")
    private AutoUserNsOptions autoUserNsOpts;
    public static final String SERIALIZED_NAME_GI_D_MAP = "GIDMap";
    @SerializedName(value="GIDMap")
    private List<IDMap> giDMap = null;
    public static final String SERIALIZED_NAME_HOST_G_I_D_MAPPING = "HostGIDMapping";
    @SerializedName(value="HostGIDMapping")
    private Boolean hostGIDMapping;
    public static final String SERIALIZED_NAME_HOST_U_I_D_MAPPING = "HostUIDMapping";
    @SerializedName(value="HostUIDMapping")
    private Boolean hostUIDMapping;
    public static final String SERIALIZED_NAME_UI_D_MAP = "UIDMap";
    @SerializedName(value="UIDMap")
    private List<IDMap> uiDMap = null;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public IDMappingOptions autoUserNs(Boolean autoUserNs) {
        this.autoUserNs = autoUserNs;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Boolean getAutoUserNs() {
        return this.autoUserNs;
    }

    public void setAutoUserNs(Boolean autoUserNs) {
        this.autoUserNs = autoUserNs;
    }

    public IDMappingOptions autoUserNsOpts(AutoUserNsOptions autoUserNsOpts) {
        this.autoUserNsOpts = autoUserNsOpts;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    public AutoUserNsOptions getAutoUserNsOpts() {
        return this.autoUserNsOpts;
    }

    public void setAutoUserNsOpts(AutoUserNsOptions autoUserNsOpts) {
        this.autoUserNsOpts = autoUserNsOpts;
    }

    public IDMappingOptions giDMap(List<IDMap> giDMap) {
        this.giDMap = giDMap;
        return this;
    }

    public IDMappingOptions addGiDMapItem(IDMap giDMapItem) {
        if (this.giDMap == null) {
            this.giDMap = new ArrayList<IDMap>();
        }
        this.giDMap.add(giDMapItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    public List<IDMap> getGiDMap() {
        return this.giDMap;
    }

    public void setGiDMap(List<IDMap> giDMap) {
        this.giDMap = giDMap;
    }

    public IDMappingOptions hostGIDMapping(Boolean hostGIDMapping) {
        this.hostGIDMapping = hostGIDMapping;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Boolean getHostGIDMapping() {
        return this.hostGIDMapping;
    }

    public void setHostGIDMapping(Boolean hostGIDMapping) {
        this.hostGIDMapping = hostGIDMapping;
    }

    public IDMappingOptions hostUIDMapping(Boolean hostUIDMapping) {
        this.hostUIDMapping = hostUIDMapping;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="UIDMap and GIDMap are used for setting up a layer's root filesystem for use inside of a user namespace where ID mapping is being used. If HostUIDMapping/HostGIDMapping is true, no mapping of the respective type will be used.  Otherwise, if UIDMap and/or GIDMap contain at least one mapping, one or both will be used.  By default, if neither of those conditions apply, if the layer has a parent layer, the parent layer's mapping will be used, and if it does not have a parent layer, the mapping which was passed to the Store object when it was initialized will be used.")
    public Boolean getHostUIDMapping() {
        return this.hostUIDMapping;
    }

    public void setHostUIDMapping(Boolean hostUIDMapping) {
        this.hostUIDMapping = hostUIDMapping;
    }

    public IDMappingOptions uiDMap(List<IDMap> uiDMap) {
        this.uiDMap = uiDMap;
        return this;
    }

    public IDMappingOptions addUiDMapItem(IDMap uiDMapItem) {
        if (this.uiDMap == null) {
            this.uiDMap = new ArrayList<IDMap>();
        }
        this.uiDMap.add(uiDMapItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    public List<IDMap> getUiDMap() {
        return this.uiDMap;
    }

    public void setUiDMap(List<IDMap> uiDMap) {
        this.uiDMap = uiDMap;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IDMappingOptions idMappingOptions = (IDMappingOptions)o;
        return Objects.equals(this.autoUserNs, idMappingOptions.autoUserNs) && Objects.equals(this.autoUserNsOpts, idMappingOptions.autoUserNsOpts) && Objects.equals(this.giDMap, idMappingOptions.giDMap) && Objects.equals(this.hostGIDMapping, idMappingOptions.hostGIDMapping) && Objects.equals(this.hostUIDMapping, idMappingOptions.hostUIDMapping) && Objects.equals(this.uiDMap, idMappingOptions.uiDMap);
    }

    public int hashCode() {
        return Objects.hash(this.autoUserNs, this.autoUserNsOpts, this.giDMap, this.hostGIDMapping, this.hostUIDMapping, this.uiDMap);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IDMappingOptions {\n");
        sb.append("    autoUserNs: ").append(this.toIndentedString(this.autoUserNs)).append("\n");
        sb.append("    autoUserNsOpts: ").append(this.toIndentedString(this.autoUserNsOpts)).append("\n");
        sb.append("    giDMap: ").append(this.toIndentedString(this.giDMap)).append("\n");
        sb.append("    hostGIDMapping: ").append(this.toIndentedString(this.hostGIDMapping)).append("\n");
        sb.append("    hostUIDMapping: ").append(this.toIndentedString(this.hostUIDMapping)).append("\n");
        sb.append("    uiDMap: ").append(this.toIndentedString(this.uiDMap)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArrayuiDMap;
        JsonArray jsonArraygiDMap;
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in IDMappingOptions is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `IDMappingOptions` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_AUTO_USER_NS_OPTS) != null && !jsonObj.get(SERIALIZED_NAME_AUTO_USER_NS_OPTS).isJsonNull()) {
            AutoUserNsOptions.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_AUTO_USER_NS_OPTS));
        }
        if (jsonObj.get(SERIALIZED_NAME_GI_D_MAP) != null && !jsonObj.get(SERIALIZED_NAME_GI_D_MAP).isJsonNull() && (jsonArraygiDMap = jsonObj.getAsJsonArray(SERIALIZED_NAME_GI_D_MAP)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_GI_D_MAP).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `GIDMap` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_GI_D_MAP).toString()));
            }
            for (int i = 0; i < jsonArraygiDMap.size(); ++i) {
                IDMap.validateJsonObject(jsonArraygiDMap.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_UI_D_MAP) != null && !jsonObj.get(SERIALIZED_NAME_UI_D_MAP).isJsonNull() && (jsonArrayuiDMap = jsonObj.getAsJsonArray(SERIALIZED_NAME_UI_D_MAP)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_UI_D_MAP).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `UIDMap` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_UI_D_MAP).toString()));
            }
            for (int i = 0; i < jsonArrayuiDMap.size(); ++i) {
                IDMap.validateJsonObject(jsonArrayuiDMap.get(i).getAsJsonObject());
            }
        }
    }

    public static IDMappingOptions fromJson(String jsonString) throws IOException {
        return (IDMappingOptions)JSON.getGson().fromJson(jsonString, IDMappingOptions.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_AUTO_USER_NS);
        openapiFields.add(SERIALIZED_NAME_AUTO_USER_NS_OPTS);
        openapiFields.add(SERIALIZED_NAME_GI_D_MAP);
        openapiFields.add(SERIALIZED_NAME_HOST_G_I_D_MAPPING);
        openapiFields.add(SERIALIZED_NAME_HOST_U_I_D_MAPPING);
        openapiFields.add(SERIALIZED_NAME_UI_D_MAP);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!IDMappingOptions.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(IDMappingOptions.class));
            return new TypeAdapter<IDMappingOptions>(){

                public void write(JsonWriter out, IDMappingOptions value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public IDMappingOptions read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    IDMappingOptions.validateJsonObject(jsonObj);
                    return (IDMappingOptions)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

