/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.libpodj.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.pod4dev.libpodj.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

@ApiModel(description="IPAMConfig represents IPAM configurations")
public class IPAMConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_AUXILIARY_ADDRESSES = "AuxiliaryAddresses";
    @SerializedName(value="AuxiliaryAddresses")
    private Map<String, String> auxiliaryAddresses = null;
    public static final String SERIALIZED_NAME_GATEWAY = "Gateway";
    @SerializedName(value="Gateway")
    private String gateway;
    public static final String SERIALIZED_NAME_IP_RANGE = "IPRange";
    @SerializedName(value="IPRange")
    private String ipRange;
    public static final String SERIALIZED_NAME_SUBNET = "Subnet";
    @SerializedName(value="Subnet")
    private String subnet;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public IPAMConfig auxiliaryAddresses(Map<String, String> auxiliaryAddresses) {
        this.auxiliaryAddresses = auxiliaryAddresses;
        return this;
    }

    public IPAMConfig putAuxiliaryAddressesItem(String key, String auxiliaryAddressesItem) {
        if (this.auxiliaryAddresses == null) {
            this.auxiliaryAddresses = new HashMap<String, String>();
        }
        this.auxiliaryAddresses.put(key, auxiliaryAddressesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Map<String, String> getAuxiliaryAddresses() {
        return this.auxiliaryAddresses;
    }

    public void setAuxiliaryAddresses(Map<String, String> auxiliaryAddresses) {
        this.auxiliaryAddresses = auxiliaryAddresses;
    }

    public IPAMConfig gateway(String gateway) {
        this.gateway = gateway;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getGateway() {
        return this.gateway;
    }

    public void setGateway(String gateway) {
        this.gateway = gateway;
    }

    public IPAMConfig ipRange(String ipRange) {
        this.ipRange = ipRange;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getIpRange() {
        return this.ipRange;
    }

    public void setIpRange(String ipRange) {
        this.ipRange = ipRange;
    }

    public IPAMConfig subnet(String subnet) {
        this.subnet = subnet;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getSubnet() {
        return this.subnet;
    }

    public void setSubnet(String subnet) {
        this.subnet = subnet;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IPAMConfig ipAMConfig = (IPAMConfig)o;
        return Objects.equals(this.auxiliaryAddresses, ipAMConfig.auxiliaryAddresses) && Objects.equals(this.gateway, ipAMConfig.gateway) && Objects.equals(this.ipRange, ipAMConfig.ipRange) && Objects.equals(this.subnet, ipAMConfig.subnet);
    }

    public int hashCode() {
        return Objects.hash(this.auxiliaryAddresses, this.gateway, this.ipRange, this.subnet);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IPAMConfig {\n");
        sb.append("    auxiliaryAddresses: ").append(this.toIndentedString(this.auxiliaryAddresses)).append("\n");
        sb.append("    gateway: ").append(this.toIndentedString(this.gateway)).append("\n");
        sb.append("    ipRange: ").append(this.toIndentedString(this.ipRange)).append("\n");
        sb.append("    subnet: ").append(this.toIndentedString(this.subnet)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in IPAMConfig is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `IPAMConfig` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_GATEWAY) != null && !jsonObj.get(SERIALIZED_NAME_GATEWAY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_GATEWAY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `Gateway` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_GATEWAY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_IP_RANGE) != null && !jsonObj.get(SERIALIZED_NAME_IP_RANGE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_IP_RANGE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `IPRange` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_IP_RANGE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SUBNET) != null && !jsonObj.get(SERIALIZED_NAME_SUBNET).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SUBNET).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `Subnet` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SUBNET).toString()));
        }
    }

    public static IPAMConfig fromJson(String jsonString) throws IOException {
        return (IPAMConfig)JSON.getGson().fromJson(jsonString, IPAMConfig.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_AUXILIARY_ADDRESSES);
        openapiFields.add(SERIALIZED_NAME_GATEWAY);
        openapiFields.add(SERIALIZED_NAME_IP_RANGE);
        openapiFields.add(SERIALIZED_NAME_SUBNET);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!IPAMConfig.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(IPAMConfig.class));
            return new TypeAdapter<IPAMConfig>(){

                public void write(JsonWriter out, IPAMConfig value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public IPAMConfig read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    IPAMConfig.validateJsonObject(jsonObj);
                    return (IPAMConfig)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

