/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.libpodj.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.pod4dev.libpodj.JSON;
import io.github.pod4dev.libpodj.model.DriverData;
import io.github.pod4dev.libpodj.model.History;
import io.github.pod4dev.libpodj.model.ImageConfig;
import io.github.pod4dev.libpodj.model.RootFS;
import io.github.pod4dev.libpodj.model.Schema2HealthConfig;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.validation.Valid;

public class ImageData
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_ANNOTATIONS = "Annotations";
    @SerializedName(value="Annotations")
    private Map<String, String> annotations = null;
    public static final String SERIALIZED_NAME_ARCHITECTURE = "Architecture";
    @SerializedName(value="Architecture")
    private String architecture;
    public static final String SERIALIZED_NAME_AUTHOR = "Author";
    @SerializedName(value="Author")
    private String author;
    public static final String SERIALIZED_NAME_COMMENT = "Comment";
    @SerializedName(value="Comment")
    private String comment;
    public static final String SERIALIZED_NAME_CONFIG = "Config";
    @SerializedName(value="Config")
    private ImageConfig config;
    public static final String SERIALIZED_NAME_CREATED = "Created";
    @SerializedName(value="Created")
    private OffsetDateTime created;
    public static final String SERIALIZED_NAME_DIGEST = "Digest";
    @SerializedName(value="Digest")
    private String digest;
    public static final String SERIALIZED_NAME_GRAPH_DRIVER = "GraphDriver";
    @SerializedName(value="GraphDriver")
    private DriverData graphDriver;
    public static final String SERIALIZED_NAME_HEALTHCHECK = "Healthcheck";
    @SerializedName(value="Healthcheck")
    private Schema2HealthConfig healthcheck;
    public static final String SERIALIZED_NAME_HISTORY = "History";
    @SerializedName(value="History")
    private List<History> history = null;
    public static final String SERIALIZED_NAME_ID = "Id";
    @SerializedName(value="Id")
    private String id;
    public static final String SERIALIZED_NAME_LABELS = "Labels";
    @SerializedName(value="Labels")
    private Map<String, String> labels = null;
    public static final String SERIALIZED_NAME_MANIFEST_TYPE = "ManifestType";
    @SerializedName(value="ManifestType")
    private String manifestType;
    public static final String SERIALIZED_NAME_NAMES_HISTORY = "NamesHistory";
    @SerializedName(value="NamesHistory")
    private List<String> namesHistory = null;
    public static final String SERIALIZED_NAME_OS = "Os";
    @SerializedName(value="Os")
    private String os;
    public static final String SERIALIZED_NAME_PARENT = "Parent";
    @SerializedName(value="Parent")
    private String parent;
    public static final String SERIALIZED_NAME_REPO_DIGESTS = "RepoDigests";
    @SerializedName(value="RepoDigests")
    private List<String> repoDigests = null;
    public static final String SERIALIZED_NAME_REPO_TAGS = "RepoTags";
    @SerializedName(value="RepoTags")
    private List<String> repoTags = null;
    public static final String SERIALIZED_NAME_ROOT_F_S = "RootFS";
    @SerializedName(value="RootFS")
    private RootFS rootFS;
    public static final String SERIALIZED_NAME_SIZE = "Size";
    @SerializedName(value="Size")
    private Long size;
    public static final String SERIALIZED_NAME_USER = "User";
    @SerializedName(value="User")
    private String user;
    public static final String SERIALIZED_NAME_VERSION = "Version";
    @SerializedName(value="Version")
    private String version;
    public static final String SERIALIZED_NAME_VIRTUAL_SIZE = "VirtualSize";
    @SerializedName(value="VirtualSize")
    private Long virtualSize;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public ImageData annotations(Map<String, String> annotations) {
        this.annotations = annotations;
        return this;
    }

    public ImageData putAnnotationsItem(String key, String annotationsItem) {
        if (this.annotations == null) {
            this.annotations = new HashMap<String, String>();
        }
        this.annotations.put(key, annotationsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Map<String, String> getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(Map<String, String> annotations) {
        this.annotations = annotations;
    }

    public ImageData architecture(String architecture) {
        this.architecture = architecture;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getArchitecture() {
        return this.architecture;
    }

    public void setArchitecture(String architecture) {
        this.architecture = architecture;
    }

    public ImageData author(String author) {
        this.author = author;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public ImageData comment(String comment) {
        this.comment = comment;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public ImageData config(ImageConfig config) {
        this.config = config;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    public ImageConfig getConfig() {
        return this.config;
    }

    public void setConfig(ImageConfig config) {
        this.config = config;
    }

    public ImageData created(OffsetDateTime created) {
        this.created = created;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    public OffsetDateTime getCreated() {
        return this.created;
    }

    public void setCreated(OffsetDateTime created) {
        this.created = created;
    }

    public ImageData digest(String digest) {
        this.digest = digest;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The following is an example of the contents of Digest types:  sha256:7173b809ca12ec5dee4506cd86be934c4596dd234ee82c0662eac04a8c2c71dc  This allows to abstract the digest behind this type and work only in those terms.")
    public String getDigest() {
        return this.digest;
    }

    public void setDigest(String digest) {
        this.digest = digest;
    }

    public ImageData graphDriver(DriverData graphDriver) {
        this.graphDriver = graphDriver;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    public DriverData getGraphDriver() {
        return this.graphDriver;
    }

    public void setGraphDriver(DriverData graphDriver) {
        this.graphDriver = graphDriver;
    }

    public ImageData healthcheck(Schema2HealthConfig healthcheck) {
        this.healthcheck = healthcheck;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    public Schema2HealthConfig getHealthcheck() {
        return this.healthcheck;
    }

    public void setHealthcheck(Schema2HealthConfig healthcheck) {
        this.healthcheck = healthcheck;
    }

    public ImageData history(List<History> history) {
        this.history = history;
        return this;
    }

    public ImageData addHistoryItem(History historyItem) {
        if (this.history == null) {
            this.history = new ArrayList<History>();
        }
        this.history.add(historyItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    public List<History> getHistory() {
        return this.history;
    }

    public void setHistory(List<History> history) {
        this.history = history;
    }

    public ImageData id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ImageData labels(Map<String, String> labels) {
        this.labels = labels;
        return this;
    }

    public ImageData putLabelsItem(String key, String labelsItem) {
        if (this.labels == null) {
            this.labels = new HashMap<String, String>();
        }
        this.labels.put(key, labelsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Map<String, String> getLabels() {
        return this.labels;
    }

    public void setLabels(Map<String, String> labels) {
        this.labels = labels;
    }

    public ImageData manifestType(String manifestType) {
        this.manifestType = manifestType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getManifestType() {
        return this.manifestType;
    }

    public void setManifestType(String manifestType) {
        this.manifestType = manifestType;
    }

    public ImageData namesHistory(List<String> namesHistory) {
        this.namesHistory = namesHistory;
        return this;
    }

    public ImageData addNamesHistoryItem(String namesHistoryItem) {
        if (this.namesHistory == null) {
            this.namesHistory = new ArrayList<String>();
        }
        this.namesHistory.add(namesHistoryItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<String> getNamesHistory() {
        return this.namesHistory;
    }

    public void setNamesHistory(List<String> namesHistory) {
        this.namesHistory = namesHistory;
    }

    public ImageData os(String os) {
        this.os = os;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getOs() {
        return this.os;
    }

    public void setOs(String os) {
        this.os = os;
    }

    public ImageData parent(String parent) {
        this.parent = parent;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getParent() {
        return this.parent;
    }

    public void setParent(String parent) {
        this.parent = parent;
    }

    public ImageData repoDigests(List<String> repoDigests) {
        this.repoDigests = repoDigests;
        return this;
    }

    public ImageData addRepoDigestsItem(String repoDigestsItem) {
        if (this.repoDigests == null) {
            this.repoDigests = new ArrayList<String>();
        }
        this.repoDigests.add(repoDigestsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<String> getRepoDigests() {
        return this.repoDigests;
    }

    public void setRepoDigests(List<String> repoDigests) {
        this.repoDigests = repoDigests;
    }

    public ImageData repoTags(List<String> repoTags) {
        this.repoTags = repoTags;
        return this;
    }

    public ImageData addRepoTagsItem(String repoTagsItem) {
        if (this.repoTags == null) {
            this.repoTags = new ArrayList<String>();
        }
        this.repoTags.add(repoTagsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<String> getRepoTags() {
        return this.repoTags;
    }

    public void setRepoTags(List<String> repoTags) {
        this.repoTags = repoTags;
    }

    public ImageData rootFS(RootFS rootFS) {
        this.rootFS = rootFS;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    public RootFS getRootFS() {
        return this.rootFS;
    }

    public void setRootFS(RootFS rootFS) {
        this.rootFS = rootFS;
    }

    public ImageData size(Long size) {
        this.size = size;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Long getSize() {
        return this.size;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    public ImageData user(String user) {
        this.user = user;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public ImageData version(String version) {
        this.version = version;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public ImageData virtualSize(Long virtualSize) {
        this.virtualSize = virtualSize;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Long getVirtualSize() {
        return this.virtualSize;
    }

    public void setVirtualSize(Long virtualSize) {
        this.virtualSize = virtualSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImageData imageData = (ImageData)o;
        return Objects.equals(this.annotations, imageData.annotations) && Objects.equals(this.architecture, imageData.architecture) && Objects.equals(this.author, imageData.author) && Objects.equals(this.comment, imageData.comment) && Objects.equals(this.config, imageData.config) && Objects.equals(this.created, imageData.created) && Objects.equals(this.digest, imageData.digest) && Objects.equals(this.graphDriver, imageData.graphDriver) && Objects.equals(this.healthcheck, imageData.healthcheck) && Objects.equals(this.history, imageData.history) && Objects.equals(this.id, imageData.id) && Objects.equals(this.labels, imageData.labels) && Objects.equals(this.manifestType, imageData.manifestType) && Objects.equals(this.namesHistory, imageData.namesHistory) && Objects.equals(this.os, imageData.os) && Objects.equals(this.parent, imageData.parent) && Objects.equals(this.repoDigests, imageData.repoDigests) && Objects.equals(this.repoTags, imageData.repoTags) && Objects.equals(this.rootFS, imageData.rootFS) && Objects.equals(this.size, imageData.size) && Objects.equals(this.user, imageData.user) && Objects.equals(this.version, imageData.version) && Objects.equals(this.virtualSize, imageData.virtualSize);
    }

    public int hashCode() {
        return Objects.hash(this.annotations, this.architecture, this.author, this.comment, this.config, this.created, this.digest, this.graphDriver, this.healthcheck, this.history, this.id, this.labels, this.manifestType, this.namesHistory, this.os, this.parent, this.repoDigests, this.repoTags, this.rootFS, this.size, this.user, this.version, this.virtualSize);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ImageData {\n");
        sb.append("    annotations: ").append(this.toIndentedString(this.annotations)).append("\n");
        sb.append("    architecture: ").append(this.toIndentedString(this.architecture)).append("\n");
        sb.append("    author: ").append(this.toIndentedString(this.author)).append("\n");
        sb.append("    comment: ").append(this.toIndentedString(this.comment)).append("\n");
        sb.append("    config: ").append(this.toIndentedString(this.config)).append("\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    digest: ").append(this.toIndentedString(this.digest)).append("\n");
        sb.append("    graphDriver: ").append(this.toIndentedString(this.graphDriver)).append("\n");
        sb.append("    healthcheck: ").append(this.toIndentedString(this.healthcheck)).append("\n");
        sb.append("    history: ").append(this.toIndentedString(this.history)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    labels: ").append(this.toIndentedString(this.labels)).append("\n");
        sb.append("    manifestType: ").append(this.toIndentedString(this.manifestType)).append("\n");
        sb.append("    namesHistory: ").append(this.toIndentedString(this.namesHistory)).append("\n");
        sb.append("    os: ").append(this.toIndentedString(this.os)).append("\n");
        sb.append("    parent: ").append(this.toIndentedString(this.parent)).append("\n");
        sb.append("    repoDigests: ").append(this.toIndentedString(this.repoDigests)).append("\n");
        sb.append("    repoTags: ").append(this.toIndentedString(this.repoTags)).append("\n");
        sb.append("    rootFS: ").append(this.toIndentedString(this.rootFS)).append("\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    virtualSize: ").append(this.toIndentedString(this.virtualSize)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArrayhistory;
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in ImageData is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `ImageData` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ARCHITECTURE) != null && !jsonObj.get(SERIALIZED_NAME_ARCHITECTURE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ARCHITECTURE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `Architecture` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ARCHITECTURE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_AUTHOR) != null && !jsonObj.get(SERIALIZED_NAME_AUTHOR).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_AUTHOR).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `Author` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_AUTHOR).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_COMMENT) != null && !jsonObj.get(SERIALIZED_NAME_COMMENT).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_COMMENT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `Comment` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_COMMENT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CONFIG) != null && !jsonObj.get(SERIALIZED_NAME_CONFIG).isJsonNull()) {
            ImageConfig.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_CONFIG));
        }
        if (jsonObj.get(SERIALIZED_NAME_DIGEST) != null && !jsonObj.get(SERIALIZED_NAME_DIGEST).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DIGEST).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `Digest` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DIGEST).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_GRAPH_DRIVER) != null && !jsonObj.get(SERIALIZED_NAME_GRAPH_DRIVER).isJsonNull()) {
            DriverData.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_GRAPH_DRIVER));
        }
        if (jsonObj.get(SERIALIZED_NAME_HEALTHCHECK) != null && !jsonObj.get(SERIALIZED_NAME_HEALTHCHECK).isJsonNull()) {
            Schema2HealthConfig.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_HEALTHCHECK));
        }
        if (jsonObj.get(SERIALIZED_NAME_HISTORY) != null && !jsonObj.get(SERIALIZED_NAME_HISTORY).isJsonNull() && (jsonArrayhistory = jsonObj.getAsJsonArray(SERIALIZED_NAME_HISTORY)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_HISTORY).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `History` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_HISTORY).toString()));
            }
            for (int i = 0; i < jsonArrayhistory.size(); ++i) {
                History.validateJsonObject(jsonArrayhistory.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `Id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MANIFEST_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_MANIFEST_TYPE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_MANIFEST_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `ManifestType` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MANIFEST_TYPE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAMES_HISTORY) != null && !jsonObj.get(SERIALIZED_NAME_NAMES_HISTORY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NAMES_HISTORY).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `NamesHistory` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAMES_HISTORY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_OS) != null && !jsonObj.get(SERIALIZED_NAME_OS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_OS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `Os` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_OS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PARENT) != null && !jsonObj.get(SERIALIZED_NAME_PARENT).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_PARENT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `Parent` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PARENT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_REPO_DIGESTS) != null && !jsonObj.get(SERIALIZED_NAME_REPO_DIGESTS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_REPO_DIGESTS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `RepoDigests` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REPO_DIGESTS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_REPO_TAGS) != null && !jsonObj.get(SERIALIZED_NAME_REPO_TAGS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_REPO_TAGS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `RepoTags` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REPO_TAGS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ROOT_F_S) != null && !jsonObj.get(SERIALIZED_NAME_ROOT_F_S).isJsonNull()) {
            RootFS.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_ROOT_F_S));
        }
        if (jsonObj.get(SERIALIZED_NAME_USER) != null && !jsonObj.get(SERIALIZED_NAME_USER).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_USER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `User` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_USER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_VERSION) != null && !jsonObj.get(SERIALIZED_NAME_VERSION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_VERSION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `Version` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VERSION).toString()));
        }
    }

    public static ImageData fromJson(String jsonString) throws IOException {
        return (ImageData)JSON.getGson().fromJson(jsonString, ImageData.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ANNOTATIONS);
        openapiFields.add(SERIALIZED_NAME_ARCHITECTURE);
        openapiFields.add(SERIALIZED_NAME_AUTHOR);
        openapiFields.add(SERIALIZED_NAME_COMMENT);
        openapiFields.add(SERIALIZED_NAME_CONFIG);
        openapiFields.add(SERIALIZED_NAME_CREATED);
        openapiFields.add(SERIALIZED_NAME_DIGEST);
        openapiFields.add(SERIALIZED_NAME_GRAPH_DRIVER);
        openapiFields.add(SERIALIZED_NAME_HEALTHCHECK);
        openapiFields.add(SERIALIZED_NAME_HISTORY);
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_LABELS);
        openapiFields.add(SERIALIZED_NAME_MANIFEST_TYPE);
        openapiFields.add(SERIALIZED_NAME_NAMES_HISTORY);
        openapiFields.add(SERIALIZED_NAME_OS);
        openapiFields.add(SERIALIZED_NAME_PARENT);
        openapiFields.add(SERIALIZED_NAME_REPO_DIGESTS);
        openapiFields.add(SERIALIZED_NAME_REPO_TAGS);
        openapiFields.add(SERIALIZED_NAME_ROOT_F_S);
        openapiFields.add(SERIALIZED_NAME_SIZE);
        openapiFields.add(SERIALIZED_NAME_USER);
        openapiFields.add(SERIALIZED_NAME_VERSION);
        openapiFields.add(SERIALIZED_NAME_VIRTUAL_SIZE);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!ImageData.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(ImageData.class));
            return new TypeAdapter<ImageData>(){

                public void write(JsonWriter out, ImageData value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public ImageData read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    ImageData.validateJsonObject(jsonObj);
                    return (ImageData)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

